/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.ide.util.MetaClass;
import oracle.dbtools.raptor.navigator.DatabaseTypeRoot;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorHook;
import oracle.dbtools.raptor.navigator.impl.ViewableElement;
import oracle.dbtools.util.Logger;
import oracle.ide.ExtensionRegistry;
import oracle.ide.controller.Controller;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.javatools.data.HashStructure;

public abstract class DatabaseTypeSupport {
    private static final String ELEMENT_KEY = "db-connection-type-provider";
    private static final String ATTRIBUTE_CLASS = "class";
    private static List<DatabaseTypeSupport> sProviders = new ArrayList<DatabaseTypeSupport>();
    private static Listener sListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DatabaseTypeSupport> getConnectionTypeProviders() {
        Class<DatabaseTypeSupport> clazz = DatabaseTypeSupport.class;
        synchronized (DatabaseTypeSupport.class) {
            HashStructureHook hashStructureHook;
            if (sListener == null && (hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(NavigatorHook.ELEMENT_NAME)) != null) {
                sListener = new Listener();
                hashStructureHook.addHashStructureHookListener((HashStructureHookListener)sListener);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Collections.unmodifiableList(sProviders);
        }
    }

    public abstract Controller getController();

    public abstract DatabaseTypeRoot getRoot();

    public abstract boolean needsViewerRegistration(ViewableElement var1);

    public abstract void registerViewers(ViewableElement var1);

    private static class Listener
    implements HashStructureHookListener {
        private Listener() {
        }

        public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
            this.processDescriptors(hashStructureHookEvent.getNewElementHashStructure());
        }

        public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
            this.processDescriptors(hashStructureHookEvent.getCombinedHashStructure());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void processDescriptors(HashStructure hashStructure) {
            List list = hashStructure.getAsList(DatabaseTypeSupport.ELEMENT_KEY);
            if (list == null) return;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                HashStructure hashStructure2 = (HashStructure)iterator.next();
                LazyClassAdapter lazyClassAdapter = LazyClassAdapter.getInstance((HashStructure)hashStructure2);
                MetaClass metaClass = lazyClassAdapter.getMetaClass(DatabaseTypeSupport.ATTRIBUTE_CLASS);
                if (metaClass == null) continue;
                Class<DatabaseTypeSupport> clazz = DatabaseTypeSupport.class;
                // MONITORENTER : oracle.dbtools.raptor.navigator.db.DatabaseTypeSupport.class
                try {
                    sProviders.add(metaClass.newInstance());
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                    Logger.severe(DatabaseTypeSupport.class, (Throwable)reflectiveOperationException);
                }
            }
        }
    }
}

