/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.impl;

import java.net.URL;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.db.model.DBItemInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseItem;
import oracle.dbtools.raptor.navigator.impl.DatabaseElement;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.model.DefaultFolder;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

abstract class AbstractDatabaseFolder<T extends DBItemInstance>
extends DefaultFolder
implements DatabaseElement,
Subject {
    private String m_cName;
    private URL m_url;
    private Subject m_subjectProxy = new IdeSubject();
    private T m_inst;

    protected AbstractDatabaseFolder(URL uRL, T t) {
        this.setURL(uRL);
        this.m_inst = t;
    }

    public abstract String getShortLabel();

    protected final T getInstance() {
        return this.m_inst;
    }

    protected final DatabaseItem getDescriptor() {
        return this.m_inst.getDescriptor();
    }

    @Override
    public final void setProperty(String string, Object object) {
        this.m_inst.setProperty(string, object);
    }

    @Override
    public Object getProperty(String string) {
        Object object = null;
        object = "ConnectionName".equals(string) ? this.m_cName : this.m_inst.getProperty(string);
        return object;
    }

    public final URL getURL() {
        return this.m_url;
    }

    public void setURL(URL uRL) {
        this.m_cName = DBURLFormatHelper.getConnectionName(uRL);
        this.m_url = uRL;
    }

    public Icon getIcon() {
        return this.m_inst.getDescriptor().getIcon();
    }

    public final Object getProviderIdentifier() {
        return this.getProperty("ConnectionName");
    }

    public String getSchemaName() {
        return null;
    }

    public final String getStoreName() {
        return Connections.getStoreName((String)this.getProperty("ConnectionName"));
    }

    public final void attach(Observer observer) {
        this.m_subjectProxy.attach(observer);
    }

    public final void detach(Observer observer) {
        this.m_subjectProxy.detach(observer);
    }

    public final void notifyObservers(Object object, UpdateMessage updateMessage) {
        this.m_subjectProxy.notifyObservers(object, updateMessage);
    }
}

