/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.model;

import java.io.Serializable;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.util.Pair;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public abstract class NavigatorTreeNode
extends DefaultMutableTreeNode
implements Displayable,
Observer {
    protected static final Comparator<NavigatorTreeNode> CASE_SENSITIVE = new ElementComparator(2);
    protected static final Comparator<NavigatorTreeNode> CASE_INSENSITIVE = new ElementComparator(1);
    private final Object __lock__ = new Object();
    NavigatorTree m_owner;
    List<NavigatorTreeNode> m_children;
    private Comparator<NavigatorTreeNode> m_comp;
    private volatile State m_state = State.CLOSED;
    private Observer m_childObserver = new Observer(){

        public void update(Object object, UpdateMessage updateMessage) {
            int n = updateMessage.getMessageID();
            if (n == UpdateMessage.OBJECT_RENAMED && object instanceof Element) {
                for (Map.Entry entry : NavigatorTreeNode.this.m_cache.entrySet()) {
                    NavigatorTreeNode navigatorTreeNode = (NavigatorTreeNode)entry.getValue();
                    if (navigatorTreeNode.getElement() != object) continue;
                    NavigatorTreeNode.this.m_cache.remove(entry.getKey());
                    NavigatorTreeNode.this.cache(navigatorTreeNode);
                    break;
                }
            }
        }
    };
    private Map<Object, NavigatorTreeNode> m_cache = new HashMap<Object, NavigatorTreeNode>();

    final Object getLock() {
        return this.__lock__;
    }

    public final Enumeration children() {
        if (this.m_children == null) {
            return DefaultMutableTreeNode.EMPTY_ENUMERATION;
        }
        return Collections.enumeration(new ArrayList<NavigatorTreeNode>(this.m_children));
    }

    @Override
    public final TreeNode getChildAt(int n) {
        return this.getChildrenImpl().get(n);
    }

    @Override
    public final int getChildCount() {
        return this.m_children != null ? this.m_children.size() : 0;
    }

    @Override
    public final int getIndex(TreeNode treeNode) {
        return this.getChildrenImpl().indexOf(treeNode);
    }

    @Override
    public void insert(MutableTreeNode mutableTreeNode, int n) {
        assert (mutableTreeNode instanceof NavigatorTreeNode);
        assert (this.m_children != null);
        assert (n >= 0 && n < this.m_children.size());
        if (this.m_comp != null) {
            throw new IllegalStateException("Cannot insert by index into sorted child list");
        }
        this.m_children.add(n, (NavigatorTreeNode)mutableTreeNode);
    }

    @Override
    public void remove(int n) {
        assert (this.m_children != null);
        assert (n >= 0 && n < this.m_children.size());
        NavigatorTreeNode navigatorTreeNode = this.m_children.remove(n);
        if (navigatorTreeNode != null) {
            this.unparentNode(navigatorTreeNode);
        }
    }

    @Override
    public void remove(MutableTreeNode mutableTreeNode) {
        this.removeChild((NavigatorTreeNode)mutableTreeNode);
    }

    protected void cache(NavigatorTreeNode navigatorTreeNode) {
        Element element = navigatorTreeNode.getElement();
        this.m_cache.put(this.getKey(element), navigatorTreeNode);
    }

    protected NavigatorTreeNode lookup(Element element) {
        return this.m_cache.get(this.getKey(element));
    }

    protected void uncache(NavigatorTreeNode navigatorTreeNode) {
        Element element = navigatorTreeNode.getElement();
        this.m_cache.remove(this.getKey(element));
    }

    protected Object getKey(Element element) {
        URL uRL;
        if (element instanceof Locatable && (uRL = ((Locatable)element).getURL()) != null) {
            return uRL.toString();
        }
        return element.getShortLabel();
    }

    NavigatorTreeNode() {
        this.m_comp = CASE_SENSITIVE;
    }

    final void setOwner(NavigatorTree navigatorTree) {
        if (navigatorTree != this.m_owner) {
            this.m_owner = navigatorTree;
        }
    }

    @Override
    public final void setUserObject(Object object) {
        this.setData((Element)object);
    }

    @Override
    public final Object getUserObject() {
        return super.getUserObject();
    }

    final void setData(Element element) {
        Element element2 = this.getElement();
        if (element2 != element) {
            if (element2 instanceof Subject) {
                ((Subject)element2).detach((Observer)this);
            }
            super.setUserObject(element);
            this.initializeFromElement(element);
            this.setAllowsChildren(element.mayHaveChildren());
            if (element instanceof Subject) {
                ((Subject)element).attach((Observer)this);
            }
        }
    }

    final State getState() {
        return this.m_state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void open() {
        Object object = this.__lock__;
        synchronized (object) {
            if (this.m_state != State.CLOSED) {
                return;
            }
            if (this.getAllowsChildren()) {
                this.m_state = State.OPENING;
                this.m_children = this.createChildList();
            } else {
                this.m_state = State.OPEN;
                this.m_children = Collections.emptyList();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() {
        Object object = this.__lock__;
        synchronized (object) {
            if (this.m_state == State.CLOSED) {
                return;
            }
            this.m_children = null;
            this.cleanupOnClose();
            this.m_state = State.CLOSED;
        }
    }

    protected void cleanupOnClose() {
    }

    abstract boolean isLoadingAsychronous();

    public final Element getElement() {
        return (Element)this.getUserObject();
    }

    public final NavigatorTree getOwningNavigatorTree() {
        return this.m_owner;
    }

    public final void update(final Object object, final UpdateMessage updateMessage) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NavigatorTreeNode.this.updateImpl(object, updateMessage);
                }
            });
        } else {
            this.updateImpl(object, updateMessage);
        }
    }

    protected void updateImpl(Object object, UpdateMessage updateMessage) {
        int n = updateMessage.getMessageID();
        if (n == UpdateMessage.OBJECT_RENAMED || n == UpdateMessage.ATTRIBUTE_CHANGED) {
            this.handleNodeChanged();
        } else if (n == UpdateMessage.CHILD_ADDED) {
            this.handleChildrenAdded(updateMessage.getAddObjects());
        } else if (n == UpdateMessage.CHILD_REMOVED) {
            this.handleChildrenRemoved(updateMessage.getRemoveObjects());
        } else if (n == UpdateMessage.STRUCTURE_CHANGED) {
            this.handleStructureChanged();
        } else if (n == UpdateMessage.OBJECT_CLOSED) {
            this.handleClose();
        } else if (n == UpdateMessage.PROPERTY_SET || n == UpdateMessage.OBJECT_OPENED || n == UpdateMessage.CHILD_RENAMED) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleStructureChanged() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.m_owner != null && this.getState() != State.CLOSED) {
                this.m_owner.collapse(this, true);
                this.m_owner.expand(this, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleClose() {
        if (this.m_owner != null) {
            Object object = this.getLock();
            synchronized (object) {
                if (this.getState() != State.CLOSED) {
                    this.m_owner.collapse(this, true);
                }
            }
        }
    }

    protected void handleNodeChanged() {
        if (this.m_owner != null) {
            this.m_owner.nodeChanged(this);
        }
    }

    protected void handleChildrenAdded(Collection<Element> collection) {
        if (this.m_owner != null) {
            this.m_owner.addChildrenToNode(this, collection);
        }
    }

    protected void handleChildrenRemoved(Collection<Element> collection) {
        if (this.m_owner != null) {
            this.m_owner.removeChildrenFromNode(this, collection);
        }
    }

    protected final void setComparator(Comparator<NavigatorTreeNode> comparator) {
        this.m_comp = comparator;
    }

    protected final Comparator<NavigatorTreeNode> getComparator() {
        return this.m_comp;
    }

    public final Iterator<NavigatorTreeNode> getChildNodes() {
        return this.getChildrenImpl().iterator();
    }

    List<NavigatorTreeNode> getChildrenImpl() {
        if (this.m_children == null) {
            return Collections.emptyList();
        }
        return this.m_children;
    }

    @Override
    public final boolean isLeaf() {
        return !this.getAllowsChildren();
    }

    protected String getURLProtocol() {
        return NavigatorTreeNode.getURLProtocol(this.getElement());
    }

    protected static String getURLProtocol(Element element) {
        URL uRL = element instanceof Locatable ? ((Locatable)element).getURL() : null;
        return uRL != null ? uRL.getProtocol() : null;
    }

    void setState(State state) {
        this.m_state = state;
    }

    public Icon getIcon() {
        return this.getElement().getIcon();
    }

    public String getLongLabel() {
        return this.getElement().getLongLabel();
    }

    public String getShortLabel() {
        return this.getElement().getShortLabel();
    }

    public String getToolTipText() {
        return this.getElement().getToolTipText();
    }

    protected List<NavigatorTreeNode> createChildList() {
        return new ArrayList<NavigatorTreeNode>();
    }

    protected void reparentNode(NavigatorTreeNode navigatorTreeNode) {
        this.cache(navigatorTreeNode);
        Element element = navigatorTreeNode.getElement();
        if (element instanceof Subject) {
            ((Subject)element).attach(this.m_childObserver);
        }
        navigatorTreeNode.setParent(this);
    }

    protected void unparentNode(NavigatorTreeNode navigatorTreeNode) {
        this.uncache(navigatorTreeNode);
        Element element = navigatorTreeNode.getElement();
        if (element instanceof Subject) {
            ((Subject)element).detach(this.m_childObserver);
        }
        navigatorTreeNode.setParent(null);
    }

    protected int addChild(NavigatorTreeNode navigatorTreeNode) {
        assert (navigatorTreeNode.getParent() == null);
        if (this.m_children == null) {
            return -1;
        }
        this.reparentNode(navigatorTreeNode);
        Comparator<NavigatorTreeNode> comparator = this.getComparator();
        List<NavigatorTreeNode> list = this.m_children;
        int n = list.size();
        if (comparator == null || n == 0) {
            list.add(navigatorTreeNode);
        } else {
            ListIterator<NavigatorTreeNode> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                NavigatorTreeNode navigatorTreeNode2 = listIterator.next();
                if (comparator.compare(navigatorTreeNode, navigatorTreeNode2) >= 0) continue;
                n = listIterator.previousIndex();
                listIterator.previous();
                listIterator.add(navigatorTreeNode);
                break;
            }
            if (n == list.size()) {
                list.add(navigatorTreeNode);
            }
        }
        return n;
    }

    protected int[] addChildren(NavigatorTreeNode[] navigatorTreeNodeArray) {
        assert (this.m_children instanceof ArrayList);
        if (this.m_children == null) {
            return new int[0];
        }
        Comparator<NavigatorTreeNode> comparator = this.getComparator();
        List<NavigatorTreeNode> list = this.m_children;
        int n = list.size();
        int[] nArray = new int[navigatorTreeNodeArray.length];
        if (comparator != null && navigatorTreeNodeArray.length > 1) {
            Arrays.sort(navigatorTreeNodeArray, comparator);
        }
        if (comparator == null || n == 0) {
            for (int i = 0; i < navigatorTreeNodeArray.length; ++i) {
                this.reparentNode(navigatorTreeNodeArray[i]);
                nArray[i] = n++;
            }
            list.addAll(Arrays.asList(navigatorTreeNodeArray));
        } else {
            Object object;
            int n2 = 0;
            int n3 = 0;
            int n4 = navigatorTreeNodeArray.length;
            ListIterator<NavigatorTreeNode> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                object = listIterator.next();
                if (n2 >= n4) break;
                NavigatorTreeNode navigatorTreeNode = navigatorTreeNodeArray[n2];
                if (navigatorTreeNode.getElement() == ((NavigatorTreeNode)object).getElement()) {
                    ++n2;
                    continue;
                }
                if (comparator.compare(navigatorTreeNode, (NavigatorTreeNode)object) >= 0) continue;
                nArray[n3++] = listIterator.previousIndex();
                listIterator.previous();
                this.reparentNode(navigatorTreeNode);
                listIterator.add(navigatorTreeNode);
                ++n2;
            }
            while (n2 < n4) {
                nArray[n3++] = n++;
                this.reparentNode(navigatorTreeNodeArray[n2]);
                list.add(navigatorTreeNodeArray[n2]);
                ++n2;
            }
            if (n3 < n4) {
                object = nArray;
                nArray = new int[n3];
                System.arraycopy(object, 0, nArray, 0, n3);
            }
        }
        return nArray;
    }

    protected int removeChild(NavigatorTreeNode navigatorTreeNode) {
        if (this.m_children == null) {
            return -1;
        }
        int n = this.m_children.indexOf(navigatorTreeNode);
        if (n >= 0) {
            this.unparentNode(navigatorTreeNode);
            this.m_children.remove(n);
            return n;
        }
        return -1;
    }

    protected Pair<NavigatorTreeNode, Integer>[] removeChildren(NavigatorTreeNode[] navigatorTreeNodeArray) {
        List<NavigatorTreeNode> list = this.m_children;
        int[] nArray = new int[navigatorTreeNodeArray.length];
        int n = 0;
        NavigatorTreeNode[] objectArray = navigatorTreeNodeArray;
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            NavigatorTreeNode navigatorTreeNode = objectArray[i];
            int n3 = list.indexOf(navigatorTreeNode);
            if (n3 < 0) continue;
            nArray[n++] = n3;
        }
        if (n < nArray.length) {
            int[] nArray2 = nArray;
            nArray = new int[n];
            System.arraycopy(nArray2, 0, nArray, 0, n);
        }
        Arrays.sort(nArray);
        Pair[] pairArray = new Pair[nArray.length];
        for (n2 = nArray.length - 1; n2 >= 0; --n2) {
            NavigatorTreeNode navigatorTreeNode = list.remove(nArray[n2]);
            this.unparentNode(navigatorTreeNode);
            pairArray[n2] = new Pair((Object)navigatorTreeNode, (Object)nArray[n2]);
        }
        return pairArray;
    }

    @Override
    public void removeAllChildren() {
        if (this.m_children != null && this.m_children.size() > 0) {
            this.m_children.clear();
        }
    }

    public NavigatorTreeNode findAncestorTreeNode(Class<? extends Element> clazz, boolean bl) {
        Serializable serializable;
        Element element = this.getElement();
        if (element != null) {
            serializable = element.getClass();
            if (bl ? clazz.isAssignableFrom((Class<?>)serializable) : serializable == clazz) {
                return this;
            }
        }
        return (serializable = (NavigatorTreeNode)this.getParent()) != null ? ((NavigatorTreeNode)serializable).findAncestorTreeNode(clazz, bl) : null;
    }

    public <T extends Element> T findAncestorElement(Class<T> clazz, boolean bl) {
        NavigatorTreeNode navigatorTreeNode = this.findAncestorTreeNode(clazz, bl);
        return (T)(navigatorTreeNode != null ? navigatorTreeNode.getElement() : null);
    }

    NavigatorTreeNode[] findNodes(Collection<Element> collection) {
        ArrayList<NavigatorTreeNode> arrayList = new ArrayList<NavigatorTreeNode>();
        List<NavigatorTreeNode> list = this.getChildrenImpl();
        if (list.size() != 0) {
            block0: for (Element element : collection) {
                for (NavigatorTreeNode navigatorTreeNode : list) {
                    if (navigatorTreeNode.getElement() != element) continue;
                    arrayList.add(navigatorTreeNode);
                    break block0;
                }
            }
        }
        return arrayList.toArray(new NavigatorTreeNode[0]);
    }

    protected abstract RaptorTask<Collection<Element>> getLoadingTask();

    protected abstract Iterator<Element> loadChildrenImpl();

    protected void initializeFromElement(Element element) {
    }

    static enum State {
        CLOSED,
        OPENING,
        OPEN;

    }

    private static class ElementComparator
    implements Comparator<NavigatorTreeNode> {
        protected Collator m_collator = Collator.getInstance();

        ElementComparator(int n) {
            this.m_collator.setStrength(n);
        }

        @Override
        public int compare(NavigatorTreeNode navigatorTreeNode, NavigatorTreeNode navigatorTreeNode2) {
            String string = navigatorTreeNode.getShortLabel();
            String string2 = navigatorTreeNode2.getShortLabel();
            return this.m_collator.compare(string, string2);
        }
    }
}

