/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.oviewer.xmleditor.XMLBasedEditor;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.model.Element;
import oracle.ide.util.MenuSpec;
import oracle.javatools.util.ModelUtil;

class ViewerEditorAddin
extends EditorAddin {
    private static final float INIT_WEIGHT = 0.5f;
    private static final float DELTA_WEIGHT = 0.001f;
    private static Map<String, Float> sNextWeightByType = new HashMap<String, Float>();
    private final String m_label;
    private String m_connType;
    private String m_objType;
    private final Class<? extends Editor> m_editorClass;
    private float m_myWeight;
    private DisplayModel _model;
    private Map<Connection, Float> weightCache = new WeakHashMap<Connection, Float>();

    private static float getWeight(String string) {
        Float f = sNextWeightByType.get(string);
        float f2 = f != null ? f.floatValue() : 0.5f;
        sNextWeightByType.put(string, Float.valueOf(f2 - 0.001f));
        return f2;
    }

    public String toString() {
        return DBObject.getKey(this.m_connType, this.m_objType);
    }

    public ViewerEditorAddin(String string, String string2, String string3, Class<? extends Editor> clazz, DisplayModel displayModel) {
        this.m_label = string;
        this.m_connType = string2;
        this.m_objType = string3;
        this.m_editorClass = clazz;
        this.m_myWeight = ViewerEditorAddin.getWeight(string2);
        this._model = displayModel;
    }

    public MenuSpec getMenuSpecification() {
        return new MenuSpec(this.m_label, null, null);
    }

    public Class getEditorClass() {
        return this.m_editorClass;
    }

    public boolean restoreAtStartup() {
        return false;
    }

    public float getEditorWeight() {
        return this.m_myWeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getEditorWeight(Element element) {
        ViewerNode viewerNode;
        DBObject dBObject = null;
        if (element instanceof ViewerNode && (dBObject = (viewerNode = (ViewerNode)element).getDBObject()) != null && dBObject.isValid() && dBObject.isConnected() && ModelUtil.areEqual((Object)DBObject.getKey(this.m_connType, this.m_objType), (Object)dBObject.getKey())) {
            Object object;
            Object object2;
            Object object3;
            if (element instanceof PlSqlNode) {
                return Float.NaN;
            }
            DisplayModel displayModel = this.getModel();
            if (XMLBasedEditor.class.isAssignableFrom(this.m_editorClass) && (object3 = dBObject.getConnection(false)) != null) {
                object2 = this.weightCache.get(object3);
                if (null == object2) {
                    object = displayModel.strictGetQuery((Connection)object3, true, true);
                    if (object == null && Connections.getInstance().lock((Connection)object3, true)) {
                        try {
                            if (displayModel.strictGetQuery((Connection)object3, true, false) == null) {
                                this.weightCache.put((Connection)object3, Float.valueOf(Float.NaN));
                                float f = Float.NaN;
                                return f;
                            }
                            this.weightCache.put((Connection)object3, Float.valueOf(this.m_myWeight));
                        }
                        finally {
                            Connections.getInstance().unlock((Connection)object3);
                        }
                    }
                } else if (Float.isNaN(((Float)object2).floatValue())) {
                    return ((Float)object2).floatValue();
                }
            }
            if ((object3 = (String)displayModel.getExtValues().get("requiredProp")) != null) {
                object2 = ((String)object3).split(":")[0].toUpperCase();
                object = ((String)object3).split(":")[1].toUpperCase();
                String string = (String)dBObject.getDictionary().get(object2);
                if (string != null && !string.equalsIgnoreCase((String)object)) {
                    return Float.NaN;
                }
            }
            if ("TABLE".equals(this.m_objType) && ("Data".equals(displayModel.getName()) || "SQL".equals(displayModel.getName())) && (object2 = (String)dBObject.getDictionary().get("GENERATED")) != null && ((String)object2).equalsIgnoreCase("Y")) {
                return Float.NaN;
            }
            return this.m_myWeight;
        }
        return Float.NaN;
    }

    public DisplayModel getModel() {
        return this._model;
    }
}

