/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.jsoneditor;

import com.fasterxml.jackson.databind.JsonNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.ide.net.URIFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.http.JsonObjectHandler;
import oracle.dbtools.http.Session;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.cloud.navigator.CloudViewerDetail;
import oracle.dbtools.raptor.cloud.navigator.ExceptionDialogRunnable;
import oracle.dbtools.raptor.cloud.navigator.ViewerStyle;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.oviewer.cloud.BasicCloudEditor;
import oracle.dbtools.raptor.oviewer.jsoneditor.RowDataHandler;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.util.Logger;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterClickListener;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.ui.table.GenericTable;
import org.apache.http.client.ResponseHandler;

public class JSONComponent {
    private String _uriString;
    private String _conName;
    private ViewerStyle _style;
    private JComponent _comp;
    protected JScrollPane _sp;
    private GenericTable _table;
    private DefaultTableModel _model;
    MouseListener dblClick;
    private final PropertyChangeSupport _listenerList = new PropertyChangeSupport(this);

    public TableModel getTableModel() {
        return this._model;
    }

    public JSONComponent(CloudViewerDetail cloudViewerDetail, String string) {
        this._uriString = cloudViewerDetail.getUriString();
        this._conName = string;
        this._style = cloudViewerDetail.getStyle();
        this.buildUI();
    }

    public void setDetails(CloudViewerDetail cloudViewerDetail) {
        this._uriString = cloudViewerDetail.getUriString();
        this._style = cloudViewerDetail.getStyle();
    }

    public String getConName() {
        return this._conName;
    }

    public void setConName(String string) {
        this._conName = string;
    }

    public Component getComp() {
        return this._comp;
    }

    JComponent getUI() {
        this.buildUI();
        return this._comp;
    }

    JComponent getDisplayUI() {
        this.buildUI();
        return this._comp instanceof BasicEditorPane ? this.getScrollableUI() : this._comp;
    }

    boolean isScrollable() {
        return !(this._comp instanceof BasicEditorPane);
    }

    JComponent getScrollableUI() {
        if (this._sp == null) {
            this._sp = new JScrollPane(this._comp);
        }
        return this._sp;
    }

    public Component getScrollableLeftMargin() {
        if (this._comp instanceof GenericTable) {
            return ((GenericTable)this._comp).getRowHeader();
        }
        return null;
    }

    public Component getScrollableTopMargin() {
        if (this._comp instanceof GenericTable) {
            return ((GenericTable)this._comp).getTableHeader();
        }
        return null;
    }

    public void refresh() {
        if (this._style == ViewerStyle.TABLE || this._style == ViewerStyle.VTABLE) {
            this._comp = this.buildTable();
            this.loadTableData();
        } else if (this._style == ViewerStyle.CODE) {
            ((BasicEditorPane)this._comp).setEditable(true);
            try {
                Session session = CConnections.getInstance().getConnection(this._conName, false);
                if (session != null) {
                    String string = (String)session.executeQuery(new URI(this._uriString), (ResponseHandler)new JsonObjectHandler<String>(){

                        protected String build(JsonNode jsonNode) throws IOException {
                            JsonNode jsonNode2 = jsonNode.path("items");
                            StringBuilder stringBuilder = new StringBuilder();
                            for (JsonNode jsonNode3 : jsonNode2) {
                                stringBuilder.append(jsonNode3.path("ddl").asText());
                                stringBuilder.append("\n");
                            }
                            return stringBuilder.toString();
                        }
                    });
                    ((BasicEditorPane)this._comp).setText(string);
                }
            }
            catch (SessionException sessionException) {
                Logger.warn(BasicCloudEditor.class, (String)sessionException.getMessage());
                Throwable throwable = sessionException.getCause();
                if (throwable == null) {
                    throwable = sessionException;
                }
                ExceptionDialogRunnable exceptionDialogRunnable = new ExceptionDialogRunnable(DatabaseNavigatorResources.getString("CONNECTION_FILTER_CONNECT_ERROR"), throwable);
                if (SwingUtilities.isEventDispatchThread()) {
                    exceptionDialogRunnable.run();
                } else {
                    try {
                        SwingUtilities.invokeLater(exceptionDialogRunnable);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.warn(BasicCloudEditor.class, (String)uRISyntaxException.getMessage());
            }
            ((BasicEditorPane)this._comp).setEditable(false);
        }
    }

    private JComponent buildTable() {
        if (this._table == null) {
            this._table = new GenericTable();
        }
        if (this.dblClick == null) {
            this.dblClick = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                        JSONComponent.this.popupCurrentCell(mouseEvent.getPoint());
                    }
                }
            };
            this._table.addMouseListener(this.dblClick);
        }
        this._table.setColumnSelectorAvailable(false);
        this._table.setColumnSelectionAllowed(false);
        this._table.setAutoResizeMode(4);
        return this._table;
    }

    private void loadTableData() {
        this._model = new DefaultTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this._table.setModel((TableModel)this._model);
        try {
            List list;
            Session session = CConnections.getInstance().getConnection(this._conName, false);
            if (session != null && (list = (List)session.executeQuery(URIFactory.newURI((String)this._uriString), RowDataHandler.getHandler(this._style))).size() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (RowDataHandler.Row row : list) {
                    for (RowDataHandler.Column column : row.getColumns()) {
                        if (arrayList.contains(column.getName())) continue;
                        arrayList.add(column.getName());
                        this._model.addColumn(column.getName());
                    }
                }
                for (RowDataHandler.Row row : list) {
                    this._model.addRow(row.getData(arrayList));
                }
                this._model.fireTableDataChanged();
                SwingUtilities.invokeLater(() -> {
                    this.firePropertyChangeEvent("scrollable_left_margin", null, this._table.getRowHeader());
                    this.firePropertyChangeEvent("scrollable_top_margin", null, this._table.getTableHeader());
                });
            }
        }
        catch (SessionException sessionException) {
            Logger.warn(BasicCloudEditor.class, (String)sessionException.getMessage());
            Throwable throwable = sessionException.getCause();
            if (throwable == null) {
                throwable = sessionException;
            }
            ExceptionDialogRunnable exceptionDialogRunnable = new ExceptionDialogRunnable(DatabaseNavigatorResources.getString("CONNECTION_FILTER_CONNECT_ERROR"), throwable);
            if (SwingUtilities.isEventDispatchThread()) {
                exceptionDialogRunnable.run();
            }
            try {
                SwingUtilities.invokeLater(exceptionDialogRunnable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void popupCurrentCell(Point point) {
        int n = this._table.rowAtPoint(point);
        int n2 = this._table.columnAtPoint(point);
        Object object = this._table.getValueAt(n, n2);
        String string = this._table.getColumnName(n2);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setText(object == null ? "" : object.toString());
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this._table, (Component)jPanel, null, (String)string, (int)2);
        jEWTDialog.setMinimumSize(new Dimension(300, 120));
        WizardLauncher.runDialog((JDialog)jEWTDialog);
    }

    private void buildUI() {
        if (this._comp != null) {
            return;
        }
        if (this._style == ViewerStyle.TABLE || this._style == ViewerStyle.VTABLE) {
            this._comp = this.buildTable();
        } else if (this._style == ViewerStyle.CODE) {
            this._comp = EditorFactory.createIdeEditorPane();
            ((BasicEditorPane)this._comp).setText("");
            ((BasicEditorPane)this._comp).setDocument((Document)new BasicDocument("foo.plsql"));
            final LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
            HighlightEditorPlugin highlightEditorPlugin = new HighlightEditorPlugin();
            ((BasicEditorPane)this._comp).installPlugin((EditorPlugin)lineGutterPlugin);
            ((BasicEditorPane)this._comp).installPlugin((EditorPlugin)highlightEditorPlugin);
            ((BasicEditorPane)this._comp).setText("");
            ((BasicEditorPane)this._comp).setEditable(false);
            ((BasicEditorPane)this._comp).setBackground(Color.WHITE);
            ((JScrollPane)this.getScrollableUI()).setRowHeaderView((Component)lineGutterPlugin);
            final JPopupMenu jPopupMenu = new JPopupMenu(Messages.getString("DisplayCodeEditor.3"));
            JMenuItem jMenuItem = new JMenuItem(Messages.getString("DisplayCodeEditor.4"));
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EditorProperties editorProperties = EditorProperties.getProperties();
                    boolean bl = !editorProperties.getBooleanProperty("show-line-numbers");
                    editorProperties.putBooleanProperty("show-line-numbers", bl);
                }
            });
            lineGutterPlugin.addGutterClickListener(new GutterClickListener(){

                public void lineClicked(Gutter gutter, int n, MouseEvent mouseEvent) {
                    gutter.hashCode();
                    jPopupMenu.show((Component)lineGutterPlugin, mouseEvent.getX(), mouseEvent.getY());
                }
            });
            ((JScrollPane)this.getScrollableUI()).getRowHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    int n = mouseEvent.getModifiers();
                    if ((n & 8) != 0 || (n & 4) != 0) {
                        jPopupMenu.show((Component)lineGutterPlugin, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._listenerList.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._listenerList.removePropertyChangeListener(propertyChangeListener);
    }

    protected final void firePropertyChangeEvent(String string, Object object, Object object2) {
        this._listenerList.firePropertyChange(string, object, object2);
    }
}

