/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.recent;

import oracle.dbtools.raptor.navigator.db.DBNavigatorManager;
import oracle.dbtools.raptor.oviewer.recent.RecentObjectsWindow;
import oracle.dbtools.raptor.view.AbstractDockableFactory;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.layout.ViewId;

public class RecentObjectsDockableFactory
extends AbstractDockableFactory {
    private static RecentObjectsWindow s_recentObjectsWindow;

    public DockableView getDockableImpl() {
        return RecentObjectsDockableFactory.getRecentObjectsWindow();
    }

    protected DockingParam createDockingParam() {
        DockingParam dockingParam = new DockingParam();
        DBNavigatorManager dBNavigatorManager = DBNavigatorManager.getInstance();
        if (dBNavigatorManager.getNavigatorWindow() != null) {
            dockingParam.setPosition((Dockable)dBNavigatorManager.getNavigatorWindow(), 3, 0);
        } else {
            ExplorerManager explorerManager = ExplorerManager.getExplorerManager();
            Dockable dockable = null;
            if (explorerManager != null) {
                ViewId viewId = explorerManager.getDefaultViewId();
                dockable = DockStation.getDockStation().findDockable(viewId);
            }
            dockingParam.setPosition(dockable, 4, 0);
        }
        return dockingParam;
    }

    static RecentObjectsWindow getRecentObjectsWindow() {
        if (s_recentObjectsWindow == null) {
            s_recentObjectsWindow = new RecentObjectsWindow();
        }
        return s_recentObjectsWindow;
    }

    protected ViewId getDefaultViewId() {
        return new ViewId("RECENT_OBJECTS_VIEW_TYPE.oracle-dbtools-raptor-recent-objects-Window");
    }
}

