/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.controls.grid.RaptorJTable;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.MasterDetailPanel;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.javatools.db.DBException;
import oracle.javatools.util.Log;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

public class PLSQLProfiles
extends MasterDetailPanel {
    boolean knowApplicable = false;
    int majorVersion = 0;
    int minorVersion = 0;

    @Override
    public String parentQuery() {
        if (!this.knowApplicable) {
            try {
                PlSqlNode plSqlNode = (PlSqlNode)this.getContext().getNode();
                String string = plSqlNode.getConnectionName();
                Version version = RaptorVersionTracker.getDbVersion(Connections.getInstance().getConnection(string));
                if (version == null) {
                    return "Failed to get dbversion";
                }
                this.majorVersion = version.toIntArray()[0];
                this.minorVersion = version.toIntArray()[1];
                if (this.majorVersion < 11) {
                    return "Select 'RDBMS version 11 is minimal required' \"Warning\" from dual";
                }
                Connection connection = Connections.getInstance().getConnection(this.getConnectionName());
                Statement statement = connection.createStatement();
                statement.executeQuery("select 1 from DBMSHP_FUNCTION_INFO where rownum = 1 union all select 1 from DBMSHP_PARENT_CHILD_INFO where rownum = 1 union all select 1 from DBMSHP_RUNS where rownum = 1 ");
                statement.close();
                this.knowApplicable = true;
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 942 || sQLException.getErrorCode() == 1775) {
                    return "Select 'Required tables DBMSHP_FUNCTION_INFO,DBMSHP_PARENT_CHILD_INFO,DBMSHP_RUNS missing' \"Warning\" from dual";
                }
                return "Select 'Unexpected SQLException during version check' \"Warning\" from dual";
            }
            catch (DBException dBException) {
                Log.error((String)("Unexpected DBException " + dBException.getMessage()));
            }
        }
        return "SELECT fi.runid RUNID, \nto_char(r.run_timestamp,'dd-mon-yyyy hh:mi') \"Timestamp\", \ncase when r.run_comment is null then ' ' else r.run_comment end \"Comment\", \n'<html><b>'||r.total_elapsed_time||'</b> &mu;s</html>' \"Total Elapsed Time\" \nFROM dbmshp_function_info fi, dbmshp_parent_child_info pc, dbmshp_runs r \nWHERE OWNER = :OBJECT_OWNER and module=:OBJECT_NAME and SYMBOLID=CHILDSYMID \nand pc.runid=fi.runid and pc.runid=r.runid and parentsymid =1 \norder by runid";
    }

    @Override
    public String[] childQueries() {
        return new String[]{"select \n'<html><b>'||c.subtree_elapsed_time||'</b> &mu;s</html>' \"Total\",\n'<html><b>'||to_char(c.subtree_elapsed_time*100/total,'990d0')||'%'||'</b></html>' \"Tot%\",  \nc.function_elapsed_time \"Function\",  \nto_char(c.function_elapsed_time*100/total, '990d0')||'%' \"Fun%\",  \nc.subtree_elapsed_time-c.function_elapsed_time \"Descendants\",  \nto_char((c.subtree_elapsed_time-c.function_elapsed_time)*100/total, '990d0')||'%' \"Desc%\", \nc.calls \"Calls\",  \nto_char(c.calls*100/tcalls, '990d0')||'%' \"Cal%\", \nc.owner || '.' ||\ncase when c.module = c.function then c.function else c.module||'.'||c.function end ||\ncase when c.line# = 0 then '' else ' (Line '||c.line#||')' end \n\"Function Name\"\n" + this.sqlId() + "from dbmshp_function_info c\n, (select max(subtree_elapsed_time) total,sum(calls) tcalls from dbmshp_function_info where  runid=:RUNID)\nwhere  c.runid=:RUNID\n", "select\n'<html><b>'||sum(c.function_elapsed_time)||'</b> &mu;s</html>' \"Exec Time\", \n'<html><b>'||to_char(sum(c.function_elapsed_time)*100/total,'990d0')||'%'||'</b></html>' \"Tot%\",  \nsum(c.calls) \"Calls\",\nto_char(sum(c.calls)*100/tcalls, '990d0')||'%' \"Cal%\", \nc.owner || '.' || c.module\n\"Module\"\nfrom dbmshp_function_info c\n, (select max(subtree_elapsed_time) total,sum(calls) tcalls from dbmshp_function_info where  runid=:RUNID)\nwhere  c.runid=:RUNID\ngroup by c.owner, c.module, total, tcalls\t\n", "select\n'<html><b>'||sum(c.function_elapsed_time)||'</b> &mu;s</html>' \"Exec Time\",\n'<html><b>'||to_char(sum(c.function_elapsed_time)*100/total,'990d0')||'%'||'</b></html>' \"Tot%\", \nsum(c.calls) \"Calls\",  \nto_char(sum(c.calls)*100/tcalls, '990d0')||'%' \"Cal%\",  \nc.namespace  \"Namespace\"\nfrom dbmshp_function_info c\n, (select max(subtree_elapsed_time) total,sum(calls) tcalls from dbmshp_function_info where  runid=:RUNID)\nwhere  c.runid=:RUNID\ngroup by c.namespace, total, tcalls\n", "select pc.parentsymid parent_id, pc.childsymid id, /*LPAD(' ', (LEVEL-1) * 4) || c.owner || '.' ||*/\ncase when c.module = c.function then c.function else c.module||'.'||c.function end \"Callee\",\n'<html><P align=\"right\"><b>'||pc.function_elapsed_time||'</b> &mu;s</p></html>' \"Elapsed\", \npc.subtree_elapsed_time \"Aggregated\", pc.calls \"Calls#\"\nfrom dbmshp_parent_child_info pc, dbmshp_function_info p, dbmshp_function_info c\nstart with  pc.runid=:RUNID and p.runid = pc.runid and c.runid = pc.runid\nand pc.childsymid = c.symbolid and pc.parentsymid = p.symbolid and p.symbolid=1\nconnect by  pc.runid=prior pc.runid and p.runid = pc.runid and c.runid = pc.runid\nand pc.childsymid = c.symbolid and pc.parentsymid = p.symbolid\nand prior pc.childsymid = pc.parentsymid"};
    }

    private String sqlId() {
        if (this.majorVersion < 12) {
            return "";
        }
        if (12 == this.majorVersion && this.minorVersion < 2) {
            return "";
        }
        return ",\n case when sql_id is NULL then ' ' else 'SQLDEV:LINK:'||sql_text||':'||sql_id||':oracle.dbtools.raptor.plsql.SqlIdDrillLink' end \"sql_id\"\n,\n case when sql_text is NULL then ' ' else sql_text end \"sql_text\"\n";
    }

    @Override
    public String[] tabNames() {
        return new String[]{Messages.getString("FunctionCalls"), Messages.getString("Module"), Messages.getString("Namespace"), Messages.getString("CallHierarchy")};
    }

    @Override
    public JMenuItem[] popupMenu(final int n) {
        if (this.tabNames().length <= n) {
            return new JMenuItem[0];
        }
        int n2 = this.parentTbl.getRowCount();
        if (n2 == 0) {
            return new JMenuItem[0];
        }
        int n3 = this.parentTbl.getSelectedRow();
        Object object = this.parentTbl.getModel().getValueAt(n3, 0);
        Integer n4 = null;
        try {
            n4 = ((NUMBER)object).intValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new JMenuItem[0];
        }
        final int n5 = n4;
        JMenuItem[] jMenuItemArray = new JMenuItem[n2 - 1];
        for (int i = 0; i < n2; ++i) {
            if (i == n3) continue;
            object = this.parentTbl.getModel().getValueAt(i, 0);
            n4 = null;
            try {
                n4 = ((NUMBER)object).intValue();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return new JMenuItem[0];
            }
            final int n6 = n4;
            int n7 = i;
            if (n3 < i) {
                --n7;
            }
            jMenuItemArray[n7] = new JMenuItem(Messages.getString("Compare_with_RUNID") + " " + n6);
            jMenuItemArray[n7].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PLSQLProfiles.this.cmp(n, n5, n6);
                }
            });
        }
        return jMenuItemArray;
    }

    void cmp(int n, int n2, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string : this.scanBinds(this.childQueries()[n])) {
            arrayList.add(n3);
        }
        Object object = new ResultSetTable();
        if (((ResultSetTable)((Object)object)).getGridModel() == null) {
            ((ResultSetTable)((Object)object)).setQuery(this.getConnectionName(), this.childQueries()[n], arrayList, null);
            try {
                ((ResultSetTable)((Object)object)).open(false);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(MasterDetailPanel.class.getName()).log(Level.SEVERE, executionException.getLocalizedMessage(), executionException);
            }
        } else {
            ((ResultSetTable)((Object)object)).getGridModel().setBindList(arrayList);
        }
        try {
            object.refresh();
        }
        catch (ExecutionException executionException) {
            Logger.getLogger(MasterDetailPanel.class.getName()).log(Level.SEVERE, executionException.getLocalizedMessage(), executionException);
        }
        int n4 = object.getColumnCount() - 1;
        RaptorJTable raptorJTable = PLSQLProfiles.cmp(this.childTbls[n].getModel(), object.getModel(), n4);
        for (int i = 0; i < raptorJTable.getColumnModel().getColumnCount(); ++i) {
            int n5 = object.getColumnModel().getColumn(i).getPreferredWidth();
            raptorJTable.getColumnModel().getColumn(i).setPreferredWidth(n5);
            if (i == n4) continue;
            raptorJTable.getColumnModel().getColumn(i).setPreferredWidth(n5 * 2);
        }
        JScrollPane jScrollPane = new JScrollPane((Component)raptorJTable);
        this.tabbedPane.add(Messages.getString("Compare") + " " + n2 + "," + n3, jScrollPane);
    }

    @Override
    protected void updateActiveTab(Object object) {
        if (this.childQueries().length < this.tabbedPane.getSelectedIndex()) {
            return;
        }
        super.updateActiveTab(object);
    }

    static RaptorJTable cmp(TableModel tableModel, TableModel tableModel2, int n) {
        int n2;
        Object[] objectArray;
        if (n < 0) {
            throw new AssertionError((Object)("pk = " + n + " < 0"));
        }
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        LinkedList<Object[]> linkedList2 = new LinkedList<Object[]>();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            int n3;
            Object object = tableModel.getValueAt(i, n);
            objectArray = null;
            for (n3 = 0; n3 < tableModel2.getRowCount(); ++n3) {
                Object object2 = tableModel2.getValueAt(n3, n);
                if (!object.equals(object2)) continue;
                objectArray = new Object[tableModel.getColumnCount()];
                objectArray[n] = tableModel.getValueAt(i, n);
                for (int j = 0; j < objectArray.length; ++j) {
                    if (j == n) continue;
                    objectArray[j] = PLSQLProfiles.displayDiff(tableModel, tableModel2, i, n3, j);
                }
                linkedList.add(objectArray);
                break;
            }
            if (objectArray != null) continue;
            objectArray = new Object[tableModel.getColumnCount()];
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                objectArray[n3] = PLSQLProfiles.cleanHtml(tableModel.getValueAt(i, n3));
            }
            linkedList2.add(objectArray);
        }
        LinkedList<Object[]> linkedList3 = new LinkedList<Object[]>();
        for (int i = 0; i < tableModel2.getRowCount(); ++i) {
            int n4;
            objectArray = tableModel2.getValueAt(i, n);
            Object[] objectArray2 = null;
            for (n4 = 0; n4 < tableModel.getRowCount(); ++n4) {
                Object object = tableModel.getValueAt(n4, n);
                if (!object.equals(objectArray)) continue;
                objectArray2 = new Object[tableModel.getColumnCount()];
                break;
            }
            if (objectArray2 != null) continue;
            objectArray2 = new Object[tableModel2.getColumnCount()];
            for (n4 = 0; n4 < objectArray2.length; ++n4) {
                objectArray2[n4] = PLSQLProfiles.cleanHtml(tableModel2.getValueAt(i, n4));
            }
            linkedList3.add(objectArray2);
        }
        Object[][] objectArray3 = new Object[linkedList.size() + linkedList3.size() + linkedList2.size()][tableModel.getColumnCount()];
        objectArray = new Object[tableModel.getColumnCount()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = tableModel.getColumnName(i);
        }
        RaptorJTable raptorJTable = new RaptorJTable(objectArray3, objectArray){

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if ("del".equals(this.getProperty("row=" + n))) {
                    component.setBackground(new Color(240, 200, 200));
                } else if ("add".equals(this.getProperty("row=" + n))) {
                    component.setBackground(new Color(200, 240, 200));
                } else {
                    component.setBackground(Color.WHITE);
                }
                return component;
            }
        };
        int n5 = 0;
        for (Object[] objectArray4 : linkedList2) {
            raptorJTable.setProperty("row=" + n5, "del");
            for (n2 = 0; n2 < objectArray4.length; ++n2) {
                objectArray3[n5][n2] = objectArray4[n2];
            }
            ++n5;
        }
        for (Object[] objectArray4 : linkedList) {
            for (n2 = 0; n2 < objectArray4.length; ++n2) {
                objectArray3[n5][n2] = objectArray4[n2];
            }
            ++n5;
        }
        for (Object[] objectArray4 : linkedList3) {
            raptorJTable.setProperty("row=" + n5, "add");
            for (n2 = 0; n2 < objectArray4.length; ++n2) {
                objectArray3[n5][n2] = objectArray4[n2];
            }
            ++n5;
        }
        return raptorJTable;
    }

    public static String displayDiff(TableModel tableModel, TableModel tableModel2, int n, int n2, int n3) {
        String string;
        String string2 = PLSQLProfiles.toString(tableModel.getValueAt(n, n3));
        if (string2.equals(string = PLSQLProfiles.toString(tableModel2.getValueAt(n2, n3)))) {
            return PLSQLProfiles.cleanHtml(string2).trim();
        }
        string2 = PLSQLProfiles.cleanHtml(string2).trim();
        string = PLSQLProfiles.cleanHtml(string).trim();
        return string2 + " -> " + string;
    }

    public static String toString(Object object) {
        String string = object.toString();
        if (object instanceof Datum) {
            try {
                string = ((Datum)object).stringValue();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return string;
    }

    public static String cleanHtml(Object object) {
        String string = PLSQLProfiles.toString(object);
        string = string.replace("<html>", "");
        string = string.replace("</html>", "");
        string = string.replace("<b>", "");
        string = string.replace("</b>", "");
        string = string.replace("&mu;s", "");
        string = string.replace("</b>", "");
        string = string.replace("</b>", "");
        return string;
    }

    public static void main(String[] stringArray) {
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn("A");
        defaultTableModel.addColumn("B");
        defaultTableModel.addColumn("C");
        defaultTableModel.insertRow(0, new Object[]{1, "1b", "1c"});
        defaultTableModel.insertRow(1, new Object[]{2, "2b", "2c"});
        DefaultTableModel defaultTableModel2 = new DefaultTableModel();
        defaultTableModel2.addColumn("A");
        defaultTableModel2.addColumn("B");
        defaultTableModel2.addColumn("C");
        defaultTableModel2.insertRow(0, new Object[]{2, "2b", "2c"});
        defaultTableModel2.insertRow(1, new Object[]{3, "3b", "3c"});
        JFrame jFrame = new JFrame("Test comparison table");
        jFrame.setDefaultCloseOperation(3);
        RaptorJTable raptorJTable = PLSQLProfiles.cmp(defaultTableModel, defaultTableModel2, 0);
        raptorJTable.setFont(new Font("TimesRoman", 0, 32));
        raptorJTable.setRowHeight(35);
        jFrame.add(new JScrollPane((Component)raptorJTable));
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.move(1200, 700);
    }
}

