/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.ide.ceditor.options.FontSizeOptions;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class ArboriEditor
extends JTextPane {
    private Map<Token, Style> styles;
    Style queryStyle;
    int fontSize;
    String fontFamily;

    public ArboriEditor() {
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                ArboriEditor.this.colorize();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
    }

    private void initStyles() {
        this.queryStyle = this.addStyle("queryStyle", null);
        StyleConstants.setForeground(this.queryStyle, new Color(50, 100, 50));
        StyleConstants.setFontFamily(this.queryStyle, "monospaced");
        Preferences preferences = Preferences.getPreferences();
        FontSizeOptions fontSizeOptions = FontSizeOptions.getInstance((PropertyStorage)preferences);
        this.fontFamily = fontSizeOptions.getFontFamily();
        this.fontSize = fontSizeOptions.getFontSize() + 3;
        StyleConstants.setFontSize(this.queryStyle, this.fontSize);
        StyleConstants.setBold(this.queryStyle, true);
        StyleConstants.setItalic(this.queryStyle, true);
        this.initStyle(Token.COMMENT, Color.gray);
        this.initStyle(Token.OPERATION, new Color(150, 75, 75));
        this.initStyle(Token.IDENTIFIER, Color.black);
        this.initStyle(Token.DIGITS, Color.blue);
        this.initStyle(Token.AUXILIARY, Color.red);
        this.initStyle(Token.BQUOTED_STRING, Color.magenta);
        this.initStyle(Token.DQUOTED_STRING, Color.black);
        this.initStyle(Token.QUOTED_STRING, new Color(150, 0, 0));
        this.initStyle(Token.WS, Color.black);
        this.initStyle(Token.LINE_COMMENT, Color.DARK_GRAY);
    }

    private void initStyle(Token token, Color color) {
        Style style = this.addStyle(color.toString(), null);
        StyleConstants.setForeground(style, color);
        StyleConstants.setFontFamily(style, "monospaced");
        StyleConstants.setFontSize(this.queryStyle, this.fontSize);
        this.styles.put(token, style);
    }

    public void colorize() {
        if (this.styles == null) {
            this.styles = new HashMap<Token, Style>();
            this.initStyles();
        }
        final StyledDocument styledDocument = this.getStyledDocument();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ArboriEditor.this.colorize(styledDocument);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void colorize(StyledDocument styledDocument) {
        String string = "N/A";
        try {
            string = styledDocument.getText(0, styledDocument.getLength());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return;
        }
        List list = LexerToken.parse((String)string, (boolean)true);
        LexerToken lexerToken = null;
        for (LexerToken lexerToken2 : list) {
            if (lexerToken != null) {
                if (lexerToken2.content != ":") {
                    styledDocument.setCharacterAttributes(lexerToken.begin, lexerToken.end - lexerToken.begin, this.styles.get(lexerToken.type), true);
                } else {
                    styledDocument.setCharacterAttributes(lexerToken.begin, lexerToken.end - lexerToken.begin, this.queryStyle, true);
                }
            }
            if (lexerToken2.type == Token.WS) continue;
            lexerToken = lexerToken2;
        }
        if (lexerToken != null) {
            styledDocument.setCharacterAttributes(lexerToken.begin, lexerToken.end - lexerToken.begin, this.styles.get(lexerToken.type), true);
        }
    }
}

