/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner.debug;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.runner.DBSourceFinder;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnector;
import oracle.jdevimpl.debugger.support.DebugFactory;
import oracle.jdevimpl.runner.debug.DatabaseDebuggingHelper;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggerHostDialog;
import oracle.jdevimpl.runner.debug.DebuggingListener;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

public class RaptorDebuggingHelper
implements DatabaseDebuggingHelper {
    private DebuggingProcess debuggingProcess;
    private DBSourceFinder m_dbSrcFinder = new DBSourceFinder(null);
    private DebuggingListener databaseListener;
    private String probeSessionId;
    private final Object databaseConnectionSync = new Object();
    private Boolean databaseConnectionDone;
    private DebugConnection m_conn;
    private boolean m_useJDWP = false;
    private static final String CALL_DBMS_DEBUG_JDWP_CONNECT = "CALL DBMS_DEBUG_JDWP.CONNECT_TCP";
    private static final String CALL_DBMS_DEBUG_JDWP_DISCONNECT = "CALL DBMS_DEBUG_JDWP.DISCONNECT()";

    public static void initialize() {
        DebuggingProcess.setDatabaseDebuggingHelperClass(RaptorDebuggingHelper.class);
    }

    public void setDebuggingProcess(DebuggingProcess debuggingProcess) {
        RunConfiguration runConfiguration;
        String string;
        this.debuggingProcess = debuggingProcess;
        if (RaptorExtensionConstants.isStandAlone()) {
            debuggingProcess.getValue("Database", null, "DatabaseRunHelper");
        }
        if ((string = (runConfiguration = debuggingProcess.getRunConfiguration()).getConnectionName()) != null) {
            this.m_dbSrcFinder = new DBSourceFinder(string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canRunInDatabase(Node node, Object object, List list) {
        if (object != null) {
            Connection connection = (Connection)object;
            if (Connections.getInstance().isOracle(connection)) {
                if (!RaptorDebuggingHelper.useJDWPForDatabase(connection)) return true;
                if (RaptorDebuggingHelper.canGetLocalHost()) {
                    return true;
                }
                String string = DbgArb.format((int)769, (Object)node.getShortLabel());
                list.add(string);
                return false;
            } else {
                String string = DbgArb.format((int)767, (Object)node.getShortLabel());
                list.add(string);
            }
            return false;
        } else {
            String string = DbgArb.format((int)766, (Object)node.getShortLabel());
            list.add(string);
        }
        return false;
    }

    public String[][] getDatabaseCommands(Object object) {
        if (object instanceof DebugConnection) {
            this.m_conn = (DebugConnection)object;
            this.m_dbSrcFinder = new DBSourceFinder(this.m_conn.getConnectionName());
            Connection connection = this.m_conn.getConnection();
            int n = 12;
            try {
                n = connection.getMetaData().getDatabaseMajorVersion();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            DebugCommands debugCommands = null;
            this.m_useJDWP = RaptorDebuggingHelper.useJDWPForDatabase(connection);
            if (this.m_useJDWP) {
                String string = RaptorDebuggingHelper.getLocalHost(this.m_conn.getConnectionName());
                if (RaptorDebuggingHelper.shouldPromptForDebuggerHost()) {
                    string = RaptorDebuggingHelper.promptForDebuggerHost(string);
                }
                if (this.startDatabaseListener()) {
                    String string2 = this.debuggingProcess.getPort();
                    debugCommands = new DebugCommands();
                    if (n <= 11) {
                        debugCommands.addStartCommand("ALTER SESSION SET PLSQL_DEBUG=TRUE");
                    }
                    if (n == 9) {
                        debugCommands.addStartCommand("ALTER SESSION SET PLSQL_COMPILER_FLAGS=INTERPRETED");
                    }
                    debugCommands.addStartCommand("CALL DBMS_DEBUG_JDWP.CONNECT_TCP( '" + string + "', '" + string2 + "' )");
                    debugCommands.addEndCommand(CALL_DBMS_DEBUG_JDWP_DISCONNECT);
                }
            } else if (this.startProbeDebugging()) {
                int n2 = this.probeSessionId.length() + 1;
                n2 += 10 - n2 % 10;
                debugCommands = new DebugCommands();
                if (n <= 11) {
                    debugCommands.addStartCommand("ALTER SESSION SET PLSQL_DEBUG=TRUE");
                }
                if (n == 9) {
                    debugCommands.addStartCommand("ALTER SESSION SET PLSQL_COMPILER_FLAGS=INTERPRETED");
                }
                debugCommands.addStartCommand("DECLARE\n  id VARCHAR2( " + n2 + " );\nBEGIN\n  id := DBMS_DEBUG.initialize( '" + this.probeSessionId + "', 0 );\n  DBMS_DEBUG.debug_on( TRUE );\nEND;");
                debugCommands.addEndCommand("BEGIN\n  DBMS_DEBUG.debug_off();\nEND;");
            }
            return debugCommands != null ? debugCommands.getCommands() : (String[][])null;
        }
        return null;
    }

    public void handleDatabaseError(String[][] stringArray, int n, int n2, int n3) {
        if (this.m_useJDWP && stringArray[n][n2].indexOf(CALL_DBMS_DEBUG_JDWP_CONNECT) != -1) {
            switch (n3) {
                case 1031: {
                    this.debuggingProcess.log((Object)DbgArb.getString((int)784));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForDatabase() {
        boolean bl = false;
        Object object = this.databaseConnectionSync;
        synchronized (object) {
            if (this.databaseConnectionDone != null) {
                bl = this.databaseConnectionDone;
            } else {
                try {
                    this.databaseConnectionSync.wait();
                    bl = this.databaseConnectionDone;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    public void startTargetFailed() {
        this.setDatabaseConnectionDone(false);
        if (this.probeSessionId == null && this.databaseListener != null) {
            this.databaseListener.stopListening();
            this.databaseListener = null;
        }
    }

    public void connectionAccepted() {
        if (this.databaseListener != null) {
            this.setDatabaseConnectionDone(true);
            this.databaseListener = null;
        }
    }

    public void listenerStopped() {
        if (this.databaseListener != null) {
            this.setDatabaseConnectionDone(false);
            this.databaseListener = null;
        }
    }

    public void finished() {
        if (this.databaseListener != null) {
            this.databaseListener.stopListening();
        }
    }

    public int getDebuggerFactory() {
        if (this.probeSessionId != null) {
            return 2;
        }
        return DebugFactory.FACTORY_JPDA_Listen;
    }

    public URL findSourceFile(Workspace workspace, Project project, String string, String string2) {
        return this.m_dbSrcFinder.findSourceFile(workspace, project, string, string2);
    }

    private static boolean useJDWPForDatabase(Connection connection) {
        Version version = RaptorVersionTracker.getDbVersion(connection);
        return DBUtil.ORACLE9i_VERSION.compareTo(version) <= 0 && Ide.getProperty((String)"DatabaseDebuggerDisableJDWP") == null;
    }

    private boolean startDatabaseListener() {
        if (this.databaseListener == null) {
            String string = this.debuggingProcess.getPort();
            if (string == null) {
                String string2 = Ide.getProperty((String)"DatabaseDebuggerPortOverride");
                string = string2 != null ? string2 : this.debuggingProcess.getLocalPort();
                this.debuggingProcess.setPort(string);
            }
            this.databaseListener = new DebuggingListener(this.debuggingProcess, false);
            if (!this.databaseListener.startListening(string)) {
                this.databaseListener = null;
                return false;
            }
        }
        return true;
    }

    private static boolean shouldPromptForDebuggerHost() {
        DebugWindowSettings debugWindowSettings = DebugWindowSettings.getInstance();
        return debugWindowSettings.isPromptForDebuggerHostForDatabaseDebugging();
    }

    private static String promptForDebuggerHost(String string) {
        string = DebuggerHostDialog.showDebuggerHostDialog((String)string);
        return string;
    }

    private boolean startProbeDebugging() {
        if (this.probeSessionId == null) {
            String string = RaptorDebuggingHelper.getLocalHost(this.m_conn.getConnectionName());
            if (string == null) {
                string = "SQL Developer";
            }
            this.probeSessionId = string + ":" + new Date().getTime();
            DebugConnector debugConnector = DebugFactory.newInstance((int)2);
            DebugConnectArg[] debugConnectArgArray = debugConnector.getConnectArgs();
            assert (debugConnectArgArray.length == 2) : "Wrong number of arguments";
            debugConnectArgArray[0].setValue(this.m_conn.getConnectionName());
            debugConnectArgArray[1].setValue(this.probeSessionId);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    RaptorDebuggingHelper.this.debuggingProcess.afterConnection(DbgArb.getString((int)150));
                    RaptorDebuggingHelper.this.setDatabaseConnectionDone(true);
                }
            };
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    RaptorDebuggingHelper.this.setDatabaseConnectionDone(false);
                    RaptorDebuggingHelper.this.debuggingProcess.log((Object)DbgArb.getString((int)151));
                    RaptorDebuggingHelper.this.debuggingProcess.superTerminate();
                }
            };
            Runnable runnable3 = new Runnable(){

                @Override
                public void run() {
                    RaptorDebuggingHelper.this.setDatabaseConnectionDone(false);
                    RaptorDebuggingHelper.this.debuggingProcess.superTerminate();
                }
            };
            String string2 = DbgArb.getString((int)148);
            String string3 = DbgArb.getString((int)149);
            this.debuggingProcess.connectToDebuggee(debugConnector, debugConnectArgArray, string2, string3, runnable, runnable2, runnable3);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDatabaseConnectionDone(boolean bl) {
        Object object = this.databaseConnectionSync;
        synchronized (object) {
            this.databaseConnectionDone = bl ? Boolean.TRUE : Boolean.FALSE;
            this.databaseConnectionSync.notify();
        }
    }

    private static boolean canGetLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostAddress() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String getLocalHost(String string) {
        String string2 = null;
        try {
            Connections connections = Connections.getInstance();
            Properties properties = connections.getConnectionInfo(string);
            Connections.populateConnectionInfo(properties);
            String string3 = properties.getProperty("hostname");
            DatagramSocket datagramSocket = new DatagramSocket();
            datagramSocket.connect(InetAddress.getByName(string3), 7);
            InetAddress inetAddress = datagramSocket.getLocalAddress();
            if (!inetAddress.isAnyLocalAddress()) {
                string2 = inetAddress.getHostAddress();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 == null) {
            try {
                string2 = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }

    public static final class DebugConnection {
        private String m_connName;
        private Connection m_conn;

        public DebugConnection(String string, Connection connection) {
            this.m_connName = string;
            this.m_conn = connection;
        }

        public String getConnectionName() {
            return this.m_connName;
        }

        public Connection getConnection() {
            return this.m_conn;
        }
    }

    private static final class DebugCommands {
        List<String> m_startCommands = new ArrayList<String>();
        List<String> m_endCommands = new ArrayList<String>();

        private DebugCommands() {
        }

        void addStartCommand(String string) {
            this.m_startCommands.add(string);
        }

        void addEndCommand(String string) {
            this.m_endCommands.add(string);
        }

        String[][] getCommands() {
            String[][] stringArray = new String[][]{this.m_startCommands.toArray(new String[0]), this.m_endCommands.toArray(new String[0])};
            return stringArray;
        }
    }
}

