/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemacopy;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.dialogs.schemacopy.DatabaseCopyArb;
import oracle.dbtools.raptor.export.data.DataMover;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.schemacopy.CopyPanelArb;
import oracle.dbtools.raptor.schemacopy.DropConfirmationPrompter;
import oracle.dbtools.raptor.schemacopy.IAutoRefresh;
import oracle.dbtools.raptor.schemacopy.Messages;
import oracle.dbtools.raptor.schemacopy.wizard.CopyWizArb;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFactory;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class CopyAPI {
    private String encoding = IdeUtil.getIdeEncoding();
    private Context context;
    private String copyLogName;
    private Connection _fromConn;
    private Connection _toConn;
    private String fromName = null;
    private boolean _cancel = false;
    private String _type = null;
    private File _file;
    private OutputStream fout;
    private BufferedOutputStream bout;
    private OutputStreamWriter _out;
    private RaptorTask<Void> _task;
    private boolean _suppressLogging;
    private IAutoRefresh _treeRefreshCallback;
    private ArrayList<DBObject> _dndObjectList = new ArrayList();
    public static final String COPYAPI_APPEND_ROWS = "Append Rows";
    public static final String COPYAPI_DROP = "DROP";
    public static final String COPYAPI_TRUNC = "TRUNC";
    public static final String COPYAPI_NONE = "NONE";
    protected static final String EXISTS_SQL = "exists_sql";
    private String _EOL = null;
    int _step = 0;

    public synchronized void setType(String string) {
        this._type = string;
    }

    public synchronized String getType() {
        return this._type;
    }

    public CopyAPI(Connection connection, Connection connection2, String string) {
        this._type = string;
        this._fromConn = connection;
        this.fromName = Connections.getInstance().getConnectionName(this._fromConn);
        this._toConn = connection2;
    }

    private static synchronized LinkedHashMap<String, String> getOrderedTypes() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("DATABASE_LINK", "Oracle#DATABASE_LINK");
        linkedHashMap.put("SEQUENCE", "Oracle#SEQUENCE");
        linkedHashMap.put("TYPE", "Oracle#TYPE");
        linkedHashMap.put("TABLE", "Oracle#TABLE");
        linkedHashMap.put("DATA", "Oracle#DATA");
        linkedHashMap.put("CONSTRAINT", "Oracle#CONSTRAINT");
        linkedHashMap.put("INDEX", "Oracle#INDEX");
        linkedHashMap.put("REFCONSTRAINT", "Oracle#REFCONSTRAINT");
        linkedHashMap.put("TRIGGER", "Oracle#TRIGGER");
        linkedHashMap.put("MATERIALIZED VIEW", "Oracle#MATERIALIZED_VIEW");
        linkedHashMap.put("MATERIALIZED VIEW LOG", "Oracle#MATERIALIZED_VIEW_LOG");
        linkedHashMap.put("VIEW", "Oracle#VIEW");
        linkedHashMap.put("FUNCTION", "Oracle#FUNCTION");
        linkedHashMap.put("PACKAGE", "Oracle#PACKAGE");
        linkedHashMap.put("PACKAGE BODY", "Oracle#PACKAGE_BODY");
        linkedHashMap.put("PROCEDURE", "Oracle#PROCEDURE");
        linkedHashMap.put("SYNONYM", "Oracle#SYNONYM");
        linkedHashMap.put("QUEUE TABLE", "Oracle#QUEUE_TABLE");
        linkedHashMap.put("QUEUE", "Oracle#QUEUE");
        return linkedHashMap;
    }

    private static synchronized LinkedHashMap<String, String> getDropTypes() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("TABLE", "Oracle#TABLE");
        linkedHashMap.put("SYNONYM", "Oracle#SYNONYM");
        linkedHashMap.put("DATABASE_LINK", "Oracle#DATABASE_LINK");
        linkedHashMap.put("SEQUENCE", "Oracle#SEQUENCE");
        linkedHashMap.put("MATERIALIZED VIEW", "Oracle#MATERIALIZED_VIEW");
        linkedHashMap.put("MATERIALIZED VIEW LOG", "Oracle#MATERIALIZED_VIEW_LOG");
        linkedHashMap.put("VIEW", "Oracle#VIEW");
        linkedHashMap.put("FUNCTION", "Oracle#FUNCTION");
        linkedHashMap.put("PACKAGE", "Oracle#PACKAGE");
        linkedHashMap.put("PROCEDURE", "Oracle#PROCEDURE");
        linkedHashMap.put("QUEUE", "Oracle#QUEUE");
        linkedHashMap.put("QUEUE TABLE", "Oracle#QUEUE_TABLE");
        linkedHashMap.put("TYPE", "Oracle#TYPE");
        return linkedHashMap;
    }

    private String getTerm() {
        if (this._EOL == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            this._EOL = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
        return this._EOL;
    }

    public synchronized void copyWithDialog(IAutoRefresh iAutoRefresh) {
        this._treeRefreshCallback = iAutoRefresh;
        this.copyWithDialog();
    }

    public void copyWithDialog() {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(DatabaseCopyArb.getString("COPY_START"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){
            private volatile Thread m_execThread;

            public Void doWork() {
                this.m_execThread = Thread.currentThread();
                try {
                    this.checkCanProceed();
                    CopyAPI.this.doCopy();
                    this.checkCanProceed();
                }
                catch (ExecutionException executionException) {
                    this.getDescriptor().setMessage("Query Cancelled");
                    CopyAPI.this.initObjectFilters(null, false);
                    CopyAPI.this._treeRefreshCallback = null;
                }
                finally {
                    this.m_execThread = null;
                }
                return null;
            }

            public boolean cancel() {
                Thread thread = this.m_execThread;
                if (thread != null) {
                    DBUtil.cancelExecution((Thread)thread);
                    CopyAPI.this._cancel = true;
                    return true;
                }
                return false;
            }
        };
        raptorTask.setCancellable(true);
        raptorTask.setPausable(false);
        RaptorTaskDescriptor raptorTaskDescriptor = raptorTask.getDescriptor();
        raptorTaskDescriptor.addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CopyAPI.this._treeRefreshCallback != null) {
                            CopyAPI.this._treeRefreshCallback.refresh();
                        }
                        try {
                            if (!CopyAPI.this._suppressLogging) {
                                TextNode textNode = new TextNode(URLFactory.newFileURL((File)CopyAPI.this._file));
                                CopyAPI.this.context = Context.newIdeContext((Node)textNode);
                                OpenEditorOptions openEditorOptions = new OpenEditorOptions(CopyAPI.this.context);
                                openEditorOptions.setFlags(1);
                                EditorManager.getEditorManager().openEditor(openEditorOptions);
                            }
                        }
                        catch (Exception exception) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                        finally {
                            CopyAPI.this._treeRefreshCallback = null;
                            CopyAPI.this.initObjectFilters(null, false);
                        }
                    }
                });
            }
        });
        this._task = raptorTask;
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void setProg(String string) {
        RaptorTaskDescriptor raptorTaskDescriptor = null;
        if (this._task != null) {
            raptorTaskDescriptor = this._task.getDescriptor();
            raptorTaskDescriptor.setMessage(string);
        }
    }

    public synchronized void initObjectFilters(ArrayList<DatabaseNode> arrayList, boolean bl) {
        DBObject dBObject = null;
        this._dndObjectList.clear();
        this._suppressLogging = bl;
        if (arrayList != null) {
            for (DatabaseNode databaseNode : arrayList) {
                dBObject = databaseNode instanceof ObjectNode ? new DBObject((Element)((ObjectNode)databaseNode).getData()) : (databaseNode instanceof PlSqlNode ? new DBObject((Element)((PlSqlNode)databaseNode).getData()) : null);
                if (dBObject == null) continue;
                this._dndObjectList.add(dBObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void doCopy() {
        block50: {
            block49: {
                this.openLog();
                try {
                    var1_1 = DDLGenerator.getInstance();
                    var2_3 = CopyAPI.getOrderedTypes();
                    var3_4 = new ArrayList<E>();
                    var4_5 = new ArrayList<Object>();
                    var5_6 = null;
                    var6_7 = null;
                    var7_8 = null;
                    var8_9 = false;
                    this.setProg(DatabaseCopyArb.getString("COPY_GEN"));
                    if (this._dndObjectList == null || this._dndObjectList.isEmpty()) {
                        try {
                            var9_10 = this._fromConn.getMetaData().getUserName();
                            for (Object var11_14 : var2_3.entrySet()) {
                                this.checkCancelled();
                                var12_15 = var11_14.getKey();
                                var14_18 = var1_1.getSchemaObjects(this._fromConn, (String)var9_10, (String)var12_15, (String)(var13_16 = (String)var11_14.getValue()));
                                if (var14_18 == null) continue;
                                for (Object var16_22 : var14_18) {
                                    this.checkCancelled();
                                    var3_4.add(var16_22);
                                }
                            }
                        }
                        catch (SQLException var9_11) {
                            this.lineError();
                            this.log(CopyPanelArb.getString("ERROR") + this.getTerm() + var9_11.getMessage() + this.getTerm());
                            this.closeLog();
                            return;
                        }
                        if (this._type.equals("DROP")) {
                            var5_6 = CopyAPI.getDropTypes();
                            var6_7 = new ArrayList<E>();
                            try {
                                var9_10 = this._fromConn.getMetaData().getUserName();
                                for (Object var11_14 : var5_6.entrySet()) {
                                    this.checkCancelled();
                                    var12_15 = (String)var11_14.getKey();
                                    var14_18 = var1_1.getSchemaObjects(this._fromConn, (String)var9_10, (String)var12_15, (String)(var13_16 = (String)var11_14.getValue()));
                                    if (var14_18 == null) continue;
                                    for (Object var16_22 : var14_18) {
                                        this.checkCancelled();
                                        var6_7.add(var16_22);
                                    }
                                }
                            }
                            catch (SQLException var9_12) {
                                this.lineError();
                                this.log(CopyPanelArb.getString("ERROR") + this.getTerm() + var9_12.getMessage() + this.getTerm());
                            }
                            this.dropDBObject(var6_7);
                        }
                    } else {
                        var3_4 = new ArrayList<DBObject>(this._dndObjectList);
                        var9_10 = null;
                        for (Object var11_14 : var3_4) {
                            this.checkCancelled();
                            if (!"TABLE".equals(var11_14.getObjectType())) continue;
                            var12_15 = DBURLFormatHelper.getURL("sqldev.nav", Connections.getInstance().getConnectionName(this._fromConn), null, var11_14.getSchemaName(), "DATA");
                            var13_16 = DBURLFormatHelper.getURL((URL)var12_15, var11_14.getObjectName());
                            var9_10 = new DBObject((URL)var13_16);
                            var4_5.add(var9_10);
                        }
                        var3_4.addAll(var4_5);
                        var6_7 = this.buildDropListForGetTypes(this._toConn, var3_4);
                        if (var6_7 != null && !var6_7.isEmpty()) {
                            DropConfirmationPrompter.getUserActionForDuplicate(this, this.isTableType(var6_7));
                            if (this._type.equals("DROP")) {
                                this.dropDBObject(var6_7);
                            } else if (this._type.equals("Append Rows")) {
                                var8_9 = true;
                            } else if (this._type.equals("NONE")) {
                                return;
                            }
                        }
                    }
                    var9_10 = new ArrayList<E>();
                    var10_13 = new ArrayList<E>();
                    var11_14 = null;
                    var12_15 = null;
                    if (!this._type.equals("TRUNC")) break block49;
                    if (this._dndObjectList == null || this._dndObjectList.isEmpty()) {
                        var11_14 = "select table_name,constraint_name from user_constraints where constraint_type = 'R'";
                    } else {
                        var13_16 = null;
                        var14_18 = null;
                        for (Object var16_22 : var3_4) {
                            this.checkCancelled();
                            if (var13_16 != null) continue;
                            var13_16 = new StringBuilder(" (");
                            var13_16.append("'");
                            var13_16.append(var16_22.getObjectName());
                            var13_16.append("'");
                            var13_16.append(", ");
                        }
                        if (var13_16 != null) {
                            var14_18 = var13_16.toString();
                            var14_18 = var13_16.substring(0, var13_16.lastIndexOf(", ")) + ")";
                        }
                        var11_14 = "select table_name,constraint_name from user_constraints where constraint_type = 'R' AND table_name IN " + var14_18;
                    }
                    if (Connections.getInstance().lock(this.fromName)) {
                        var12_15 = DBUtil.getInstance((String)this.fromName).executeQuery((String)var11_14, Collections.emptyList());
                        try {
                            if (var12_15 == null) ** GOTO lbl123
                            while (var12_15.next()) {
                                this.checkCancelled();
                                var9_10.add("alter table \"" + var12_15.getString(1) + "\" disable constraint \"" + var12_15.getString(2) + "\"");
                                var10_13.add((Map.Entry<String, String>)("alter table \"" + var12_15.getString(1) + "\" enable constraint \"" + var12_15.getString(2) + "\""));
                            }
                        }
                        catch (SQLException var13_17) {
                            this.lineError();
                            this.log(CopyPanelArb.getString("ERROR") + this.getTerm() + var13_17.getMessage() + this.getTerm());
                            this.closeLog();
                            return;
                        }
                    }
lbl123:
                    // 4 sources

                    var13_16 = var9_10.iterator();
                }
                catch (InterruptedException var1_2) {}
                while (var13_16.hasNext()) {
                    var14_18 = (String)var13_16.next();
                    this.checkCancelled();
                    this.setProg(DatabaseCopyArb.getString("DISABLE_CONST"));
                    this.lineStart();
                    this.log(var14_18 + this.getTerm());
                    this.log(ScriptUtils.runSqlReturnResult((String)var14_18, this._toConn));
                    this.lineEnd();
                }
            }
            for (ArrayList<DBObject> var14_18 : var3_4) {
                try {
                    this.checkCancelled();
                }
                catch (InterruptedException var15_20) {
                    if (this._type.equals("TRUNC")) {
                        var16_22 = var10_13.iterator();
                        while (var16_22.hasNext()) {
                            var17_24 = (String)var16_22.next();
                            this.setProg(DatabaseCopyArb.getString("ENABLE_CONST"));
                            this.log(var17_24 + this.getTerm());
                            this.log(ScriptUtils.runSqlReturnResult(var17_24, this._toConn));
                        }
                    }
                    this.lineError();
                    throw var15_20;
                }
                if (var14_18.getObjectType().equals("DATA")) {
                    this.setProg(DatabaseCopyArb.getString("MOVING_DATA") + " " + var14_18.getObjectName());
                    var15_19 = new DataMover(this._fromConn, this._toConn);
                    var15_19.setLogFile(this._out);
                    this.lineStart();
                    this.log(CopyPanelArb.getString("MOVING_DATA_MESSAGE") + var14_18.getObjectName() + this.getTerm());
                    this.lineEnd();
                    var15_19.move((DBObject)var14_18, true);
                    continue;
                }
                if (!var8_9 && !this._type.equals("TRUNC") || this._type.equals("TRUNC") && !var14_18.getObjectType().equals("TABLE") && !var14_18.getObjectType().equals("REFCONSTRAINT") && !var14_18.getObjectType().equals("CONSTRAINT")) {
                    try {
                        this.setProg(DatabaseCopyArb.getString("CREATING_OBJ") + " " + var14_18.getObjectName());
                        var15_19 = "set define off;\n" + var1_1.getCopyDDL((DBObject)var14_18);
                        var16_22 = var15_19.replaceAll("\"" + var14_18.getSchemaName() + "\"\\.", "");
                        if (var14_18.getObjectType().equals("QUEUE TABLE") || var14_18.getObjectType().equals("QUEUE")) {
                            var16_22 = var15_19.replaceAll("'" + var14_18.getSchemaName() + ".", "'");
                        }
                        if (var16_22.equals("")) continue;
                        this.lineStart();
                        this.log((String)var16_22 + this.getTerm());
                        this.log(ScriptUtils.runSqlReturnResult((String)var16_22, this._toConn));
                        this.lineEnd();
                    }
                    catch (Exception var15_21) {
                        this.log(CopyPanelArb.getString("ERROR") + this.getTerm() + var14_18.getObjectName() + this.getTerm() + var15_21.getMessage() + this.getTerm());
                    }
                    continue;
                }
                if (!this._type.equals("TRUNC") || !var14_18.getObjectType().equals("TABLE")) continue;
                this.setProg(DatabaseCopyArb.getString("TRUNC_OBJ") + " " + var14_18.getObjectName());
                var7_8 = "  truncate " + var14_18.getObjectType() + " \"" + var14_18.getObjectName() + "\"";
                this.lineStart();
                this.log(var7_8 + this.getTerm());
                this.log(ScriptUtils.runSqlReturnResult(var7_8, this._toConn));
                this.lineEnd();
            }
            if (!this._type.equals("TRUNC")) break block50;
            var13_16 = var10_13.iterator();
            while (var13_16.hasNext()) {
                var14_18 = (String)var13_16.next();
                this.setProg(DatabaseCopyArb.getString("ENABLE_CONST"));
                this.lineStart();
                this.log(var14_18 + this.getTerm());
                this.log(ScriptUtils.runSqlReturnResult((String)var14_18, this._toConn));
                this.lineEnd();
            }
            break block50;
            {
                finally {
                    DBUtil.closeResultSet((ResultSet)var12_15);
                    Connections.getInstance().unlock(this.fromName);
                }
            }
            {
                this.log(CopyPanelArb.getString("COPY_CANCELED") + this.getTerm());
                this.lineEnd();
            }
            finally {
                this.closeLog();
            }
        }
    }

    private boolean isTableType(List<DBObject> list) {
        boolean bl = false;
        if (list != null) {
            for (DBObject dBObject : list) {
                if (!"TABLE".equals(dBObject.getObjectType())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private List<DBObject> buildDropListForGetTypes(Connection connection, List<DBObject> list) {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        String string = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = null;
        try {
            if (list != null && !list.isEmpty()) {
                string = this.getQuery(this._toConn, EXISTS_SQL);
                for (DBObject dBObject : list) {
                    hashMap.put("TYPE", dBObject.getObjectType());
                    hashMap.put("OWNER", connection.getMetaData().getUserName());
                    hashMap.put("OBJECT_NAME", dBObject.getObjectName());
                    string2 = DBUtil.getInstance((Connection)this._toConn).executeOracleReturnOneCol(string, hashMap);
                    if (!"x".equals(string2)) continue;
                    arrayList.add(dBObject);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return arrayList;
    }

    private Query getQueryFromFile(Connection connection, String string, MetaResource metaResource) {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((MetaResource)metaResource);
        Query query = queryXMLSupport.getQuery(string, connection);
        return query;
    }

    private MetaResource getDefaultQueryFile() {
        return new MetaResource(this.getClass().getClassLoader(), "/oracle/dbtools/raptor/ddl/oracle/ObjectSql.xml");
    }

    private final String getQuery(Connection connection, String string) {
        Query query = this.getQueryFromFile(connection, string, this.getDefaultQueryFile());
        return query.getSql();
    }

    private void dropDBObject(List<DBObject> list) throws InterruptedException {
        String string = null;
        for (DBObject dBObject : list) {
            this.checkCancelled();
            string = dBObject.getObjectType().equals("MATERIALIZED VIEW LOG") ? "  DROP " + dBObject.getObjectType() + " on \"" + dBObject.getObjectName() + "\";" : (dBObject.getObjectType().equals("TABLE") ? "  DROP " + dBObject.getObjectType() + " \"" + dBObject.getObjectName() + "\" cascade constraints;" : (dBObject.getObjectType().equals("QUEUE") ? "begin" + this._EOL + "DBMS_AQADM.DROP_QUEUE(queue_name=>'" + dBObject.getObjectName() + "', auto_commit=>TRUE);" + this._EOL + "end;" : (dBObject.getObjectType().equals("QUEUE TABLE") ? "begin" + this._EOL + "DBMS_AQADM.DROP_QUEUE_TABLE(queue_table=>'" + dBObject.getObjectName() + "', force=>TRUE);" + this._EOL + "end;" : "  DROP " + dBObject.getObjectType() + " \"" + dBObject.getObjectName() + "\";")));
            this.setProg(DatabaseCopyArb.getString("DROP_OBJ") + " " + dBObject.getObjectName());
            this.lineStart();
            this.log(string + this.getTerm());
            this.log(ScriptUtils.runSqlReturnResult(string, this._toConn));
            this.lineEnd();
        }
    }

    private String getStep() {
        ++this._step;
        return Integer.toString(this._step);
    }

    private void clearStep() {
        this._step = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<String, String> getSummary() {
        this.clearStep();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> linkedHashMap2 = CopyAPI.getOrderedTypes();
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        if (Connections.getInstance().lock(this._fromConn)) {
            block27: {
                try {
                    Iterator iterator;
                    try {
                        iterator = this._fromConn.getMetaData().getUserName();
                        for (String string : linkedHashMap2.keySet()) {
                            Object object = linkedHashMap2.get(string);
                            ArrayList<DBObject> arrayList2 = DDLGenerator.getInstance().getSchemaObjects(this._fromConn, (String)((Object)iterator), string, (String)object);
                            if (arrayList2 == null) continue;
                            for (DBObject dBObject : arrayList2) {
                                arrayList.add(dBObject);
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        this.log(CopyPanelArb.getString("ERROR") + this.getTerm() + sQLException.getMessage() + this.getTerm());
                    }
                    if (this._type.equals(COPYAPI_DROP)) {
                        iterator = CopyAPI.getDropTypes();
                        ArrayList<DBObject> arrayList3 = new ArrayList<DBObject>();
                        try {
                            String string = this._fromConn.getMetaData().getUserName();
                            for (ArrayList<DBObject> arrayList2 : ((LinkedHashMap)((Object)iterator)).keySet()) {
                                String string2 = (String)((LinkedHashMap)((Object)iterator)).get(arrayList2);
                                ArrayList<DBObject> arrayList4 = DDLGenerator.getInstance().getSchemaObjects(this._fromConn, string, (String)((Object)arrayList2), string2);
                                if (arrayList4 == null) continue;
                                for (DBObject dBObject : arrayList4) {
                                    arrayList3.add(dBObject);
                                }
                            }
                        }
                        catch (SQLException sQLException) {
                            this.log(CopyPanelArb.getString("ERROR") + this.getTerm() + sQLException.getMessage() + this.getTerm());
                        }
                        for (Object object : arrayList3) {
                            linkedHashMap.put(this.getStep(), " DROP " + ((DBObject)object).getObjectType() + " " + ((DBObject)object).getObjectName());
                        }
                    }
                    if (!this._type.equals(COPYAPI_TRUNC)) break block27;
                    iterator = "select table_name,constraint_name from user_constraints where constraint_type = 'R'";
                    ResultSet resultSet = DBUtil.getInstance((String)this.fromName).executeQuery((String)((Object)iterator), Collections.emptyList());
                    try {
                        if (resultSet != null) {
                            while (resultSet.next()) {
                                linkedList.add("DISABLE constraint \"" + resultSet.getString(2) + " on Table \"" + resultSet.getString(1));
                                linkedList2.add("ENABLE constraint \"" + resultSet.getString(2) + " on Table \"" + resultSet.getString(1));
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        this.log(CopyPanelArb.getString("ERROR") + this.getTerm() + sQLException.getMessage() + this.getTerm());
                    }
                    finally {
                        DBUtil.closeResultSet((ResultSet)resultSet);
                    }
                }
                finally {
                    Connections.getInstance().unlock(this._fromConn);
                }
            }
            for (String string : linkedList) {
                linkedHashMap.put(this.getStep(), string);
            }
            for (DBObject dBObject : arrayList) {
                if (dBObject.getObjectType().equals("DATA")) {
                    linkedHashMap.put(this.getStep(), CopyWizArb.getString("MOVE_DATA_MESSAGE") + dBObject.getObjectName());
                    continue;
                }
                if (!this._type.equals(COPYAPI_TRUNC) || this._type.equals(COPYAPI_TRUNC) && !dBObject.getObjectType().equals("TABLE") && !dBObject.getObjectType().equals("REFCONSTRAINT") && !dBObject.getObjectType().equals("CONSTRAINT")) {
                    linkedHashMap.put(this.getStep(), "CREATE " + dBObject.getObjectType() + " " + dBObject.getObjectName());
                    continue;
                }
                if (!this._type.equals(COPYAPI_TRUNC) || !dBObject.getObjectType().equals("TABLE")) continue;
                linkedHashMap.put(this.getStep(), "TRUNCATE " + dBObject.getObjectName());
            }
            if (this._type.equals(COPYAPI_TRUNC)) {
                for (String string : linkedList2) {
                    linkedHashMap.put(this.getStep(), string);
                }
            }
        }
        return linkedHashMap;
    }

    public void cancel() {
        this._cancel = true;
    }

    private void openLog() {
        if (!this._suppressLogging) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.yyyy-HH.mm.ss");
                StringBuilder stringBuilder = new StringBuilder(simpleDateFormat.format(new Date()));
                this.copyLogName = Ide.getUserSettingsDirectory() + "SchemaCopy." + stringBuilder + ".log";
                this._file = new File(this.copyLogName);
                this.fout = new FileOutputStream(this._file.getPath());
                this.bout = new BufferedOutputStream(this.fout);
                this._out = new OutputStreamWriter((OutputStream)this.bout, this.encoding);
            }
            catch (IOException iOException) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Could Not Create File", (String)(this._file.getPath() + this._file.getName()), null);
            }
        }
    }

    private void lineStart() {
        try {
            if (this._out != null) {
                this._out.write(Messages.getString("CopyAPI.169") + this.getTerm());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void lineEnd() {
        try {
            if (this._out != null) {
                this._out.write(Messages.getString("CopyAPI.170") + this.getTerm());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void lineError() {
        try {
            if (this._out != null) {
                this._out.write(Messages.getString("CopyAPI.171") + this.getTerm());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void log(String string) {
        try {
            if (this._out != null) {
                this._out.write(string + this.getTerm());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeLog() {
        try {
            if (this._out != null) {
                this._out.flush();
                this._out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkCancelled() throws InterruptedException {
        if (Thread.interrupted() || this._cancel) {
            throw new InterruptedException();
        }
    }
}

