/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.URLFileChooserPaths;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.utils.Messages;
import oracle.dbtools.raptor.utils.UtilsResources;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.db.util.IconWithSmallOverlay;
import oracle.ide.dialogs.URLChooserShortcut;
import oracle.ide.dialogs.URLChooserShortcutProvider;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.PlatformUtils;

public class URLChooserShortcuts
implements URLChooserShortcutProvider {
    private static final int MAX_PATH_CONTEXT_SHORTCUTS_COUNT = 10;
    private static URLChooserShortcuts _instance;
    private List<URLChooserShortcut> _shortcuts = new ArrayList<URLChooserShortcut>();
    private static Collection<URLChooserShortcut> __std_doc_location_shortcuts;
    private URLFileChooserPaths.URLFileChooserPathContext pathContext;
    private URLFileChooserPaths.URLFileChooserPathContext defaultPathContext = DBConfig.getInstance().getURLFileChooserPaths().getPathContext("DEFAULT_CONTEXT");
    private static final String URL_PATH_SEPARATOR = "/";

    private URLChooserShortcuts() {
    }

    public static URLChooserShortcuts getInstance() {
        if (null == _instance) {
            _instance = new URLChooserShortcuts();
        }
        return _instance;
    }

    public Collection<URLChooserShortcut> createShortcuts(Context context) {
        return this.initialize(this._shortcuts);
    }

    public void setPathContext(String string) {
        this.pathContext = null == string ? null : DBConfig.getInstance().getURLFileChooserPaths().getPathContext(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<URLChooserShortcut> getStandardDocumentLocationShortcuts() {
        ArrayList<URLChooserShortcut> arrayList = new ArrayList<URLChooserShortcut>();
        Class<URLChooserShortcuts> clazz = URLChooserShortcuts.class;
        synchronized (URLChooserShortcuts.class) {
            if (__std_doc_location_shortcuts == null) {
                __std_doc_location_shortcuts = new ArrayList<URLChooserShortcut>();
                URL uRL = URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory());
                this.addIfExists(URLFactory.newDirURL((URL)uRL, (String)Messages.getString("URLChooserShortcuts.3")), UtilsResources.get("DESKTOP"), __std_doc_location_shortcuts, RaptorImagesArb.getIcon("DESKTOP"));
                this.addIfExists(URLFactory.newDirURL((URL)uRL, (String)Messages.getString("URLChooserShortcuts.4")), UtilsResources.get("DOCUMENTS"), __std_doc_location_shortcuts, RaptorImagesArb.getIcon("MY_DOCUMENTS"));
                if (!PlatformUtils.isWindows7()) {
                    this.addIfExists(URLFactory.newDirURL((URL)uRL, (String)Messages.getString("URLChooserShortcuts.5")), UtilsResources.get("MY_DOCUMENTS"), __std_doc_location_shortcuts, RaptorImagesArb.getIcon("MY_DOCUMENTS"));
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            arrayList.addAll(__std_doc_location_shortcuts);
            this.addDefaultScriptPath(arrayList);
            return arrayList;
        }
    }

    private synchronized Collection<URLChooserShortcut> initialize(List<URLChooserShortcut> list) {
        Icon icon;
        list.clear();
        URLPath uRLPath = this.getPathContextPaths();
        if (uRLPath != null) {
            icon = new IconWithSmallOverlay(OracleIcons.getIcon((String)"header/folder_header.png"), OracleIcons.getIcon((String)"favorites.png"), 16, 16, 12, 12);
            for (URL uRL : uRLPath.asList()) {
                this.addIfExists(uRL, list, icon);
            }
        }
        if ((uRLPath = this.getDefaultPathContextPaths()) != null) {
            icon = OracleIcons.getIcon((String)"header/folder_header.png");
            for (URL uRL : uRLPath.asList()) {
                this.addIfExists(uRL, list, icon);
            }
        }
        if (this._shortcuts.size() > 10) {
            this._shortcuts.subList(10, this._shortcuts.size()).clear();
        }
        this.addDefaultScriptPath(list);
        return list;
    }

    private URLPath getPathContextPaths() {
        return null == this.pathContext ? null : this.pathContext.getURLPath();
    }

    private URLPath getDefaultPathContextPaths() {
        return null == this.defaultPathContext ? null : this.defaultPathContext.getURLPath();
    }

    private void addDefaultScriptPath(Collection<URLChooserShortcut> collection) {
        URL uRL = DBConfig.getInstance().getScriptDirectory();
        if (this.isValidURL(uRL)) {
            IconWithSmallOverlay iconWithSmallOverlay = new IconWithSmallOverlay(OracleIcons.getIcon((String)"header/folder_header.png"), OracleIcons.getIcon((String)"sqlfile.png"), 16, 16, 12, 12);
            this.addIfExists(uRL, UtilsResources.get("SQL"), collection, (Icon)iconWithSmallOverlay);
        }
    }

    private boolean isValidURL(URL uRL) {
        return uRL != null && URLFileSystem.exists((URL)uRL) && URLFileSystem.isDirectory((URL)uRL) && !URLFileSystem.isHidden((URL)uRL) && URLFileSystem.canRead((URL)uRL);
    }

    private void addIfExists(URL uRL, Collection<URLChooserShortcut> collection, Icon icon) {
        this.addIfExists(uRL, null, collection, icon);
    }

    private void addIfExists(URL uRL, String string, Collection<URLChooserShortcut> collection, Icon icon) {
        if (!URLFileSystem.isDirectory((URL)uRL)) {
            uRL = URLFileSystem.getParent((URL)uRL);
        }
        if (this.isValidURL(uRL)) {
            uRL = this.ensureDirectoryPathFormat(uRL);
            boolean bl = true;
            for (URLChooserShortcut uRLChooserShortcut : collection) {
                if (!uRL.equals(uRLChooserShortcut.url())) continue;
                bl = false;
                break;
            }
            if (bl) {
                if (null == string) {
                    string = URLFileSystem.getName((URL)uRL);
                }
                if (null == icon) {
                    icon = OracleIcons.getIcon((String)"header/folder_header.png");
                }
                collection.add(new URLChooserShortcut(icon, string, uRL));
            }
        }
    }

    private URL ensureDirectoryPathFormat(URL uRL) {
        String string;
        if (uRL != null && !(string = uRL.getPath()).endsWith(URL_PATH_SEPARATOR)) {
            string = string + URL_PATH_SEPARATOR;
            try {
                uRL = new URL("file", null, string);
            }
            catch (MalformedURLException malformedURLException) {
                Logger.warn(this.getClass(), (Throwable)malformedURLException);
            }
        }
        return uRL;
    }
}

