/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils.persistence;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import oracle.dbtools.util.Logger;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.adapter.ReferenceWorker;

public abstract class PersistenceFactory<R extends Referenceable>
implements ObjectFactory {
    public static final int UNSPECIFIED_PORT_VALUE = -1;

    public static String getBindingName(String string, String string2) {
        return string + "/" + string2;
    }

    public static String getConnectionName(String string, String string2) {
        int n;
        String string3 = null;
        if (string2 != null && (n = string2.indexOf(47)) >= 0 && string.equals(string2.substring(0, n))) {
            string3 = string2.substring(n + 1);
        }
        return string3;
    }

    protected static String extractConnectionNameIgnoreType(String string) {
        int n;
        String string2 = null;
        if (string != null && (n = string.indexOf(47)) >= 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public static void setStringValue(Reference reference, String string, String string2) {
        if (string2 != null) {
            reference.add(new StringRefAddr(string, string2));
        }
    }

    protected static String getStringValue(Reference reference, String string) {
        String string2 = null;
        RefAddr refAddr = reference.get(string);
        if (refAddr instanceof StringRefAddr) {
            string2 = (String)refAddr.getContent();
        }
        return string2;
    }

    public static void setURIValue(Reference reference, String string, URI uRI) {
        if (uRI != null) {
            String string2 = uRI.toString();
            reference.add(new StringRefAddr(string, string2));
        }
    }

    protected static URI getURIValue(Reference reference, String string) {
        URI uRI = null;
        RefAddr refAddr = reference.get(string);
        if (refAddr instanceof StringRefAddr) {
            String string2 = (String)refAddr.getContent();
            try {
                uRI = new URI(string2);
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.severe(PersistenceFactory.class, (Throwable)uRISyntaxException);
            }
        }
        return uRI;
    }

    public static void setURLValue(Reference reference, String string, URL uRL) {
        if (uRL != null) {
            String string2 = uRL.toString();
            reference.add(new StringRefAddr(string, string2));
        }
    }

    public static URL getURLValue(Reference reference, String string) {
        URL uRL = null;
        RefAddr refAddr = reference.get(string);
        if (refAddr instanceof StringRefAddr) {
            String string2 = (String)refAddr.getContent();
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                Logger.severe(PersistenceFactory.class, (Throwable)malformedURLException);
            }
        }
        return uRL;
    }

    public static void setSecureValue(Reference reference, String string, char[] cArray, String string2) {
        ReferenceWorker referenceWorker;
        RefAddr refAddr;
        if (cArray != null && cArray.length > 0 && (refAddr = (referenceWorker = DatabaseProviderHelper.getDefaultWorker()).encrypt(string, cArray, string2)) != null) {
            reference.add(refAddr);
        }
    }

    protected static char[] getSecureValue(Reference reference, String string, String string2) {
        char[] cArray = null;
        RefAddr refAddr = reference.get(string);
        if (refAddr != null) {
            cArray = DatabaseProviderHelper.getDefaultWorker().decrypt(refAddr, string2);
        }
        return cArray;
    }

    public static void setIntValue(Reference reference, String string, int n) {
        reference.add(new StringRefAddr(string, Integer.toString(n)));
    }

    protected static int getIntValue(Reference reference, String string) {
        int n = -1;
        RefAddr refAddr = reference.get(string);
        if (refAddr instanceof StringRefAddr) {
            String string2 = (String)refAddr.getContent();
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.severe(PersistenceFactory.class, (Throwable)numberFormatException);
            }
        }
        return n;
    }

    public static void setBooleanValue(Reference reference, String string, Boolean bl) {
        if (bl != null) {
            reference.add(new StringRefAddr(string, bl.toString()));
        }
    }

    public static Boolean getBooleanValue(Reference reference, String string) {
        Boolean bl = null;
        RefAddr refAddr = reference.get(string);
        if (refAddr instanceof StringRefAddr && refAddr.getContent() != null) {
            bl = Boolean.valueOf((String)refAddr.getContent());
        }
        return bl;
    }
}

