/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.shared;

import java.io.File;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;

public class DebugSharedLocation
implements DebugLocation {
    DebugMethodInfo method;
    long address;
    int bytecodeOffset;
    boolean exactBC;
    String path;
    String filename;
    int line;
    boolean exactLine;

    public DebugSharedLocation(DebugMethodInfo method, long address, int bytecodeOffset, boolean exactBC, String path, String filename, int line, boolean exactLine) {
        this.method = method;
        this.address = address;
        this.bytecodeOffset = bytecodeOffset;
        this.exactBC = exactBC;
        if (path == null) {
            path = method.getClassInfo().getPackage().replace('.', File.separatorChar) + File.separator + filename;
        }
        this.path = path;
        this.filename = filename;
        this.line = line;
        this.exactLine = exactLine;
    }

    @Override
    public DebugMethodInfo getMethod() {
        return this.method;
    }

    @Override
    public DebugClassInfo getClassInfo() {
        return this.method.getClassInfo();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public int getBytecodeOffset() {
        return this.bytecodeOffset;
    }

    @Override
    public boolean isBytecodeExact() {
        return this.exactBC;
    }

    public int getLine() {
        return this.line;
    }

    @Override
    public boolean isLineExact() {
        return this.exactLine;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setLineExact(boolean exactLine) {
        this.exactLine = exactLine;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DebugSharedLocation) {
            DebugSharedLocation other = (DebugSharedLocation)o;
            return this.method.equals(other.method) && this.address == other.address && this.bytecodeOffset == other.bytecodeOffset && this.exactBC == other.exactBC && this.line == other.line && this.exactLine == other.exactLine;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return null;
    }
}

