/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.internal.debugger.evaluator;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.Ide;
import oracle.ideimpl.debugger.evaluator.ConditionEvaluationResult;
import oracle.ideimpl.debugger.evaluator.ConditionEvaluationResultType;
import oracle.jdevimpl.debugger.evaluator.EvaluatorProxy;
import oracle.jdevimpl.debugger.plugin.evaluator.CommonPluginEvaluatorBase;
import oracle.jdevimpl.debugger.plugin.evaluator.ExpressionEvaluationException;
import oracle.jdevimpl.debugger.plugin.evaluator.PlsqlEvaluator;
import oracle.jdevimpl.debugger.plugin.evaluator.PluginEvaluatorContext;
import oracle.jdevimpl.debugger.plugin.hooks.DebuggerHelperHook;
import oracle.jdevimpl.debugger.plugin.hooks.DebuggerLanguageHelper;
import oracle.jdevimpl.debugger.res.EvaluatorImplArb;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugEvaluator;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

public class EvaluatorProxyImpl
implements EvaluatorProxy {
    private PluginEvaluatorContext evaluatorContext = new PluginEvaluatorContext();
    private CommonPluginEvaluatorBase javaEvaluator;
    private CommonPluginEvaluatorBase plsqlEvaluator;
    private CommonPluginEvaluatorBase xsltEvaluator;
    private boolean allowMethodInvocation;
    Set<CommonPluginEvaluatorBase> evaluators = new LinkedHashSet<CommonPluginEvaluatorBase>();

    private EvaluatorProxyImpl() {
    }

    @Override
    public void setAllowMethodInvocation(boolean allow) {
        this.allowMethodInvocation = true;
    }

    @Override
    public boolean setDebugContext(DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
        if (this.evaluatorContext.setDebugContext(vm, thread, frame)) {
            this.clearCache();
            this.setEvaluators();
            return true;
        }
        return false;
    }

    @Override
    public boolean setDebugContext(DebugDataObjectInfo dataObject) {
        if (this.evaluatorContext.setDebugContext(dataObject)) {
            this.clearCache();
            this.setEvaluators();
            return true;
        }
        return false;
    }

    @Override
    public PluginEvaluatorContext getEvaluatorContext() {
        return this.evaluatorContext;
    }

    @Override
    public void clearCache() {
        if (this.evaluatorContext.getVM() != null) {
            this.evaluatorContext.getVM().clearEvaluators();
        }
        if (this.javaEvaluator != null) {
            this.javaEvaluator.clearCache();
        }
        if (this.plsqlEvaluator != null) {
            this.plsqlEvaluator.clearCache();
        }
        if (this.xsltEvaluator != null) {
            this.xsltEvaluator.clearCache();
        }
    }

    private void setEvaluators() {
        if (this.evaluatorContext.getVM() != null) {
            int languages;
            this.evaluators.clear();
            DebugEvaluator[] debuggerEvaluators = this.evaluatorContext.getVM().getEvaluators();
            if (debuggerEvaluators != null) {
                this.evaluators.addAll(Arrays.asList(debuggerEvaluators));
            }
            if (!(((languages = this.evaluatorContext.getVM().getLanguages()) & 1) == 0 || this.javaEvaluator != null && this.evaluators.contains(this.javaEvaluator))) {
                this.evaluators.add(this.getJavaEvaluator());
            }
            if (!((languages & 2) == 0 || this.plsqlEvaluator != null && this.evaluators.contains(this.plsqlEvaluator))) {
                this.evaluators.add(this.getPlsqlEvaluator());
            }
            if (!((languages & 4) == 0 || this.xsltEvaluator != null && this.evaluators.contains(this.xsltEvaluator))) {
                this.evaluators.add(this.getXsltEvaluator());
            }
        }
    }

    @Override
    public boolean validate(String exp) {
        if (this.getJavaEvaluator() != null) {
            return this.getJavaEvaluator().validate(exp);
        }
        if (this.getPlsqlEvaluator() != null) {
            return this.getPlsqlEvaluator().validate(exp);
        }
        if (this.getXsltEvaluator() != null) {
            return this.getXsltEvaluator().validate(exp);
        }
        return false;
    }

    @Override
    public ConditionEvaluationResult evaluateCondition(String condition) {
        ConditionEvaluationResult result = new ConditionEvaluationResult();
        CommonPluginEvaluatorBase[] evaluatorUsed = new CommonPluginEvaluatorBase[1];
        Object o = this.evaluate(condition, evaluatorUsed);
        if (o instanceof ExpressionEvaluationException) {
            ExpressionEvaluationException eee = (ExpressionEvaluationException)o;
            if (eee.getRetriable()) {
                result.setResultType(ConditionEvaluationResultType.RETRIABLE_EXCEPTION);
                result.setException((Throwable)eee);
                return result;
            }
            result.setResultType(ConditionEvaluationResultType.COULD_NOT_EVALUATE);
            result.setException((Throwable)eee);
            return result;
        }
        if (o != null && evaluatorUsed[0] != null) {
            int conditionResult = evaluatorUsed[0].evaluateConditionResult(o, this.allowMethodInvocation);
            switch (conditionResult) {
                case -2: {
                    break;
                }
                case -1: {
                    String msg = EvaluatorImplArb.format(1, condition);
                    result.setResultType(ConditionEvaluationResultType.NOT_BOOLEAN);
                    result.setMessage(msg);
                    return result;
                }
                case 1: {
                    result.setResultType(ConditionEvaluationResultType.TRUE);
                    result.setMessage(EvaluatorImplArb.getString(2));
                    return result;
                }
                case 0: {
                    result.setResultType(ConditionEvaluationResultType.FALSE);
                    result.setMessage(EvaluatorImplArb.getString(3));
                    return result;
                }
            }
        }
        String msg = EvaluatorImplArb.format(0, condition);
        result.setResultType(ConditionEvaluationResultType.COULD_NOT_EVALUATE);
        result.setMessage(msg);
        if (o instanceof Throwable) {
            result.setException((Throwable)o);
        }
        return result;
    }

    @Override
    public Object evaluate(String exp) {
        return this.evaluate(exp, null);
    }

    private Object evaluate(String exp, CommonPluginEvaluatorBase[] evaluatorUsed) {
        if (this.evaluatorContext.getVM() != null) {
            LinkedHashSet<Object> currentEvaluators = new LinkedHashSet<Object>();
            if (this.evaluatorContext.getFrame() != null) {
                Object frameEvaluator = this.evaluatorContext.getFrame().getEvaluator();
                if (frameEvaluator == null) {
                    switch (this.evaluatorContext.getFrame().getLanguage()) {
                        case 1: {
                            frameEvaluator = this.getJavaEvaluator();
                            break;
                        }
                        case 2: {
                            frameEvaluator = this.getPlsqlEvaluator();
                            break;
                        }
                        case 4: {
                            frameEvaluator = this.getXsltEvaluator();
                        }
                    }
                }
                if (frameEvaluator != null) {
                    currentEvaluators.add(frameEvaluator);
                }
            }
            for (CommonPluginEvaluatorBase evaluator : this.evaluators) {
                if (currentEvaluators.contains(evaluator)) continue;
                currentEvaluators.add(evaluator);
            }
            ExpressionEvaluationException evaluationException = null;
            for (CommonPluginEvaluatorBase commonPluginEvaluatorBase : currentEvaluators) {
                if (commonPluginEvaluatorBase == null) continue;
                Object o = commonPluginEvaluatorBase.evaluate(exp, this.allowMethodInvocation);
                if (o instanceof ExpressionEvaluationException) {
                    evaluationException = (ExpressionEvaluationException)o;
                    continue;
                }
                if (o == null) continue;
                if (evaluatorUsed != null) {
                    evaluatorUsed[0] = commonPluginEvaluatorBase;
                }
                return o;
            }
            if (evaluationException != null) {
                return evaluationException;
            }
        }
        return null;
    }

    private CommonPluginEvaluatorBase getJavaEvaluator() {
        if (this.javaEvaluator == null) {
            List<DebuggerLanguageHelper> helpers = DebuggerHelperHook.getLanguageSpecificHelpers(Ide.getActiveProject());
            for (DebuggerLanguageHelper helper : helpers) {
                if (!helper.hasEvaluator(1)) continue;
                this.javaEvaluator = helper.getEvaluator(1, this.getEvaluatorContext(), this.allowMethodInvocation);
                break;
            }
        }
        return this.javaEvaluator;
    }

    private CommonPluginEvaluatorBase getPlsqlEvaluator() {
        if (this.plsqlEvaluator == null) {
            this.plsqlEvaluator = new PlsqlEvaluator(this.evaluatorContext);
        }
        return this.plsqlEvaluator;
    }

    private CommonPluginEvaluatorBase getXsltEvaluator() {
        if (this.xsltEvaluator == null) {
            List<DebuggerLanguageHelper> helpers = DebuggerHelperHook.getLanguageSpecificHelpers(Ide.getActiveProject());
            for (DebuggerLanguageHelper helper : helpers) {
                if (!helper.hasEvaluator(4)) continue;
                this.xsltEvaluator = helper.getEvaluator(4, this.getEvaluatorContext(), this.allowMethodInvocation);
                break;
            }
        }
        return this.xsltEvaluator;
    }
}

