/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.ToolTipSettings;

public final class ToolTipSettingsPanel
extends DefaultTraversablePanel {
    private JCheckBox showColumnNameCheckBox = new JCheckBox();
    private JCheckBox showColumnQuickInspectCheckBox = new JCheckBox();
    private JCheckBox showColumnValueCheckBox = new JCheckBox();
    private JCheckBox showColumnActualTypeCheckBox = new JCheckBox();
    private JCheckBox showColumnDeclaredTypeCheckBox = new JCheckBox();
    private JCheckBox showColumnHexValueCheckBox = new JCheckBox();
    private JCheckBox showColumnAddressCheckBox = new JCheckBox();
    private JCheckBox showColumnIDCheckBox = new JCheckBox();
    private JLabel spacerLabel = new JLabel();

    public ToolTipSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_tooltipwindowsettingspanel_html");
        this.setLayout(new GridBagLayout());
        this.spacerLabel.setEnabled(false);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
        this.add(this.makeChooseColumnsPanel(null), constraints);
        ++constraints.gridy;
        constraints.insets.top = 8;
        constraints.weighty = 1.0;
        this.add(this.spacerLabel, constraints);
    }

    JPanel makeChooseColumnsPanel(Insets borderInsets) {
        JPanel panel = new JPanel(new GridLayout(0, 2, 0, 0));
        TitledBorder border = BorderFactory.createTitledBorder(RunMgrArb.getString(91));
        panel.setBorder(border);
        if (borderInsets != null) {
            Insets temp = border.getBorderInsets(panel);
            borderInsets.top = temp.top;
            borderInsets.left = temp.left;
            borderInsets.bottom = temp.bottom;
            borderInsets.right = temp.right;
        }
        ResourceUtils.resButton((AbstractButton)this.showColumnNameCheckBox, (String)DbgArb.getString(669));
        ResourceUtils.resButton((AbstractButton)this.showColumnValueCheckBox, (String)DbgArb.getString(672));
        ResourceUtils.resButton((AbstractButton)this.showColumnActualTypeCheckBox, (String)DbgArb.getString(670));
        ResourceUtils.resButton((AbstractButton)this.showColumnDeclaredTypeCheckBox, (String)DbgArb.getString(671));
        ResourceUtils.resButton((AbstractButton)this.showColumnHexValueCheckBox, (String)DbgArb.getString(673));
        ResourceUtils.resButton((AbstractButton)this.showColumnAddressCheckBox, (String)DbgArb.getString(674));
        ResourceUtils.resButton((AbstractButton)this.showColumnIDCheckBox, (String)DbgArb.getString(675));
        panel.add(this.showColumnNameCheckBox);
        panel.add(new JLabel());
        panel.add(this.showColumnValueCheckBox);
        panel.add(this.showColumnHexValueCheckBox);
        panel.add(this.showColumnActualTypeCheckBox);
        panel.add(this.showColumnDeclaredTypeCheckBox);
        panel.add(this.showColumnAddressCheckBox);
        panel.add(this.showColumnIDCheckBox);
        return panel;
    }

    private ToolTipSettings getData(TraversableContext tc) {
        return ToolTipSettings.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        ToolTipSettings settings = this.getData(tc);
        this.onEntry(settings);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        ToolTipSettings settings = this.getData(tc);
        this.onExit(settings);
    }

    void onEntry(ToolTipSettings toolTipSettings) {
        this.showColumnNameCheckBox.setSelected(true);
        this.showColumnNameCheckBox.setEnabled(false);
        this.showColumnValueCheckBox.setSelected(toolTipSettings.getColumnVisible(1));
        this.showColumnActualTypeCheckBox.setSelected(toolTipSettings.getColumnVisible(2));
        this.showColumnDeclaredTypeCheckBox.setSelected(toolTipSettings.getColumnVisible(3));
        this.showColumnHexValueCheckBox.setSelected(toolTipSettings.getColumnVisible(4));
        this.showColumnAddressCheckBox.setSelected(toolTipSettings.getColumnVisible(5));
        this.showColumnIDCheckBox.setSelected(toolTipSettings.getColumnVisible(6));
    }

    void onExit(ToolTipSettings toolTipSettings) throws TraversalException {
        toolTipSettings.setColumnVisible(0, true);
        toolTipSettings.setColumnVisible(1, this.showColumnValueCheckBox.isSelected());
        toolTipSettings.setColumnVisible(2, this.showColumnActualTypeCheckBox.isSelected());
        toolTipSettings.setColumnVisible(3, this.showColumnDeclaredTypeCheckBox.isSelected());
        toolTipSettings.setColumnVisible(4, this.showColumnHexValueCheckBox.isSelected());
        toolTipSettings.setColumnVisible(5, this.showColumnAddressCheckBox.isSelected());
        toolTipSettings.setColumnVisible(6, this.showColumnIDCheckBox.isSelected());
    }
}

