/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import oracle.jdbc.OracleDriver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.XSULocale;
import oracle.xml.sql.core.OracleXMLConvert;
import oracle.xml.sql.dml.OracleXMLSave;
import oracle.xml.sql.query.OracleXMLQuery;
import org.w3c.dom.Node;

public class OracleXML {
    static final String errorHeader = "OracleXML-Error:wrong argument list \nCall with \n\n";
    static final String geterrString = "OracleXML getXML \n [-user \"username/password\"]  \t-- the user name and password \n [-conn \"JDBC_connect_string\"]\t-- JDBC connect string \n [-withDTD | -withSchema]       -- generate the DTD/Schema \n [-rowsetTag <rowsetTag>]       -- document tag name \n [-rowTag    <rowTag>]          -- row element tag name \n [-rowIdAttr <attrName>]        -- row-id attribute name \n [-rowIdColumn <column_name>]   -- db-column to use for the row id \n [-collectionIdAttr <attrName>] -- collection element-id attribute\n [-useTypeForCollElemTag]       -- use type name for coll-elem tag\n [-useNullAttrId]               -- use a null attribute \n [-styleSheet <URI>]    \t-- stylesheet processing instruction header\n [-styleSheetType <type>]  \t-- stylesheet header type (e.g., text/xsl)\n [-setXSLT <URI>]               -- XSLT to apply to XML doc \n [-setXSLTRef <URI>]            -- XSLT external entity reference \n [-useLowerCase| -useUpperCase] -- the case of the tag names \n [-withEscaping]       \t\t-- if necessary do SQL-XML name escaping\n [-errorTag <errorTagName>]     -- error tag name\n [-raiseException]              -- raise exceptions for errors \n [-raiseNoRowsException]        -- raise exception if no returned \n [-useStrictLegalXMLCharCheck]  -- do strict checking on input data \n [-maxRows   <maxRows>]         -- maximum rows in output \n [-skipRows  <skipRows>]        -- rows to skip in output \n [-encoding <encoding_name>]    -- encoding to be used \n [-dateFormat <date format>]    -- date format to be used, \n       see javadoc for java.text.SimpleDateFormat for legal patterns \n (<query>| -fileName <sqlfile>) -- SQL query | file containing the query\n";
    static final String geterrorString = "OracleXML-Error:wrong argument list \nCall with \n\nOracleXML getXML \n [-user \"username/password\"]  \t-- the user name and password \n [-conn \"JDBC_connect_string\"]\t-- JDBC connect string \n [-withDTD | -withSchema]       -- generate the DTD/Schema \n [-rowsetTag <rowsetTag>]       -- document tag name \n [-rowTag    <rowTag>]          -- row element tag name \n [-rowIdAttr <attrName>]        -- row-id attribute name \n [-rowIdColumn <column_name>]   -- db-column to use for the row id \n [-collectionIdAttr <attrName>] -- collection element-id attribute\n [-useTypeForCollElemTag]       -- use type name for coll-elem tag\n [-useNullAttrId]               -- use a null attribute \n [-styleSheet <URI>]    \t-- stylesheet processing instruction header\n [-styleSheetType <type>]  \t-- stylesheet header type (e.g., text/xsl)\n [-setXSLT <URI>]               -- XSLT to apply to XML doc \n [-setXSLTRef <URI>]            -- XSLT external entity reference \n [-useLowerCase| -useUpperCase] -- the case of the tag names \n [-withEscaping]       \t\t-- if necessary do SQL-XML name escaping\n [-errorTag <errorTagName>]     -- error tag name\n [-raiseException]              -- raise exceptions for errors \n [-raiseNoRowsException]        -- raise exception if no returned \n [-useStrictLegalXMLCharCheck]  -- do strict checking on input data \n [-maxRows   <maxRows>]         -- maximum rows in output \n [-skipRows  <skipRows>]        -- rows to skip in output \n [-encoding <encoding_name>]    -- encoding to be used \n [-dateFormat <date format>]    -- date format to be used, \n       see javadoc for java.text.SimpleDateFormat for legal patterns \n (<query>| -fileName <sqlfile>) -- SQL query | file containing the query\n";
    static final String puterrString = "OracleXML putXML \n [-user \"username/password\"]  \t-- the user name and password\n [-conn \"JDBC_connect_string\"]\t-- JDBC connect string \n [-batchSize <size>]     \t-- number of inserts executed at a time \n [-commitBatch <size>]     \t-- number of inserts commited at a time \n [-rowTag <rowTagName>]    \t-- the name for row elements \n [-dateFormat <format>]    \t-- the format of date elements \n [-withEscaping]       \t\t-- if necessary do SQL-XML name escaping\n [-ignoreCase]             \t-- ignore the case of the tag namess \n [-preserveWhitespace]    \t-- preserves any whitespaces \n [-setXSLT <URI>]          \t-- XSLT to apply to XML doc \n [-setXSLTRef <URI>]  \t\t-- external entity reference for XSLT doc\n [-fileName fileName |     \t-- the XML document file name  or\n  -URL url |               \t - URL   or\n  -xmlDoc <XMLDocumentString>]\t - XML string \n <tableName>               \t-- the table name to put into \n";
    static final String puterrorString = "OracleXML-Error:wrong argument list \nCall with \n\nOracleXML putXML \n [-user \"username/password\"]  \t-- the user name and password\n [-conn \"JDBC_connect_string\"]\t-- JDBC connect string \n [-batchSize <size>]     \t-- number of inserts executed at a time \n [-commitBatch <size>]     \t-- number of inserts commited at a time \n [-rowTag <rowTagName>]    \t-- the name for row elements \n [-dateFormat <format>]    \t-- the format of date elements \n [-withEscaping]       \t\t-- if necessary do SQL-XML name escaping\n [-ignoreCase]             \t-- ignore the case of the tag namess \n [-preserveWhitespace]    \t-- preserves any whitespaces \n [-setXSLT <URI>]          \t-- XSLT to apply to XML doc \n [-setXSLTRef <URI>]  \t\t-- external entity reference for XSLT doc\n [-fileName fileName |     \t-- the XML document file name  or\n  -URL url |               \t - URL   or\n  -xmlDoc <XMLDocumentString>]\t - XML string \n <tableName>               \t-- the table name to put into \n";
    static final String errorString = "OracleXML-Error:wrong argument list \nCall with \n\nOracleXML getXML \n [-user \"username/password\"]  \t-- the user name and password \n [-conn \"JDBC_connect_string\"]\t-- JDBC connect string \n [-withDTD | -withSchema]       -- generate the DTD/Schema \n [-rowsetTag <rowsetTag>]       -- document tag name \n [-rowTag    <rowTag>]          -- row element tag name \n [-rowIdAttr <attrName>]        -- row-id attribute name \n [-rowIdColumn <column_name>]   -- db-column to use for the row id \n [-collectionIdAttr <attrName>] -- collection element-id attribute\n [-useTypeForCollElemTag]       -- use type name for coll-elem tag\n [-useNullAttrId]               -- use a null attribute \n [-styleSheet <URI>]    \t-- stylesheet processing instruction header\n [-styleSheetType <type>]  \t-- stylesheet header type (e.g., text/xsl)\n [-setXSLT <URI>]               -- XSLT to apply to XML doc \n [-setXSLTRef <URI>]            -- XSLT external entity reference \n [-useLowerCase| -useUpperCase] -- the case of the tag names \n [-withEscaping]       \t\t-- if necessary do SQL-XML name escaping\n [-errorTag <errorTagName>]     -- error tag name\n [-raiseException]              -- raise exceptions for errors \n [-raiseNoRowsException]        -- raise exception if no returned \n [-useStrictLegalXMLCharCheck]  -- do strict checking on input data \n [-maxRows   <maxRows>]         -- maximum rows in output \n [-skipRows  <skipRows>]        -- rows to skip in output \n [-encoding <encoding_name>]    -- encoding to be used \n [-dateFormat <date format>]    -- date format to be used, \n       see javadoc for java.text.SimpleDateFormat for legal patterns \n (<query>| -fileName <sqlfile>) -- SQL query | file containing the query\n\n -- OR -- \n\nOracleXML putXML \n [-user \"username/password\"]  \t-- the user name and password\n [-conn \"JDBC_connect_string\"]\t-- JDBC connect string \n [-batchSize <size>]     \t-- number of inserts executed at a time \n [-commitBatch <size>]     \t-- number of inserts commited at a time \n [-rowTag <rowTagName>]    \t-- the name for row elements \n [-dateFormat <format>]    \t-- the format of date elements \n [-withEscaping]       \t\t-- if necessary do SQL-XML name escaping\n [-ignoreCase]             \t-- ignore the case of the tag namess \n [-preserveWhitespace]    \t-- preserves any whitespaces \n [-setXSLT <URI>]          \t-- XSLT to apply to XML doc \n [-setXSLTRef <URI>]  \t\t-- external entity reference for XSLT doc\n [-fileName fileName |     \t-- the XML document file name  or\n  -URL url |               \t - URL   or\n  -xmlDoc <XMLDocumentString>]\t - XML string \n <tableName>               \t-- the table name to put into \n";

    public static void main(String[] args) {
        String temp = errorString;
        if (args.length > 1 && args.length <= 40) {
            if (args[0].equalsIgnoreCase("putXML")) {
                temp = OracleXML.ExecutePutXML(args);
            } else if (args[0].equalsIgnoreCase("getXML")) {
                temp = OracleXML.ExecuteGetXML(args);
            }
        }
        if (temp != null) {
            System.out.println(temp);
        }
    }

    private static String ExecutePutXML(String[] args) {
        int i;
        int batchSize = -1;
        int commitBatch = -1;
        String tableName = null;
        String fileName = null;
        String userName = null;
        String jdbcstr = null;
        String xmlDoc = null;
        String rowtagName = null;
        String dateFormat = null;
        String xslt = null;
        String xsltRef = null;
        boolean ignoreCase = false;
        boolean preserveWhitespace = false;
        boolean withEscaping = false;
        int baseArg = 1;
        boolean fileSeen = false;
        boolean userSeen = false;
        boolean rowtagSeen = false;
        boolean dateformatSeen = false;
        boolean jdbcstrSeen = false;
        boolean getTimingInfo = false;
        for (i = baseArg; i < args.length - 1; ++i) {
            if (args[i].equalsIgnoreCase("-fileName") || args[i].equalsIgnoreCase("-URL")) {
                if (fileSeen) {
                    return puterrorString;
                }
                fileSeen = true;
                fileName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-xmlDoc")) {
                if (fileSeen) {
                    return puterrorString;
                }
                if (++i >= args.length - 1) {
                    return puterrorString;
                }
                fileSeen = true;
                xmlDoc = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-setXSLT")) {
                if (xslt != null) {
                    return geterrorString;
                }
                if (++i > args.length - 1) {
                    return geterrorString;
                }
                xslt = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-setXSLTRef")) {
                if (xsltRef != null) {
                    return geterrorString;
                }
                if (++i > args.length - 1) {
                    return geterrorString;
                }
                xsltRef = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-withEscaping")) {
                if (withEscaping) {
                    return geterrorString;
                }
                withEscaping = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-ignoreCase")) {
                if (ignoreCase) {
                    return puterrorString;
                }
                ignoreCase = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-preserveWhitespace")) {
                if (preserveWhitespace) {
                    return puterrorString;
                }
                preserveWhitespace = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-dateFormat")) {
                if (dateformatSeen) {
                    return puterrorString;
                }
                if (++i >= args.length - 1) {
                    return puterrorString;
                }
                dateFormat = args[i];
                dateformatSeen = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-rowTag")) {
                if (rowtagSeen) {
                    return puterrorString;
                }
                if (++i >= args.length - 1) {
                    return puterrorString;
                }
                rowtagName = args[i];
                rowtagSeen = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-user")) {
                if (userSeen) {
                    return puterrorString;
                }
                if (++i >= args.length - 1) {
                    return puterrorString;
                }
                userName = args[i];
                userSeen = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-conn")) {
                if (jdbcstrSeen) {
                    return geterrorString;
                }
                if (++i >= args.length - 1) {
                    return geterrorString;
                }
                jdbcstr = args[i];
                jdbcstrSeen = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-batchSize")) {
                if (batchSize >= 0) {
                    return puterrorString;
                }
                if (++i >= args.length - 1) {
                    return puterrorString;
                }
                batchSize = new Integer(args[i]);
                if (batchSize >= 0) continue;
                batchSize = 0;
                continue;
            }
            if (args[i].equalsIgnoreCase("-commitBatch")) {
                if (commitBatch >= 0) {
                    return puterrorString;
                }
                if (++i >= args.length - 1) {
                    return puterrorString;
                }
                commitBatch = new Integer(args[i]);
                if (commitBatch >= 0) continue;
                commitBatch = 0;
                continue;
            }
            if (args[i].equalsIgnoreCase("-displayTimingInfo")) {
                if (getTimingInfo) {
                    return geterrorString;
                }
                getTimingInfo = true;
                continue;
            }
            return puterrorString;
        }
        tableName = args[i];
        return OracleXML.Put_XML(userName, jdbcstr, batchSize, commitBatch, xmlDoc, fileName, rowtagName, withEscaping, ignoreCase, preserveWhitespace, dateFormat, tableName, getTimingInfo, xslt, xsltRef);
    }

    private static String Put_XML(String username, String connstr, int batchSize, int commitBatch, String xmlDoc, String fileName, String rowtagName, boolean withEscaping, boolean ignoreCase, boolean preserveWhitespace, String dateFormat, String tabName, boolean getTimingInfo, String xslt, String xsltRef) {
        Connection conn = null;
        boolean count = false;
        OracleXMLSave sav = null;
        try {
            conn = OracleXML.getConnection(username, connstr);
            int rowCount = 0;
            sav = new OracleXMLSave(conn, tabName);
            if (xslt != null) {
                sav.setXSLT(xslt, xsltRef);
            }
            if (batchSize < 0) {
                sav.setBatchSize(17);
            } else {
                sav.setBatchSize(batchSize);
            }
            if (commitBatch < 0) {
                sav.setCommitBatch(3 * 17);
            } else {
                sav.setCommitBatch(commitBatch);
            }
            if (dateFormat != null) {
                sav.setDateFormat(dateFormat);
            }
            if (withEscaping) {
                sav.setSQLToXMLNameEscaping(withEscaping);
            }
            sav.setIgnoreCase(ignoreCase);
            if (preserveWhitespace) {
                sav.setPreserveWhitespace(preserveWhitespace);
            }
            if (rowtagName != null) {
                sav.setRowTag(rowtagName);
            }
            if (getTimingInfo) {
                sav.collectTimingInfo(getTimingInfo);
            }
            if (fileName != null) {
                URL url = OracleXMLSave.getURL(fileName);
                rowCount = sav.insertXML(url);
            } else {
                rowCount = sav.insertXML(xmlDoc);
            }
            sav.close();
            conn.close();
            if (getTimingInfo) {
                return sav.getTimingInfo() + "\n successfully inserted " + rowCount + " rows into " + tabName;
            }
            return " successfully inserted " + rowCount + " rows into " + tabName;
        }
        catch (Exception e) {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (sav != null) {
                    sav.close();
                }
            }
            catch (Exception ef) {
                // empty catch block
            }
            e.printStackTrace();
            return "";
        }
    }

    private static String ExecuteGetXML(String[] args) {
        String sqlString;
        int baseArg;
        int i;
        String user = null;
        String jdbcstr = null;
        int metaType = 0;
        boolean useDOMDoc = false;
        boolean getTimingInfo = false;
        String rowsetTag = null;
        String rowTag = null;
        String rowIdAttr = null;
        String rowIdAttrCol = null;
        String collIdAttr = null;
        String encoding = null;
        String dateFormat = null;
        boolean useStrictLegalXMLCharCheck = false;
        boolean useTypeForCollElemTag = false;
        boolean useNullAttrId = false;
        String styleSheet = null;
        String styleSheetType = null;
        String xslt = null;
        String xsltRef = null;
        boolean useLowerCase = false;
        boolean useUpperCase = false;
        boolean useCaseSeen = false;
        boolean withEscaping = false;
        boolean noXML = false;
        boolean noXMLSeen = false;
        boolean noDisplay = false;
        boolean noDisplaySeen = false;
        String errorTag = null;
        boolean raiseException = false;
        boolean raiseNoRowsException = false;
        int maxRows = -1;
        boolean maxRowsSeen = false;
        int skipRows = 0;
        boolean skipRowsSeen = false;
        String fileName = null;
        for (i = baseArg = 1; i <= args.length - 1; ++i) {
            if (args[i].equalsIgnoreCase("-user")) {
                if (user != null) {
                    return geterrorString;
                }
                if (++i > args.length - 1) {
                    return geterrorString;
                }
                user = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-conn")) {
                if (jdbcstr != null) {
                    return geterrorString;
                }
                if (++i > args.length - 1) {
                    return geterrorString;
                }
                jdbcstr = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-encoding")) {
                if (encoding != null) {
                    return geterrorString;
                }
                if (++i >= args.length - 1) {
                    return geterrorString;
                }
                encoding = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-dateFormat")) {
                if (dateFormat != null) {
                    return geterrorString;
                }
                if (++i >= args.length - 1) {
                    return geterrorString;
                }
                dateFormat = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-withDTD")) {
                if (metaType != 0) {
                    return geterrorString;
                }
                metaType = 1;
                continue;
            }
            if (args[i].equalsIgnoreCase("-withSchema")) {
                if (metaType != 0) {
                    return geterrorString;
                }
                metaType = 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-useDOMDoc")) {
                if (useDOMDoc) {
                    return geterrorString;
                }
                useDOMDoc = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-rowsetTag")) {
                if (rowsetTag != null) {
                    return geterrorString;
                }
                if (++i > args.length - 1) {
                    return geterrorString;
                }
                rowsetTag = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-rowTag")) {
                if (rowTag != null) {
                    return geterrorString;
                }
                if (++i > args.length - 1) {
                    return geterrorString;
                }
                rowTag = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-rowIdAttr")) {
                if (rowIdAttr != null) {
                    return geterrorString;
                }
                if (++i > args.length - 1) {
                    return geterrorString;
                }
                rowIdAttr = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-rowIdColumn")) {
                if (rowIdAttrCol != null) {
                    return geterrorString;
                }
                if (++i > args.length - 1) {
                    return geterrorString;
                }
                rowIdAttrCol = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-collectionIdAttr")) {
                if (collIdAttr != null) {
                    return geterrorString;
                }
                if (++i > args.length - 1) {
                    return geterrorString;
                }
                collIdAttr = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-useTypeForCollElemTag")) {
                if (useTypeForCollElemTag) {
                    return geterrorString;
                }
                useTypeForCollElemTag = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-useNullAttrId")) {
                if (useNullAttrId) {
                    return geterrorString;
                }
                useNullAttrId = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-styleSheet")) {
                if (styleSheet != null) {
                    return geterrorString;
                }
                if (++i > args.length - 1) {
                    return geterrorString;
                }
                styleSheet = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-styleSheetType")) {
                if (styleSheetType != null) {
                    return geterrorString;
                }
                if (++i > args.length - 1) {
                    return geterrorString;
                }
                styleSheetType = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-setXSLT")) {
                if (xslt != null) {
                    return geterrorString;
                }
                if (++i > args.length - 1) {
                    return geterrorString;
                }
                xslt = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-setXSLTRef")) {
                if (xsltRef != null) {
                    return geterrorString;
                }
                if (++i > args.length - 1) {
                    return geterrorString;
                }
                xsltRef = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-withEscaping")) {
                if (withEscaping) {
                    return geterrorString;
                }
                withEscaping = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-useLowerCase")) {
                if (useCaseSeen) {
                    return geterrorString;
                }
                useLowerCase = true;
                useCaseSeen = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-useUpperCase")) {
                if (useCaseSeen) {
                    return geterrorString;
                }
                useUpperCase = true;
                useCaseSeen = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-noXML")) {
                if (noXMLSeen) {
                    return geterrorString;
                }
                noXML = true;
                noXMLSeen = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-noDisplay")) {
                if (noDisplaySeen) {
                    return geterrorString;
                }
                noDisplay = true;
                noDisplaySeen = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-errorTag")) {
                if (errorTag != null) {
                    return geterrorString;
                }
                if (++i > args.length - 1) {
                    return geterrorString;
                }
                errorTag = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-useStrictLegalXMLCharCheck")) {
                if (useStrictLegalXMLCharCheck) {
                    return geterrorString;
                }
                useStrictLegalXMLCharCheck = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-raiseException")) {
                if (raiseException) {
                    return geterrorString;
                }
                raiseException = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-raiseNoRowsException")) {
                if (raiseNoRowsException) {
                    return geterrorString;
                }
                raiseNoRowsException = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-maxRows")) {
                if (maxRowsSeen) {
                    return geterrorString;
                }
                if (++i > args.length - 1) {
                    return geterrorString;
                }
                maxRows = new Integer(args[i]);
                maxRowsSeen = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-skipRows")) {
                if (skipRowsSeen) {
                    return geterrorString;
                }
                if (++i > args.length - 1) {
                    return geterrorString;
                }
                skipRows = new Integer(args[i]);
                skipRowsSeen = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-fileName")) {
                if (fileName != null) {
                    return geterrorString;
                }
                if (++i > args.length - 1) {
                    return geterrorString;
                }
                fileName = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-displayTimingInfo")) {
                if (getTimingInfo) {
                    return geterrorString;
                }
                getTimingInfo = true;
                continue;
            }
            if (i >= args.length - 1 && fileName == null) continue;
            return geterrorString;
        }
        if (fileName != null) {
            StringWriter out = new StringWriter();
            String res = OracleXML.SQLStringFromFile(fileName, out);
            if (res != null) {
                return res;
            }
            sqlString = out.toString();
        } else {
            sqlString = args[i - 1];
        }
        return OracleXML.To_XML(user, jdbcstr, metaType, useDOMDoc, rowsetTag, rowTag, rowIdAttr, rowIdAttrCol, collIdAttr, useTypeForCollElemTag, useNullAttrId, styleSheet, styleSheetType, xslt, xsltRef, useLowerCase, useUpperCase, withEscaping, errorTag, raiseException, raiseNoRowsException, maxRows, skipRows, getTimingInfo, noXML, noDisplay, encoding, dateFormat, useStrictLegalXMLCharCheck, sqlString);
    }

    private static String SQLStringFromFile(String fileName, StringWriter out) {
        FileInputStream fis = null;
        InputStreamReader in = null;
        try {
            fis = new FileInputStream(fileName);
            in = new InputStreamReader((InputStream)fis, System.getProperty("file.encoding"));
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e.getMessage());
        }
        char[] buffer = new char[4096];
        try {
            int numchars;
            while ((numchars = in.read(buffer)) != -1) {
                out.write(buffer, 0, numchars);
            }
            out.close();
        }
        catch (Exception e) {
            return "Error reading file :" + fileName;
        }
        return null;
    }

    private static String To_XML(String user, String connstr, int metaType, boolean useDOMDoc, String rowsetTag, String rowTag, String rowIdAttr, String rowIdAttrCol, String collIdAttr, boolean useTypeForCollElemTag, boolean useNullAttrId, String styleSheet, String styleSheetType, String xslt, String xsltRef, boolean useLowerCase, boolean useUpperCase, boolean withEscaping, String errorTag, boolean raiseException, boolean raiseNoRowsException, int maxRows, int skipRows, boolean getTimingInfo, boolean noXML, boolean noDisplay, String encoding, String dateFormat, boolean useStrictLegalXMLCharCheck, String sqlString) {
        Connection conn = null;
        String jenc = null;
        boolean count = false;
        try {
            conn = OracleXML.getConnection(user, connstr);
            if (noXML) {
                long timeStart = System.currentTimeMillis();
                PreparedStatement ps = conn.prepareStatement(sqlString);
                ResultSet rs = ps.executeQuery();
                ResultSetMetaData rmdata = rs.getMetaData();
                while (rs.next()) {
                    for (int i = 1; i <= rmdata.getColumnCount(); ++i) {
                        String str = rs.getString(i);
                    }
                }
                rs.close();
                long endTime = System.currentTimeMillis();
                System.out.println(" Done - query took .." + (endTime - timeStart));
                return null;
            }
            OracleXMLQuery qry = new OracleXMLQuery(conn, sqlString);
            qry.setStrictLegalXMLCharCheck(useStrictLegalXMLCharCheck);
            if (rowsetTag != null) {
                qry.setRowsetTag(rowsetTag);
            }
            if (rowTag != null) {
                qry.setRowTag(rowTag);
            }
            if (rowIdAttr != null) {
                qry.setRowIdAttrName(rowIdAttr);
            }
            if (rowIdAttrCol != null) {
                qry.setRowIdAttrValue(rowIdAttrCol);
            }
            if (collIdAttr != null) {
                qry.setCollIdAttrName(collIdAttr);
            }
            if (errorTag != null) {
                qry.setErrorTag(errorTag);
            }
            if (dateFormat != null) {
                qry.setDateFormat(dateFormat);
            }
            if (xslt != null) {
                qry.setXSLT(xslt, xsltRef);
            }
            if (styleSheet != null) {
                if (styleSheetType != null) {
                    qry.setStylesheetHeader(styleSheet, styleSheetType);
                } else {
                    qry.setStylesheetHeader(styleSheet);
                }
            }
            if (useLowerCase) {
                qry.useLowerCaseTagNames();
            } else if (useUpperCase) {
                qry.useUpperCaseTagNames();
            }
            if (useTypeForCollElemTag) {
                qry.useTypeForCollElemTag(useTypeForCollElemTag);
            }
            if (useNullAttrId) {
                qry.useNullAttributeIndicator(useNullAttrId);
            }
            if (raiseException) {
                qry.setRaiseException(raiseException);
            }
            if (raiseNoRowsException) {
                qry.setRaiseNoRowsException(raiseNoRowsException);
            }
            if (withEscaping) {
                qry.setSQLToXMLNameEscaping(withEscaping);
            }
            if (getTimingInfo) {
                ((OracleXMLConvert)qry.getInternalObj()).collectTimingInfo(true);
            }
            qry.setMaxRows(maxRows);
            qry.setSkipRows(skipRows);
            if (encoding == null || encoding.length() == 0) {
                jenc = encoding = System.getProperty("file.encoding");
            } else {
                jenc = XSULocale.getJavaCharset(encoding);
                if (jenc == null) {
                    jenc = encoding;
                    if ((encoding = XSULocale.getIANACharset(encoding)) == null) {
                        throw new OracleXMLSQLException(OracleXMLConvert.msg.getMessage1("XSUE-0102", jenc));
                    }
                }
                qry.setEncoding(encoding);
            }
            XMLDocument doc = null;
            String str = null;
            if (useDOMDoc) {
                doc = (XMLDocument)qry.getXMLDOM((Node)doc, metaType);
            } else {
                str = qry.getXMLString((Node)doc, metaType);
            }
            conn.close();
            if (getTimingInfo) {
                OracleXML.encPrint(((OracleXMLConvert)qry.getInternalObj()).getTimingInfo(), jenc);
            }
            if (noDisplay) {
                str = "Finished Generating XML ";
                useDOMDoc = false;
            }
            if (useDOMDoc) {
                doc.print(new PrintWriter(new OutputStreamWriter((OutputStream)System.out, jenc)));
            } else {
                OracleXML.encPrint(str, jenc);
            }
            return null;
        }
        catch (SQLException e) {
            return e.getMessage();
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    private static void encPrint(String str, String cset) {
        if (cset == null) {
            System.out.print(str);
        } else {
            try {
                PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, cset));
                out.println(str);
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Connection getConnection(String username, String connstr) throws SQLException {
        String user = "scott";
        String passwd = "tiger";
        DriverManager.registerDriver((Driver)new OracleDriver());
        if (username == null && connstr != null) {
            return DriverManager.getConnection(connstr);
        }
        if (connstr == null) {
            connstr = "jdbc:oracle:oci8:@";
        }
        if (username != null) {
            int tempIndex = username.indexOf(47);
            user = username.substring(0, tempIndex);
            passwd = username.substring(tempIndex + 1);
        }
        return DriverManager.getConnection(connstr, user, passwd);
    }

    private static String createTestXMLDoc() {
        return "<?xml version = \"1.0\"?><!DOCTYPE ROWSET [<!ELEMENT ROWSET (ROW)*><!ELEMENT ROW (PONO, CUSTREF?, ORDERDATE?, SHIPDATE?, LINE_ITEM_LIST?, SHIPTOADDR?)><!ATTLIST ROW id CDATA #REQUIRED><!ELEMENT PONO (#PCDATA)><!ATTLIST PONO><!ELEMENT CUSTREF (#PCDATA)><!ATTLIST CUSTREF REFTYPE NMTOKEN #FIXED \"PO.CUSTOMER_INFO_T\"><!ELEMENT ORDERDATE (#PCDATA)><!ELEMENT SHIPDATE (#PCDATA)><!ELEMENT LINE_ITEM_LIST (LINE_ITEM_LIST_ITEM)*><!ELEMENT LINE_ITEM_LIST_ITEM (LINEITEMNO?, STOCKREF?, QUANTITY?, DISCOUNT?)><!ATTLIST LINE_ITEM_LIST_ITEM itemNo CDATA #REQUIRED><!ELEMENT LINEITEMNO (#PCDATA)><!ELEMENT STOCKREF (#PCDATA)><!ATTLIST STOCKREF REFTYPE NMTOKEN #FIXED \"PO.STOCK_INFO_T\"><!ELEMENT QUANTITY (#PCDATA)><!ELEMENT DISCOUNT (#PCDATA)><!ELEMENT SHIPTOADDR (STREET?, CITY?, STATE?, ZIP?)><!ELEMENT STREET (#PCDATA)><!ELEMENT CITY (#PCDATA)><!ELEMENT STATE (#PCDATA)><!ELEMENT ZIP (#PCDATA)>]><ROWSET> <ROW id = \"1\">  <PONO>1001</PONO>  <CUSTREF>002202084b3cd2bb12ba09e4e03400400b403bc34b3cd2bb12b209e4e03400400b403bc3</CUSTREF>  <ORDERDATE>1999-05-19 14:32:30.0</ORDERDATE>  <SHIPDATE>1997-05-10 00:00:00.0</SHIPDATE>  <LINE_ITEM_LIST>   <LINE_ITEM_LIST_ITEM itemNo = \"1\">    <LINEITEMNO>1</LINEITEMNO>    <STOCKREF>002202084b3cd2bb12b809e4e03400400b403bc34b3cd2bb12b309e4e03400400b403bc3</STOCKREF>    <QUANTITY>12</QUANTITY>    <DISCOUNT>0</DISCOUNT>   </LINE_ITEM_LIST_ITEM>   <LINE_ITEM_LIST_ITEM itemNo = \"2\">    <LINEITEMNO>2</LINEITEMNO>    <STOCKREF>002202084b3cd2bb12b909e4e03400400b403bc34b3cd2bb12b309e4e03400400b403bc3</STOCKREF>    <QUANTITY>10</QUANTITY>    <DISCOUNT>10</DISCOUNT>   </LINE_ITEM_LIST_ITEM>  </LINE_ITEM_LIST> </ROW> <ROW id = \"2\">  <PONO>2001</PONO>  <CUSTREF>002202084b3cd2bb12bb09e4e03400400b403bc34b3cd2bb12b209e4e03400400b403bc3</CUSTREF>  <ORDERDATE>1999-05-19 14:32:30.0</ORDERDATE>  <SHIPDATE>1997-05-20 00:00:00.0</SHIPDATE>  <LINE_ITEM_LIST>   <LINE_ITEM_LIST_ITEM itemNo = \"1\">    <LINEITEMNO>10</LINEITEMNO>    <STOCKREF>002202084b3cd2bb12b609e4e03400400b403bc34b3cd2bb12b309e4e03400400b403bc3</STOCKREF>    <QUANTITY>1</QUANTITY>    <DISCOUNT>0</DISCOUNT>   </LINE_ITEM_LIST_ITEM>   <LINE_ITEM_LIST_ITEM itemNo = \"2\">    <LINEITEMNO>11</LINEITEMNO>    <STOCKREF>002202084b3cd2bb12b709e4e03400400b403bc34b3cd2bb12b309e4e03400400b403bc3</STOCKREF>    <QUANTITY>2</QUANTITY>    <DISCOUNT>1</DISCOUNT>   </LINE_ITEM_LIST_ITEM>  </LINE_ITEM_LIST>  <SHIPTOADDR>   <STREET>55, Madison Ave</STREET>   <CITY>Madison</CITY>   <STATE>WI</STATE>   <ZIP>53715</ZIP>  </SHIPTOADDR> </ROW></ROWSET>";
    }
}

