/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import java.util.concurrent.Callable;

final class IndexingClient {
    private static final ThreadLocal<Boolean> clientRunning = new ThreadLocal();

    IndexingClient() {
    }

    public static void run(Runnable r) {
        clientRunning.set(Boolean.TRUE);
        try {
            r.run();
        }
        finally {
            clientRunning.set(Boolean.FALSE);
        }
    }

    public static <T> T call(Callable<T> c) throws Exception {
        clientRunning.set(Boolean.TRUE);
        try {
            T t = c.call();
            return t;
        }
        finally {
            clientRunning.set(Boolean.FALSE);
        }
    }

    public static boolean isRunning() {
        Boolean b = clientRunning.get();
        return b == null ? false : b;
    }
}

