/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.sparql.viz;

import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.layout.mxCircleLayout;
import com.mxgraph.layout.mxFastOrganicLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.mxGraphOutline;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import oracle.dbtools.rdfgraph.utils.RDFPrefixManager;
import oracle.dbtools.rdfgraph.utils.RDFStatement;
import oracle.javatools.icons.OracleIcons;

public class BasicRDFVisualizerPane
extends JPanel {
    protected mxGraph graph;
    protected mxGraphComponent graphComponent;
    protected mxGraphOutline graphOutline;
    HashMap<String, Object> vertices = new HashMap();
    HashMap<Integer, Object> edges = new HashMap();
    HashMap<String, String> bNodes = new HashMap();
    HashMap<String, String> rNodes = new HashMap();
    List<RDFStatement> triples = new ArrayList<RDFStatement>();
    boolean short_uris = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicRDFVisualizerPane(List<RDFStatement> list, boolean bl) {
        this.triples = list;
        this.short_uris = bl;
        this.setLayout(new BorderLayout());
        this.graph = new mxGraph(){

            public boolean isCellSelectable(Object object) {
                mxCell mxCell2;
                if (object != null && object instanceof mxCell && (mxCell2 = (mxCell)object).isEdge()) {
                    return false;
                }
                return super.isCellSelectable(object);
            }
        };
        this.graphComponent = new mxGraphComponent(this.graph);
        this.graphComponent.setConnectable(false);
        this.graphComponent.setToolTips(true);
        this.graph.getModel().beginUpdate();
        try {
            this.mapVerticesAndEdges(this.graph);
            mxCircleLayout mxCircleLayout2 = new mxCircleLayout(this.graph);
            mxCircleLayout2.execute(this.graph.getDefaultParent());
        }
        finally {
            this.graph.getModel().endUpdate();
        }
        this.graphComponent.setAutoExtend(true);
        this.graphComponent.getViewport().setBackground(Color.white);
        this.graphOutline = new mxGraphOutline(this.graphComponent);
        this.installListeners();
        this.setPreferredSize(new Dimension(450, 130));
        this.add((Component)this.createToolBar(), "First");
        this.add((Component)this.graphComponent);
    }

    public void fitGraph() {
        SwingUtilities.invokeLater(() -> {
            this.zoomIn();
            int n = 2;
            int n2 = 3;
            mxRectangle mxRectangle2 = this.graph.getGraphBounds();
            int n3 = this.getWidth() - n;
            int n4 = this.getHeight() - n;
            double d = mxRectangle2.getWidth() / this.graph.getView().getScale();
            double d2 = mxRectangle2.getHeight() / this.graph.getView().getScale();
            double d3 = Math.min((double)n2, Math.min((double)n3 / d, (double)n4 / d2));
            this.graph.getView().scaleAndTranslate(d3, ((double)(n + n3) - d * d3) / (2.0 * d3) - mxRectangle2.getX() / this.graph.getView().getScale(), ((double)(n + n4) - d2 * d3) / (2.0 * d3) - mxRectangle2.getY() / this.graph.getView().getScale());
        });
    }

    public void circleLayout() {
        mxCircleLayout mxCircleLayout2 = new mxCircleLayout(this.graph);
        mxCircleLayout2.execute(this.graph.getDefaultParent());
    }

    public void organicLayout() {
        mxFastOrganicLayout mxFastOrganicLayout2 = new mxFastOrganicLayout(this.graph);
        mxFastOrganicLayout2.setForceConstant(100.0);
        mxFastOrganicLayout2.execute(this.graph.getDefaultParent());
    }

    public void hierarchicalLayout() {
        mxHierarchicalLayout mxHierarchicalLayout2 = new mxHierarchicalLayout(this.graph);
        mxHierarchicalLayout2.execute(this.graph.getDefaultParent());
    }

    public void zoomIn() {
        if (this.graphComponent != null) {
            this.graphComponent.zoomIn();
        }
    }

    public void zoomOut() {
        if (this.graphComponent != null) {
            this.graphComponent.zoomOut();
        }
    }

    protected void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getWheelRotation() < 0) {
            this.graphComponent.zoomIn();
        } else {
            this.graphComponent.zoomOut();
        }
    }

    protected void installListeners() {
        MouseWheelListener mouseWheelListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getSource() instanceof mxGraphOutline || mouseWheelEvent.isControlDown()) {
                    BasicRDFVisualizerPane.this.mouseWheelMoved(mouseWheelEvent);
                }
            }
        };
        this.graphOutline.addMouseWheelListener(mouseWheelListener);
        this.graphComponent.addMouseWheelListener(mouseWheelListener);
    }

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        try {
            JButton jButton = new JButton(OracleIcons.getIcon((String)"zoomin.png"));
            jButton.setToolTipText("Zoom In");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BasicRDFVisualizerPane.this.zoomIn();
                }
            });
            JButton jButton2 = new JButton(OracleIcons.getIcon((String)"zoomout.png"));
            jButton2.setToolTipText("Zoom Out");
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BasicRDFVisualizerPane.this.zoomOut();
                }
            });
            JButton jButton3 = new JButton(OracleIcons.getIcon((String)"fitToWindowSize.png"));
            jButton3.setToolTipText("Fit to page");
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BasicRDFVisualizerPane.this.fitGraph();
                }
            });
            JButton jButton4 = new JButton(OracleIcons.getIcon((String)"ancestor.png"));
            jButton4.setToolTipText("Hierarchical layout");
            jButton4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BasicRDFVisualizerPane.this.hierarchicalLayout();
                }
            });
            JButton jButton5 = new JButton(OracleIcons.getIcon((String)"accessors.png"));
            jButton5.setToolTipText("Organic layout");
            jButton5.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BasicRDFVisualizerPane.this.organicLayout();
                }
            });
            JButton jButton6 = new JButton(OracleIcons.getIcon((String)"bmj_layout_grid.png"));
            jButton6.setToolTipText("Circle layout");
            jButton6.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BasicRDFVisualizerPane.this.circleLayout();
                }
            });
            jToolBar.add(jButton);
            jToolBar.add(jButton2);
            jToolBar.add(jButton3);
            jToolBar.add(jButton4);
            jToolBar.add(jButton5);
            jToolBar.add(jButton6);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return jToolBar;
    }

    private int resizeResource(String string) {
        int n = 10;
        if (string != null) {
            n = n * string.length() + 10;
        }
        if (n < 110) {
            n = 110;
        }
        return n;
    }

    private int resizeCellSize(String string) {
        int n = 8;
        if (string != null) {
            n *= string.length();
        }
        if (n > 100) {
            int n2 = n / 100;
            n = n2 * 15 + 10;
        }
        if (n < 100) {
            return 100;
        }
        return n;
    }

    private String shortResource(String string) {
        String string2 = string;
        if (string.startsWith("<")) {
            string2 = string.substring(1, string.length() - 1);
        }
        if (this.rNodes.containsKey(string2)) {
            return this.rNodes.get(string2);
        }
        int n = string2.lastIndexOf(47);
        int n2 = string2.lastIndexOf(35);
        int n3 = string2.lastIndexOf(58);
        int n4 = n;
        if (n2 > n4) {
            n4 = n2;
        }
        if (n3 > n4) {
            n4 = n3;
        }
        if (n4 < 0) {
            return string2;
        }
        this.rNodes.put(string2, "..." + string2.substring(n4));
        return this.rNodes.get(string2);
    }

    private void mapVerticesAndEdges(mxGraph mxGraph2) {
        Object object = mxGraph2.getDefaultParent();
        for (RDFStatement rDFStatement : this.triples) {
            Object object2;
            Object object3;
            String string;
            String string2;
            if (!this.vertices.containsKey(rDFStatement.getRDFTerms()[0])) {
                string2 = "shape=ellipse;whiteSpace=wrap";
                if (rDFStatement.getRDFTerms()[0].startsWith("_")) {
                    string2 = "shape=ellipse;whiteSpace=wrap;fillColor=white";
                    string = rDFStatement.getRDFTerms()[0];
                    String string3 = "_:BN" + this.bNodes.size();
                    if (this.bNodes.containsKey(string)) {
                        string3 = this.bNodes.get(string);
                    } else {
                        this.bNodes.put(string, string3);
                    }
                    object3 = mxGraph2.insertVertex(object, null, (Object)string3, 20.0, 20.0, 60.0, 60.0, string2);
                    this.vertices.put(rDFStatement.getRDFTerms()[0], object3);
                } else {
                    string = this.shortResource(RDFPrefixManager.shortenURI(rDFStatement.getRDFTerms()[0], this.short_uris));
                    int n = this.resizeResource(string);
                    object3 = mxGraph2.insertVertex(object, null, (Object)string, 20.0, 20.0, (double)n, 30.0, string2);
                    this.vertices.put(rDFStatement.getRDFTerms()[0], object3);
                }
            } else {
                object3 = this.vertices.get(rDFStatement.getRDFTerms()[0]);
            }
            if (!this.vertices.containsKey(rDFStatement.getRDFTerms()[2])) {
                string2 = "shape=ellipse;whiteSpace=wrap";
                if (rDFStatement.getRDFTerms()[2].startsWith("\"")) {
                    int n = this.resizeCellSize(rDFStatement.getRDFTerms()[2]);
                    string2 = "whiteSpace=wrap;fillColor=lightgray";
                    object2 = mxGraph2.insertVertex(object, null, (Object)RDFPrefixManager.shortenURI(rDFStatement.getRDFTerms()[2], this.short_uris), 20.0, 20.0, (double)n, (double)n, string2);
                    this.vertices.put(rDFStatement.getRDFTerms()[2], object2);
                } else if (rDFStatement.getRDFTerms()[2].startsWith("_")) {
                    string2 = "shape=ellipse;whiteSpace=wrap;fillColor=white";
                    string = rDFStatement.getRDFTerms()[2];
                    String string4 = "_:BN" + this.bNodes.size();
                    if (this.bNodes.containsKey(string)) {
                        string4 = this.bNodes.get(string);
                    } else {
                        this.bNodes.put(string, string4);
                    }
                    object2 = mxGraph2.insertVertex(object, null, (Object)string4, 20.0, 20.0, 60.0, 60.0, string2);
                    this.vertices.put(rDFStatement.getRDFTerms()[2], object2);
                } else {
                    string = this.shortResource(RDFPrefixManager.shortenURI(rDFStatement.getRDFTerms()[2], this.short_uris));
                    int n = this.resizeResource(string);
                    object2 = mxGraph2.insertVertex(object, null, (Object)string, 20.0, 20.0, (double)n, 30.0, string2);
                    this.vertices.put(rDFStatement.getRDFTerms()[2], object2);
                }
            } else {
                object2 = this.vertices.get(rDFStatement.getRDFTerms()[2]);
            }
            if (this.edges.containsKey(rDFStatement.hashCode())) continue;
            Object object4 = mxGraph2.insertEdge(object, null, (Object)RDFPrefixManager.shortenURI(rDFStatement.getRDFTerms()[1], this.short_uris), object3, object2);
            this.edges.put(rDFStatement.hashCode(), object4);
        }
    }
}

