/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.wizards.rdfmodel;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.ui.TriplesTablePanel;
import oracle.dbtools.rdfgraph.utils.RDFStatement;
import oracle.dbtools.rdfgraph.utils.RDFStatementIterator;
import oracle.dbtools.rdfgraph.wizards.AbstractWizardPanel;
import oracle.dbtools.rdfgraph.wizards.rdfmodel.RDFModelWizardModel;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;

public class RDFModelDataSourceWizardPanel
extends AbstractWizardPanel<RDFModelWizardModel> {
    private static final int MAX_TRIPLES = 1000;
    private URLFileChooser.URLFileChooserPanel sourceFilePicker;
    private JButton btnLoadSourceFile;
    private TriplesTablePanel previewTable;
    private static int MAX_TRIPLES_PREVIEW = 1000;

    @Override
    protected void initializeUI(RDFModelWizardModel rDFModelWizardModel) {
        rDFModelWizardModel.initialize();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.previewTable = new TriplesTablePanel();
        this.sourceFilePicker = URLFileChooser.createURLFileChooserPanel((int)0, (String)RdfgraphArb.getString("RDFModelPrepareLoadWizardPanel.SOURCE_FILE_"));
        this.sourceFilePicker.setSelectionScope(0);
        this.sourceFilePicker.setSelectionMode(0);
        this.sourceFilePicker.clearChooseableURLFilters();
        this.sourceFilePicker.addChooseableURLFilter((URLFilter)new WildcardURLFilter("*.nt", false, "N-Triples"));
        this.sourceFilePicker.addChooseableURLFilter((URLFilter)new WildcardURLFilter("*.nq", false, "N-Quads"));
        this.sourceFilePicker.addChooseableURLFilter((URLFilter)new WildcardURLFilter("*.ttl", false, "Turtle"));
        this.sourceFilePicker.addActionListener(actionEvent -> {
            URLFileChooser uRLFileChooser = (URLFileChooser)actionEvent.getSource();
            if (uRLFileChooser.getSelectedFile() != null) {
                this.loadTriplesInPreview(rDFModelWizardModel);
            }
        });
        this.add((Component)this.sourceFilePicker, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(this.previewTable, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        this.enableButtons(false, false, false);
    }

    private void loadTriplesInPreviewFromTurtle(RDFModelWizardModel rDFModelWizardModel) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTriplesInPreview(RDFModelWizardModel rDFModelWizardModel) {
        File file = null;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        boolean bl = false;
        int n = 0;
        if (this.sourceFilePicker.getSelectedFile() == null) {
            return;
        }
        file = this.sourceFilePicker.getSelectedFile();
        try {
            RDFStatementIterator rDFStatementIterator = new RDFStatementIterator(new FileInputStream(file));
            while (rDFStatementIterator.hasNext()) {
                RDFStatement rDFStatement = rDFStatementIterator.next();
                if (rDFStatement.isTriple() && n <= MAX_TRIPLES_PREVIEW) {
                    arrayList.add(new Object[]{rDFStatement.getRDFTerms()[0], rDFStatement.getRDFTerms()[1], rDFStatement.getRDFTerms()[2], RdfgraphArb.getString("RDFModelDataSourceWizardPanel._DEFAULT_")});
                } else if (rDFStatement.isQuad()) {
                    bl = true;
                    arrayList.add(new Object[]{rDFStatement.getRDFTerms()[0], rDFStatement.getRDFTerms()[1], rDFStatement.getRDFTerms()[2], rDFStatement.getRDFTerms()[3]});
                }
                if (++n <= 1000) continue;
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            rDFModelWizardModel.setSourceFile(file);
            if (bl) {
                rDFModelWizardModel.setQuads(true);
                this.previewTable.getTableModel().enableQuads();
            } else {
                rDFModelWizardModel.setQuads(false);
                this.previewTable.getTableModel().disableQuads();
            }
            this.previewTable.setData(arrayList);
            this.enableButtons(false, true, false);
        }
    }
}

