/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.core.DHParams;
import oracle.security.crypto.core.Key;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;

public abstract class DHKey
implements Key,
ASN1Object {
    protected DHParams a;

    protected DHKey() {
    }

    protected DHKey(DHParams dHParams) {
        this.a = dHParams;
    }

    protected DHKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public String getAlgorithm() {
        return "Diffie-Hellman";
    }

    public int getBitLength() {
        FIPS_140_2.assertReadyState();
        if (this.a == null || this.a.getP() == null) {
            return 0;
        }
        return this.a.getP().bitLength();
    }

    public abstract Object clone();

    public DHParams getParams() {
        FIPS_140_2.assertReadyState();
        return this.a;
    }

    public abstract void setParams(DHParams var1);

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getEncoded());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

