/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.fips.FIPS_140_2;

public class DigestInputStream
extends FilterInputStream {
    protected MessageDigest a;

    public DigestInputStream(InputStream inputStream, MessageDigest messageDigest) {
        super(inputStream);
        this.a = messageDigest;
    }

    public synchronized int read() throws IOException {
        int n = this.in.read();
        if (n != -1) {
            this.a.update((byte)n);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n4 = 0; n4 < n2 && (n3 = this.read()) != -1; ++n4) {
            byArray[n + n4] = (byte)n3;
        }
        return n4 != 0 ? n4 : -1;
    }

    public byte[] computeCurrent() {
        this.a.computeCurrent();
        return this.a.getDigestBits();
    }

    public MessageDigest getMessageDigest() {
        return this.a;
    }

    public void setMessageDigest(MessageDigest messageDigest) {
        this.a = messageDigest;
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

