/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jrf.JrfUtils;
import oracle.jrf.i18n.JRFMessageBundleHelper;

public class AppContextStartup {
    public static final String JRF_ENABLE_APP_CONTEXT_INIT = "oracle.jrf.EnableAppContextInit";
    private static final boolean ENABLED = AppContextStartup.init();
    private static final Logger LOGGER = Logger.getLogger(JrfUtils.JRF_LOGGER);

    private static boolean init() {
        try {
            return Boolean.getBoolean(JRF_ENABLE_APP_CONTEXT_INIT);
        }
        catch (SecurityException se) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initAppContext() {
        Thread thread = Thread.currentThread();
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        ClassLoader originalTCL = thread.getContextClassLoader();
        thread.setContextClassLoader(systemLoader);
        try {
            LOGGER.log(Level.FINE, JRFMessageBundleHelper.msg.getString("JRF-20031"));
            Class.forName("sun.awt.AppContext", true, systemLoader);
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.FINE, JRFMessageBundleHelper.msg.getString("JRF-20032"), e);
            boolean bl = false;
            return bl;
        }
        finally {
            thread.setContextClassLoader(originalTCL);
        }
        return true;
    }

    public static void main(String[] args) {
        if (!ENABLED) {
            return;
        }
        AppContextStartup.initAppContext();
    }
}

