/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.NotificationListener;
import oracle.jrf.Port;
import oracle.jrf.PortabilityLayerException;
import weblogic.management.configuration.ServerMBean;

public abstract class PortConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Port> serverPorts;
    private Port frontEndHttpPort;
    private Port frontEndHttpSslPort;
    private Port clusterFrontEndHttpPort;
    private Port clusterFrontEndHttpSslPort;
    private Map<String, List<Port>> clusterMemberPorts;
    private String localHost;
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    protected final String PROPERTIES_FILE_NAME = "jrf-port-config.properties";
    public static final String WEBLOGIC_T3 = "t3";
    public static final String WEBLOGIC_T3S = "t3s";
    public static final String WEBLOGIC_IIOP = "iiop";
    public static final String WEBLOGIC_IIOPS = "iiops";

    protected PortConfig() throws Exception {
        this.initLocalHost();
    }

    public abstract String[] getSupportedPortProtocols();

    protected void setFrontEndHttpPort(Port frontEndHttpPort) {
        this.frontEndHttpPort = frontEndHttpPort;
    }

    protected void setFrontEndHttpSslPort(Port frontEndHttpSslPort) {
        this.frontEndHttpSslPort = frontEndHttpSslPort;
    }

    protected void setClusterFrontEndHttpPort(Port clusterFrontEndHttpPort) {
        this.clusterFrontEndHttpPort = clusterFrontEndHttpPort;
    }

    protected void setClusterFrontEndHttpSslPort(Port clusterFrontEndHttpSslPort) {
        this.clusterFrontEndHttpSslPort = clusterFrontEndHttpSslPort;
    }

    public Port getHttpPort() {
        return this.getServerPort(HTTP);
    }

    public Port getHttpPort(String partitionName) {
        return null;
    }

    public List<Port> getClusterHttpPorts() {
        return this.getClusterMemberPorts(HTTP);
    }

    public Port getHttpSslPort() {
        return this.getServerPort(HTTPS);
    }

    public Port getHttpSslPort(String partitionName) {
        return null;
    }

    public List<Port> getClusterHttpSslPorts() {
        return this.getClusterMemberPorts(HTTPS);
    }

    public Port getFrontEndHttpPort() {
        return this.frontEndHttpPort;
    }

    public Port getFrontEndHttpSslPort() {
        return this.frontEndHttpSslPort;
    }

    public Port getClusterFrontEndHttpPort() {
        return this.clusterFrontEndHttpPort;
    }

    public Port getClusterFrontEndHttpSslPort() {
        return this.clusterFrontEndHttpSslPort;
    }

    public List<Port> getClusterMemberPorts(String protocol) {
        if (this.clusterMemberPorts != null) {
            return this.clusterMemberPorts.get(protocol);
        }
        return null;
    }

    protected void addClusterMemberPort(Port port) {
        if (port != null) {
            List<Port> portList;
            if (this.clusterMemberPorts == null) {
                this.clusterMemberPorts = new HashMap<String, List<Port>>();
            }
            if ((portList = this.clusterMemberPorts.get(port.getProtocol())) == null) {
                portList = new ArrayList<Port>();
            }
            portList.add(port);
            this.clusterMemberPorts.put(port.getProtocol(), portList);
        }
    }

    public Port getServerPort(String protocol) {
        if (this.serverPorts != null) {
            return this.serverPorts.get(protocol);
        }
        return null;
    }

    protected void addServerPort(Port port) {
        if (port != null) {
            if (this.serverPorts == null) {
                this.serverPorts = new HashMap<String, Port>();
            }
            this.serverPorts.put(port.getProtocol(), port);
        }
    }

    public String getJndiProviderURL() {
        for (String defaultProtocol : this.getDefaultJndiProtocols()) {
            String url = this.getJndiProviderURLForProtocol(defaultProtocol);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public boolean isSSLRequired() {
        return false;
    }

    public boolean isSSLRequired(ServerMBean server) {
        return false;
    }

    public String getJndiProviderURL(String partitionName) {
        return null;
    }

    public String getJndiSslProviderURL() {
        for (String defaultProtocol : this.getDefaultJndiSslProtocols()) {
            String url = this.getJndiProviderURLForProtocol(defaultProtocol);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public String getJndiSslProviderURL(String partitionName) {
        return null;
    }

    protected String getJndiProviderURLForProtocol(String protocol) {
        if (this.isClustered()) {
            return this.getClusterJndiProviderURL(protocol);
        }
        Port serverPort = this.getServerPort(protocol);
        if (serverPort != null) {
            return serverPort.getDnsResolvedURLString();
        }
        return null;
    }

    public String getClusterJndiProviderURL(String defaultProtocol) {
        List<Port> clusterPorts = this.getClusterMemberPorts(defaultProtocol);
        if (clusterPorts != null) {
            String url = null;
            for (Port port : clusterPorts) {
                if (url == null) {
                    url = this.getClusterProtocolURLPrefix(port.getProtocol()) + port.getDnsResolvedHost() + ":" + port.getPort();
                    continue;
                }
                url = url + this.getClusterJNDISeparator() + port.getDnsResolvedHost() + ":" + port.getPort();
            }
            return url;
        }
        return null;
    }

    private String getClusterProtocolURLPrefix(String protocol) {
        return protocol + "://";
    }

    protected String getClusterJNDISeparator() {
        return ",";
    }

    public abstract boolean isClustered();

    protected abstract String[] getDefaultJndiProtocols();

    protected abstract String[] getDefaultJndiSslProtocols();

    protected String getLocalHost() {
        return this.localHost;
    }

    protected void initLocalHost() throws UnknownHostException {
        this.localHost = InetAddress.getLocalHost().getCanonicalHostName();
    }

    protected static boolean isIPv6(String host) throws UnknownHostException {
        InetAddress address = InetAddress.getByName(host);
        return address instanceof Inet6Address;
    }

    protected static String resolveHost(String host) throws UnknownHostException {
        if (host.indexOf("localhost") > -1 || host.indexOf("127.0.0.1") > -1) {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        InetAddress address = InetAddress.getByName(host);
        String resolvedHost = address.getCanonicalHostName();
        if (resolvedHost.indexOf(".") < 0 && host.indexOf(".") > 0) {
            return host;
        }
        return resolvedHost;
    }

    protected abstract void registerPortConfigChangeListener(NotificationListener var1) throws PortabilityLayerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parsePortConfigPropertiesFile(File portConfigPropertiesFile) throws Exception {
        if (!portConfigPropertiesFile.exists()) {
            return;
        }
        Properties properties = new Properties();
        try (FileInputStream is2 = new FileInputStream(portConfigPropertiesFile);){
            properties.load(is2);
        }
        catch (IOException is2) {
            // empty catch block
        }
        String host = properties.getProperty("frontend.http.host");
        String port = properties.getProperty("frontend.http.port");
        if (host != null && port != null) {
            this.setFrontEndHttpPort(new Port(HTTP, host, Integer.valueOf(port), this));
        }
        host = properties.getProperty("frontend.https.host");
        port = properties.getProperty("frontend.https.port");
        if (host != null && port != null) {
            this.setFrontEndHttpSslPort(new Port(HTTPS, host, Integer.valueOf(port), this));
        }
        host = properties.getProperty("http.host");
        port = properties.getProperty("http.port");
        if (host != null && port != null) {
            this.addServerPort(new Port(HTTP, host, Integer.valueOf(port), this));
        }
        host = properties.getProperty("https.host");
        port = properties.getProperty("https.port");
        if (host != null && port != null) {
            this.addServerPort(new Port(HTTPS, host, Integer.valueOf(port), this));
        }
    }
}

