/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.workbench.plugin.TeradataMachine;
import oracle.dbtools.migration.workbench.plugin.TeradataStateInterface;

public abstract class TeradataState
implements TeradataStateInterface {
    protected TeradataMachine machine = null;

    public TeradataState(TeradataMachine teradataMachine) {
        this.machine = teradataMachine;
    }

    @Override
    public String getDatafileExtension() {
        return "dat";
    }

    public static String makeNumericFormat(int n, int n2) {
        return TeradataState.makeNumericFormat(n, n2, '-');
    }

    public static String makeNumericFormat(int n, int n2, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(c);
        for (int i = 0; i < n; ++i) {
            if (i == n - n2) {
                stringBuffer.append('.');
            }
            stringBuffer.append('9');
        }
        return stringBuffer.toString();
    }

    public static String makeLengthString(String string, boolean bl, int n, int n2) {
        String string2 = bl ? "CAST((CASE WHEN (" + string + ") IS NULL THEN " + TeradataState.makeLengthString(0, n2) + "  ELSE " + TeradataState.makeLengthString(n, n2) + " END) AS VARCHAR(6))" : TeradataState.makeLengthString(n, n2);
        return string2;
    }

    public static String makeLengthString(int n, int n2) {
        String string = Integer.toString(n);
        StringBuffer stringBuffer = new StringBuffer("'");
        for (int i = 0; i < n2 - string.length(); ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        stringBuffer.append("'");
        return stringBuffer.toString();
    }

    protected static class ColumnDetails {
        MdColumn col;

        public ColumnDetails(MdColumn mdColumn) {
            this.col = mdColumn;
        }

        public String getLencode() {
            return this.col.getProperty("TERADATA_DUMPLENDECODE");
        }

        public String getName() {
            return this.col.getColumnName();
        }

        public String getType() {
            return this.col.getColumnType();
        }

        public Integer getOrder() {
            return this.col.getColumnOrder();
        }

        public Integer getPrecision() {
            if (this.col.getPrecision() == null) {
                return this.getScale();
            }
            return this.col.getPrecision();
        }

        public Integer getScale() {
            if (this.col.getScale() == null) {
                return 0;
            }
            return this.col.getScale();
        }

        public String getNullable() {
            return this.col.getNullable() == null ? "N" : this.col.getNullable();
        }
    }
}

