/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.teradata;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.QueryCapture;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;

public class Teradata12CapturerImpl {
    private static final String GET_SCHEMA_QUERY = "select databasenamei from dbc.dbase where databasenamei NOT IN ('TDPUSER', 'TDUSER', 'TWM', 'SQLJ','SYSTEMFE','DEFAULT','SYSSPATIAL','CRASHDUMPS','SYSLIB')";
    private static final String GET_TABLE_QUERY = "select dbc.tvm.TVMName TABLE_NAME\n                                               , dbc.tvm.TVMID ID\n                                          from   dbc.tvm\n                                               , dbc.dbase\n                                          where  dbc.tvm.tablekind='T'\n                                             and dbc.tvm.CommitOpt='N'\n                                             and dbc.tvm.databaseID=dbc.dbase.databaseID\n                                             and UPPER(TRIM(dbc.dbase.databasenamei))=UPPER(TRIM('${schema}')) ";
    private static final String GET_COLUMN_QUERY_12 = "select   TRIM(DBC.TVFields.FieldName) \"COLNAME\"\n       , CASE TRIM(DBC.TVFields.FieldType)\n             WHEN 'AT' THEN 'ANSITIME'\n             WHEN 'BF' THEN 'BYTEFIXED'\n             WHEN 'BO' THEN 'BYTELARGEOBJECT'\n             WHEN 'BS' THEN 'BINARYSTRING'\n             WHEN 'BV' THEN 'BYTEVARYING'\n             WHEN 'CF' THEN 'CHARFIXED' || ( CASE dbc.TVFields.CharType WHEN 1 THEN 'LATIN' WHEN '2' THEN 'UNICODE' WHEN '3' THEN 'KANJISJIS' WHEN 4 THEN 'GRAPHIC' WHEN 5 THEN 'KANJI1' ELSE 'LATIN' END)\n             WHEN 'CO' THEN 'CHARLARGEOBJECT' || ( CASE dbc.TVFields.CharType WHEN 1 THEN 'LATIN' WHEN '2' THEN 'UNICODE' WHEN '3' THEN 'KANJISJIS' WHEN 4 THEN 'GRAPHIC' WHEN 5 THEN 'KANJI1' ELSE 'LATIN' END)\n             WHEN 'CS' THEN 'CHARSTRING'\n             WHEN 'CV' THEN 'CHARVARYING' || ( CASE dbc.TVFields.CharType WHEN 1 THEN 'LATIN' WHEN '2' THEN 'UNICODE' WHEN '3' THEN 'KANJISJIS' WHEN 4 THEN 'GRAPHIC' WHEN 5 THEN 'KANJI1' ELSE 'LATIN' END)\n             WHEN 'D'  THEN 'DECIMAL'\n             WHEN 'DA' THEN 'DATE'\n             WHEN 'DH' THEN 'DAYHOUR'\n             WHEN 'DI' THEN 'DAYINTERVAL'\n             WHEN 'DM' THEN 'DAYMINUTE'\n             WHEN 'DS' THEN 'DAYSECOND'\n             WHEN 'DT' THEN 'DATETAG'\n             WHEN 'DY' THEN 'DAY'\n             WHEN 'F'  THEN 'REAL'\n             WHEN 'HM' THEN 'HOURMINUTE'\n             WHEN 'HR' THEN 'HOUR'\n             WHEN 'HS' THEN 'HOURSECOND'\n             WHEN 'I'  THEN 'INTEGER'\n             WHEN 'I1' THEN 'BYTEINT'\n             WHEN 'I2' THEN 'SMALLINT'\n             WHEN 'I8' THEN 'BIGINTEGER'\n             WHEN 'LF' THEN 'CHARFIXEDLOCALE'\n             WHEN 'LV' THEN 'CHARVARYINGLOCALE'\n             WHEN 'MI' THEN 'MINUTE'\n             WHEN 'MO' THEN 'MONTH'\n             WHEN 'MS' THEN 'MINUTETOSECOND'\n             WHEN 'NM' THEN 'NUMBERTAG'\n             WHEN 'SC' THEN 'SECOND'\n             WHEN 'SZ' THEN 'TIMESTAMPWITHTIMEZONE'\n             WHEN 'TM' THEN 'TIMETAG'\n             WHEN 'TS' THEN 'TIMESTAMPWITHOUTTIMEZONE'\n             WHEN 'TZ' THEN 'ANSITIMEWITHTIMEZONE'\n             WHEN 'UF' THEN 'CHARFIXEDUNICODE'\n             WHEN 'UT' THEN 'USERDEFINEDTYPE'\n             WHEN 'UV' THEN 'CHARVARYINGUNICODE'\n             WHEN 'YI' THEN 'YEARINTERVAL'\n             WHEN 'YM' THEN 'YEARMONTH'\n             WHEN 'YR' THEN 'YEAR'\n             else TRIM(DBC.TVFields.FieldType)\n         END \"TYPENAME\"\n       , case\n               when ((DBC.TVFields.TotalDigits IS NOT NULL)OR(DBC.TVFields.ImpliedPoint IS NOT NULL)) then (DBC.TVFields.TotalDigits(FORMAT 'Z9'))\n               else (DBC.TVFields.MaxLength(FORMAT 'Z,ZZZ,ZZZ,ZZ9')) \n         end \"LENGTH\"\n       , DBC.TVFields.ImpliedPoint(FORMAT 'Z9') \"SCALE\"\n       , DBC.TVFields.nullable \"NULLS\"\n       , DBC.TVFields.DefaultValue \"DEFAULT\"\n       , TRIM(DBC.TVFields.FieldFormat) \"COLUMNFORMAT\"\n       , TRIM(DBC.TVFields.FieldType) \"RAWTYPENAME\"\n       , DBC.TVFields.MaxLength(FORMAT 'Z,ZZZ,ZZZ,ZZ9') \"MAXLENGTH\"\n       , DBC.TVFields.ColumnCheck \"CHECK\"\n       , DBC.TVFields.TotalDigits (NAMED \"DecimalTotalDigits\" , FORMAT 'Z9')\n       , DBC.TVFields.ImpliedPoint (NAMED \"DecimalFractionalDigits\" , FORMAT 'Z9')\n       , DBC.tvfields.MaxLength (NAMED \"ColumnLength\" , FORMAT 'Z,ZZZ,ZZZ,ZZ9')\nFROM\n       DBC.TVM\n           inner join DBC.Dbase on DBC.TVM.DatabaseId = dbase.DatabaseId\n           inner join DBC.TVFields on DBC.TVM.tvmid = DBC.TVFields.tableid\nWHERE\n         UPPER(TRIM(DBC.DBase.DatabaseNameI))=UPPER(TRIM('${schema}')) and\n         UPPER(TRIM(DBC.TVM.TVMNameI))=UPPER(TRIM('${table}'))\nORDER BY  DBC.TVFields.FieldId ";
    protected static String GET_COLUMN_QUERY = "select   TRIM(DBC.TVFields.FieldName) \"COLNAME\"\n       , CASE TRIM(DBC.TVFields.FieldType)\n             WHEN 'AT' THEN 'ANSITIME'\n             WHEN 'BF' THEN 'BYTEFIXED'\n             WHEN 'BO' THEN 'BYTELARGEOBJECT'\n             WHEN 'BS' THEN 'BINARYSTRING'\n             WHEN 'BV' THEN 'BYTEVARYING'\n             WHEN 'CF' THEN 'CHARFIXED' || ( CASE dbc.TVFields.CharType WHEN 1 THEN 'LATIN' WHEN '2' THEN 'UNICODE' WHEN '3' THEN 'KANJISJIS' WHEN 4 THEN 'GRAPHIC' WHEN 5 THEN 'KANJI1' ELSE 'LATIN' END)\n             WHEN 'CO' THEN 'CHARLARGEOBJECT' || ( CASE dbc.TVFields.CharType WHEN 1 THEN 'LATIN' WHEN '2' THEN 'UNICODE' WHEN '3' THEN 'KANJISJIS' WHEN 4 THEN 'GRAPHIC' WHEN 5 THEN 'KANJI1' ELSE 'LATIN' END)\n             WHEN 'CS' THEN 'CHARSTRING'\n             WHEN 'CV' THEN 'CHARVARYING' || ( CASE dbc.TVFields.CharType WHEN 1 THEN 'LATIN' WHEN '2' THEN 'UNICODE' WHEN '3' THEN 'KANJISJIS' WHEN 4 THEN 'GRAPHIC' WHEN 5 THEN 'KANJI1' ELSE 'LATIN' END)\n             WHEN 'D'  THEN 'DECIMAL'\n             WHEN 'DA' THEN 'DATE'\n             WHEN 'DH' THEN 'DAYHOUR'\n             WHEN 'DI' THEN 'DAYINTERVAL'\n             WHEN 'DM' THEN 'DAYMINUTE'\n             WHEN 'DS' THEN 'DAYSECOND'\n             WHEN 'DT' THEN 'DATETAG'\n             WHEN 'DY' THEN 'DAY'\n             WHEN 'F'  THEN 'REAL'\n             WHEN 'HM' THEN 'HOURMINUTE'\n             WHEN 'HR' THEN 'HOUR'\n             WHEN 'HS' THEN 'HOURSECOND'\n             WHEN 'I'  THEN 'INTEGER'\n             WHEN 'I1' THEN 'BYTEINT'\n             WHEN 'I2' THEN 'SMALLINT'\n             WHEN 'I8' THEN 'BIGINTEGER'\n             WHEN 'LF' THEN 'CHARFIXEDLOCALE'\n             WHEN 'LV' THEN 'CHARVARYINGLOCALE'\n             WHEN 'MI' THEN 'MINUTE'\n             WHEN 'MO' THEN 'MONTH'\n             WHEN 'MS' THEN 'MINUTETOSECOND'\n             WHEN 'NM' THEN 'NUMBERTAG'\n             WHEN 'SC' THEN 'SECOND'\n             WHEN 'SZ' THEN 'TIMESTAMPWITHTIMEZONE'\n             WHEN 'TM' THEN 'TIMETAG'\n             WHEN 'TS' THEN 'TIMESTAMPWITHOUTTIMEZONE'\n             WHEN 'TZ' THEN 'ANSITIMEWITHTIMEZONE'\n             WHEN 'UF' THEN 'CHARFIXEDUNICODE'\n             WHEN 'UT' THEN 'USERDEFINEDTYPE'\n             WHEN 'UV' THEN 'CHARVARYINGUNICODE'\n             WHEN 'YI' THEN 'YEARINTERVAL'\n             WHEN 'YM' THEN 'YEARMONTH'\n             WHEN 'YR' THEN 'YEAR'\n             else TRIM(DBC.TVFields.FieldType)\n         END \"TYPENAME\"\n       , case\n               when ((DBC.TVFields.TotalDigits IS NOT NULL)OR(DBC.TVFields.ImpliedPoint IS NOT NULL)) then (DBC.TVFields.TotalDigits(FORMAT 'Z9'))\n               else (DBC.TVFields.MaxLength(FORMAT 'Z,ZZZ,ZZZ,ZZ9')) \n         end \"LENGTH\"\n       , DBC.TVFields.ImpliedPoint(FORMAT 'Z9') \"SCALE\"\n       , DBC.TVFields.nullable \"NULLS\"\n       , DBC.TVFields.DefaultValue \"DEFAULT\"\n       , TRIM(DBC.TVFields.FieldFormat) \"COLUMNFORMAT\"\n       , TRIM(DBC.TVFields.FieldType) \"RAWTYPENAME\"\n       , DBC.TVFields.MaxLength(FORMAT 'Z,ZZZ,ZZZ,ZZ9') \"MAXLENGTH\"\n       , DBC.TVFields.ColumnCheck \"CHECK\"\n       , DBC.TVFields.TotalDigits (NAMED \"DecimalTotalDigits\" , FORMAT 'Z9')\n       , DBC.TVFields.ImpliedPoint (NAMED \"DecimalFractionalDigits\" , FORMAT 'Z9')\n       , DBC.tvfields.MaxLength (NAMED \"ColumnLength\" , FORMAT 'Z,ZZZ,ZZZ,ZZ9')\nFROM\n       DBC.TVM\n           inner join DBC.Dbase on DBC.TVM.DatabaseId = dbase.DatabaseId\n           inner join DBC.TVFields on DBC.TVM.tvmid = DBC.TVFields.tableid\nWHERE\n         UPPER(TRIM(DBC.DBase.DatabaseNameI))=UPPER(TRIM('${schema}')) and\n         UPPER(TRIM(DBC.TVM.TVMNameI))=UPPER(TRIM('${table}'))\nORDER BY  DBC.TVFields.FieldId ";
    private static final String GET_VIEW_QUERY = "select dbc.tvm.TVMName VIEWNAME\n                                              , dbc.dbase.DatabaseName OWNER\n                                              , 'TRUE' READONLY\n                                              , 'TRUE' VALID\n                                              , CASE\n                                                    WHEN dbc.TVM.CreateText  IS NOT NULL THEN dbc.TVM.CreateText \n                                                    ELSE dbc.TVM.RequestText \n                                                END TEXT\n                                              , dbc.tvm.TVMID ID                                         from   dbc.tvm inner join dbc.dbase on dbc.tvm.databaseID=dbc.dbase.databaseID\n                                         where  dbc.tvm.tablekind='V'\n                                            and UPPER(TRIM(dbc.dbase.databasenamei))=UPPER(TRIM('${schema}')) ";
    private static final String GET_INDEXES_QUERY = "select unique DBC.Indexes.TableId ID\n                                       , DBC.Indexes.Name INDNAME\n                                       , DBC.Indexes.IndexType INDEXTYPE\n                                       , DBC.Indexes.UniqueFlag UNIQUERULE\n                                       , DBC.userdb.Name CREATEUSER\n                                  from    DBC.Indexes inner join DBC.userdb on DBC.Indexes.CreateUID=DBC.userdb.id \n                                                     inner join DBC.Dbase on dbc.dbase.databaseid=dbc.Indexes.databaseid \n                                                     inner join DBC.TVM on DBC.TVM.TVMId=DBC.Indexes.TableId\n                                 where   DBC.Indexes.Name is not null and\n                                         UPPER(TRIM(DBC.TVM.TVMNameI))=UPPER(TRIM('${table}')) and \n                                         UPPER(TRIM(DBC.DBase.DatabaseNameI))=UPPER(TRIM('${schema}')) ";
    private static final String GET_INDEX_DETAILS_QUERY = "select  DBC.TVFields.FieldName COLNAME                                           , DBC.Indexes.FieldPosition COLSEQ\n                                     from    DBC.TVFields\n                                           , DBC.Indexes\n                                           , DBC.Dbase\n                                           , DBC.TVM\n                                     where   DBC.TVFields.TableId= DBC.Indexes.TableId and\n                                             DBC.TVFields.FieldId=DBC.Indexes.FieldId and\n                                             dbc.dbase.databaseid=dbc.Indexes.databaseid and\n                                             DBC.TVM.TVMId=DBC.Indexes.TableId and\n                                             DBC.Indexes.Name='${index}' and\n                                             UPPER(TRIM(DBC.TVM.TVMNameI))=UPPER(TRIM('${table}')) and \n                                             UPPER(TRIM(DBC.DBase.DatabaseNameI))=UPPER(TRIM('${schema}')) ";
    private static final String GET_TRIGGERS_QUERY = "select  dbc.TriggersTbl.TriggerName TRIGNAME\n                                           , TRIG_DB.DatabaseName OWNER\n                                           , TABLE_DB.DatabaseName TABSCHEMA\n                                           , dbc.TVM.TVMName TABNAME\n                                           , dbc.TriggersTbl.TriggerEvent TRIGEVENT\n                                           , dbc.TriggersTbl.TriggerEnabled VALID\n                                           , dbc.TriggersTbl.CreateText TEXT\n                                           , dbc.TriggersTbl.CommentString REMARKS\n                                     from    dbc.TVM\n                                           , dbc.Dbase TRIG_DB\n                                           , dbc.Dbase TABLE_DB\n                                           , dbc.TriggersTbl\n                                     where   dbc.TriggersTbl.TableId=dbc.TVM.TVMId and\n                                             TABLE_DB.databaseid=dbc.TriggersTbl.subjectTabDBaseId and\n                                             TRIG_DB.databaseid=dbc.TriggersTbl.databaseid and\n                                             UPPER(TRIM(dbc.TVM.TVMNameI))=UPPER(TRIM('${triggersubject}')) and\n                                             UPPER(TRIM(TRIG_DB.databasename))=UPPER(TRIM('${schema}')) ";
    private static final String GET_PROCEDURES_QUERY = "select dbc.TVM.TVMName NAME\n          , CASE \n                WHEN dbc.TVM.TableKind in ('F', 'A', 'B', 'R', 'S') THEN 'FUNCTION'\n                WHEN dbc.TVM.TableKind in ('P', 'E') THEN 'PROCEDURE'\n                ELSE 'NONE'\n           END  ROUTINETYPE\n           ,  CASE\n                 WHEN dbc.TVM.CreateText  IS NOT NULL THEN dbc.TVM.CreateText \n                 ELSE dbc.TVM.RequestText \n              END TEXT\n           , dbc.TVM.CreateTimeStamp  CREATE_TIME\n           , dbc.TVM.CommentString REMARKS\nfrom  dbc.TVM\n        , dbc.Dbase\nwhere dbc.TVM.TableKind in ('F', 'A', 'B', 'R', 'S', 'P', 'E') \n            and dbc.TVM.DatabaseId=dbc.Dbase.DatabaseId\n            and UPPER(TRIM(dbc.Dbase.DatabaseNameI))=UPPER(TRIM('${schema}')) ";
    private static final String GET_PK_CONSTRAINTS_QUERY = "SELECT\n       CAST(TRANSLATE(COALESCE (indexes.Name, TRIM(tvm.TVMName) || '_' || TRIM(DBC.Indexes.IndexType) || TRIM(indexes.IndexNumber) ) USING UNICODE_TO_LOCALE WITH ERROR) AS CHAR(30)) (NAMED CONSTNAME)\n     , indexes.IndexType \"TYPE\"\n     , CAST(TRANSLATE(dbase.DatabaseName USING UNICODE_TO_LOCALE WITH ERROR) AS CHAR(30)) (NAMED TABSCHEMA)\n     , CAST(TRANSLATE(tvm.TVMName USING UNICODE_TO_LOCALE WITH ERROR) AS CHAR(30)) (NAMED TABNAME)\n     , CAST(TRANSLATE(tvfields.FieldName USING UNICODE_TO_LOCALE WITH ERROR) AS CHAR(30)) (NAMED COLNAME)\n     , indexes.FieldPosition(NAMED ColumnPosition,FORMAT 'Z9') (NAMED COLSEQ)\n     , '' \"REMARKS\"\n     , indexes.IndexNumber(FORMAT 'ZZ9')\n     , indexes.UniqueFlag\n     , indexes.CreateTimeStamp\n     , indexes.LastAlterTimeStamp\n     , indexes.IndexMode\n     , indexes.AccessCount\n     , indexes.LastAccessTimeStamp\nFROM\n     DBC.tvm\n        inner join DBC.Indexes  on DBC.TVM.TVMId=DBC.Indexes.TableId\n        inner join DBC.TVFields on DBC.TVM.TVMId=DBC.TVFields.tableid\n        inner join DBC.DBase    on DBC.TVM.DatabaseId=DBC.Dbase.DatabaseId\nWHERE\n      DBC.Indexes.IndexType in ('K', 'P', 'Q', 'U')\n  AND tvfields.fieldid = indexes.fieldid\n  AND UPPER(TRIM(dbc.DBase.DatabaseNameI))=UPPER(TRIM('${schema}'))\n  AND UPPER(TRIM(TABNAME))=UPPER(TRIM('${table}')) \nORDER BY CONSTNAME, TabName, IndexNumber, ColSeq\n";
    private static final String GET_CK_CONSTRAINTS_QUERY = "select distinct\n               TRIM(DBC.TableConstraints.Name)        (NAMED CONSTRAINT_NAME)\n             , TRIM(DBC.TableConstraints.TableCheck)  (NAMED SEARCH_CONDITION)\n             , DBC.TableConstraints.IndexNumber       (NAMED INDEX_NUMBER)\n        from DBC.TableConstraints inner join DBC.TVM on DBC.TableConstraints.TVMId=DBC.TVM.TVMId\n        where DBC.TableConstraints.ConstraintType='C' and UPPER(TRIM(DBC.TVM.TVMName))=UPPER(TRIM('${table}'))\n";
    private static final String GET_COL_CK_CONSTRAINTS_QUERY = "select\n      null                           (NAMED CONSTRAINT_NAME)\n    , TRIM(DBC.TVFIELDS.COLUMNCHECK) (named SEARCH_CONDITION)\n    , TRIM(DBC.TVM.TVMNAME) (named TABNAME)\n    , TRIM(DBC.TVFields.FieldName) (named COLNAME)\nfrom DBC.TVFIELDS inner join DBC.TVM on DBC.TVFields.TableId=DBC.TVM.TVMId\nwhere DBC.TVFields.ColumnCheck IS NOT NULL and UPPER(TRIM(DBC.TVM.TVMName))=UPPER(TRIM('${table}'))\n";
    private static final String GET_FK_CONSTRAINTS_QUERY = "select  distinct\n         LOCAL_DB.DatabaseName \"TABSCHEMA\"\n       , LOCAL_TVM.TVMName \"TABNAME\"\n       , REF_DB.DatabaseName \"REFTABSCHEMA\"\n       , REF_TVM.TVMName \"REFTABNAME\"\n       , RT.ReferenceIdxName \"CONSTNAME\"\n       , LOCAL_FLD.FieldName \"COLNAME\"\n       , REF_FLD.FieldName \"REFCOLNAME\"\n       , IND.Name \"REFKEYNAME\"\n       , IND.FieldPosition \"COLSEQ\"\n       , 'R' \"TYPE\"\n       , '' \"REMARKS\"\n       , RT.ForeignKeyFID \"FKID\"\n       , RT.ReferenceIdx \"IDXID\"\nfrom\n    dbc.ReferencedTbls RT\n         inner join dbc.Dbase LOCAL_DB on LOCAL_DB.DatabaseId=RT.ReferencingDbID\n         inner join dbc.TVM LOCAL_TVM on LOCAL_TVM.TVMId=RT.ReferencingTblID\n         inner join dbc.Dbase REF_DB on REF_DB.DatabaseId=RT.ReferencedDbID\n         inner join dbc.TVM REF_TVM on REF_TVM.TVMId=RT.ReferencedTblID\n         inner join dbc.TVFields LOCAL_FLD on LOCAL_FLD.tableId=RT.ReferencingTblID and LOCAL_FLD.FieldId=RT.ForeignKeyFID\n         inner join dbc.TVFields REF_FLD on REF_FLD.tableId=RT.ReferencedTblID and REF_FLD.FieldId=RT.ParentKeyFID\n         inner join dbc.Indexes IND on IND.tableId=RT.ReferencedTblID and IND.FieldId=RT.ParentKeyFID\nwhere UPPER(TRIM(LOCAL_DB.DatabaseNameI))=UPPER(TRIM('${schema}')) and UPPER(TRIM(LOCAL_TVM.TVMNameI))=UPPER(TRIM('${table}'))\norder by TABNAME, LOCAL_FLD.FieldId";
    private static final String GET_TABLE_CHECK_CONSTRAINTS_QUERY = "";
    private static final String GET_COLUMN_CHECK_CONSTRAINTS_QUERY = "";
    protected Map<String, Integer> m_typeMap = new Hashtable<String, Integer>(){
        {
            this.put("AT", 26);
            this.put("BF", 0);
            this.put("BO", -8);
            this.put("BS", 0);
            this.put("BV", -2);
            this.put("CF", 0);
            this.put("CO", -8);
            this.put("CS", 0);
            this.put("CV", 0);
            this.put("D ", 4);
            this.put("D", 4);
            this.put("DA", 10);
            this.put("DH", 0);
            this.put("DI", 0);
            this.put("DM", 0);
            this.put("DS", 0);
            this.put("DT", 0);
            this.put("DY", 0);
            this.put("F ", 0);
            this.put("F", 0);
            this.put("HM", 0);
            this.put("HR", 0);
            this.put("HS", 0);
            this.put("I ", 4);
            this.put("I", 4);
            this.put("I1", 1);
            this.put("I2", 2);
            this.put("I8", 8);
            this.put("LF", 0);
            this.put("LV", 0);
            this.put("MI", 11);
            this.put("MO", 0);
            this.put("MS", 0);
            this.put("NM", 0);
            this.put("SC", 0);
            this.put("SZ", 31);
            this.put("TM", 0);
            this.put("TS", 26);
            this.put("TZ", 21);
            this.put("UF", 0);
            this.put("UT", 0);
            this.put("UV", 0);
            this.put("YI", 0);
            this.put("YM", 0);
            this.put("YR", 0);
        }
    };
    public static final String TERADATA_LANGUAGE_ID = "TERADATALANG";
    private Connection m_sourceConnection;
    private MigrationStorer m_storer;

    public Teradata12CapturerImpl(MigrationStorer migrationStorer, Connection connection) {
        this.setStorer(migrationStorer);
        this.m_sourceConnection = connection;
    }

    private void setStorer(MigrationStorer migrationStorer) {
        this.m_storer = migrationStorer;
    }

    public MigrationStorer getStorer() {
        return this.m_storer;
    }

    public Connection getConnection() {
        return this.m_sourceConnection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) {
        if (captureContext.shouldCancel()) {
            CaptureEvent captureEvent = new CaptureEvent(-1, string, "");
            captureContext.getAudience().fireListeners(captureEvent);
            return;
        }
        try {
            if (string.equals("MD_CATALOGS")) {
                this.captureCatalog(captureContext);
                return;
            }
            if (string.equals("MD_SCHEMAS")) {
                this.captureSchemas(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_TABLES")) {
                this.captureTables(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_VIEWS")) {
                this.captureViews(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_COLUMNS")) {
                this.captureColumns(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_INDEXES")) {
                this.captureIndexes(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_TRIGGERS")) {
                this.captureTriggers(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_STORED_PROGRAMS")) {
                this.captureProcedures(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_CONSTRAINTS")) {
                this.captureConstraints(captureContext);
                return;
            }
            if (!string.equals("MD_SYNONYMS")) return;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            return;
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureProcedures(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        try (CloseableResultSet closeableResultSet = null;){
            Object object;
            Serializable serializable;
            StringBuffer stringBuffer = this.getStoredPgmQuery(captureContext);
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
            if (migrationObjectFilter != null) {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append(migrationObjectFilter.toWhereClause("ROUTINENAME "));
                object = ((StringBuffer)serializable).toString().replaceAll("WHERE", "AND");
                stringBuffer.append((String)object);
            }
            serializable = new HashSet();
            this.processFilter(migrationObjectFilter, stringBuffer, (Set<String>)((Object)serializable), "MD_STORED_PROGRAMS", true);
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            object = closeableResultSet.getResultSet();
            while (object.next() && !captureContext.shouldCancel()) {
                String string = object.getString("NAME");
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !serializable.contains(string.toUpperCase())) continue;
                MdStoredProgram mdStoredProgram = new MdStoredProgram(dBObjectId, TERADATA_LANGUAGE_ID);
                mdStoredProgram.setName(string);
                mdStoredProgram.setProgramtype(object.getString("ROUTINETYPE"));
                String string2 = object.getString("REMARKS");
                if (string2 != null && string2.length() > 0) {
                    mdStoredProgram.setComments(string2);
                }
                mdStoredProgram.setNativeSql(object.getString("TEXT"));
                Timestamp timestamp = object.getTimestamp("CREATE_TIME");
                mdStoredProgram.setCreatedOn(new Date(timestamp.getTime()));
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_STORED_PROGRAMS"), mdStoredProgram.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdStoredProgram = (MdStoredProgram)this.getStorer().storeObject((PersistableObject)mdStoredProgram);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
    }

    protected StringBuffer getStoredPgmQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString(GET_PROCEDURES_QUERY);
        return new StringBuffer(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void capturePrimaryKeyConstraints(CaptureContext captureContext) throws SQLException, PersistenceException {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
        String string = this.getPKConstrQuery(captureContext);
        try (CloseableResultSet closeableResultSet = QueryCapture.issueSQL((String)string.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);){
            ResultSet resultSet = closeableResultSet.getResultSet();
            HashMap<String, MdConstraint> hashMap = new HashMap<String, MdConstraint>();
            PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                CaptureEvent captureEvent;
                String string2;
                String string3 = resultSet.getString("TYPE");
                String string4 = null;
                String string5 = resultSet.getString("CONSTNAME");
                String string6 = resultSet.getString("UniqueFlag");
                if (string5 != null) {
                    string5 = string5.trim();
                }
                if (string3.trim().equals("K")) {
                    string4 = "PK";
                } else if (string3.trim().equals("U") || string3.trim().equals("UNIQUE")) {
                    string4 = "UNIQUE";
                } else {
                    if (!string3.trim().equals("Q") && !string3.trim().equals("P") || string6 == null || !string6.equals("Y")) continue;
                    string4 = "UNIQUE";
                }
                MdConstraint mdConstraint = (MdConstraint)hashMap.get(string5);
                if (mdConstraint == null && string4 != null) {
                    MdConstraint mdConstraint2 = new MdConstraint(dBObjectId, TERADATA_LANGUAGE_ID);
                    mdConstraint2.setName(string5);
                    mdConstraint2.setConstraintType(string4);
                    string2 = resultSet.getString("REMARKS");
                    mdConstraint2.setComments(string2);
                    captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint2.getName());
                    captureContext.getAudience().fireListeners(captureEvent);
                    mdConstraint2 = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint2);
                    hashMap.put(string5, mdConstraint2);
                    captureEvent.setEventId(4);
                    captureContext.getAudience().fireListeners(captureEvent);
                } else if (string4 == null) {
                    Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "Could not capture Constraint:" + string5 + " Unknown Type:" + string3);
                    continue;
                }
                if ((mdConstraint = (MdConstraint)hashMap.get(string5)) == null) continue;
                int n = resultSet.getInt("COLSEQ");
                string2 = resultSet.getString("COLNAME");
                captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), string2);
                captureContext.getAudience().fireListeners(captureEvent);
                MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n));
                mdConstraintDetail.setColumnId(persistenceUtility.getIdForColumn(mdConstraint.getTableId(), string2));
                mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
    }

    protected String getPKConstrQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString(GET_PK_CONSTRAINTS_QUERY);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureForeignKeyConstraints(CaptureContext captureContext) throws SQLException, PersistenceException {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
        String string = (String)captureContext.getContextVariable("TABLE");
        String string2 = (String)captureContext.getContextVariable("SCHEMA");
        String string3 = this.getFKConstrQuery(captureContext);
        try (CloseableResultSet closeableResultSet = QueryCapture.issueSQL((String)string3, (Connection)this.m_sourceConnection, (CaptureContext)captureContext);){
            ResultSet resultSet = closeableResultSet.getResultSet();
            HashMap<String, MdConstraint> hashMap = new HashMap<String, MdConstraint>();
            PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                String string4 = resultSet.getString("TYPE");
                String string5 = resultSet.getString("CONSTNAME");
                String string6 = resultSet.getString("REFTABSCHEMA");
                DBObjectId dBObjectId2 = persistenceUtility.getIdForSchema((DBObjectId)captureContext.getContextVariable("CATALOGID"), string6);
                String string7 = resultSet.getString("REFTABNAME");
                DBObjectId dBObjectId3 = persistenceUtility.getIdForTable(dBObjectId2, string7);
                string5 = string5 == null ? resultSet.getString("TABNAME") + "_FK" + resultSet.getShort("IDXID") : string5.trim();
                if (string4.trim().equals("R") || string4.trim().equals("FOREIGN KEY")) {
                    String string8;
                    MdConstraint mdConstraint;
                    if (hashMap.get(string5) == null) {
                        mdConstraint = new MdConstraint(dBObjectId, TERADATA_LANGUAGE_ID);
                        mdConstraint.setName(string5);
                        mdConstraint.setConstraintType("FOREIGN KEY");
                        String string9 = resultSet.getString("REMARKS");
                        mdConstraint.setComments(string9);
                        mdConstraint.setReftableId(dBObjectId3);
                        string8 = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
                        captureContext.getAudience().fireListeners((CaptureEvent)string8);
                        mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
                        hashMap.put(string5, mdConstraint);
                        string8.setEventId(4);
                        captureContext.getAudience().fireListeners((CaptureEvent)string8);
                    }
                    if ((mdConstraint = (MdConstraint)hashMap.get(string5)) == null) continue;
                    int n = resultSet.getInt("COLSEQ");
                    string8 = resultSet.getString("COLNAME");
                    CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), string8);
                    captureContext.getAudience().fireListeners(captureEvent);
                    MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n));
                    mdConstraintDetail.setColumnId(persistenceUtility.getIdForColumn(mdConstraint.getTableId(), string8));
                    mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                    captureEvent.setEventId(4);
                    captureContext.getAudience().fireListeners(captureEvent);
                    String string10 = resultSet.getString("REFCOLNAME");
                    captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), string10);
                    captureContext.getAudience().fireListeners(captureEvent);
                    mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n + 1));
                    mdConstraintDetail.setRefFlag("Y");
                    if (dBObjectId3 != null && string10 != null) {
                        DBObjectId dBObjectId4 = persistenceUtility.getIdForColumn(dBObjectId3, string10);
                        mdConstraintDetail.setColumnId(dBObjectId4);
                    }
                    mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                    captureEvent.setEventId(4);
                    captureContext.getAudience().fireListeners(captureEvent);
                    continue;
                }
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "Could not capture Constraint:" + string5 + " Unknown Type:" + string4);
            }
        }
    }

    protected String getFKConstrQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString(GET_FK_CONSTRAINTS_QUERY);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureCheckConstraints(CaptureContext captureContext) throws SQLException, PersistenceException {
        ResultSet resultSet;
        String string = this.getCheckConstrQuery(captureContext);
        HashMap<String, MdConstraint> hashMap = new HashMap<String, MdConstraint>();
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        int n = 0;
        try (CloseableResultSet closeableResultSet = QueryCapture.issueSQL((String)string.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);){
            resultSet = closeableResultSet.getResultSet();
            n = this.captureCheckConstraintsRS(captureContext, resultSet, n, hashMap, hashMap2);
        }
        string = this.getColCheckConstrQuery(captureContext);
        closeableResultSet = QueryCapture.issueSQL((String)string.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
        try {
            resultSet = closeableResultSet.getResultSet();
            n = this.captureCheckConstraintsRS(captureContext, resultSet, n, hashMap, hashMap2);
        }
        finally {
            closeableResultSet.close();
        }
    }

    private int captureCheckConstraintsRS(CaptureContext captureContext, ResultSet resultSet, int n, Map<String, MdConstraint> map, Map<String, Integer> map2) throws SQLException, PersistenceException {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
        DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        String string = (String)captureContext.getContextVariable("TABLE");
        while (resultSet.next() && !captureContext.shouldCancel()) {
            Integer n2;
            String string2 = null;
            String string3 = resultSet.getString("CONSTRAINT_NAME");
            String string4 = resultSet.getString("SEARCH_CONDITION");
            String string5 = "";
            if (string3 == null) {
                n2 = map2.get(string4);
                if (n2 == null) {
                    n2 = ++n;
                    map2.put(string4, n2);
                }
                string3 = string + "_C" + n2;
            } else {
                string3 = string3.trim();
            }
            string2 = "CHECK";
            n2 = new MdConstraint(dBObjectId, TERADATA_LANGUAGE_ID);
            n2.setName(string3);
            n2.setConstraintType(string2);
            n2.setComments(string5);
            n2.addProperty(new AdditionalProperty("TERADATA_CHECKCONSTRAINT", "needconverting"), dBObjectId2);
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), n2.getName());
            captureContext.getAudience().fireListeners(captureEvent);
            n2 = (MdConstraint)this.getStorer().storeObject((PersistableObject)n2);
            map.put(string3, (MdConstraint)n2);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
            MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(n2.getKey(), Integer.valueOf(1));
            if (string4.indexOf(40) >= 0 && string4.lastIndexOf(41) >= 0) {
                string4 = string4.substring(string4.indexOf(40) + 1);
                string4 = string4.substring(0, string4.lastIndexOf(41));
            }
            mdConstraintDetail.setConstraintText(string4);
            mdConstraintDetail.setColumnId(null);
            captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), string3);
            captureContext.getAudience().fireListeners(captureEvent);
            mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
        }
        return n;
    }

    protected String getCheckConstrQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString(GET_CK_CONSTRAINTS_QUERY);
        return string;
    }

    protected String getColCheckConstrQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString(GET_COL_CK_CONSTRAINTS_QUERY);
        return string;
    }

    private void captureConstraints(CaptureContext captureContext) throws SQLException, PersistenceException {
        this.capturePrimaryKeyConstraints(captureContext);
        this.captureForeignKeyConstraints(captureContext);
        this.captureCheckConstraints(captureContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureTriggers(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        try (CloseableResultSet closeableResultSet = null;){
            Object object;
            Serializable serializable;
            StringBuffer stringBuffer = this.getTriggerQuery(captureContext);
            if (migrationObjectFilter != null) {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append(migrationObjectFilter.toWhereClause("TRIGNAME "));
                object = ((StringBuffer)serializable).toString().replaceAll("WHERE", "AND");
                stringBuffer.append((String)object);
            }
            serializable = new HashSet();
            this.processFilter(migrationObjectFilter, stringBuffer, (Set<String>)((Object)serializable), "MD_TRIGGERS", true);
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            object = closeableResultSet.getResultSet();
            while (object.next() && !captureContext.shouldCancel()) {
                String string = object.getString("TRIGNAME");
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !serializable.contains(string.toUpperCase())) continue;
                DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
                MdTrigger mdTrigger = new MdTrigger(dBObjectId, object.getString("TRIGEVENT"), TERADATA_LANGUAGE_ID);
                mdTrigger.setTriggerName(string);
                mdTrigger.setComments(object.getString("REMARKS"));
                mdTrigger.setTriggerEvent(object.getString("TRIGEVENT"));
                mdTrigger.setNativeSql(object.getString("TEXT"));
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_TRIGGERS"), string);
                captureContext.getAudience().fireListeners(captureEvent);
                this.getStorer().storeObject((PersistableObject)mdTrigger);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
    }

    protected StringBuffer getTriggerQuery(CaptureContext captureContext) {
        String string = (String)captureContext.getContextVariable("TABLE");
        if (string == null) {
            string = (String)captureContext.getContextVariable("VIEW");
        }
        if (string == null) {
            string = "";
        }
        captureContext.setContextVariable("TRIGGERSUBJECT", (Object)string);
        String string2 = captureContext.applyToSQLString(GET_TRIGGERS_QUERY);
        captureContext.resetContextVariable("TRIGGERSUBJECT");
        StringBuffer stringBuffer = new StringBuffer(string2);
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureIndexes(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        try (CloseableResultSet closeableResultSet = null;){
            Object object;
            Serializable serializable;
            StringBuffer stringBuffer = this.getIndexQuery(captureContext);
            if (migrationObjectFilter != null) {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append(migrationObjectFilter.toWhereClause("DBC.Indexes.NAME "));
                object = ((StringBuffer)serializable).toString().replaceAll("WHERE", "AND");
                stringBuffer.append((String)object);
            }
            serializable = new HashSet();
            this.processFilter(migrationObjectFilter, stringBuffer, (Set<String>)((Object)serializable), "MD_INDEXES", true);
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            object = closeableResultSet.getResultSet();
            while (object.next() && !captureContext.shouldCancel()) {
                String string = object.getString("INDNAME").trim();
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !serializable.contains(string.toUpperCase())) continue;
                DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
                MdIndexe mdIndexe = new MdIndexe(dBObjectId);
                mdIndexe.setIndexName(string);
                String string2 = object.getString("INDEXTYPE");
                String string3 = object.getString("UNIQUERULE");
                if (string2.equals("K")) {
                    mdIndexe.setIndexType("PRIMARY");
                } else if (string3.equals("Y")) {
                    mdIndexe.setIndexType("UNIQUE");
                } else {
                    mdIndexe.setIndexType("NON_UNIQUE");
                }
                String string4 = object.getString("CREATEUSER");
                if (string4 != null) {
                    mdIndexe.setCreatedBy(string4.trim());
                }
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEXES"), mdIndexe.getIndexName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdIndexe = (MdIndexe)this.getStorer().storeObject((PersistableObject)mdIndexe);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
                this.captureIndexDetails(mdIndexe, captureContext);
            }
        }
    }

    protected StringBuffer getIndexQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString(GET_INDEXES_QUERY);
        return new StringBuffer(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureIndexDetails(MdIndexe mdIndexe, CaptureContext captureContext) throws SQLException, PersistenceException {
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        captureContext.setContextVariable("INDEX", (Object)mdIndexe.getIndexName());
        String string = this.getIndexDetailsQuery(captureContext);
        captureContext.resetContextVariable("INDEX");
        try (CloseableResultSet closeableResultSet = QueryCapture.issueSQL((String)string, (Connection)this.m_sourceConnection, (CaptureContext)captureContext);){
            ResultSet resultSet = closeableResultSet.getResultSet();
            while (resultSet.next()) {
                String string2 = resultSet.getString("COLNAME");
                int n = resultSet.getInt("COLSEQ");
                DBObjectId dBObjectId = persistenceUtility.getIdForColumn(mdIndexe.getTableId(), string2);
                MdIndexDetail mdIndexDetail = new MdIndexDetail(mdIndexe.getKey(), dBObjectId, Integer.valueOf(n));
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEX_DETAILS"), mdIndexe.getIndexName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdIndexDetail = (MdIndexDetail)this.getStorer().storeObject((PersistableObject)mdIndexDetail);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
    }

    protected String getIndexDetailsQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString(GET_INDEX_DETAILS_QUERY);
        return string;
    }

    protected void processFilter(MigrationObjectFilter migrationObjectFilter, StringBuffer stringBuffer, Set<String> set, String string, boolean bl) {
        if (migrationObjectFilter != null && !migrationObjectFilter.getObjectType().equals(string)) {
            throw new IllegalArgumentException("Filter is of incorrect type " + migrationObjectFilter.getObjectType());
        }
        if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
            stringBuffer.append(" ").append(migrationObjectFilter.getWhereClause());
        }
        if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
            for (String string2 : migrationObjectFilter.getObjectNames()) {
                set.add(bl ? string2.toUpperCase() : string2);
            }
        }
    }

    private void captureColumns(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        HashSet<String> hashSet = new HashSet<String>();
        StringBuffer stringBuffer = this.getColumnQuery(captureContext);
        this.processFilter(migrationObjectFilter, stringBuffer, hashSet, "MD_COLUMNS", true);
        this.doCaptureColumns(stringBuffer.toString(), this.m_sourceConnection, this.getStorer(), captureContext, hashSet);
    }

    protected StringBuffer getColumnQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString(GET_COLUMN_QUERY);
        StringBuffer stringBuffer = new StringBuffer(string);
        return stringBuffer;
    }

    public void doCaptureColumns(String string, Connection connection, MigrationStorer migrationStorer, CaptureContext captureContext, Set<String> set) throws PersistenceException, SQLException {
        CloseableResultSet closeableResultSet = QueryCapture.issueSQL((String)string, (Connection)connection, (CaptureContext)captureContext);
        ResultSet resultSet = closeableResultSet.getResultSet();
        int n = 1;
        while (resultSet.next()) {
            if (captureContext.shouldCancel()) {
                closeableResultSet.close();
                CaptureEvent captureEvent = new CaptureEvent(-1, "MD_COLUMNS", "");
                captureContext.getAudience().fireListeners(captureEvent);
                return;
            }
            this.processColumnRow(resultSet, migrationStorer, captureContext, n++);
        }
        closeableResultSet.close();
    }

    protected void processColumnRow(ResultSet resultSet, MigrationStorer migrationStorer, CaptureContext captureContext, int n) throws PersistenceException, SQLException {
        Integer n2;
        Object object;
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
        DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        MdColumn mdColumn = new MdColumn(dBObjectId, resultSet.getString(1), Integer.valueOf(n));
        CaptureAudience captureAudience = captureContext.getAudience();
        String string = resultSet.getString(2);
        mdColumn.setColumnType(string);
        mdColumn.setPrecision(Integer.valueOf(resultSet.getInt(3)));
        mdColumn.setScale(Integer.valueOf(resultSet.getInt(4)));
        String string2 = resultSet.getString(5).trim();
        string2 = string2.toUpperCase().equals("Y") || string2.equals("1") ? "Y" : "N";
        String string3 = resultSet.getString(6);
        mdColumn.setDefaultValue(string3);
        mdColumn.setNullable(string2);
        String string4 = resultSet.getString("COLUMNFORMAT");
        String string5 = resultSet.getString("RAWTYPENAME");
        Integer n3 = resultSet.getInt("MAXLENGTH");
        Integer n4 = resultSet.getInt("DecimalTotalDigits");
        Integer n5 = resultSet.getInt("DecimalFractionalDigits");
        Integer n6 = resultSet.getInt("ColumnLength");
        if (string5 != null) {
            object = this.getTypeLenCode(string5, n6, n5, n4);
            if (object == null || (Integer)object == 0) {
                n2 = mdColumn.getPrecision();
                object = n2;
            }
            if ((Integer)object > 64000) {
                // empty if block
            }
            mdColumn.addProperty(new AdditionalProperty("TERADATA_DUMPLENDECODE", ((Integer)object).toString()), dBObjectId2);
        }
        if (string3 != null) {
            if (string.equals("ANSITIME") || string.equals("ANSITIMEWITHTIMEZONE")) {
                mdColumn.addProperty(new AdditionalProperty("TERADATA_CHECK_TIME_DEFAULT", string3), dBObjectId2);
            }
            if (string.equals("TIMESTAMPWITHTIMEZONE") || string.equals("TIMESTAMPWITHOUTTIMEZONE")) {
                mdColumn.addProperty(new AdditionalProperty("TERADATA_CHECK_TIMESTAMP_DEFAULT", string3), dBObjectId2);
            }
            if (string.equals("DATE")) {
                mdColumn.addProperty(new AdditionalProperty("TERADATA_CHECK_DATE_DEFAULT", string3), dBObjectId2);
            }
        }
        if (string4 != null) {
            mdColumn.addProperty(new AdditionalProperty("TERADATA_COLUMNFORMAT", string4), dBObjectId2);
        }
        if (n3 != null) {
            mdColumn.addProperty(new AdditionalProperty("TERADATA_MAXLENGTH", n3.toString()), dBObjectId2);
        }
        if ((object = resultSet.getString("CHECK")) != null && ((String)object).indexOf(40) >= 0 && ((String)object).lastIndexOf(41) >= 0) {
            object = ((String)object).substring(((String)object).indexOf(40) + 1);
            object = ((String)object).substring(0, ((String)object).lastIndexOf(41));
        }
        n2 = new CaptureEvent(3, "COLUMN", mdColumn.getColumnName());
        captureAudience.fireListeners((CaptureEvent)n2);
        migrationStorer.storeObject((PersistableObject)mdColumn);
        n2.setEventId(4);
        captureAudience.fireListeners((CaptureEvent)n2);
    }

    private void captureCatalog(CaptureContext captureContext) throws PersistenceException {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        MdCatalog mdCatalog = new MdCatalog(dBObjectId);
        mdCatalog.setDummyFlag("Y");
        mdCatalog.setCatalogName("Teradata");
        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CATALOGS"), mdCatalog.getCatalogName());
        captureContext.getAudience().fireListeners(captureEvent);
        this.getStorer().storeObject((PersistableObject)mdCatalog);
        captureEvent.setEventId(4);
        captureContext.getAudience().fireListeners(captureEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureSchemas(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        HashSet<String> hashSet = new HashSet<String>();
        CloseableResultSet closeableResultSet = null;
        StringBuffer stringBuffer = new StringBuffer(this.getSchemaQuery());
        this.processFilter(migrationObjectFilter, stringBuffer, hashSet, "MD_SCHEMAS", true);
        try {
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet.getResultSet();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                String string = resultSet.getString(1);
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string.toUpperCase())) continue;
                QueryCapture.processSchemaRow((ResultSet)resultSet, (MigrationStorer)this.getStorer(), (CaptureContext)captureContext);
            }
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    protected String getSchemaQuery() {
        return GET_SCHEMA_QUERY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureViews(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        try (CloseableResultSet closeableResultSet = null;){
            Object object;
            StringBuffer stringBuffer;
            StringBuffer stringBuffer2 = this.getViewQuery(captureContext);
            if (migrationObjectFilter != null) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(migrationObjectFilter.toWhereClause("VIEWNAME "));
                object = stringBuffer.toString().replaceAll("WHERE", "AND");
                stringBuffer2.append((String)object);
            }
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer2.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            stringBuffer = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
            object = closeableResultSet.getResultSet();
            while (object.next() && !captureContext.shouldCancel()) {
                MdView mdView = new MdView((DBObjectId)stringBuffer, TERADATA_LANGUAGE_ID);
                mdView.setViewName(object.getString("VIEWNAME"));
                mdView.setNativeSql(object.getString("TEXT"));
                mdView.setCreatedBy(object.getString("OWNER"));
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_VIEWS"), mdView.getViewName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdView = (MdView)this.getStorer().storeObject((PersistableObject)mdView);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
    }

    protected StringBuffer getViewQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString(GET_VIEW_QUERY);
        return new StringBuffer(string);
    }

    protected Integer getTypeLenCode(String string, Integer n, Integer n2, Integer n3) {
        Integer n4 = 0;
        String string2 = string.trim();
        try {
            if (string != null) {
                n4 = this.m_typeMap.get(string);
                if (string2.equals("BF")) {
                    n4 = n;
                }
                if (string2.equals("CF")) {
                    n4 = n;
                }
                if (string2.equals("DH")) {
                    n4 = n2 + 10;
                }
                if (string2.equals("DM")) {
                    n4 = n2 + 10;
                }
                if (string2.equals("DS")) {
                    n4 = n3 > 0 ? n2 + 10 : n2 + n3 + 11;
                }
                if (string2.equals("DY")) {
                    n4 = n2 + 10;
                }
                if (string2.equals("HM")) {
                    switch (n2) {
                        case 4: {
                            n4 = 13;
                            break;
                        }
                        case 3: {
                            n4 = 12;
                            break;
                        }
                        default: {
                            n4 = 11;
                        }
                    }
                }
                if (string2.equals("HR")) {
                    switch (n2) {
                        case 4: {
                            n4 = 13;
                            break;
                        }
                        case 3: {
                            n4 = 12;
                            break;
                        }
                        default: {
                            n4 = 11;
                        }
                    }
                }
                if (string2.equals("HS")) {
                    switch (n2) {
                        case 4: {
                            n4 = n3 > 0 ? 14 : 13;
                            break;
                        }
                        case 3: {
                            n4 = n3 > 0 ? 13 : 12;
                            break;
                        }
                        default: {
                            n4 = n3 > 0 ? 12 : 11;
                        }
                    }
                }
                if (string2.equals("MO")) {
                    switch (n2) {
                        case 4: {
                            n4 = 7;
                            break;
                        }
                        case 3: {
                            n4 = 6;
                            break;
                        }
                        default: {
                            n4 = 5;
                        }
                    }
                }
                if (string2.equals("MS")) {
                    n4 = n3 > 0 ? 12 + n3 : 11;
                }
                if (string2.equals("SC")) {
                    n4 = n3 > 0 ? 12 + n3 : 11;
                }
                if (string2.equals("YM")) {
                    n4 = n2 + 4;
                }
                if (string2.equals("YR")) {
                    n4 = n2 + 4;
                }
            }
        }
        catch (Exception exception) {
            n4 = 0;
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureTables(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        HashSet<String> hashSet = new HashSet<String>();
        CloseableResultSet closeableResultSet = null;
        StringBuffer stringBuffer = new StringBuffer(this.getTableQuery(captureContext));
        this.processFilter(migrationObjectFilter, stringBuffer, hashSet, "MD_TABLES", true);
        try {
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet.getResultSet();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                String string;
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains((string = resultSet.getString(1)).toUpperCase())) continue;
                QueryCapture.processTableRow((ResultSet)resultSet, (MigrationStorer)this.getStorer(), (CaptureContext)captureContext);
            }
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    protected String getTableQuery(CaptureContext captureContext) {
        return captureContext.applyToSQLString(GET_TABLE_QUERY);
    }
}

