/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.teradata;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdPartition;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.AbstractOfflineCapturer;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.teradata.offline.Messages;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;

public class Teradata12OfflineCapturer
extends AbstractOfflineCapturer {
    private String m_directory;
    private MdSchema m_ctxSchema;
    private DBObjectId m_ctxSchemaId;
    private DBObjectId m_ctxConnectionId;
    private MdCatalog m_ctxCatalog;
    private MdCatalog dummyCatalog = null;
    private Properties m_props;
    private Map<String, File> m_schemaTablesFileMap = null;
    private Map<String, File> m_schemaViewsFileMap = null;
    private Map<String, File> m_schemaPKeysFileMap = null;
    private Map<String, File> m_schemaProcsFileMap = null;
    private Map<String, MdSchema> m_schemas = new Hashtable<String, MdSchema>();
    private ArrayList<String> m_dblist = null;
    private String m_dbName = null;
    protected Map<String, String> typeMap = new Hashtable<String, String>(){
        {
            this.put("AT", "ANSITIME");
            this.put("BF", "BYTEFIXED");
            this.put("BO", "BYTELARGEOBJECT");
            this.put("BS", "BINARYSTRING");
            this.put("BV", "BYTEVARYING");
            this.put("CF", "CHARFIXED");
            this.put("CO", "CHARLARGEOBJECT");
            this.put("CS", "CHARSTRING");
            this.put("CV", "CHARVARYING");
            this.put("D", "DECIMAL");
            this.put("DA", "DATE");
            this.put("DH", "DAYHOUR");
            this.put("DI", "DAYINTERVAL");
            this.put("DM", "DAYMINUTE");
            this.put("DS", "DAYSECOND");
            this.put("DT", "DATETAG");
            this.put("DY", "DAY");
            this.put("F", "REAL");
            this.put("HM", "HOURMINUTE");
            this.put("HR", "HOUR");
            this.put("HS", "HOURSECOND");
            this.put("I", "INTEGER");
            this.put("I1", "BYTEINT");
            this.put("I2", "SMALLINT");
            this.put("I8", "BIGINTEGER");
            this.put("LF", "CHARFIXEDLOCALE");
            this.put("LV", "CHARVARYINGLOCALE");
            this.put("MI", "MINUTE");
            this.put("MO", "MONTH");
            this.put("MS", "MINUTETOSECOND");
            this.put("NM", "NUMBERTAG");
            this.put("SC", "SECOND");
            this.put("SZ", "TIMESTAMPWITHTIMEZONE");
            this.put("TM", "TIMETAG");
            this.put("TS", "TIMESTAMPWITHOUTTIMEZONE");
            this.put("TZ", "ANSITIMEWITHTIMEZONE");
            this.put("UF", "CHARFIXEDUNICODE");
            this.put("UT", "USERDEFINEDTYPE");
            this.put("UV", "CHARVARYINGUNICODE");
            this.put("YI", "YEARINTERVAL");
            this.put("YM", "YEARMONTH");
            this.put("YR", "YEAR");
        }
    };
    protected Map<String, Integer> m_typeLenCodeMap = new Hashtable<String, Integer>(){
        {
            this.put("AT", 26);
            this.put("BF", 0);
            this.put("BO", -8);
            this.put("BS", 0);
            this.put("BV", -2);
            this.put("CF", 0);
            this.put("CO", -8);
            this.put("CS", 0);
            this.put("CV", 0);
            this.put("D ", 4);
            this.put("D", 4);
            this.put("DA", 10);
            this.put("DH", 0);
            this.put("DI", 0);
            this.put("DM", 0);
            this.put("DS", 0);
            this.put("DT", 0);
            this.put("DY", 0);
            this.put("F ", 0);
            this.put("F", 0);
            this.put("HM", 0);
            this.put("HR", 0);
            this.put("HS", 0);
            this.put("I ", 4);
            this.put("I", 4);
            this.put("I1", 1);
            this.put("I2", 2);
            this.put("I8", 8);
            this.put("LF", 0);
            this.put("LV", 0);
            this.put("MI", 11);
            this.put("MO", 0);
            this.put("MS", 0);
            this.put("NM", 0);
            this.put("SC", 0);
            this.put("SZ", 31);
            this.put("TM", 0);
            this.put("TS", 26);
            this.put("TZ", 21);
            this.put("UF", 0);
            this.put("UT", 0);
            this.put("UV", 0);
            this.put("YI", 0);
            this.put("YM", 0);
            this.put("YR", 0);
        }
    };
    Map<String, Map<String, List<Map<String, String>>>> m_tablePKeys = new TreeMap<String, Map<String, List<Map<String, String>>>>();
    PrintWriter pw = null;
    Object pwLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, File> splitFiles(String string, String string2, String string3) throws IOException {
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        OutputStreamWriter outputStreamWriter2 = null;
        PrintWriter printWriter = null;
        LineNumberReader lineNumberReader = null;
        Hashtable<String, File> hashtable = new Hashtable<String, File>();
        try {
            hashtable.clear();
            lineNumberReader = this.getLineReader(string);
            if (lineNumberReader == null) {
                Hashtable<String, File> hashtable2 = hashtable;
                return hashtable2;
            }
            BTEQExportReader bTEQExportReader = new BTEQExportReader(lineNumberReader);
            String string4 = "";
            while (bTEQExportReader.next()) {
                String string5 = bTEQExportReader.get(string2);
                if (string5 == null) continue;
                if (!string5.equals(string4)) {
                    File file;
                    if (printWriter != null) {
                        printWriter.close();
                        printWriter = null;
                    }
                    if (outputStreamWriter2 != null) {
                        outputStreamWriter2.close();
                        outputStreamWriter2 = null;
                    }
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                        outputStreamWriter = null;
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                        fileOutputStream = null;
                    }
                    if ((file = (File)hashtable.get(string5)) == null) {
                        file = File.createTempFile(string3, ".txt");
                        hashtable.put(string5, file);
                        fileOutputStream = new FileOutputStream(file);
                        outputStreamWriter2 = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
                        printWriter = new PrintWriter(outputStreamWriter2);
                        printWriter.println(bTEQExportReader.getHeaderLine());
                    } else {
                        fileOutputStream = new FileOutputStream(file, true);
                        outputStreamWriter2 = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
                        printWriter = new PrintWriter(outputStreamWriter2);
                    }
                    string4 = string5;
                }
                printWriter.println(bTEQExportReader.getLine());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (outputStreamWriter2 != null) {
                outputStreamWriter2.close();
            }
            if (outputStreamWriter != null) {
                outputStreamWriter.close();
                outputStreamWriter = null;
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (lineNumberReader != null) {
                lineNumberReader.close();
            }
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String captureInitializeImpl(String string, Properties properties) throws OfflineCaptureException {
        this.m_directory = string;
        this.m_props = properties;
        try {
            this.m_schemaTablesFileMap = this.splitFiles("TABLES_FILE", "DBNAME", "tables_");
            this.m_schemaViewsFileMap = this.splitFiles("VIEWDEFN_FILE", "DBNAME", "views_");
            this.m_schemaPKeysFileMap = this.splitFiles("PKEY_FILE", "DBNAME", "pkeys_");
            this.m_schemaProcsFileMap = this.splitFiles("PROCS_FILE", "DBNAME", "procs_");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try (LineNumberReader lineNumberReader = null;){
            Map<String, List<Map<String, String>>> map;
            String string22;
            Iterator<Object> iterator;
            Object object;
            lineNumberReader = this.getLineReader("PKEY_FILE");
            if (lineNumberReader == null) {
                throw new NullPointerException("Unable to open primary key file");
            }
            BTEQExportReader bTEQExportReader = new BTEQExportReader(lineNumberReader);
            while (bTEQExportReader.next()) {
                object = bTEQExportReader.get("DBNAME");
                iterator = bTEQExportReader.get("TABNAME");
                string22 = bTEQExportReader.get("CONSTNAME");
                map = bTEQExportReader.get("TYPE");
                String string3 = bTEQExportReader.get("UNIQUEFLAG");
                if (object == null || iterator == null || string22 == null) continue;
                Map<String, List<Map<String, String>>> map2 = this.m_tablePKeys.get((String)object + "." + iterator);
                if (map2 == null) {
                    map2 = new TreeMap<String, List<Map<String, String>>>();
                    this.m_tablePKeys.put((String)object + "." + iterator, map2);
                }
                if (!((String)((Object)map)).equals("K") && !((String)((Object)map)).equals("U") && (!((String)((Object)map)).equals("Q") && !((String)((Object)map)).equals("P") || string3 == null || !string3.equals("Y"))) continue;
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                for (String string4 : bTEQExportReader.getColumnNames()) {
                    treeMap.put(string4, bTEQExportReader.get(string4));
                }
                Object object2 = map2.get(string22);
                if (object2 == null) {
                    object2 = new ArrayList();
                    map2.put(string22, (List<Map<String, String>>)object2);
                }
                object2.add(treeMap);
            }
            object = new Vector();
            for (String string22 : this.m_tablePKeys.keySet()) {
                map = this.m_tablePKeys.get(string22);
                if (map.size() != 0) continue;
                object.add(string22);
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                string22 = (String)iterator.next();
                this.m_tablePKeys.remove(string22);
            }
            this.m_dblist = this.getSelectedDatabaseList();
            for (String string22 : this.m_dblist) {
                this.addDatabaseToCapture(string22);
            }
        }
        catch (IOException iOException) {
            throw new OfflineCaptureException((Exception)iOException);
        }
        return "TeradataOffline";
    }

    public void captureStarting() {
        this.m_dbName = this.getNextDatabase();
        this.getPwPrintln("captureStarting: " + this.m_dbName);
        this.getPwFlush();
    }

    public String getModelName() throws CaptureException {
        return "Teradata";
    }

    public String getSourceURL() throws CaptureException {
        return "/tmp/Teradata12";
    }

    public boolean equals(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrintWriter getPw() {
        Object object = this.pwLock;
        synchronized (object) {
            if (this.pw == null) {
                try {
                    File file = new File("c:\\m\\out1.txt");
                    int n = 2;
                    while (file.exists()) {
                        file = new File("c:\\m\\out" + n++ + ".txt");
                    }
                    FileWriter fileWriter = new FileWriter(file);
                    this.pw = new PrintWriter(fileWriter);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return this.pw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        try {
            if ("MD_CATALOGS".equals(string)) {
                this.getContextValues(captureContext);
                System.out.println("CaptureObjects: " + string + " m_dbName " + this.m_dbName + " (" + (this.m_ctxSchema == null ? "-" : this.m_ctxSchema.getName()) + ") [" + Thread.currentThread().getName() + " " + Thread.currentThread().getId() + "]");
                this.getPwPrintln("CaptureObjects: " + string + " m_dbName " + this.m_dbName + " (" + (this.m_ctxSchema == null ? "-" : this.m_ctxSchema.getName()) + ") [" + Thread.currentThread().getName() + " " + Thread.currentThread().getId() + "]");
                this.getPwFlush();
                this.captureDummyCatalog(captureContext);
                return;
            }
            if ("MD_SCHEMAS".equals(string)) {
                this.getContextValues(captureContext);
                System.out.println("CaptureObjects: " + string + " m_dbName " + this.m_dbName + " (" + (this.m_ctxSchema == null ? "-" : this.m_ctxSchema.getName()) + ") [" + Thread.currentThread().getName() + " " + Thread.currentThread().getId() + "]");
                this.getPwPrintln("CaptureObjects: " + string + " m_dbName " + this.m_dbName + " (" + (this.m_ctxSchema == null ? "-" : this.m_ctxSchema.getName()) + ") [" + Thread.currentThread().getName() + " " + Thread.currentThread().getId() + "]");
                this.getPwFlush();
                this.captureSchemas(captureContext);
                return;
            }
            if ("MD_TABLES".equals(string)) {
                this.getContextValues(captureContext);
                System.out.println("CaptureObjects: " + string + " m_dbName " + this.m_dbName + " (" + (this.m_ctxSchema == null ? "-" : this.m_ctxSchema.getName()) + ") [" + Thread.currentThread().getName() + " " + Thread.currentThread().getId() + "]");
                this.getPwPrintln("CaptureObjects: " + string + " m_dbName " + this.m_dbName + " (" + (this.m_ctxSchema == null ? "-" : this.m_ctxSchema.getName()) + ") [" + Thread.currentThread().getName() + " " + Thread.currentThread().getId() + "]");
                this.getPwFlush();
                String string2 = this.m_ctxSchema.getName();
                if (this.m_dbName == null) return;
                if (string2 == null) return;
                if (!this.m_dbName.equals(string2)) return;
                this.captureTables(captureContext);
                CloseableIterator closeableIterator = this.getStorer().getPersistenceUtility().getTablesForSchemaId(this.m_ctxSchemaId);
                HashMap<String, DBObjectId> hashMap = new HashMap<String, DBObjectId>();
                while (true) {
                    if (!closeableIterator.hasNext()) {
                        closeableIterator.close();
                        if (hashMap.size() <= 0) return;
                        this.captureIndexes(captureContext, hashMap);
                        this.captureConstraints(captureContext, hashMap);
                        this.captureTriggers(captureContext, hashMap);
                        this.capturePartitions(captureContext, hashMap);
                        return;
                    }
                    MdTable mdTable = (MdTable)closeableIterator.next();
                    String string3 = mdTable.getTableName();
                    hashMap.put(string3, mdTable.getKey());
                }
            }
            if ("MD_VIEWS".equals(string)) {
                this.getContextValues(captureContext);
                System.out.println("CaptureObjects: " + string + " m_dbName " + this.m_dbName + " (" + (this.m_ctxSchema == null ? "-" : this.m_ctxSchema.getName()) + ") [" + Thread.currentThread().getName() + " " + Thread.currentThread().getId() + "]");
                this.getPwPrintln("CaptureObjects: " + string + " m_dbName " + this.m_dbName + " (" + (this.m_ctxSchema == null ? "-" : this.m_ctxSchema.getName()) + ") [" + Thread.currentThread().getName() + " " + Thread.currentThread().getId() + "]");
                this.getPwFlush();
                this.captureViews(captureContext);
                return;
            }
            if (string.equals("MD_INDEXES")) {
                return;
            }
            if (string.equals("MD_TRIGGERS")) {
                return;
            }
            if (string.equals("MD_STORED_PROGRAMS")) {
                this.getContextValues(captureContext);
                System.out.println("CaptureObjects: " + string + " m_dbName " + this.m_dbName + " (" + (this.m_ctxSchema == null ? "-" : this.m_ctxSchema.getName()) + ") [" + Thread.currentThread().getName() + " " + Thread.currentThread().getId() + "]");
                this.getPwPrintln("CaptureObjects: " + string + " m_dbName " + this.m_dbName + " (" + (this.m_ctxSchema == null ? "-" : this.m_ctxSchema.getName()) + ") [" + Thread.currentThread().getName() + " " + Thread.currentThread().getId() + "]");
                this.getPwFlush();
                this.captureStoredPrograms(captureContext);
                return;
            }
            if (!string.equals("MD_CONSTRAINTS")) return;
            return;
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return;
        }
    }

    private void getContextValues(CaptureContext captureContext) throws PersistenceException {
        this.m_ctxSchemaId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
        this.m_ctxConnectionId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        this.m_ctxCatalog = (MdCatalog)captureContext.getContextVariable("CATALOG");
        this.m_ctxSchema = null;
        if (this.m_ctxSchemaId != null) {
            try {
                this.m_ctxSchema = MdSchema.retrieveExistingInstance((PersistenceManager)MigrationAddin.getPersistenceManager(), (DBObjectId)this.m_ctxSchemaId);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, noSuchObjectException.getStackTrace()[0].toString(), noSuchObjectException);
            }
        }
    }

    private boolean captureDummyCatalog(CaptureContext captureContext) throws PersistenceException {
        if (this.dummyCatalog == null) {
            this.dummyCatalog = new MdCatalog(this.m_ctxConnectionId);
            this.dummyCatalog.setDummyFlag("Y");
            this.dummyCatalog.setCatalogName("Teradata");
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CATALOGS"), "");
            captureContext.getAudience().fireListeners(captureEvent);
            this.dummyCatalog = (MdCatalog)this.getStorer().storeObject((PersistableObject)this.dummyCatalog);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureSchemas(CaptureContext captureContext) throws PersistenceException, IOException {
        try (BufferedReader bufferedReader = null;){
            String string = this.m_dbName;
            if (string != null) {
                this.captureSchema(captureContext, string);
            }
        }
    }

    private void captureSchema(CaptureContext captureContext, String string) throws PersistenceException {
        String string2 = string.trim();
        if (this.m_dbName.equals(string2)) {
            MdSchema mdSchema = new MdSchema(this.m_ctxCatalog.getKey());
            mdSchema.setName(string2);
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_SCHEMAS"), mdSchema.getName());
            captureContext.getAudience().fireListeners(captureEvent);
            mdSchema = (MdSchema)this.getStorer().storeObject((PersistableObject)mdSchema);
            this.m_schemas.put(string2, mdSchema);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
            captureContext.setContextVariable("SCHEMAID", (Object)mdSchema.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureTables(CaptureContext captureContext) throws PersistenceException, IOException {
        BufferedReader bufferedReader = null;
        File file = null;
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        try {
            String string = this.m_ctxSchema.getName();
            file = this.m_schemaTablesFileMap.get(string);
            if (file == null || !file.exists() || !file.isFile()) {
                return;
            }
            bufferedReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            BTEQExportReader bTEQExportReader = new BTEQExportReader((LineNumberReader)bufferedReader);
            String string2 = "";
            String string3 = "";
            String string4 = "";
            MdTable mdTable = null;
            int n = 1;
            while (bTEQExportReader.next()) {
                Object object;
                CaptureEvent captureEvent;
                String string5 = bTEQExportReader.get("DBNAME");
                String string6 = bTEQExportReader.get("TABNAME");
                if (!string5.equals(string) || string5 == null || string6 == null) continue;
                if (!string5.equals(string2) || !string6.equals(string3)) {
                    string2 = string5;
                    string3 = string6;
                    n = 0;
                    boolean bl = this.m_ctxCatalog.getDummyFlag() == null ? false : this.m_ctxCatalog.getDummyFlag().equals("Y");
                    String string7 = string4 = bl ? "" : this.m_ctxCatalog.getCatalogName() + ".";
                    if (this.m_ctxSchema != null) {
                        string4 = string4 + this.m_ctxSchema.getName() + ".";
                    }
                    mdTable = new MdTable(this.m_ctxSchemaId, string6, string4 + string6);
                    mdTable.setCreatedBy(string5);
                    captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_TABLES"), mdTable.getTableName());
                    captureContext.getAudience().fireListeners(captureEvent);
                    mdTable = (MdTable)this.getStorer().storeObject((PersistableObject)mdTable);
                    captureEvent.setEventId(4);
                    captureContext.getAudience().fireListeners(captureEvent);
                }
                String string8 = this.mapTeradataType(bTEQExportReader.get("TYPENAME"), bTEQExportReader.get("CHARTYPE"), bTEQExportReader.get("COLUMNUDTNAME"));
                String string9 = bTEQExportReader.get("LENGTH");
                String string10 = bTEQExportReader.get("SCALE");
                String string11 = bTEQExportReader.get("NULLS");
                String string12 = bTEQExportReader.get("DEFAULTVAL");
                Integer n2 = null;
                ++n;
                if (string8 != null && (string8.equals("BF") || string8.equals("BO") || string8.equals("BS") || string8.equals("BV"))) {
                    string12 = null;
                }
                MdColumn mdColumn = new MdColumn(mdTable.getKey(), bTEQExportReader.get("COLNAME"), Integer.valueOf(n));
                if (string8 != null) {
                    if (string8.equals("PERIODDATE")) {
                        mdColumn.addProperty(new AdditionalProperty("TERADATA_PERIODDATE_COLUMN", "needconverting"), dBObjectId);
                        string9 = Integer.toString(28);
                        string10 = Integer.toString(0);
                    } else if (string8.equals("PERIODTIMESTAMPWITHTIMEZONE")) {
                        mdColumn.addProperty(new AdditionalProperty("TERADATA_PERIODTIMESTAMPWITHTIMEZONE_COLUMN", "needconverting"), dBObjectId);
                        string9 = Integer.toString(72);
                        string10 = Integer.toString(0);
                    } else if (string8.equals("PERIODTIMESTAMP")) {
                        mdColumn.addProperty(new AdditionalProperty("TERADATA_PERIODTIMESTAMP_COLUMN", "needconverting"), dBObjectId);
                        string9 = Integer.toString(60);
                        string10 = Integer.toString(0);
                    } else if (string8.equals("PERIODTIME")) {
                        mdColumn.addProperty(new AdditionalProperty("TERADATA_PERIODTIME_COLUMN", "needconverting"), dBObjectId);
                        string9 = Integer.toString(38);
                        string10 = Integer.toString(0);
                    } else if (string8.equals("PERIODTIMEWITHTIMEZONE")) {
                        mdColumn.addProperty(new AdditionalProperty("TERADATA_PERIODTIMEWITHTIMEZONE_COLUMN", "needconverting"), dBObjectId);
                        string9 = Integer.toString(50);
                        string10 = Integer.toString(0);
                    } else if (string8.equals("USERDEFINEDTYPE") && (object = bTEQExportReader.get("COLUMNUDTNAME")) != null) {
                        if (((String)object).equals("ST_GEOMETRY")) {
                            mdColumn.addProperty(new AdditionalProperty("TERADATA_ST_GEOMETRY_COLUMN", "needconverting"), dBObjectId);
                            string8 = "ST_GEOMETRY";
                            n2 = -2;
                        } else if (((String)object).equals("MBR")) {
                            mdColumn.addProperty(new AdditionalProperty("TERADATA_MBR_COLUMN", "needconverting"), dBObjectId);
                            string8 = "MBR";
                            n2 = -2;
                        }
                    }
                }
                object = captureContext.getAudience();
                mdColumn.setColumnType(string8);
                string11 = string11.toUpperCase().equals("Y") || string11.equals("1") ? "Y" : "N";
                mdColumn.setDefaultValue(string12);
                mdColumn.setNullable(string11);
                if (string9 != null && !string9.equals("null")) {
                    mdColumn.setPrecision(Integer.valueOf(string9));
                }
                if (string10 != null && !string10.equals("null")) {
                    mdColumn.setScale(Integer.valueOf(string10));
                }
                if (string11 != null && !string11.equals("null")) {
                    mdColumn.setNullable(string11);
                }
                if (string12 != null && !string12.equals("null")) {
                    mdColumn.setDefaultValue(string12);
                }
                if (string12 != null) {
                    if (string8.equals("ANSITIME") || string8.equals("ANSITIMEWITHTIMEZONE")) {
                        mdColumn.addProperty(new AdditionalProperty("TERADATA_CHECK_TIME_DEFAULT", string12), dBObjectId);
                    }
                    if (string8.equals("TIMESTAMPWITHTIMEZONE") || string8.equals("TIMESTAMPWITHOUTTIMEZONE")) {
                        mdColumn.addProperty(new AdditionalProperty("TERADATA_CHECK_TIMESTAMP_DEFAULT", string12), dBObjectId);
                    }
                    if (string8.equals("DATE")) {
                        mdColumn.addProperty(new AdditionalProperty("TERADATA_CHECK_DATE_DEFAULT", string12), dBObjectId);
                    }
                }
                String string13 = bTEQExportReader.get("TYPENAME");
                Integer n3 = bTEQExportReader.getInt("LENGTH");
                Integer n4 = bTEQExportReader.getInteger("DTOTDIGITS");
                Integer n5 = bTEQExportReader.getInteger("DFRACDIGITS");
                if (string13 != null) {
                    if (n2 == null) {
                        n2 = this.getTypeLenCode(string13, n3, n4, n5);
                        if (n2 == null || n2 == 0) {
                            Integer n6;
                            n2 = n6 = mdColumn.getPrecision();
                        }
                        if (n2 > 64000) {
                            System.out.println("> 64000");
                        }
                    }
                    mdColumn.addProperty(new AdditionalProperty("TERADATA_DUMPLENDECODE", n2.toString()), dBObjectId);
                }
                if (n3 != null) {
                    mdColumn.addProperty(new AdditionalProperty("TERADATA_MAXLENGTH", n3.toString()), dBObjectId);
                }
                captureEvent = new CaptureEvent(3, "COLUMN", mdColumn.getColumnName());
                object.fireListeners(captureEvent);
                this.getStorer().storeObject((PersistableObject)mdColumn);
                captureEvent.setEventId(4);
                object.fireListeners(captureEvent);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (file != null && file.exists()) {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureIndexes(CaptureContext captureContext, Map<String, DBObjectId> map) throws PersistenceException, IOException {
        BTEQExportReader bTEQExportReader;
        MdIndexe mdIndexe;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        Object object;
        Object object2;
        CloseableIterator closeableIterator = this.getStorer().getPersistenceUtility().getTablesForSchemaId(this.m_ctxSchemaId);
        HashMap<String, MdIndexe> hashMap = new HashMap<String, MdIndexe>();
        while (closeableIterator.hasNext()) {
            object2 = (MdTable)closeableIterator.next();
            object = object2.getTableName();
            map.put((String)object, object2.getKey());
        }
        closeableIterator.close();
        object2 = null;
        try {
            object2 = this.getLineReader("INDEXES_FILE");
            object = new BTEQExportReader((LineNumberReader)object2);
            while (((BTEQExportReader)object).next()) {
                string6 = ((BTEQExportReader)object).get("DBNAME");
                string5 = ((BTEQExportReader)object).get("TABNAME");
                if (!string6.equals(this.m_ctxSchema.getName()) || string6 == null || string5 == null) continue;
                string4 = ((BTEQExportReader)object).get("INDNAME");
                string3 = ((BTEQExportReader)object).get("INDEXTYPE");
                string2 = ((BTEQExportReader)object).get("UNIQUERULE");
                string = ((BTEQExportReader)object).get("CREATEUSER");
                DBObjectId dBObjectId = map.get(string5);
                if (dBObjectId == null) {
                    Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, Messages.getString("Teradata12OfflineCapturer.11", new String[]{string4}));
                    return;
                }
                mdIndexe = new MdIndexe(dBObjectId);
                mdIndexe.setIndexName(string4);
                mdIndexe.setCreatedBy(string);
                mdIndexe.setIndexType(string2);
                mdIndexe.addProperty(new AdditionalProperty("INDEX_TYPE", string3), this.m_ctxConnectionId);
                bTEQExportReader = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEXES"), mdIndexe.getIndexName());
                captureContext.getAudience().fireListeners((CaptureEvent)bTEQExportReader);
                mdIndexe = (MdIndexe)this.getStorer().storeObject((PersistableObject)mdIndexe);
                hashMap.put(string6 + "." + string5 + "." + string4, mdIndexe);
                bTEQExportReader.setEventId(4);
                captureContext.getAudience().fireListeners((CaptureEvent)bTEQExportReader);
            }
        }
        finally {
            if (object2 != null) {
                ((BufferedReader)object2).close();
                object2 = null;
            }
        }
        try {
            object = this.getStorer().getPersistenceUtility();
            object2 = this.getLineReader("INDEXDETAILS_FILE");
            bTEQExportReader = new BTEQExportReader((LineNumberReader)object2);
            while (bTEQExportReader.next()) {
                string5 = bTEQExportReader.get("DBNAME");
                string4 = bTEQExportReader.get("TABNAME");
                if (!string5.equals(this.m_ctxSchema.getName()) || string5 == null || string4 == null) continue;
                string3 = bTEQExportReader.get("INDNAME");
                string2 = (MdIndexe)hashMap.get(string5 + "." + string4 + "." + string3);
                if (string2 == null) continue;
                string = bTEQExportReader.get("COLNAME");
                int n = bTEQExportReader.getInt("COLSEQ");
                mdIndexe = object.getIdForColumn(string2.getTableId(), string);
                MdIndexDetail mdIndexDetail = new MdIndexDetail(string2.getKey(), (DBObjectId)mdIndexe, Integer.valueOf(n));
                string6 = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEX_DETAILS"), string2.getIndexName());
                captureContext.getAudience().fireListeners((CaptureEvent)string6);
                mdIndexDetail = (MdIndexDetail)this.getStorer().storeObject((PersistableObject)mdIndexDetail);
                string6.setEventId(4);
                captureContext.getAudience().fireListeners((CaptureEvent)string6);
            }
        }
        finally {
            if (object2 != null) {
                ((BufferedReader)object2).close();
            }
        }
    }

    private void captureConstraints(CaptureContext captureContext, Map<String, DBObjectId> map) throws PersistenceException, IOException {
        this.capturePrimaryKeyConstraints(captureContext, map);
        this.captureForeignKeyConstraints(captureContext, map);
        this.captureCheckConstraints(captureContext, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void capturePrimaryKeyConstraints(CaptureContext captureContext, Map<String, DBObjectId> map) throws PersistenceException, IOException {
        BufferedReader bufferedReader = null;
        File file = null;
        HashMap<String, DBObjectId> hashMap = new HashMap<String, DBObjectId>();
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        try {
            file = this.m_schemaPKeysFileMap.get(this.m_dbName);
            if (file == null || !file.exists() || !file.isFile()) {
                return;
            }
            bufferedReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            BTEQExportReader bTEQExportReader = new BTEQExportReader((LineNumberReader)bufferedReader);
            while (bTEQExportReader.next()) {
                CaptureEvent captureEvent;
                String string;
                DBObjectId dBObjectId;
                DBObjectId dBObjectId2;
                String string2 = bTEQExportReader.get("TYPE");
                String string3 = null;
                String string4 = bTEQExportReader.get("CONSTNAME");
                String string5 = bTEQExportReader.get("DBNAME");
                String string6 = bTEQExportReader.get("TABNAME");
                String string7 = bTEQExportReader.get("UNIQUEFLAG");
                if (string5 == null || !string5.equals(this.m_dbName) || string6 == null || (dBObjectId2 = map.get(string6)) == null) continue;
                if (string2.trim().equals("K")) {
                    string3 = "PK";
                } else if (string2.trim().equals("U") || string2.trim().equals("UNIQUE")) {
                    string3 = "UNIQUE";
                } else {
                    if (!string2.trim().equals("Q") && !string2.trim().equals("P") || string7 == null || !string7.equals("Y")) continue;
                    string3 = "UNIQUE";
                }
                MdConstraint mdConstraint = (MdConstraint)hashMap.get(string4);
                if (mdConstraint != null) {
                    dBObjectId = mdConstraint.getContainerId();
                    if (dBObjectId2.getId() != dBObjectId.getId()) {
                        mdConstraint = null;
                        string4 = string4 + bTEQExportReader.getRecordNo();
                    }
                }
                if (mdConstraint == null && string3 != null) {
                    dBObjectId = new MdConstraint(dBObjectId2, "TERADATALANG");
                    dBObjectId.setName(string4);
                    dBObjectId.setConstraintType(string3);
                    string = bTEQExportReader.get("REMARKS");
                    dBObjectId.setComments(string);
                    captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), dBObjectId.getName());
                    captureContext.getAudience().fireListeners(captureEvent);
                    dBObjectId = (MdConstraint)this.getStorer().storeObject((PersistableObject)dBObjectId);
                    hashMap.put(string4, dBObjectId);
                    captureEvent.setEventId(4);
                    captureContext.getAudience().fireListeners(captureEvent);
                } else if (string3 == null) {
                    Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "Could not capture Constraint:" + string4 + " Unknown Type:" + string2);
                    continue;
                }
                if ((mdConstraint = (MdConstraint)hashMap.get(string4)) == null) continue;
                int n = bTEQExportReader.getInt("COLSEQ");
                string = bTEQExportReader.get("COLNAME");
                captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), string);
                captureContext.getAudience().fireListeners(captureEvent);
                MdConstraintDetail mdConstraintDetail = null;
                try {
                    mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n));
                    mdConstraintDetail.setColumnId(persistenceUtility.getIdForColumn(mdConstraint.getTableId(), string));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject(mdConstraintDetail);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (file != null && file.exists()) {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void capturePartitions(CaptureContext captureContext, Map<String, DBObjectId> map) throws PersistenceException, IOException {
        Object object;
        Object object2;
        CloseableIterator closeableIterator = this.getStorer().getPersistenceUtility().getTablesForSchemaId(this.m_ctxSchemaId);
        HashMap hashMap = new HashMap();
        while (closeableIterator.hasNext()) {
            object2 = (MdTable)closeableIterator.next();
            object = object2.getTableName();
            map.put((String)object, object2.getKey());
        }
        closeableIterator.close();
        object2 = null;
        try {
            object2 = this.getLineReader("INDCONSTR_FILE");
            object = new BTEQExportReader((LineNumberReader)object2);
            while (((BTEQExportReader)object).next()) {
                String string = ((BTEQExportReader)object).get("NAME");
                String string2 = ((BTEQExportReader)object).get("TableName");
                if (!string.equals(this.m_ctxSchema.getName()) || string == null || string2 == null) continue;
                String string3 = ((BTEQExportReader)object).get("IndexName");
                String string4 = ((BTEQExportReader)object).get("ConstraintType");
                String string5 = ((BTEQExportReader)object).get("ConstraintText");
                DBObjectId dBObjectId = map.get(string2);
                if (dBObjectId == null) {
                    Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, Messages.getString("Teradata12OfflineCapturer.11", new String[]{string3}));
                    return;
                }
                MdPartition mdPartition = new MdPartition(dBObjectId);
                mdPartition.setNativeSql(string5);
                mdPartition.setComments(string + "." + string2 + "." + string3);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_PARTITIONS"), mdPartition.getComments());
                captureContext.getAudience().fireListeners(captureEvent);
                mdPartition = (MdPartition)this.getStorer().storeObject((PersistableObject)mdPartition);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
        finally {
            if (object2 != null) {
                ((BufferedReader)object2).close();
                object2 = null;
            }
        }
    }

    private boolean findPKey(Map<String, List<Map<String, String>>> map, List<Map<String, String>> list) {
        Vector<String> vector = new Vector<String>();
        for (Map<String, String> object : list) {
            vector.add(object.get("REFCOLNAME"));
        }
        for (String string : map.keySet()) {
            List<Map<String, String>> list2 = map.get(string);
            if (list.size() != list2.size()) continue;
            Vector vector2 = new Vector(vector);
            for (Map<String, String> map2 : list2) {
                String string2 = map2.get("COLNAME");
                if (!vector2.contains(string2)) continue;
                vector2.remove(string2);
                if (vector2.size() != 0) continue;
                this.updateFKey(list, string, list2);
                return true;
            }
        }
        return false;
    }

    private void updateFKey(List<Map<String, String>> list, String string, List<Map<String, String>> list2) {
        for (Map<String, String> map : list) {
            String string2 = map.get("REFCOLNAME");
            map.put("REFCONSTNAME", string);
            for (Map<String, String> map2 : list2) {
                String string3 = map2.get("COLNAME");
                if (!string3.equals(string2)) continue;
                map.put("COLSEQ", map2.get("COLSEQ"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureForeignKeyConstraints(CaptureContext captureContext, Map<String, DBObjectId> map) throws PersistenceException, IOException {
        try (BufferedReader bufferedReader = null;){
            List<Object> list;
            Object object;
            Object object2;
            PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
            bufferedReader = this.getLineReader("FKEY_FILE");
            BTEQExportReader bTEQExportReader = new BTEQExportReader((LineNumberReader)bufferedReader);
            HashMap<String, MdConstraint> hashMap = new HashMap<String, MdConstraint>();
            TreeMap<Object, ArrayList<Object>> treeMap = new TreeMap<Object, ArrayList<Object>>();
            while (bTEQExportReader.next()) {
                String string = bTEQExportReader.get("DBNAME");
                String string2 = bTEQExportReader.get("TABNAME");
                if (string == null || !string.equals(this.m_ctxSchema.getName()) || string2 == null) continue;
                object2 = new TreeMap();
                for (String string3 : bTEQExportReader.getColumnNames()) {
                    object2.put(string3, bTEQExportReader.get(string3));
                }
                object = (String)object2.get("TABNAME") + "." + (String)object2.get("CONSTNAME");
                list = (List)treeMap.get(object);
                if (list == null) {
                    list = new ArrayList<Object>();
                    treeMap.put(object, (ArrayList<Object>)list);
                }
                list.add(object2);
            }
            for (String string2 : treeMap.keySet()) {
                CaptureEvent captureEvent;
                Object object3;
                MdConstraint mdConstraint;
                String string3;
                object2 = (List)treeMap.get(string2);
                object = (String[])object2.get(0);
                list = (String)object.get("DBNAME");
                String string = (String)object.get("TABNAME");
                string3 = (String)object.get("REFTABSCHEMA");
                String string4 = (String)object.get("REFTABNAME");
                Map<String, List<Map<String, String>>> map2 = this.m_tablePKeys.get(string3 + "." + string4);
                if (!this.findPKey(map2, (List<Map<String, String>>)object2) || list == null && !((String)((Object)list)).equals(this.m_ctxSchema.getName()) || string == null) continue;
                String string5 = (String)object.get("CONSTNAME");
                DBObjectId dBObjectId = persistenceUtility.getIdForSchema((DBObjectId)captureContext.getContextVariable("CATALOGID"), string3);
                DBObjectId dBObjectId2 = persistenceUtility.getIdForTable(dBObjectId, string4);
                DBObjectId dBObjectId3 = map.get(string);
                if (dBObjectId3 == null || dBObjectId2 == null) continue;
                if (hashMap.get(string5) == null) {
                    mdConstraint = new MdConstraint(dBObjectId3, "TERADATALANG");
                    mdConstraint.setName(string5);
                    mdConstraint.setConstraintType("FOREIGN KEY");
                    object3 = (String)object.get("REMARKS");
                    mdConstraint.setComments((String)object3);
                    mdConstraint.setReftableId(dBObjectId2);
                    captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
                    captureContext.getAudience().fireListeners(captureEvent);
                    mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
                    hashMap.put(string5, mdConstraint);
                    captureEvent.setEventId(4);
                    captureContext.getAudience().fireListeners(captureEvent);
                }
                if ((mdConstraint = (MdConstraint)hashMap.get(string5)) == null) continue;
                object3 = object2.iterator();
                while (object3.hasNext()) {
                    Map map3 = (Map)object3.next();
                    int n = Integer.valueOf((String)map3.get("COLSEQ"));
                    String string6 = (String)map3.get("COLNAME");
                    captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), string6);
                    captureContext.getAudience().fireListeners(captureEvent);
                    MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n));
                    mdConstraintDetail.setColumnId(persistenceUtility.getIdForColumn(mdConstraint.getTableId(), string6));
                    mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                    captureEvent.setEventId(4);
                    captureContext.getAudience().fireListeners(captureEvent);
                    String string7 = (String)map3.get("REFCOLNAME");
                    captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), string7);
                    captureContext.getAudience().fireListeners(captureEvent);
                    mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n + 1));
                    mdConstraintDetail.setRefFlag("Y");
                    DBObjectId dBObjectId4 = persistenceUtility.getIdForColumn(dBObjectId2, string7);
                    mdConstraintDetail.setColumnId(dBObjectId4);
                    mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                    captureEvent.setEventId(4);
                    captureContext.getAudience().fireListeners(captureEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureCheckConstraints(CaptureContext captureContext, Map<String, DBObjectId> map) throws PersistenceException, IOException {
        try (BufferedReader bufferedReader = null;){
            String string = this.m_ctxSchema.getName();
            bufferedReader = this.getLineReader("CHECK_FILE");
            BTEQExportReader bTEQExportReader = new BTEQExportReader((LineNumberReader)bufferedReader);
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
            int n = 0;
            while (bTEQExportReader.next()) {
                Integer n2;
                DBObjectId dBObjectId;
                String string2 = bTEQExportReader.get("DBNAME");
                String string3 = bTEQExportReader.get("TABNAME");
                if (string2 == null || !string2.equals(this.m_ctxSchema.getName()) || string3 == null || (dBObjectId = map.get(string3)) == null) continue;
                DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
                String string4 = null;
                String string5 = bTEQExportReader.get("CONSTRAINT_NAME");
                String string6 = bTEQExportReader.get("SEARCH_CONDITION");
                String string7 = "";
                if (string5 == null) {
                    n2 = (Integer)hashMap2.get(string6);
                    if (n2 == null) {
                        n2 = ++n;
                        hashMap2.put(string6, n2);
                    }
                    string5 = string3 + "_C" + n2;
                }
                string4 = "CHECK";
                n2 = new MdConstraint(dBObjectId, "TERADATALANG");
                n2.setName(string5);
                n2.setConstraintType(string4);
                n2.setComments(string7);
                n2.addProperty(new AdditionalProperty("TERADATA_CHECKCONSTRAINT", "needconverting"), dBObjectId2);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), n2.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                n2 = (MdConstraint)this.getStorer().storeObject((PersistableObject)n2);
                hashMap.put(string5, n2);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
                MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(n2.getKey(), Integer.valueOf(1));
                if (string6.indexOf(40) >= 0 && string6.lastIndexOf(41) >= 0) {
                    string6 = string6.substring(string6.indexOf(40) + 1);
                    string6 = string6.substring(0, string6.lastIndexOf(41));
                }
                mdConstraintDetail.setConstraintText(string6);
                mdConstraintDetail.setColumnId(null);
                captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), string5);
                captureContext.getAudience().fireListeners(captureEvent);
                mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureTriggers(CaptureContext captureContext, Map<String, DBObjectId> map) throws PersistenceException, IOException {
        try (LineNumberReader lineNumberReader = null;){
            lineNumberReader = this.getLineReader("TRIGGERS_FILE");
            BTEQExportReader bTEQExportReader = new BTEQExportReader(lineNumberReader);
            while (bTEQExportReader.next()) {
                DBObjectId dBObjectId;
                String string = bTEQExportReader.get("TRIGNAME");
                String string2 = bTEQExportReader.get("TABNAME");
                if (string2 == null || (dBObjectId = map.get(string2)) == null) continue;
                MdTrigger mdTrigger = new MdTrigger(dBObjectId, bTEQExportReader.get("TRIGEVENT"), "TERADATALANG");
                mdTrigger.setTriggerName(string);
                mdTrigger.setComments(bTEQExportReader.get("REMARKS"));
                mdTrigger.setTriggerEvent(bTEQExportReader.get("TRIGEVENT"));
                mdTrigger.setNativeSql(bTEQExportReader.get("TEXT"));
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_TRIGGERS"), string);
                captureContext.getAudience().fireListeners(captureEvent);
                this.getStorer().storeObject((PersistableObject)mdTrigger);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureViews(CaptureContext captureContext) throws PersistenceException, IOException {
        BufferedReader bufferedReader = null;
        File file = null;
        try {
            file = this.m_schemaViewsFileMap.get(this.m_ctxSchema.getName());
            if (file == null || !file.exists() || !file.isFile()) {
                return;
            }
            bufferedReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            BTEQExportReader bTEQExportReader = new BTEQExportReader((LineNumberReader)bufferedReader);
            while (bTEQExportReader.next()) {
                String string = bTEQExportReader.get("DBNAME");
                String string2 = bTEQExportReader.get("VIEWNAME");
                String string3 = bTEQExportReader.get("TEXT");
                if (!string.equals(this.m_ctxSchema.getName())) continue;
                MdView mdView = new MdView(this.m_ctxSchemaId, "TERADATALANG");
                mdView.setViewName(string2);
                mdView.setNativeSql(string3);
                mdView.setCreatedBy(string);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_VIEWS"), mdView.getViewName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdView = (MdView)this.getStorer().storeObject((PersistableObject)mdView);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (file != null && file.exists()) {
                file.delete();
            }
        }
    }

    protected String mapTeradataType(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        string = string.toUpperCase();
        String string4 = this.typeMap.get(string);
        if (string.equals("CF") || string.equals("CO") || string.equals("CV")) {
            string4 = string2.equals("1") ? string4 + "LATIN" : (string2.equals("2") ? string4 + "UNICODE" : (string2.equals("3") ? string4 + "KANJISJIS" : (string2.equals("4") ? string4 + "GRAPHIC" : (string2.equals("5") ? string4 + "KANJI1" : string4 + "LATIN"))));
        }
        if (string4 == null) {
            return string;
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureStoredPrograms(CaptureContext captureContext) throws PersistenceException, IOException {
        BufferedReader bufferedReader = null;
        File file = null;
        try {
            file = this.m_schemaProcsFileMap.get(this.m_dbName);
            if (file == null || !file.exists() || !file.isFile()) {
                return;
            }
            bufferedReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            BTEQExportReader bTEQExportReader = new BTEQExportReader((LineNumberReader)bufferedReader);
            while (bTEQExportReader.next()) {
                Timestamp timestamp;
                String string = bTEQExportReader.get("DBNAME");
                String string2 = bTEQExportReader.get("NAME");
                if (string == null) continue;
                String string3 = this.m_ctxSchema.getName();
                MdSchema mdSchema = this.m_schemas.get(string);
                if (mdSchema == null) continue;
                MdStoredProgram mdStoredProgram = new MdStoredProgram(mdSchema.getKey(), "TERADATALANG");
                mdStoredProgram.setName(string2);
                String string4 = bTEQExportReader.get("ROUTINETYPE");
                mdStoredProgram.setProgramtype(string4);
                String string5 = bTEQExportReader.get("REMARKS");
                if (string5 != null && string5.length() > 0 && !string5.equals("null")) {
                    mdStoredProgram.setComments(string5);
                }
                String string6 = bTEQExportReader.get("CREATE_TIME");
                try {
                    timestamp = Timestamp.valueOf(string6);
                    mdStoredProgram.setCreatedOn(new Date(timestamp.getTime()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mdStoredProgram.setNativeSql(bTEQExportReader.get("TEXT"));
                timestamp = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_STORED_PROGRAMS"), mdStoredProgram.getName());
                captureContext.getAudience().fireListeners((CaptureEvent)timestamp);
                mdStoredProgram = (MdStoredProgram)this.getStorer().storeObject((PersistableObject)mdStoredProgram);
                timestamp.setEventId(4);
                captureContext.getAudience().fireListeners((CaptureEvent)timestamp);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (file != null) {
                file.delete();
            }
        }
    }

    public String[] generateScripts(String string, int n) throws OfflineCaptureException {
        String[] stringArray = this.getFilesToWrite(n);
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        for (String string2 : stringArray) {
            String string3 = string2.substring(string2.lastIndexOf(47) + 1);
            stringArray2[n2++] = string3;
            this.writeFile(string, string2, string3);
        }
        return stringArray2;
    }

    protected String getFilesToWritePath() {
        return "/oracle/dbtools/migration/teradata/offline/resources12/";
    }

    protected String[] getFilesToWrite(int n) {
        String[] stringArray = n == 2 ? new String[]{"startDump.sh", "extract.bteq", "teradata.ocp"} : new String[]{"startDump.bat", "extract.bteq", "teradata.ocp"};
        return stringArray;
    }

    public String[] getScriptFiles(int n) throws OfflineCaptureException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() throws OfflineCaptureException {
        this.getPwPrintln("cleanUp(): " + this.m_dbName);
        this.getPwFlush();
        Object object = this.pwLock;
        synchronized (object) {
            if (this.pw != null) {
                this.pw.close();
                this.pw = null;
            }
        }
    }

    public String writeFile(String string, String string2, String string3) throws OfflineCaptureException {
        InputStream inputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            Object object;
            String string4 = this.getFilesToWritePath();
            inputStream = new BufferedInputStream(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(string4 + string2));
            File file = null;
            file = new File(string + File.separator + string3);
            if (!file.exists()) {
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                object = new byte[10000];
                int n = 0;
                n = inputStream.read((byte[])object);
                while (n > -1) {
                    ((BufferedOutputStream)filterOutputStream).write((byte[])object, 0, n);
                    n = inputStream.read((byte[])object);
                }
                ((BufferedOutputStream)filterOutputStream).flush();
                inputStream.close();
            }
            object = file.getPath();
            String string5 = object;
            return string5;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new OfflineCaptureException((Exception)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new OfflineCaptureException((Exception)iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private LineNumberReader getLineReader(String string) throws IOException {
        File file;
        String string2 = this.m_props.getProperty(string).trim();
        LineNumberReader lineNumberReader = null;
        if (string2 != null && (file = new File(this.m_directory, string2)).canRead()) {
            FileReader fileReader = new FileReader(file);
            lineNumberReader = new LineNumberReader(fileReader);
        }
        return lineNumberReader;
    }

    public String getEnterpriseCaptureFileName() {
        return "TeradataEnterpriseCaptureViews.xml";
    }

    protected Integer getTypeLenCode(String string, Integer n, Integer n2, Integer n3) {
        Integer n4 = 0;
        String string2 = string.trim();
        try {
            if (string != null) {
                n4 = this.m_typeLenCodeMap.get(string);
                if (string2.equals("BF")) {
                    n4 = n;
                }
                if (string2.equals("CF")) {
                    n4 = n;
                }
                if (string2.equals("DH")) {
                    n4 = n2 + 10;
                }
                if (string2.equals("DM")) {
                    n4 = n2 + 10;
                }
                if (string2.equals("DS")) {
                    n4 = n3 > 0 ? n2 + 10 : n2 + n3 + 11;
                }
                if (string2.equals("DY")) {
                    n4 = n2 + 10;
                }
                if (string2.equals("HM")) {
                    switch (n2) {
                        case 4: {
                            n4 = 13;
                            break;
                        }
                        case 3: {
                            n4 = 12;
                            break;
                        }
                        default: {
                            n4 = 11;
                        }
                    }
                }
                if (string2.equals("HR")) {
                    switch (n2) {
                        case 4: {
                            n4 = 13;
                            break;
                        }
                        case 3: {
                            n4 = 12;
                            break;
                        }
                        default: {
                            n4 = 11;
                        }
                    }
                }
                if (string2.equals("HS")) {
                    switch (n2) {
                        case 4: {
                            n4 = n3 > 0 ? 14 : 13;
                            break;
                        }
                        case 3: {
                            n4 = n3 > 0 ? 13 : 12;
                            break;
                        }
                        default: {
                            n4 = n3 > 0 ? 12 : 11;
                        }
                    }
                }
                if (string2.equals("MO")) {
                    switch (n2) {
                        case 4: {
                            n4 = 7;
                            break;
                        }
                        case 3: {
                            n4 = 6;
                            break;
                        }
                        default: {
                            n4 = 5;
                        }
                    }
                }
                if (string2.equals("MS")) {
                    n4 = n3 > 0 ? 12 + n3 : 11;
                }
                if (string2.equals("SC")) {
                    n4 = n3 > 0 ? 12 + n3 : 11;
                }
                if (string2.equals("YM")) {
                    n4 = n2 + 4;
                }
                if (string2.equals("YR")) {
                    n4 = n2 + 4;
                }
            }
        }
        catch (Exception exception) {
            n4 = 0;
        }
        return n4;
    }

    private void getPwPrintln(String string) {
        PrintWriter printWriter = this.getPw();
        if (printWriter != null) {
            printWriter.println(string);
        }
    }

    private void getPwFlush() {
        PrintWriter printWriter = this.getPw();
        if (printWriter != null) {
            printWriter.flush();
        }
    }

    private class BTEQExportReader {
        private Map<String, Integer> columnStartPosMap = new Hashtable<String, Integer>();
        private Map<String, Integer> columnEndPosMap = new Hashtable<String, Integer>();
        protected String headerLine;
        protected String nextLine;
        private LineNumberReader lnr;
        private String[] columnNames;
        protected int recordNo;

        public BTEQExportReader(LineNumberReader lineNumberReader) throws IOException {
            this(lineNumberReader.readLine());
            this.lnr = lineNumberReader;
        }

        public BTEQExportReader(String string) throws IOException {
            this.headerLine = string;
            if (string != null) {
                this.columnNames = string.split("[  |]+");
                int n = 0;
                this.columnStartPosMap.put(this.columnNames[0], n);
                for (int i = 1; i < this.columnNames.length; ++i) {
                    if ((n = string.indexOf(124, n)) < 0) continue;
                    this.columnEndPosMap.put(this.columnNames[i - 1], n);
                    this.columnStartPosMap.put(this.columnNames[i], ++n);
                }
                this.nextLine = null;
            }
        }

        public boolean next() throws IOException {
            this.nextLine = this.lnr.readLine();
            this.recordNo = this.lnr.getLineNumber();
            return this.nextLine != null;
        }

        public String get(String string) {
            String string2 = null;
            Integer n = this.columnStartPosMap.get(string);
            Integer n2 = this.columnEndPosMap.get(string);
            if (n != null) {
                string2 = n2 == null ? this.nextLine.substring(n) : this.nextLine.substring(n, n2);
            }
            return string2 != null ? string2.trim() : null;
        }

        public int getInt(String string) {
            String string2 = this.get(string);
            if (string2 == null) {
                throw new NumberFormatException("Null value");
            }
            return Integer.valueOf(string2);
        }

        public Integer getInteger(String string) {
            String string2 = this.get(string);
            if (string2 == null || string2.equals("null")) {
                return null;
            }
            return Integer.valueOf(string2);
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public int getRecordNo() {
            return this.recordNo;
        }

        public String getHeaderLine() {
            return this.headerLine;
        }

        public String getLine() {
            return this.nextLine;
        }
    }
}

