/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.teradata;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.teradata.Teradata12CapturerImpl;

public class Teradata13CapturerImpl
extends Teradata12CapturerImpl {
    protected static final String GET_COLUMN_QUERY_13 = "select   TRIM(DBC.TVFields.FieldName) \"COLNAME\"\n       , CASE TRIM(DBC.TVFields.FieldType)\n             WHEN 'AT' THEN 'ANSITIME'\n             WHEN 'BF' THEN 'BYTEFIXED'\n             WHEN 'BO' THEN 'BYTELARGEOBJECT'\n             WHEN 'BS' THEN 'BINARYSTRING'\n             WHEN 'BV' THEN 'BYTEVARYING'\n             WHEN 'CF' THEN 'CHARFIXED' || ( CASE dbc.TVFields.CharType WHEN 1 THEN 'LATIN' WHEN '2' THEN 'UNICODE' WHEN '3' THEN 'KANJISJIS' WHEN 4 THEN 'GRAPHIC' WHEN 5 THEN 'KANJI1' ELSE 'LATIN' END)\n             WHEN 'CO' THEN 'CHARLARGEOBJECT'\n             WHEN 'CS' THEN 'CHARSTRING'\n             WHEN 'CV' THEN 'CHARVARYING' || ( CASE dbc.TVFields.CharType WHEN 1 THEN 'LATIN' WHEN '2' THEN 'UNICODE' WHEN '3' THEN 'KANJISJIS' WHEN 4 THEN 'GRAPHIC' WHEN 5 THEN 'KANJI1' ELSE 'LATIN' END)\n             WHEN 'D'  THEN 'DECIMAL'\n             WHEN 'DA' THEN 'DATE'\n             WHEN 'DH' THEN 'DAYHOUR'\n             WHEN 'DI' THEN 'DAYINTERVAL'\n             WHEN 'DM' THEN 'DAYMINUTE'\n             WHEN 'DS' THEN 'DAYSECOND'\n             WHEN 'DT' THEN 'DATETAG'\n             WHEN 'DY' THEN 'DAY'\n             WHEN 'F'  THEN 'REAL'\n             WHEN 'GF' THEN 'GRAPHIC'\n             WHEN 'GV' THEN 'VARGRAPHIC'\n             WHEN 'HM' THEN 'HOURMINUTE'\n             WHEN 'HR' THEN 'HOUR'\n             WHEN 'HS' THEN 'HOURSECOND'\n             WHEN 'I'  THEN 'INTEGER'\n             WHEN 'I1' THEN 'BYTEINT'\n             WHEN 'I2' THEN 'SMALLINT'\n             WHEN 'I8' THEN 'BIGINTEGER'\n             WHEN 'LF' THEN 'CHARFIXEDLOCALE'\n             WHEN 'LV' THEN 'CHARVARYINGLOCALE'\n             WHEN 'MI' THEN 'MINUTE'\n             WHEN 'MO' THEN 'MONTH'\n             WHEN 'MS' THEN 'MINUTETOSECOND'\n             WHEN 'NM' THEN 'NUMBERTAG'\n             WHEN 'PD' THEN 'PERIODDATE'\n             WHEN 'PM' THEN 'PERIODTIMESTAMPWITHTIMEZONE'\n             WHEN 'PS' THEN 'PERIODTIMESTAMP'\n             WHEN 'PT' THEN 'PERIODTIME'\n             WHEN 'PZ' THEN 'PERIODTIMEWITHTIMEZONE'\n             WHEN 'SC' THEN 'SECOND'\n             WHEN 'SZ' THEN 'TIMESTAMPWITHTIMEZONE'\n             WHEN 'TM' THEN 'TIMETAG'\n             WHEN 'TS' THEN 'TIMESTAMPWITHOUTTIMEZONE'\n             WHEN 'TZ' THEN 'ANSITIMEWITHTIMEZONE'\n             WHEN 'UF' THEN 'CHARFIXEDUNICODE'\n             WHEN 'UT' THEN 'USERDEFINEDTYPE'\n             WHEN 'UV' THEN 'CHARVARYINGUNICODE'\n             WHEN 'YI' THEN 'YEARINTERVAL'\n             WHEN 'YM' THEN 'YEARMONTH'\n             WHEN 'YR' THEN 'YEAR'\n             else TRIM(DBC.TVFields.FieldType)\n         END \"TYPENAME\"\n       , case\n               when ((DBC.TVFields.TotalDigits IS NOT NULL)OR(DBC.TVFields.ImpliedPoint IS NOT NULL)) then (DBC.TVFields.TotalDigits(FORMAT 'Z9'))\n               else (DBC.TVFields.MaxLength(FORMAT 'Z,ZZZ,ZZZ,ZZ9')) \n         end \"LENGTH\"\n       , DBC.TVFields.ImpliedPoint(FORMAT 'Z9') \"SCALE\"\n       , DBC.TVFields.nullable \"NULLS\"\n       , DBC.TVFields.DefaultValue \"DEFAULT\"\n       , TRIM(DBC.TVFields.FieldFormat) \"COLUMNFORMAT\"\n       , TRIM(DBC.TVFields.FieldType) \"RAWTYPENAME\"\n       , DBC.TVFields.MaxLength(FORMAT 'Z,ZZZ,ZZZ,ZZ9') \"MAXLENGTH\"\n       , DBC.TVFields.ColumnCheck \"CHECK\"\n       , DBC.TVFields.TotalDigits (NAMED \"DecimalTotalDigits\" , FORMAT 'Z9')\n       , DBC.TVFields.ImpliedPoint (NAMED \"DecimalFractionalDigits\" , FORMAT 'Z9')\n       , DBC.tvfields.MaxLength (NAMED \"ColumnLength\" , FORMAT 'Z,ZZZ,ZZZ,ZZ9')\n       , DBC.TVFields.UDTName \"UDTNAME\"\nFROM\n       DBC.TVM\n           inner join DBC.Dbase on DBC.TVM.DatabaseId = dbase.DatabaseId\n           inner join DBC.TVFields on DBC.TVM.tvmid = DBC.TVFields.tableid\nWHERE\n         UPPER(TRIM(DBC.DBase.DatabaseNameI))=UPPER(TRIM('${schema}')) and\n         UPPER(TRIM(DBC.TVM.TVMNameI))=UPPER(TRIM('${table}'))\nORDER BY  DBC.TVFields.FieldId ";

    public Teradata13CapturerImpl(MigrationStorer migrationStorer, Connection connection) {
        super(migrationStorer, connection);
        GET_COLUMN_QUERY = GET_COLUMN_QUERY_13;
        this.m_typeMap.put("PD", 28);
        this.m_typeMap.put("PM", 72);
        this.m_typeMap.put("PS", 60);
        this.m_typeMap.put("PT", 38);
        this.m_typeMap.put("PZ", 50);
    }

    @Override
    protected void processColumnRow(ResultSet resultSet, MigrationStorer migrationStorer, CaptureContext captureContext, int n) throws PersistenceException, SQLException {
        Integer n2;
        Object object;
        String string;
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
        DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        boolean bl = false;
        MdColumn mdColumn = new MdColumn(dBObjectId, resultSet.getString(1), Integer.valueOf(n));
        CaptureAudience captureAudience = captureContext.getAudience();
        String string2 = resultSet.getString("TYPENAME");
        Integer n3 = resultSet.getInt("LENGTH");
        Integer n4 = resultSet.getInt("SCALE");
        if (string2 != null) {
            if (string2.equals("PERIODDATE")) {
                mdColumn.addProperty(new AdditionalProperty("TERADATA_PERIODDATE_COLUMN", "needconverting"), dBObjectId2);
                n3 = 28;
                n4 = 0;
            } else if (string2.equals("PERIODTIMESTAMPWITHTIMEZONE")) {
                mdColumn.addProperty(new AdditionalProperty("TERADATA_PERIODTIMESTAMPWITHTIMEZONE_COLUMN", "needconverting"), dBObjectId2);
                n3 = 72;
                n4 = 0;
            } else if (string2.equals("PERIODTIMESTAMP")) {
                mdColumn.addProperty(new AdditionalProperty("TERADATA_PERIODTIMESTAMP_COLUMN", "needconverting"), dBObjectId2);
                n3 = 60;
                n4 = 0;
            } else if (string2.equals("PERIODTIME")) {
                mdColumn.addProperty(new AdditionalProperty("TERADATA_PERIODTIME_COLUMN", "needconverting"), dBObjectId2);
                n3 = 38;
                n4 = 0;
            } else if (string2.equals("PERIODTIMEWITHTIMEZONE")) {
                mdColumn.addProperty(new AdditionalProperty("TERADATA_PERIODTIMEWITHTIMEZONE_COLUMN", "needconverting"), dBObjectId2);
                n3 = 50;
                n4 = 0;
            } else if (string2.equals("USERDEFINEDTYPE") && (string = resultSet.getString("UDTNAME")) != null && string.equals("ST_GEOMETRY")) {
                mdColumn.addProperty(new AdditionalProperty("TERADATA_ST_GEOMETRY_COLUMN", "needconverting"), dBObjectId2);
            }
        }
        mdColumn.setColumnType(string2);
        mdColumn.setPrecision(n3);
        mdColumn.setScale(n4);
        string = resultSet.getString("NULLS").trim();
        string = string.toUpperCase().equals("Y") || string.equals("1") ? "Y" : "N";
        String string3 = resultSet.getString("DEFAULT");
        mdColumn.setDefaultValue(string3);
        mdColumn.setNullable(string);
        String string4 = resultSet.getString("COLUMNFORMAT");
        String string5 = resultSet.getString("RAWTYPENAME");
        Integer n5 = resultSet.getInt("MAXLENGTH");
        if (string5 != null) {
            object = (Integer)this.m_typeMap.get(string5);
            if (object == null) {
                object = 0;
            }
            if ((Integer)object == 0) {
                n2 = mdColumn.getPrecision();
                object = n2;
            }
            mdColumn.addProperty(new AdditionalProperty("TERADATA_DUMPLENDECODE", ((Integer)object).toString()), dBObjectId2);
        }
        if (string3 != null) {
            if (string2.equals("ANSITIME") || string2.equals("ANSITIMEWITHTIMEZONE")) {
                mdColumn.addProperty(new AdditionalProperty("TERADATA_CHECK_TIME_DEFAULT", string3), dBObjectId2);
            }
            if (string2.equals("TIMESTAMPWITHTIMEZONE") || string2.equals("TIMESTAMPWITHOUTTIMEZONE")) {
                mdColumn.addProperty(new AdditionalProperty("TERADATA_CHECK_TIMESTAMP_DEFAULT", string3), dBObjectId2);
            }
            if (string2.equals("DATE")) {
                mdColumn.addProperty(new AdditionalProperty("TERADATA_CHECK_DATE_DEFAULT", string3), dBObjectId2);
            }
        }
        if (string4 != null) {
            mdColumn.addProperty(new AdditionalProperty("TERADATA_COLUMNFORMAT", string4), dBObjectId2);
        }
        if (n5 != null) {
            mdColumn.addProperty(new AdditionalProperty("TERADATA_MAXLENGTH", n5.toString()), dBObjectId2);
        }
        if ((object = resultSet.getString("CHECK")) != null && ((String)object).indexOf(40) >= 0 && ((String)object).lastIndexOf(41) >= 0) {
            object = ((String)object).substring(((String)object).indexOf(40) + 1);
            object = ((String)object).substring(0, ((String)object).lastIndexOf(41));
        }
        n2 = new CaptureEvent(3, "COLUMN", mdColumn.getColumnName());
        captureAudience.fireListeners((CaptureEvent)n2);
        migrationStorer.storeObject((PersistableObject)mdColumn);
        n2.setEventId(4);
        captureAudience.fireListeners((CaptureEvent)n2);
    }
}

