/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.breakpoint;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.IdeAction;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.peek.Peek;
import oracle.javatools.ui.ColorUtils2;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.jdevimpl.debugger.breakpoint.CoreBreakpoint;
import oracle.jdevimpl.debugger.breakpoint.res.BreakpointArb;
import oracle.jdevimpl.runner.RunItemActions;

public final class BreakpointHoverBuilder {
    private Peek peek;
    private CoreBreakpoint breakpoint;

    BreakpointHoverBuilder(CoreBreakpoint breakpoint, CodeEditor codeEditor, JComponent gutterComponent) {
        this.breakpoint = breakpoint;
        final Context context = new Context(codeEditor.getGutter().getContext());
        context.setProperty("Breakpoint", (Object)breakpoint);
        JPanel content = new JPanel((LayoutManager)new MigLayout("ins 2 2 2 2, gapx 4, gapy 2, fill"));
        content.setOpaque(true);
        content.putClientProperty(UIConstants.VETO_CONVERSION, true);
        Color background = ColorUtils2.alphaColor((Color)UIConstants.getColor((String)"ghost.panel.background", (UIConstants.Look)UIConstants.Look.DARK), (float)0.93f);
        content.setBackground(background);
        final JCheckBox enabledCheck = new JCheckBox(BreakpointArb.getString(16), breakpoint.isEnabled());
        enabledCheck.setToolTipText(BreakpointArb.getString(54));
        enabledCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakpointHoverBuilder.this.breakpoint.setEnabled(enabledCheck.isSelected());
            }
        });
        final JCheckBox haltCheck = new JCheckBox(BreakpointArb.getString(0), breakpoint.isActionHalt());
        haltCheck.setToolTipText(BreakpointArb.getString(53));
        haltCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakpointHoverBuilder.this.breakpoint.setActionHalt(haltCheck.isSelected());
            }
        });
        final JCheckBox stackCheck = new JCheckBox(BreakpointArb.getString(50), breakpoint.isActionLogStack());
        stackCheck.setToolTipText(BreakpointArb.getString(51));
        stackCheck.setEnabled(breakpoint.isActionLog());
        stackCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakpointHoverBuilder.this.breakpoint.setActionLogStack(stackCheck.isSelected());
            }
        });
        final JCheckBox beepCheck = new JCheckBox(BreakpointArb.getString(1), breakpoint.isActionBeep());
        beepCheck.setToolTipText(BreakpointArb.getString(52));
        beepCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakpointHoverBuilder.this.breakpoint.setActionBeep(beepCheck.isSelected());
            }
        });
        final JTextField conditionField = new JTextField(breakpoint.getCondition(), 16);
        conditionField.setToolTipText(BreakpointArb.getString(45));
        conditionField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                BreakpointHoverBuilder.this.breakpoint.setCondition(conditionField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BreakpointHoverBuilder.this.breakpoint.setCondition(conditionField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BreakpointHoverBuilder.this.breakpoint.setCondition(conditionField.getText());
            }
        });
        final JTextField logField = new JTextField(breakpoint.getActionLogExpression(), 16);
        logField.setToolTipText(BreakpointArb.getString(47));
        logField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                BreakpointHoverBuilder.this.breakpoint.setActionLog(true);
                BreakpointHoverBuilder.this.breakpoint.setActionLogExpression(logField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BreakpointHoverBuilder.this.breakpoint.setActionLog(true);
                BreakpointHoverBuilder.this.breakpoint.setActionLogExpression(logField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BreakpointHoverBuilder.this.breakpoint.setActionLog(true);
                BreakpointHoverBuilder.this.breakpoint.setActionLogExpression(logField.getText());
            }
        });
        final JSpinner passesSpinner = new JSpinner(new SpinnerNumberModel(breakpoint.getPassCount(), 0, Integer.MAX_VALUE, 1));
        passesSpinner.setToolTipText(BreakpointArb.getString(49));
        ((JSpinner.NumberEditor)passesSpinner.getEditor()).getTextField().setColumns(4);
        passesSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BreakpointHoverBuilder.this.breakpoint.setPassCount((Integer)passesSpinner.getValue());
            }
        });
        JButton moreButton = new JButton(BreakpointArb.getString(56));
        final IdeAction viewAction = RunItemActions.getActionCodeEditorEditBreakpoint();
        moreButton.setEnabled(viewAction.isEnabled());
        moreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakpointHoverBuilder.this.peek.hideHover();
                try {
                    viewAction.performAction(context);
                }
                catch (Exception f) {
                    Logger.getLogger("global").log(Level.SEVERE, f.getMessage());
                }
            }
        });
        content.add((Component)enabledCheck, "growx, span, split");
        content.add((Component)haltCheck, "growx");
        content.add((Component)beepCheck, "growx");
        content.add((Component)stackCheck, "growx, wrap");
        content.add(new JLabel(BreakpointArb.getString(44)));
        content.add((Component)conditionField, "span, wrap");
        content.add(new JLabel(BreakpointArb.getString(46)));
        content.add((Component)logField, "span, wrap");
        content.add(new JLabel(BreakpointArb.getString(48)));
        content.add((Component)passesSpinner, "");
        content.add((Component)moreButton, "span, right, ay bottom");
        this.peek = new Peek(gutterComponent, (JComponent)content, HoverFlavor.getFlavor((String)"info"));
        this.peek.getGhostPointingPalette().setLook(UIConstants.Look.DARK);
        this.peek.getGhostPointingPalette().setResizable(false);
        this.peek.setHideOnKeyPress(false);
        if (breakpoint.getType() == 6) {
            this.peek.getGhostPointingPalette().setTitle(BreakpointArb.format(55, breakpoint.getFieldName()));
        }
    }

    public Peek getPeek() {
        return this.peek;
    }
}

