/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.Component;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.Editor;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.view.View;
import oracle.jdevimpl.runner.RunItemActions;
import oracle.jdevimpl.runner.RunItemController;

public final class JRunnerContextMenuListener
implements ContextMenuListener {
    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        View view = context.getView();
        if (view instanceof NavigatorWindow || view instanceof Editor) {
            if (context.getElement() == null && context.getNode() == null) {
                return;
            }
            JRunnerContextMenuListener.insertRunnableItems(popup, context);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public static void insertRunnableItems(ContextMenu popup, Context context) {
        IdeAction actionContextMenuRunProject = RunItemActions.getActionContextMenuRun();
        if (actionContextMenuRunProject != null) {
            actionContextMenuRunProject.putValue("UserData", (Object)context);
            RunItemController.getInstance().update(actionContextMenuRunProject, context);
            if (actionContextMenuRunProject.isEnabled()) {
                JMenuItem menuitemContextMenuRunProject = popup.createMenuItem((ToggleAction)actionContextMenuRunProject, MenuConstants.WEIGHT_RUN_RUN_FILE);
                popup.add((Component)menuitemContextMenuRunProject, MenuConstants.SECTION_RUN_CTXT_MENU);
            } else {
                actionContextMenuRunProject.putValue("UserData", null);
            }
        }
    }
}

