/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import oracle.express.ExpressServerException;
import oracle.express.ObjectClosedException;
import oracle.express.TaskInterruptedException;
import oracle.express.UnexpectedException;
import oracle.express.idl.ExpressModule.ExpressException;
import oracle.express.idl.ExpressModule.RemoteObjectClosedException;
import oracle.express.idl.ExpressModule.RemoteTaskInterruptedException;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorManagerInterface;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorValue2UnionSequenceHolder;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorValue3UnionSequenceHolder;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorValueUnionSequenceHolder;
import oracle.express.idl.ExpressOlapiDataCursorModule.InvalidIndexSpecificationException;
import oracle.express.idl.ExpressOlapiDataCursorModule.RemoteSpecificationUpdateNeededException;
import oracle.express.idl.reconciliation.TxsOqCursorBlockStruct;
import oracle.express.idl.reconciliation.TxsOqCursorValueUnion;
import oracle.express.idl.reconciliation.TxsOqCursorValueUnionSequenceHelper;
import oracle.express.idl.util.InterfaceStub;
import oracle.express.olapi.data.CursorBlock;
import oracle.express.olapi.data.CursorBlockFetcher;
import oracle.express.olapi.data.CursorTreeManager;
import oracle.express.olapi.data.full.DataCursorManager;
import oracle.olapi.data.cursor.PositionOutOfBoundsException;
import oracle.olapi.data.cursor.SpecificationUpdateNeededException;
import oracle.olapi.data.source.Parameter;
import org.omg.CORBA.NO_IMPLEMENT;

final class FullCursorBlockFetcher
implements CursorBlockFetcher {
    private DataCursorManager _cursorManager;
    private CursorManagerInterface _cursorManagerInterface;
    private boolean _isClosed;

    public FullCursorBlockFetcher(DataCursorManager dataCursorManager, CursorManagerInterface cursorManagerInterface) {
        this._cursorManager = dataCursorManager;
        this._cursorManagerInterface = cursorManagerInterface;
        this._isClosed = false;
    }

    public final CursorBlock fetchCursorBlock(long[] lArray, int[] nArray, Parameter[] parameterArray, CursorTreeManager cursorTreeManager) {
        try {
            TxsOqCursorBlockStruct txsOqCursorBlockStruct;
            TxsOqCursorValueUnion[] txsOqCursorValueUnionArray = CursorTreeManager.getParameterValues(cursorTreeManager, parameterArray);
            if (((InterfaceStub)((Object)this._getCursorManagerInterface())).isPostServerVsnnum("11.0.0.0.0")) {
                CursorValue3UnionSequenceHolder cursorValue3UnionSequenceHolder = new CursorValue3UnionSequenceHolder();
                TxsOqCursorValueUnionSequenceHelper.convertBack(txsOqCursorValueUnionArray, cursorValue3UnionSequenceHolder);
                txsOqCursorBlockStruct = new TxsOqCursorBlockStruct(this._getCursorManagerInterface().fetch3Blocks(nArray, lArray, cursorValue3UnionSequenceHolder.value));
            } else if (((InterfaceStub)((Object)this._getCursorManagerInterface())).isPostServerVsnnum("10.1.0.5.0")) {
                CursorValue2UnionSequenceHolder cursorValue2UnionSequenceHolder = new CursorValue2UnionSequenceHolder();
                TxsOqCursorValueUnionSequenceHelper.convertBack(txsOqCursorValueUnionArray, cursorValue2UnionSequenceHolder);
                txsOqCursorBlockStruct = new TxsOqCursorBlockStruct(this._getCursorManagerInterface().fetch2Blocks(nArray, lArray, cursorValue2UnionSequenceHolder.value));
            } else {
                CursorValueUnionSequenceHolder cursorValueUnionSequenceHolder = new CursorValueUnionSequenceHolder();
                TxsOqCursorValueUnionSequenceHelper.convertBack(txsOqCursorValueUnionArray, cursorValueUnionSequenceHolder);
                txsOqCursorBlockStruct = new TxsOqCursorBlockStruct(this._getCursorManagerInterface().fetchBlocks(nArray, lArray, cursorValueUnionSequenceHolder.value));
            }
            return new CursorBlock(txsOqCursorBlockStruct, txsOqCursorValueUnionArray);
        }
        catch (RemoteSpecificationUpdateNeededException remoteSpecificationUpdateNeededException) {
            throw new UnexpectedException(remoteSpecificationUpdateNeededException.toString());
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            this._closed();
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
        catch (InvalidIndexSpecificationException invalidIndexSpecificationException) {
            throw new PositionOutOfBoundsException();
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            this._closed();
            throw new ObjectClosedException(nO_IMPLEMENT.toString());
        }
    }

    public final CursorBlock fetchAnyCursorBlock(Parameter[] parameterArray) {
        return this.fetchAnyCursorBlock(parameterArray, null);
    }

    public final CursorBlock fetchAnyCursorBlock(Parameter[] parameterArray, CursorTreeManager cursorTreeManager) {
        try {
            TxsOqCursorBlockStruct txsOqCursorBlockStruct;
            TxsOqCursorValueUnion[] txsOqCursorValueUnionArray = CursorTreeManager.getParameterValues(cursorTreeManager, parameterArray);
            if (((InterfaceStub)((Object)this._getCursorManagerInterface())).isPostServerVsnnum("11.0.0.0.0")) {
                CursorValue3UnionSequenceHolder cursorValue3UnionSequenceHolder = new CursorValue3UnionSequenceHolder();
                TxsOqCursorValueUnionSequenceHelper.convertBack(txsOqCursorValueUnionArray, cursorValue3UnionSequenceHolder);
                txsOqCursorBlockStruct = new TxsOqCursorBlockStruct(this._getCursorManagerInterface().fetch3InitialBlocks(cursorValue3UnionSequenceHolder.value));
            } else if (((InterfaceStub)((Object)this._getCursorManagerInterface())).isPostServerVsnnum("10.1.0.5.0")) {
                CursorValue2UnionSequenceHolder cursorValue2UnionSequenceHolder = new CursorValue2UnionSequenceHolder();
                TxsOqCursorValueUnionSequenceHelper.convertBack(txsOqCursorValueUnionArray, cursorValue2UnionSequenceHolder);
                txsOqCursorBlockStruct = new TxsOqCursorBlockStruct(this._getCursorManagerInterface().fetch2InitialBlocks(cursorValue2UnionSequenceHolder.value));
            } else {
                CursorValueUnionSequenceHolder cursorValueUnionSequenceHolder = new CursorValueUnionSequenceHolder();
                TxsOqCursorValueUnionSequenceHelper.convertBack(txsOqCursorValueUnionArray, cursorValueUnionSequenceHolder);
                txsOqCursorBlockStruct = new TxsOqCursorBlockStruct(this._getCursorManagerInterface().fetchInitialBlocks(cursorValueUnionSequenceHolder.value));
            }
            return new CursorBlock(txsOqCursorBlockStruct, txsOqCursorValueUnionArray);
        }
        catch (RemoteSpecificationUpdateNeededException remoteSpecificationUpdateNeededException) {
            throw new SpecificationUpdateNeededException();
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            this._closed();
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            this._closed();
            throw new ObjectClosedException(nO_IMPLEMENT.toString());
        }
    }

    public void close() {
        this._isClosed = true;
    }

    private void _closed() {
        this._cursorManager._closed();
    }

    private CursorManagerInterface _getCursorManagerInterface() throws ObjectClosedException {
        if (this._isClosed) {
            throw new ObjectClosedException();
        }
        return this._cursorManagerInterface;
    }
}

