/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.List;
import java.util.Set;
import oracle.express.mdm.MetadataNotFoundException;
import oracle.olapi.ArraySet;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.MetadataXMLReader;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.MdmAttributeModel;
import oracle.olapi.metadata.mdm.MdmBaseAttribute;
import oracle.olapi.metadata.mdm.MdmDescriptionType;
import oracle.olapi.metadata.mdm.MdmDimensionality;
import oracle.olapi.metadata.mdm.MdmDimensionedObject;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmModel;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmXMLTags;
import oracle.olapi.metadata.mtm.MtmAttributeMap;
import oracle.olapi.syntax.SQLDataType;
import org.xml.sax.SAXException;

public abstract class MdmAttribute
extends MdmDimensionedObject {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MdmXMLTags.DESCRIPTION_TYPE, MdmXMLTags.IS_VISIBLE_FOR_ALL, MdmXMLTags.TARGET_DIMENSION, MdmXMLTags.TARGET_ATTRIBUTE};
    private static final String CONTAINER_DIMENSIONALITY_NAME = "AttributeDimensionality";

    public MtmAttributeMap getAttributeMap() throws MetadataNotFoundException {
        return (MtmAttributeMap)this.getSourceMap();
    }

    protected void finishObjectCreation() {
        super.finishObjectCreation();
        if (!this.getMetadataProvider().getDataProvider().read11gMetadata()) {
            return;
        }
        MdmPrimaryDimension mdmPrimaryDimension = this.getPrimaryDimension();
        if (mdmPrimaryDimension == null) {
            return;
        }
        MdmDimensionality mdmDimensionality = this.findOrCreateDimensionality(MdmXMLTags.CONTAINER_DIMENSIONALITY, CONTAINER_DIMENSIONALITY_NAME, this.getPersistenceType());
        MdmXMLTags.DIMENSION_REF.initializeProperty((BaseMetadataObject)mdmDimensionality, (Object)mdmPrimaryDimension.getInternalID(), this.getPersistenceType());
    }

    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    public static String generateIDFromXML(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, String string, String string2, String string3, MetadataXMLReader metadataXMLReader) throws SAXException {
        baseMetadataObject = baseMetadataObject.getTopLevelObject(metadataXMLReader.getPersistenceType());
        return MdmDimensionedObject.generateIDFromXML(baseMetadataObject, xMLTag, string, string2, string3, metadataXMLReader);
    }

    MdmAttribute(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    public MdmAttribute(String string, String string2, short s, MdmPrimaryDimension mdmPrimaryDimension) {
        super(string, string2, s, mdmPrimaryDimension.getBaseMetadataProvider(), (BaseMetadataObject)mdmPrimaryDimension);
    }

    public final MdmPrimaryDimension getTargetDimension() {
        return (MdmPrimaryDimension)this.getPropertyObjectValue(MdmXMLTags.TARGET_DIMENSION);
    }

    public final void setTargetDimension(MdmPrimaryDimension mdmPrimaryDimension) {
        this.setPropertyObjectValue(MdmXMLTags.TARGET_DIMENSION, mdmPrimaryDimension);
    }

    public final MdmBaseAttribute getTargetAttribute() {
        return (MdmBaseAttribute)this.getPropertyObjectValue(MdmXMLTags.TARGET_ATTRIBUTE);
    }

    public final void setTargetAttribute(MdmBaseAttribute mdmBaseAttribute) {
        this.setPropertyObjectValue(MdmXMLTags.TARGET_ATTRIBUTE, mdmBaseAttribute);
    }

    public final MdmDescriptionType getDescriptionType() {
        return (MdmDescriptionType)this.getPropertyObjectValue(MdmXMLTags.DESCRIPTION_TYPE);
    }

    public final void setDescriptionType(MdmDescriptionType mdmDescriptionType) {
        this.setPropertyObjectValue(MdmXMLTags.DESCRIPTION_TYPE, mdmDescriptionType);
    }

    public final boolean isVisibleForAll() {
        return this.getPropertyBooleanValue(MdmXMLTags.IS_VISIBLE_FOR_ALL);
    }

    public final void setIsVisibleForAll(boolean bl) {
        this.setPropertyBooleanValue(MdmXMLTags.IS_VISIBLE_FOR_ALL, bl);
    }

    public final void setPrimaryDimension(MdmPrimaryDimension mdmPrimaryDimension) {
        if (this.getMetadataProvider().getDataProvider().read11gMetadata()) {
            this.setContainedByObject(mdmPrimaryDimension);
        }
    }

    public final List getDimensionality() {
        List list = super.getDimensionality();
        MdmDimensionality mdmDimensionality = this.getContainerDimensionality();
        if (mdmDimensionality != null) {
            list.add(mdmDimensionality);
        }
        return list;
    }

    private MdmDimensionality getContainerDimensionality() {
        return (MdmDimensionality)this.getPropertyObjectValue(MdmXMLTags.CONTAINER_DIMENSIONALITY);
    }

    private void setContainerDimensionality(MdmDimensionality mdmDimensionality) {
        this.setPropertyObjectValue(MdmXMLTags.CONTAINER_DIMENSIONALITY, mdmDimensionality);
    }

    public MdmAttributeModel getAttributeModel() {
        return null;
    }

    public final MdmModel getModel() {
        return this.getAttributeModel();
    }

    public void setAttributeModel(MdmAttributeModel mdmAttributeModel) {
    }

    public final void setModel(MdmModel mdmModel) {
        if (mdmModel instanceof MdmAttributeModel) {
            this.setAttributeModel((MdmAttributeModel)mdmModel);
        }
    }

    public final MdmPrimaryDimension getPrimaryDimension() {
        if (!this.getMetadataProvider().getDataProvider().read11gMetadata()) {
            List list = this.getDimensions();
            if (list.size() == 0) {
                return null;
            }
            return (MdmPrimaryDimension)list.get(0);
        }
        return (MdmPrimaryDimension)this.getContainedByObject();
    }

    protected final Set getInputDefinitions() {
        ArraySet arraySet = new ArraySet();
        MdmAttribute mdmAttribute = this;
        for (MdmPrimaryDimension mdmPrimaryDimension : mdmAttribute.getDimensions()) {
            arraySet.add(mdmPrimaryDimension.getSource().getDefinition());
        }
        return arraySet;
    }

    protected final SourceDefinition getTypeDefinition() {
        return this.getDataType().getSource().getDefinition();
    }

    public final MetadataObject getType() {
        return this.convertSQLDataTypeToOldDataType(this.getSQLDataType(), this.isBooleanValued());
    }

    public abstract SQLDataType getSQLDataType();

    public static XMLTag classGetContainedByPropertyTag() {
        return MdmXMLTags.CONTAINER_PRIMARY_DIM;
    }
}

