/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.express.mdm.MetadataNotFoundException;
import oracle.olapi.ArraySet;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.metadata.MetadataXMLReader;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmDimensionality;
import oracle.olapi.metadata.mdm.MdmDimensionedObject;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasureDimension;
import oracle.olapi.metadata.mdm.MdmMeasureModel;
import oracle.olapi.metadata.mdm.MdmMember;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmModel;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmViewColumn;
import oracle.olapi.metadata.mdm.MdmViewColumnOwner;
import oracle.olapi.metadata.mdm.MdmXMLTags;
import oracle.olapi.metadata.mtm.MtmMeasureMap;
import org.xml.sax.SAXException;

public abstract class MdmMeasure
extends MdmDimensionedObject
implements MdmMember,
MdmViewColumnOwner {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MdmXMLTags.MEASURE_UNITS, MdmXMLTags.MEASURE_FORMAT, MdmXMLTags.PRECEDENCE, MdmXMLTags.MEASURE_MODEL, MdmXMLTags.ET_MEASURE_COLUMN_NAME};
    private MdmViewColumn m_ETColumn = null;

    private synchronized void createViewColumns() {
        if (null != this.m_ETColumn) {
            return;
        }
        this.m_ETColumn = new MdmViewColumn(this, this.getName(), MdmXMLTags.ET_MEASURE_COLUMN_NAME);
    }

    public MtmMeasureMap getMeasureMap() throws MetadataNotFoundException {
        return (MtmMeasureMap)this.getSourceMap();
    }

    MdmMeasure(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    public MdmMeasure(String string, short s, MdmCube mdmCube) {
        super(string, MdmMeasure.generateID((BaseMetadataObject)mdmCube, string), s, mdmCube.getBaseMetadataProvider(), (BaseMetadataObject)mdmCube);
    }

    public String getValue() {
        if (this.getSourceMap() != null) {
            return this.getSource().getID();
        }
        return this.getMetadataProvider().getDataProvider()._getSourceIDProvider().createHiddenID(this.getMetadataProvider().getID(), this.getID(), this.getMetadataProvider().getDataProvider());
    }

    public String getLocalValue() {
        return this.getName();
    }

    public MdmPrimaryDimension getOwnerDimension() {
        return this.getMeasureDimension();
    }

    public MdmMeasureDimension getMeasureDimension() {
        return this.getMetadataProvider().getRootSchema().getMeasureDimension();
    }

    public MdmLevel getLevel() {
        MdmLevelHierarchy mdmLevelHierarchy = (MdmLevelHierarchy)this.getMeasureDimension().getHierarchies().get(0);
        return (MdmLevel)mdmLevelHierarchy.getLevels().get(0);
    }

    public int getLevelDepth() {
        return 0;
    }

    public String getParentValue() {
        return null;
    }

    public String getParentLocalValue() {
        return null;
    }

    public MdmLevel getParentLevel() {
        return null;
    }

    public int getPrecedence() {
        return this.getPropertyIntegerValue(MdmXMLTags.PRECEDENCE, 0);
    }

    public String getValueFormat() {
        return this.getPropertyStringValue(MdmXMLTags.MEASURE_FORMAT);
    }

    public void setValueFormat(String string) {
        this.setPropertyStringValue(MdmXMLTags.MEASURE_FORMAT, string);
    }

    public String getUnits() {
        String string = this.getPropertyStringValue(MdmXMLTags.MEASURE_UNITS);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void setUnits(String string) {
        this.setPropertyStringValue(MdmXMLTags.MEASURE_UNITS, string);
    }

    public void setPrecedence(int n) {
        this.setPropertyIntegerValue(MdmXMLTags.PRECEDENCE, n);
    }

    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    public static String generateIDFromXML(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, String string, String string2, String string3, MetadataXMLReader metadataXMLReader) throws SAXException {
        ArrayList<String> arrayList = null;
        BaseMetadataObject baseMetadataObject2 = baseMetadataObject.getTopLevelObject(metadataXMLReader.getPersistenceType());
        if (baseMetadataObject2 instanceof MdmCube) {
            baseMetadataObject = baseMetadataObject2;
        } else {
            String string4 = metadataXMLReader.getAttributeValue(MdmXMLTags.CUBE_NAME, false);
            if (null != string4) {
                arrayList = new ArrayList<String>();
                arrayList.add(string4);
                arrayList.add(string);
                string = null;
            }
        }
        return MdmMeasure.generateIDFromXML(baseMetadataObject, xMLTag, string, string2, string3, metadataXMLReader, arrayList);
    }

    protected void appendIDAttrsForXMLObjectRef(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, MetadataToXMLConverter metadataToXMLConverter) {
        if (!metadataToXMLConverter.isMetadataXMLVersionSameOrLaterThan("1.2") && null != baseMetadataObject && baseMetadataObject.getTopLevelObject() != this.getTopLevelObject()) {
            MdmCube mdmCube = this.getCube();
            metadataToXMLConverter.appendIDAttribute(MdmXMLTags.CUBE_NAME, mdmCube.getName(), (BaseMetadataObject)mdmCube);
            this.appendNameForXMLObjectRef(baseMetadataObject, xMLTag, metadataToXMLConverter);
        } else {
            super.appendIDAttrsForXMLObjectRef(baseMetadataObject, xMLTag, metadataToXMLConverter);
        }
    }

    public final MdmCube getCube() {
        return (MdmCube)this.getContainedByObject();
    }

    public final void setCube(MdmCube mdmCube) {
        this.setContainedByObject(mdmCube);
    }

    public final List getDimensionality() {
        if (null == this.getCube()) {
            return super.getDimensionality();
        }
        return this.getCube().getDimensionality();
    }

    public final void addDimensionality(MdmDimensionality mdmDimensionality) {
        if (null == this.getCube()) {
            super.addDimensionality(mdmDimensionality);
        } else {
            this.getCube().addDimensionality(mdmDimensionality);
        }
    }

    public final void removeDimensionality(MdmDimensionality mdmDimensionality) {
        this.getCube().removeDimensionality(mdmDimensionality);
    }

    public final MdmMeasureModel getMeasureModel() {
        return (MdmMeasureModel)this.getPropertyObjectValue(MdmXMLTags.MEASURE_MODEL);
    }

    public final MdmModel getModel() {
        return (MdmModel)this.getPropertyObjectValue(MdmXMLTags.MEASURE_MODEL);
    }

    public final void setMeasureModel(MdmMeasureModel mdmMeasureModel) {
        this.setPropertyObjectValue(MdmXMLTags.MEASURE_MODEL, mdmMeasureModel);
    }

    public final void setModel(MdmModel mdmModel) {
        if (mdmModel instanceof MdmMeasureModel) {
            this.setPropertyObjectValue(MdmXMLTags.MEASURE_MODEL, mdmModel);
        }
    }

    protected final Set getInputDefinitions() {
        ArraySet arraySet = new ArraySet();
        MdmMeasure mdmMeasure = this;
        for (MdmPrimaryDimension mdmPrimaryDimension : mdmMeasure.getDimensions()) {
            arraySet.add(mdmPrimaryDimension.getSource().getDefinition());
        }
        return arraySet;
    }

    protected final SourceDefinition getTypeDefinition() {
        return this.getDataType().getSource().getDefinition();
    }

    public final MdmViewColumn getETMeasureColumn() {
        if (null == this.m_ETColumn) {
            this.createViewColumns();
        }
        return this.m_ETColumn;
    }

    public final MetadataObject getType() {
        return this.convertSQLDataTypeToOldDataType(this.getSQLDataType(), this.isBooleanValued());
    }

    protected void updateID(String string) {
        super.updateID(string);
        this.m_ETColumn = null;
    }

    public static final XMLTag classGetContainedByPropertyTag() {
        return MdmXMLTags.CONTAINER_CUBE;
    }
}

