/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.metadata.deployment.AW;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.metadata.mdm.MdmDerivedMeasure;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmRootSchema;
import oracle.olapi.syntax.Expression;
import oracle.olapi.syntax.SyntaxObject;

public final class AddDerivedMeasure {
    public static final String JDBC_URL_PROPERTY_NAME = "url";
    public static final String USER_ID_PROPERTY_NAME = "user";
    public static final String PASSWORD_PROPERTY_NAME = "password";
    public static final String CUBE_NAME_PROPERTY = "cube_name";

    private static Properties parseCommandLineProperties(String[] stringArray) {
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; i += 2) {
            if (i + 1 == stringArray.length) {
                throw new IllegalArgumentException("Command-line arguments must be specified in the form -<PropertyName> <PropertyValue>, with name and value separated by whitespace.");
            }
            properties.put(stringArray[i].substring(1), stringArray[i + 1]);
        }
        properties.put("TransactionMode", "11g");
        properties.put("MetadataReaderMode", "11_ONLY");
        return properties;
    }

    private static OracleConnection connect(Properties properties) throws SQLException {
        String string = (String)properties.get(JDBC_URL_PROPERTY_NAME);
        if (null == string) {
            throw new IllegalArgumentException("Must specifiy -url");
        }
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection connection = DriverManager.getConnection(string, properties);
        return (OracleConnection)connection;
    }

    private static String getInput(String string, boolean bl) {
        System.out.println(string);
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        boolean bl2 = true;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (null != (string2 = bufferedReader.readLine()) && !string2.equals("") && !string2.equals("/")) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(string2);
                if (!bl) continue;
                break;
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Properties properties = AddDerivedMeasure.parseCommandLineProperties(stringArray);
        try {
            Object object;
            String string;
            OracleConnection oracleConnection = AddDerivedMeasure.connect(properties);
            System.out.println("Connected");
            DataProvider dataProvider = new DataProvider(null, properties);
            dataProvider.createSession(oracleConnection);
            System.out.println("Create OLAP API Session");
            MdmMetadataProvider mdmMetadataProvider = dataProvider.getMdmMetadataProvider();
            MdmRootSchema mdmRootSchema = (MdmRootSchema)mdmMetadataProvider.getRootSchema();
            String string2 = (String)properties.get(USER_ID_PROPERTY_NAME);
            MdmDatabaseSchema mdmDatabaseSchema = mdmRootSchema.getDatabaseSchema(string2.toUpperCase());
            String string3 = (String)properties.get(CUBE_NAME_PROPERTY);
            MdmCube mdmCube = mdmDatabaseSchema.findOrCreateCube(string3.toUpperCase());
            if (mdmCube.getOrganization() == null) {
                string = AddDerivedMeasure.getInput("Enter the aw name for the new cube : ", true);
                object = mdmDatabaseSchema.findOrCreateAW(string);
                mdmCube.createAWOrganization((AW)object, true);
            }
            string = AddDerivedMeasure.getInput("Enter new derived measure name : ", true);
            object = AddDerivedMeasure.getInput("Enter measure expression followed by empty line : ", false);
            Expression expression = (Expression)SyntaxObject.fromSyntax((String)object, mdmMetadataProvider, string2.toUpperCase());
            MdmDerivedMeasure mdmDerivedMeasure = mdmCube.findOrCreateDerivedMeasure(string);
            mdmDerivedMeasure.setMeasureExpression(expression);
            System.out.println("Committing...");
            dataProvider.getTransactionProvider().commitCurrentTransaction();
            System.out.println("Commit Successful");
            oracleConnection.close();
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            throw new RuntimeException(exception.toString());
        }
    }
}

