/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.syntax.DataObject;
import oracle.olapi.syntax.DimensionArgument;
import oracle.olapi.syntax.IdentifierArgument;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.UnresolvedIdentifier;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.Identifier;
import oracle.olapi.syntax.parser.IdentifierResolver;

public final class UnresolvedDimensionArgument
extends DimensionArgument
implements UnresolvedIdentifier {
    private Identifier m_Identifier;
    private IdentifierResolver m_IDResolver;
    private int m_Mask = 0;

    public IdentifierResolver getIDResolver() {
        return this.m_IDResolver;
    }

    public Identifier getIdentifier() {
        return this.m_Identifier;
    }

    private int getMask() {
        return this.m_Mask;
    }

    public UnresolvedDimensionArgument(Identifier identifier, IdentifierResolver identifierResolver, int n) {
        super(null);
        this.m_IDResolver = identifierResolver;
        this.m_Identifier = identifier;
        this.m_Mask = n;
        this.initialize();
    }

    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.appendIdentifier(this.getIdentifier().toString());
    }

    public DataObject validate(ValidationContext validationContext) {
        DimensionArgument dimensionArgument = this.resolveToDimension(validationContext, false);
        if (dimensionArgument instanceof UnresolvedDimensionArgument) {
            validationContext.addUnresolvedID((UnresolvedDimensionArgument)dimensionArgument);
        } else if (null == dimensionArgument) {
            this.getIDResolver().error(this.getIdentifier());
        }
        return dimensionArgument;
    }

    protected boolean checkIfDefinitionIsComplete() {
        return false;
    }

    DimensionArgument resolveToDimension(ValidationContext validationContext, boolean bl) {
        Identifier identifier = new Identifier(this.getIdentifier());
        return this.getIDResolver().getDimensionArgument(identifier, validationContext, this.getMask(), bl);
    }

    IdentifierArgument resolveToIdentifier() {
        if (1 == this.getIdentifier().getNumComponents()) {
            return new IdentifierArgument(this.getIDResolver().getString(this.getIdentifier()));
        }
        return null;
    }

    DimensionArgument resolveToDimension(ValidationContext validationContext) {
        return this.resolveToDimension(validationContext, false);
    }

    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitUnresolvedDimensionArgument(this, object);
    }
}

