/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.syntax.DataObject;
import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.DimensionArgument;
import oracle.olapi.syntax.IdentifierArgument;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.UnresolvedIdentifier;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.Identifier;
import oracle.olapi.syntax.parser.IdentifierResolver;

public final class UnresolvedExpression
extends TypedExpression
implements UnresolvedIdentifier {
    private Identifier m_Identifier;
    private IdentifierResolver m_IDResolver;

    public IdentifierResolver getIDResolver() {
        return this.m_IDResolver;
    }

    public Identifier getIdentifier() {
        return this.m_Identifier;
    }

    public UnresolvedExpression(Identifier identifier, IdentifierResolver identifierResolver) {
        this.m_IDResolver = identifierResolver;
        this.m_Identifier = identifier;
        this.setDataType(DataType.NULL_TYPE);
        this.initialize();
    }

    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.appendIdentifier(this.getIdentifier().toString());
    }

    public DataObject validate(ValidationContext validationContext) {
        TypedExpression typedExpression = this.resolveToColumn(validationContext, false);
        if (typedExpression instanceof UnresolvedExpression) {
            validationContext.addUnresolvedID((UnresolvedExpression)typedExpression);
        } else if (null == typedExpression) {
            this.getIDResolver().error(this.getIdentifier());
        }
        return typedExpression;
    }

    protected boolean checkIfDefinitionIsComplete() {
        return false;
    }

    TypedExpression resolveToColumn(ValidationContext validationContext, boolean bl) {
        Identifier identifier = new Identifier(this.getIdentifier());
        return this.getIDResolver().getColumnExpression(identifier, bl);
    }

    IdentifierArgument resolveToIdentifier() {
        if (1 == this.getIdentifier().getNumComponents()) {
            return new IdentifierArgument(this.getIDResolver().getString(this.getIdentifier()));
        }
        return null;
    }

    DimensionArgument resolveToDimension(ValidationContext validationContext, int n) {
        Identifier identifier = new Identifier(this.getIdentifier());
        return this.getIDResolver().getDimensionArgument(identifier, validationContext, n, false);
    }

    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitUnresolvedExpression(this, object);
    }
}

