/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform;

import java.util.HashMap;
import java.util.Map;
import oracle.adf.model.dvt.util.transform.DataCellInterface;
import oracle.adf.model.dvt.util.transform.LayerInterface;
import oracle.adf.model.dvt.util.transform.MemberInterface;
import oracle.adf.model.dvt.util.transform.RowProjection;
import oracle.javatools.annotations.Concealed;

@Concealed
public class ProjectionInfo {
    private String[][] m_layout = null;
    private MemberInterface[] m_dataItems = null;
    private String[] m_ignoredCols = null;
    private LayerInterface m_layerInt = null;
    private final RowProjection m_proj;
    private Map<String, LayerInterface> m_layerMap = new HashMap<String, LayerInterface>();
    private Map<String, Boolean> m_isIgnoredCol = new HashMap<String, Boolean>();

    public ProjectionInfo(RowProjection proj) {
        this.m_proj = proj;
    }

    public String[][] getLayout() {
        if (this.m_layout == null && this.m_proj != null) {
            this.m_layout = this.m_proj.getLayout();
        }
        return this.m_layout;
    }

    public MemberInterface[] getDataItems() {
        if (this.m_dataItems == null && this.m_proj != null) {
            this.m_dataItems = this.m_proj.getDataItems();
        }
        return this.m_dataItems;
    }

    public LayerInterface getLayer(String column) {
        LayerInterface li = this.m_layerMap.get(column);
        if (li == null && this.m_proj != null) {
            li = this.m_proj.getLayer(column);
            this.m_layerMap.put(column, li);
        }
        return li;
    }

    public String[] getIgnoredColumns() {
        if (this.m_ignoredCols == null && this.m_proj != null) {
            this.m_ignoredCols = this.m_proj.getIgnoredColumns();
        }
        return this.m_ignoredCols;
    }

    public LayerInterface getDataLayer() {
        if (this.m_layerInt == null && this.m_proj != null) {
            this.m_layerInt = this.m_proj.getDataLayer();
        }
        return this.m_layerInt;
    }

    public DataCellInterface getData(Map<String, Object> keyPath) {
        return this.m_proj.getData(keyPath);
    }

    public boolean isIgnoredColumn(String column) {
        Boolean val = this.m_isIgnoredCol.get(column);
        if (val != null) {
            return val;
        }
        String[] ignoredCols = this.getIgnoredColumns();
        if (ignoredCols == null) {
            this.m_isIgnoredCol.put(column, Boolean.FALSE);
            return false;
        }
        for (int i = 0; i < ignoredCols.length; ++i) {
            if (!column.equals(ignoredCols[i])) continue;
            this.m_isIgnoredCol.put(column, Boolean.TRUE);
            return true;
        }
        this.m_isIgnoredCol.put(column, Boolean.FALSE);
        return false;
    }
}

