/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.util.Enumeration;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.SimpleCondition;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class CompoundCondition {
    public static final int OR = 0;
    public static final int AND = 1;
    protected ErrorHandler m_eh = null;
    protected Object m_leftOperand;
    protected int m_operator;
    protected Object m_rightOperand;
    @Concealed
    public static final String XML_NAME = "CompoundCondition";
    private static final String a_leftOperand = "leftOperand";
    private static final String a_rightOperand = "rightOperand";
    private static final String a_operator = "operator";

    public CompoundCondition() {
        this.m_leftOperand = null;
        this.m_operator = -1;
        this.m_rightOperand = null;
    }

    public CompoundCondition(Object leftOperand, int operator, Object rightOperand) {
        this.m_leftOperand = leftOperand;
        this.m_operator = operator;
        this.m_rightOperand = rightOperand;
        if (!this.isValidCondition() && this.m_eh != null) {
            this.m_eh.log("invalid condition", this.getClass().toString(), "CompoundCondition constructor");
        }
    }

    public boolean isValidCondition() {
        if (this.m_leftOperand == null || !(this.m_leftOperand instanceof SimpleCondition) || !(this.m_leftOperand instanceof CompoundCondition)) {
            return false;
        }
        if (this.m_operator != 0 && this.m_operator != 1) {
            return false;
        }
        return this.m_rightOperand != null && this.m_rightOperand instanceof SimpleCondition && this.m_rightOperand instanceof CompoundCondition;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.m_eh = eh;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CompoundCondition) || o == null) {
            return false;
        }
        CompoundCondition dc = (CompoundCondition)o;
        return (this.m_leftOperand != null && this.m_leftOperand.equals(dc.getLeftOperand()) || this.m_leftOperand == null && dc.getLeftOperand() == null) && this.m_operator == dc.getOperator() && (this.m_rightOperand != null && this.m_rightOperand.equals(dc.getRightOperand()) || this.m_rightOperand == null && dc.getRightOperand() == null);
    }

    public Object getLeftOperand() {
        return this.m_leftOperand;
    }

    public int getOperator() {
        return this.m_operator;
    }

    public Object getRightOperand() {
        return this.m_rightOperand;
    }

    public ContainerNode getXML() {
        if (!this.isValidCondition()) {
            return null;
        }
        ContainerNode cNode = new ContainerNode(XML_NAME);
        ContainerNode lNode = new ContainerNode(a_leftOperand);
        if (this.getLeftOperand() instanceof CompoundCondition) {
            lNode.addContainedObject(((CompoundCondition)this.getLeftOperand()).getXML());
        } else {
            lNode.addContainedObject(((SimpleCondition)this.getLeftOperand()).getXML());
        }
        cNode.addContainedObject(lNode);
        cNode.addProperty(a_operator, this.getOperator());
        ContainerNode rNode = new ContainerNode(a_rightOperand);
        if (this.getRightOperand() instanceof CompoundCondition) {
            rNode.addContainedObject(((CompoundCondition)this.getRightOperand()).getXML());
        } else {
            rNode.addContainedObject(((SimpleCondition)this.getRightOperand()).getXML());
        }
        cNode.addContainedObject(rNode);
        return cNode;
    }

    public boolean setXML(ContainerNode node) {
        PropertyNode pNode = node.getProperty(a_operator);
        if (pNode != null) {
            this.m_operator = pNode.getValueAsInteger();
        }
        Enumeration e = node.getContainedObject();
        while (e.hasMoreElements()) {
            Object o;
            Enumeration le;
            ContainerNode cNode = (ContainerNode)e.nextElement();
            if (cNode.getName().equals(a_leftOperand)) {
                le = cNode.getContainedObject();
                o = e.nextElement();
                if (o instanceof ContainerNode) {
                    this.m_leftOperand = new CompoundCondition();
                    ((CompoundCondition)this.m_leftOperand).setXML((ContainerNode)o);
                    continue;
                }
                this.m_leftOperand = new SimpleCondition();
                ((SimpleCondition)this.m_leftOperand).setXML((ObjectNode)o);
                continue;
            }
            if (cNode.getName().equals(a_rightOperand)) {
                le = cNode.getContainedObject();
                o = e.nextElement();
                if (o instanceof ContainerNode) {
                    this.m_rightOperand = new CompoundCondition();
                    ((CompoundCondition)this.m_rightOperand).setXML((ContainerNode)o);
                    continue;
                }
                this.m_rightOperand = new SimpleCondition();
                ((SimpleCondition)this.m_rightOperand).setXML((ObjectNode)o);
                continue;
            }
            return false;
        }
        return true;
    }
}

