/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.ide.datatransfer;

import java.util.Map;
import oracle.bm.ide.datatransfer.LazySelector;
import oracle.bm.javatools.datatransfer.Flavor;
import oracle.bm.javatools.datatransfer.FlavorSelector;
import oracle.bm.javatools.datatransfer.SelectorNode;
import oracle.bm.javatools.util.MultivaluedMap;

public class LazySelectorNode<T>
implements SelectorNode<T> {
    private LazySelector m_selector;
    private SelectorNode<T> m_selectorNode;
    private MultivaluedMap<Flavor, T> m_handlers = new MultivaluedMap();

    public LazySelectorNode(LazySelector selector) {
        this.m_selector = selector;
    }

    @Override
    public void addHandler(Flavor flavor, T handler) {
        if (this.m_selectorNode == null) {
            this.m_handlers.put(flavor, handler);
        } else {
            this.m_selectorNode.addHandler(flavor, handler);
        }
    }

    @Override
    public void getHandlers(Flavor flavor, MultivaluedMap<T, Flavor> handlers) {
        if (this.m_selectorNode == null) {
            FlavorSelector selector = this.m_selector.getSelector();
            if (selector == null) {
                return;
            }
            this.m_selectorNode = selector.createSelectorNode();
            for (Map.Entry<Flavor, T> e : this.m_handlers.entries()) {
                this.m_selectorNode.addHandler(e.getKey(), e.getValue());
            }
            this.m_handlers = null;
        }
        this.m_selectorNode.getHandlers(flavor, handlers);
    }
}

