/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.execute.DBRequestProcessor;
import oracle.ide.db.execute.DBRequestProcessorFactory;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ideimpl.db.explorer.model.DBExplorerElement;
import oracle.ideimpl.db.explorer.model.ExplorerModelHelper;
import oracle.ideimpl.db.explorer.resource.ExplorerBundle;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.icons.OracleIcons;

abstract class BaseFolder
implements Element,
Subject,
DBExplorerElement {
    private static final Collection<String> s_globallyIgnored = Arrays.asList("ID", "name", "SQLQuery", "code", "source", "bytes");
    private static final Iterator<String> s_tsKeyGen = DBUtil.getTimestampKeyGenerator((String)BaseFolder.class.getName());
    private final Collection<Observer> m_observers = new ArrayList<Observer>();
    private final List<Element> m_children = new CopyOnWriteArrayList<Element>();
    private ErrorsFolder m_errorsFolder;
    private boolean m_loaded;
    private boolean m_loading;
    private final Attributes m_attributes = new ElementAttributes();
    private final Comparator<Element> m_childComparator = (element, element2) -> this.compareChildren((Element)element, (Element)element2);
    private ExplorerModelHelper m_helper;
    private Element m_parentElement;

    BaseFolder() {
    }

    @Override
    public final void setHelper(ExplorerModelHelper explorerModelHelper) {
        if (explorerModelHelper != null) {
            this.m_helper = explorerModelHelper;
        }
    }

    protected final ExplorerModelHelper getHelper() {
        return this.m_helper;
    }

    protected final Element getParentElement() {
        return this.m_parentElement;
    }

    protected final void setParentElement(Element element) {
        this.m_parentElement = element;
    }

    @Override
    public void reset() {
        if (this.m_loaded && !this.m_loading) {
            this.m_loaded = false;
            this.initChildren();
        }
    }

    void setErrors(List<Element> list) {
        ErrorsFolder errorsFolder = this.m_errorsFolder;
        if (list == null) {
            this.m_errorsFolder = null;
            if (errorsFolder != null) {
                this.m_children.remove(errorsFolder);
                UpdateMessage.fireChildRemoved((Subject)this, (Element)errorsFolder);
            }
        } else {
            if (errorsFolder == null) {
                this.m_errorsFolder = new ErrorsFolder();
                this.m_errorsFolder.setHelper(this.getHelper());
            }
            this.m_errorsFolder.setErrors(list);
            if (errorsFolder == null) {
                this.m_children.add(0, this.m_errorsFolder);
                UpdateMessage.fireChildAdded((Subject)this, (Element)this.m_errorsFolder);
                UpdateMessage.fireStructureChanged((Subject)this);
            } else {
                UpdateMessage.fireStructureChanged((Subject)this.m_errorsFolder);
            }
        }
    }

    private synchronized List<Element> initChildren() {
        List<Element> list;
        ExplorerModelHelper explorerModelHelper = this.getHelper();
        if (!this.m_loaded && explorerModelHelper != null) {
            this.m_loading = true;
            this.m_loaded = true;
            final DBObjectProvider dBObjectProvider = this.useDBRunnable();
            if (dBObjectProvider == null) {
                list = this.loadChildren();
            } else {
                DBRequestProcessor dBRequestProcessor;
                LoadingElement loadingElement = new LoadingElement();
                list = this.m_children;
                if (this.m_children.size() == 0) {
                    this.m_children.add(loadingElement);
                    dBRequestProcessor = this.createChildAddedMessage();
                    dBRequestProcessor.getAddObjects().add(loadingElement);
                    this.notifyObservers(this, (UpdateMessage)dBRequestProcessor);
                }
                DBRequestProcessor dBRequestProcessor2 = dBRequestProcessor = DBRequestProcessorFactory.getProcessor((DBObjectNode)explorerModelHelper.getNode());
                dBRequestProcessor2.getClass();
                dBRequestProcessor.execute(new DBRequestProcessor.DBRunnable(dBRequestProcessor2, dBObjectProvider, loadingElement.getShortLabel()){
                    {
                        DBRequestProcessor dBRequestProcessor2 = dBRequestProcessor;
                        dBRequestProcessor2.getClass();
                        super(dBRequestProcessor2, dBObjectProvider3, string);
                    }

                    protected void doWork() {
                        String string = (String)s_tsKeyGen.next();
                        try {
                            DBUtil.suspendTimestampChecking((DBObjectProvider)dBObjectProvider, (String)string);
                            BaseFolder.this.loadChildren();
                        }
                        finally {
                            DBUtil.resumeTimestampChecking((DBObjectProvider)dBObjectProvider, (String)string);
                        }
                    }
                });
            }
        } else {
            list = this.m_children;
        }
        return list;
    }

    protected DBObjectProvider useDBRunnable() {
        return null;
    }

    protected final int compareChildren(Element element, Element element2) {
        if (element.mayHaveChildren()) {
            if (!element2.mayHaveChildren()) {
                return -1000;
            }
        } else if (element2.mayHaveChildren()) {
            return 1000;
        }
        return String.valueOf(element.getShortLabel()).toUpperCase().compareTo(String.valueOf(element2.getShortLabel()).toUpperCase());
    }

    protected boolean sortChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Element> loadChildren() {
        List<Element> list;
        this.m_loading = true;
        try {
            final List<Element> list2 = this.createChildren(this.m_children);
            list = list2;
            if (this.sortChildren()) {
                Collections.sort(list2, this.m_childComparator);
            }
            if (this.m_errorsFolder != null) {
                list2.add(0, this.m_errorsFolder);
            }
            final ArrayList<Element> arrayList = new ArrayList<Element>();
            final ArrayList<Element> arrayList2 = new ArrayList<Element>(this.m_children);
            for (Element element : list2) {
                if (element instanceof BaseFolder) {
                    ((BaseFolder)element).setParentElement(this);
                }
                if (element instanceof DBExplorerElement) {
                    ((DBExplorerElement)element).setHelper(this.getHelper());
                }
                if (!this.contains(this.m_children, element)) {
                    arrayList.add(element);
                    continue;
                }
                if (element instanceof DBExplorerElement) {
                    ((DBExplorerElement)element).reset();
                }
                arrayList2.remove(element);
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    BaseFolder.this.m_children.clear();
                    BaseFolder.this.m_children.addAll(list2);
                    BaseFolder.this.fireMessages(arrayList2, arrayList);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        catch (CancelledException cancelledException) {
            list = Collections.emptyList();
        }
        finally {
            this.m_loading = false;
        }
        return list;
    }

    protected void fireMessages(List<Element> list, List<Element> list2) {
        if (list.size() > 0) {
            UpdateMessage.fireChildrenRemoved((Subject)this, list);
        }
        if (list2.size() > 0) {
            UpdateMessage updateMessage = this.createChildAddedMessage();
            updateMessage.getAddObjects().addAll(list2);
            this.notifyObservers(this, updateMessage);
            UpdateMessage.fireStructureChanged((Subject)this);
        }
    }

    private UpdateMessage createChildAddedMessage() {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_ADDED, null);
        TreeExplorer.setSelectAddedChild((UpdateMessage)updateMessage, (boolean)false);
        return updateMessage;
    }

    private <T> boolean contains(List<? extends T> list, T t) {
        boolean bl = false;
        for (T t2 : list) {
            if (t2 != t) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected abstract List<Element> createChildren(List<Element> var1) throws CancelledException;

    public boolean mayHaveChildren() {
        return true;
    }

    public final Iterator<Element> getChildren() {
        return Collections.unmodifiableList(this.initChildren()).iterator();
    }

    public void notifyObservers(Object object, UpdateMessage updateMessage) {
        for (Observer observer : this.m_observers) {
            observer.update(object, updateMessage);
        }
    }

    public void detach(Observer observer) {
        this.m_observers.remove(observer);
    }

    public void attach(Observer observer) {
        this.m_observers.add(observer);
    }

    public final Object getData() {
        return this;
    }

    public final Attributes getAttributes() {
        return this.m_attributes;
    }

    public String getToolTipText() {
        return null;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    protected boolean isIgnoredProperty(PropertyInfo propertyInfo, DBObjectProvider dBObjectProvider, Object object) {
        String string;
        String string2;
        boolean bl = propertyInfo.isInternal() || propertyInfo.isDeprecated() || propertyInfo.isTextPassword() ? true : (s_globallyIgnored.contains(string2 = propertyInfo.getPropertyName()) ? true : (object instanceof DBObject ? (string = PropertyDisplayRegistry.getDisplayNameOrNull((String)string2, (DBObjectProvider)dBObjectProvider, (DBObject)((DBObject)object))) == null : false));
        return bl;
    }

    private class ErrorsFolder
    extends BaseFolder {
        private List<Element> m_errors;

        private ErrorsFolder() {
        }

        @Override
        void setErrors(List<Element> list) {
            if (this.m_errors != null) {
                UpdateMessage.fireChildrenRemoved((Subject)this, this.m_errors);
            }
            this.m_errors = list;
            if (list != null) {
                UpdateMessage.fireChildrenAdded((Subject)this, list);
            }
        }

        @Override
        protected List<Element> createChildren(List<Element> list) {
            return this.m_errors == null ? Collections.emptyList() : this.m_errors;
        }

        public Icon getIcon() {
            return OracleIcons.getIcon((String)"folder.png");
        }

        @Override
        public Object getKey() {
            return "ERRORS";
        }

        @Override
        public String getLongLabel() {
            return this.getShortLabel();
        }

        public String getShortLabel() {
            return ExplorerBundle.get("EXPLORER_ERROR_FOLDER");
        }
    }

    private final class LoadingElement
    extends DefaultElement
    implements DBExplorerElement {
        private LoadingElement() {
        }

        @Override
        public Object getKey() {
            return this;
        }

        @Override
        public void reset() {
        }

        @Override
        public void setHelper(ExplorerModelHelper explorerModelHelper) {
        }

        public String getShortLabel() {
            return ExplorerBundle.format("EXPLORER_PROGRESS_MESSAGE", BaseFolder.this.getShortLabel());
        }
    }
}

