/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;

public abstract class DBObjectLister {
    private final DBObjectProvider m_pro;

    protected DBObjectLister(DBObjectProvider dBObjectProvider) {
        this.m_pro = dBObjectProvider;
    }

    protected DBObjectProvider getProvider() {
        return this.m_pro;
    }

    public abstract Collection<ObjectInfo> listObjects(DBObjectCriteria var1) throws DBException;

    public boolean supportsTimestamps(String string) {
        return false;
    }

    public Long getExternalTimestamp(SystemObject systemObject) throws DBException {
        return null;
    }

    public boolean equals(Object object) {
        return object instanceof DBObjectLister && this.getClass().equals(object.getClass()) && this.m_pro == ((DBObjectLister)object).m_pro;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class ObjectInfo {
        private final String m_type;
        private final Schema m_schema;
        private final String m_name;
        private final Object m_idVal;
        private final Long m_timestamp;

        public ObjectInfo(String string, String string2) {
            this(string, null, string2, null, null);
        }

        public ObjectInfo(String string, Schema schema, String string2) {
            this(string, schema, string2, null, null);
        }

        public ObjectInfo(String string, Schema schema, String string2, Object object) {
            this(string, schema, string2, null, null);
        }

        public ObjectInfo(String string, Schema schema, String string2, Object object, Long l) {
            this.m_type = string;
            this.m_schema = schema;
            this.m_name = string2;
            this.m_idVal = object;
            this.m_timestamp = l;
        }

        public String getType() {
            return this.m_type;
        }

        public Schema getSchema() {
            return this.m_schema;
        }

        public String getName() {
            return this.m_name;
        }

        public Object getIdentifier() {
            return this.m_idVal;
        }

        public Long getTimestamp() {
            return this.m_timestamp;
        }
    }
}

