/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.BuiltInObjectCache;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.DatabaseRegistry;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.plsql.DefaultSourceOptions;
import oracle.javatools.db.plsql.parser.PlSqlParserFactory;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.property.PropertyInitializer;
import oracle.javatools.db.refactoring.UpdateProcessor;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SqlAliasExpander;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

public abstract class DatabaseDescriptor {
    @Deprecated
    public static final String FEATURE_TABLE_PARTITIONING = "TABLE PARTITIONING";
    @Deprecated
    public static final String FEATURE_GLOBAL_HASH_INDEX_PARTITIONING = "GLOBAL HASH INDEX PARTITIONING";
    @Deprecated
    public static final String FEATURE_COLUMN_SEQUENCES = "COLUMN SEQUENCES";
    @Deprecated
    public static final String FEATURE_STORAGE_OPTIONS = "STORAGE OPTIONS";
    @Deprecated
    public static final String FEATURE_BITMAP_INDEXING = "BITMAP INDEXING";
    @Deprecated
    public static final String FEATURE_LOB_PARAMETERS = "LOB PARAMETERS";
    @Deprecated
    public static final String FEATURE_MAXTRANS = "MAXTRANS";
    @Deprecated
    public static final String FEATURE_XMLTYPE_COL_PROPS = "XMLTYPE COLUMN STORAGE PROPERTIES";
    public static final String BUILT_IN_OBJECT = "BUILT_IN_OBJECT";
    private DatabaseDescriptor m_base;
    private Charset m_ideCharset;
    private final Class<? extends Database> m_databaseClass;
    private DefaultSourceOptions m_defaultSourceOptions;
    private BuiltInObjectCache m_builtInObjs;
    private DataTypeCache m_dataTypes;

    protected DatabaseDescriptor(Class<? extends Database> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Descriptor class cannot be null");
        }
        this.m_databaseClass = clazz;
    }

    protected DatabaseDescriptor(DatabaseDescriptor databaseDescriptor) {
        this(databaseDescriptor.getDatabaseClass());
        this.m_base = databaseDescriptor;
    }

    protected final Class<? extends Database> getDatabaseClass() {
        if (this.m_databaseClass == null) {
            return this.m_base.getDatabaseClass();
        }
        return this.m_databaseClass;
    }

    public final String getDatabaseName() {
        return DatabaseRegistry.getInstance().getDatabaseName(this.getDatabaseType(), this.getDatabaseVersion());
    }

    public abstract String getDatabaseType();

    public abstract int getDatabaseVersion();

    protected DatabaseDescriptor getBaseDescriptor() {
        return this.m_base;
    }

    public void setIdeCharset(Charset charset) {
        this.m_ideCharset = charset;
    }

    public Charset getIdeCharset() {
        return this.m_ideCharset;
    }

    public boolean isSameDatabase(DatabaseDescriptor databaseDescriptor) {
        return databaseDescriptor != null && ModelUtil.areEqual((Object)this.getDatabaseType(), (Object)databaseDescriptor.getDatabaseType()) && this.getDatabaseVersion() == databaseDescriptor.getDatabaseVersion();
    }

    public boolean isCompatibleWith(DatabaseDescriptor databaseDescriptor) {
        boolean bl = false;
        bl = this.m_base != null ? this.m_base.isCompatibleWith(databaseDescriptor) : (databaseDescriptor.m_base != null ? this.isCompatibleWith(databaseDescriptor.m_base) : ModelUtil.areEqual((Object)this.getDatabaseType(), (Object)databaseDescriptor.getDatabaseType()) && this.getDatabaseVersion() <= databaseDescriptor.getDatabaseVersion());
        return bl;
    }

    @Deprecated
    public final boolean isCompatibleUpgrade(Class<? extends Database> clazz, Class<? extends Database> clazz2) {
        DatabaseDescriptor databaseDescriptor = DatabaseFactory.getDatabaseDescriptor(clazz);
        DatabaseDescriptor databaseDescriptor2 = DatabaseFactory.getDatabaseDescriptor(clazz2);
        return databaseDescriptor != null && databaseDescriptor.isCompatibleWith(databaseDescriptor2);
    }

    public List<DatabaseDescriptor> listCompatibleUpgrades() {
        ArrayList<DatabaseDescriptor> arrayList = new ArrayList<DatabaseDescriptor>();
        DatabaseRegistry databaseRegistry = DatabaseRegistry.getInstance();
        String string = this.getDatabaseType();
        for (int n : databaseRegistry.listDatabaseVersions(string)) {
            DatabaseDescriptor databaseDescriptor;
            if (n == this.getDatabaseVersion() || !this.isCompatibleWith(databaseDescriptor = databaseRegistry.getDatabaseDescriptor(string, n))) continue;
            arrayList.add(databaseDescriptor);
        }
        return arrayList;
    }

    public final boolean isValidName(String string, String string2) {
        try {
            this.validateName(string, string2);
        }
        catch (InvalidNameException invalidNameException) {
            return false;
        }
        return true;
    }

    public abstract void validateName(String var1, String var2) throws InvalidNameException;

    public abstract int getCasePolicy();

    @Deprecated
    public int getQuotedNameCasePolicy() {
        return this.getCasePolicy() == 0 ? 0 : 3;
    }

    public final boolean areNamesEqual(DBObject dBObject, DBObject dBObject2) {
        String string = dBObject == null ? null : dBObject.getName();
        String string2 = dBObject2 == null ? null : dBObject2.getName();
        boolean bl = true;
        if (string != null || string2 != null) {
            String string3 = dBObject == null ? dBObject2.getType() : dBObject.getType();
            bl = this.areNamesEqual(string, string2, string3, false);
        }
        return bl;
    }

    public boolean areNamesEqual(String string, String string2, String string3, boolean bl) {
        boolean bl2;
        if (string == string2) {
            bl2 = true;
        } else if (string == null || string2 == null) {
            bl2 = false;
        } else {
            String string4 = bl ? this.getInternalName(string, string3) : string;
            String string5 = bl ? this.getInternalName(string2, string3) : string2;
            int n = this.getCasePolicy();
            bl2 = n == 0 ? string4.equalsIgnoreCase(string5) : string4.equals(string5);
        }
        return bl2;
    }

    public abstract String getIdentifierQuoteString();

    public abstract int getMaxNameLength(String var1);

    @Deprecated
    public boolean supportsFeature(String string) {
        if (this.m_base != null) {
            return this.m_base.supportsFeature(string);
        }
        return false;
    }

    public void validateEncoding(String string, Object object) throws ValidationException {
    }

    protected boolean needsQuoting(String string) {
        boolean bl;
        if (this.m_base != null) {
            bl = this.m_base.needsQuoting(string);
        } else if (ModelUtil.hasLength((String)string) && string.length() == string.trim().length()) {
            if (this.isValidName(null, string)) {
                switch (this.getCasePolicy()) {
                    case 2: {
                        bl = ModelUtil.areDifferent((Object)string, (Object)string.toUpperCase());
                        break;
                    }
                    case 1: {
                        bl = ModelUtil.areDifferent((Object)string, (Object)string.toLowerCase());
                        break;
                    }
                    default: {
                        bl = false;
                        break;
                    }
                }
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public String quoteIdentifier(String string, boolean bl) throws InvalidNameException {
        String string2;
        if (this.m_base != null) {
            return this.m_base.quoteIdentifier(string, bl);
        }
        String string3 = this.getIdentifierQuoteString();
        String string4 = string3 = string3 != null ? string3.trim() : "";
        if (ModelUtil.hasLength((String)string)) {
            if (string3.length() == 0) {
                this.validateName(null, string);
                string2 = string;
            } else if (bl || this.needsQuoting(string)) {
                String string5 = this.escapeQuoteCharacter(string3);
                String string6 = string3 + string.replaceAll(Pattern.quote(string3), string5) + string3;
                this.validateName(null, string6);
                string2 = string6;
            } else {
                string2 = string;
            }
        } else {
            throw new InvalidNameException(null, APIBundle.get("INVALID_IDENTIFIER_NO_NAME"));
        }
        return string2;
    }

    protected String escapeQuoteCharacter(String string) {
        String string2 = this.m_base != null ? this.m_base.escapeQuoteCharacter(string) : (string.equals("\"") ? "\\" + string : string + string);
        return string2;
    }

    public String getInternalName(String string, String string2) {
        if (this.m_base != null) {
            return this.m_base.getInternalName(string, string2);
        }
        String string3 = this.getIdentifierQuoteString();
        int n = this.getCasePolicy();
        String string4 = string;
        if (ModelUtil.hasLength((String)string)) {
            string = string.trim();
            if (ModelUtil.hasLength((String)string3)) {
                int n2 = string3.length();
                int n3 = string.length();
                int n4 = string.indexOf(string3);
                int n5 = string.lastIndexOf(string3);
                if (n3 > n2 && n4 == 0 && n5 == n3 - n2) {
                    string4 = string.substring(n4 + n2, n5);
                    boolean bl = this.canIncludePath(string2);
                    n4 = string4.indexOf(string3);
                    while (n4 > -1 && n4 < string4.length()) {
                        n5 = string4.indexOf(string3, n4 + n2);
                        if (n5 == n4 + n2) {
                            string4 = string4.substring(0, n4 + 1) + string4.substring(n5 + n2);
                        } else if (bl && n5 == n4 + n2 + 1 && string4.charAt(n5 - 1) == '.') {
                            string4 = string4.substring(0, n4) + '.' + string4.substring(n5 + n2);
                        }
                        n4 = string4.indexOf(string3, n4 + n2);
                    }
                }
            }
            if (ModelUtil.areEqual((Object)string4, (Object)string)) {
                switch (n) {
                    case 2: {
                        string4 = string.toUpperCase();
                        break;
                    }
                    case 1: {
                        string4 = string.toLowerCase();
                        break;
                    }
                }
            }
        }
        return string4;
    }

    private boolean canIncludePath(String string) {
        return "SQLFragment".equals(string);
    }

    public String getExternalName(String string, String string2) {
        String string3;
        try {
            string3 = this.quoteIdentifier(string, false);
        }
        catch (InvalidNameException invalidNameException) {
            string3 = string;
        }
        return string3;
    }

    public final Collection<String> listSchemaNamespaceTypes(DBObjectProvider dBObjectProvider) {
        ArrayList<String> arrayList;
        if (this.m_base == null) {
            arrayList = new ArrayList();
            for (Map.Entry<String, DBObjectValidator> entry : this.getValidators(dBObjectProvider).entrySet()) {
                DBObjectValidator dBObjectValidator = entry.getValue();
                if (dBObjectValidator != null && dBObjectValidator.getNamespaceType() != DBObjectValidator.NamespaceType.SCHEMA) continue;
                arrayList.add(entry.getKey());
            }
        } else {
            arrayList = this.m_base.listSchemaNamespaceTypes(dBObjectProvider);
        }
        return arrayList;
    }

    public abstract Map<String, DBObjectValidator> getValidators(DBObjectProvider var1);

    public DBObjectLister getTriggerLister(DBObjectProvider dBObjectProvider) {
        return null;
    }

    public List<PropertyInitializer> getPropertyInitializers(DBObjectProvider dBObjectProvider) {
        if (this.m_base != null) {
            return this.m_base.getPropertyInitializers(dBObjectProvider);
        }
        return Collections.emptyList();
    }

    @Deprecated
    public List<PropertyInitializer> getExternalPropertyDefaulters(DBObjectProvider dBObjectProvider) {
        if (this.m_base != null) {
            return this.m_base.getExternalPropertyDefaulters(dBObjectProvider);
        }
        return Collections.emptyList();
    }

    public List<UpdateProcessor> getUpdateProcessors() {
        if (this.m_base != null) {
            return this.m_base.getUpdateProcessors();
        }
        return Collections.emptyList();
    }

    public DDLGenerator getDDLGenerator(DBObjectProvider dBObjectProvider) {
        DDLGenerator dDLGenerator = null;
        if (this.m_base != null) {
            dDLGenerator = this.m_base.getDDLGenerator(dBObjectProvider);
        }
        return dDLGenerator;
    }

    public SQLQueryBuilderFactory getSQLQueryBuilderFactory() {
        SQLQueryBuilderFactory sQLQueryBuilderFactory = null;
        if (this.m_base != null) {
            sQLQueryBuilderFactory = this.m_base.getSQLQueryBuilderFactory();
        }
        return sQLQueryBuilderFactory;
    }

    public PlSqlParserFactory getPlSqlParserFactory(DBObjectProvider dBObjectProvider) {
        PlSqlParserFactory plSqlParserFactory = null;
        if (this.m_base != null) {
            plSqlParserFactory = this.m_base.getPlSqlParserFactory(dBObjectProvider);
        }
        return plSqlParserFactory;
    }

    public DerivedPropertyBuilder getDerivedPropertyBuilder(Class<? extends AbstractBuildableObject> clazz, DBObjectProvider dBObjectProvider) {
        DerivedPropertyBuilder derivedPropertyBuilder = null;
        if (this.m_base != null) {
            derivedPropertyBuilder = this.m_base.getDerivedPropertyBuilder(clazz, dBObjectProvider);
        }
        return derivedPropertyBuilder;
    }

    public boolean supportsRowID(DBObjectProvider dBObjectProvider, String string) {
        boolean bl = false;
        if (this.m_base != null) {
            bl = this.m_base.supportsRowID(dBObjectProvider, string);
        }
        return bl;
    }

    public Collection<DataType> listSupportedDataTypes() {
        Collection<DataType> collection = null;
        if (this.m_base == null) {
            Object object;
            TreeMap<String, DataType> treeMap = null;
            Iterator<DataTypeCache> iterator = this.getDataTypeCaches();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (object == null) continue;
                if (treeMap == null) {
                    treeMap = new TreeMap<String, DataType>();
                }
                for (DataType dataTypeArray : ((DataTypeCache)object).listSupportedDataTypes()) {
                    String string = dataTypeArray.getName();
                    if (treeMap.containsKey(string)) continue;
                    treeMap.put(string, dataTypeArray);
                }
            }
            if (treeMap == null) {
                collection = new ArrayList<DataType>();
                object = DataTypeRegistry.getInstance();
                Class<? extends Database> clazz = this.getDatabaseClass();
                if (clazz != null && ((DataTypeRegistry)object).isRegistered(clazz)) {
                    for (DataType dataType : ((DataTypeRegistry)object).listDataTypes(clazz)) {
                        collection.add(dataType);
                    }
                }
            } else {
                collection = new ArrayList(treeMap.values());
            }
        } else {
            collection = this.m_base.listSupportedDataTypes();
        }
        return collection;
    }

    public final Collection<DataType> listPreferredDataTypes() {
        ArrayList<DataType> arrayList = new ArrayList<DataType>();
        for (String string : this.listPreferredDataTypeNames()) {
            DataType dataType = this.getDataType(string);
            if (dataType == null) continue;
            arrayList.add(dataType);
        }
        return arrayList;
    }

    public Collection<String> listPreferredDataTypeNames() {
        Collection<String> collection = this.m_base == null ? Collections.emptyList() : this.m_base.listPreferredDataTypeNames();
        return collection;
    }

    public DataTypeUsage createDefaultTypeUsage() {
        DataTypeUsage dataTypeUsage = null;
        if (this.m_base == null) {
            Collection<DataType> collection = this.listPreferredDataTypes();
            if (collection.size() > 0) {
                dataTypeUsage = collection.iterator().next().createDefaultUsage();
            }
            if (dataTypeUsage == null) {
                dataTypeUsage = this.findDataType("VARCHAR2", "VARCHAR", "CHAR", "CHARACTER");
            }
        } else {
            dataTypeUsage = this.m_base.createDefaultTypeUsage();
        }
        return dataTypeUsage;
    }

    public DataTypeUsage createDefaultNumericTypeUsage() {
        DataTypeUsage dataTypeUsage = null;
        if (this.m_base == null) {
            Collection<DataType> collection = this.listPreferredDataTypes();
            for (DataType dataType : collection) {
                if (!ModelUtil.areEqual((Object)2, (Object)dataType.getSQLType())) continue;
                dataTypeUsage = dataType.createDefaultUsage();
                break;
            }
            if (dataTypeUsage == null) {
                dataTypeUsage = this.findDataType("NUMBER", "NUMERIC", "INTEGER", "INT");
            }
        } else {
            dataTypeUsage = this.m_base.createDefaultNumericTypeUsage();
        }
        return dataTypeUsage;
    }

    private DataTypeUsage findDataType(String ... stringArray) {
        String string;
        DataType dataType = null;
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n && (dataType = this.getDataType(string = stringArray2[i])) == null; ++i) {
        }
        return dataType == null ? null : dataType.createDefaultUsage();
    }

    public DataType getDataType(String string) {
        DataType dataType = null;
        if (this.m_base == null) {
            Object object;
            string = string.trim().toUpperCase();
            boolean bl = false;
            Iterator<DataTypeCache> iterator = this.getDataTypeCaches();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (object == null) continue;
                bl = true;
                dataType = ((DataTypeCache)object).getDataType(string);
                if (dataType == null) continue;
                break;
            }
            if (!bl) {
                object = DataTypeRegistry.getInstance();
                Class<? extends Database> clazz = this.getDatabaseClass();
                if (clazz != null && ((DataTypeRegistry)object).isRegistered(clazz)) {
                    dataType = ((DataTypeRegistry)object).findDataType(string, clazz);
                }
            }
        } else {
            dataType = this.m_base.getDataType(string);
        }
        return dataType;
    }

    protected final Iterator<DataTypeCache> getDataTypeCaches() {
        return new VersionIterator<DataTypeCache>(){

            @Override
            protected DataTypeCache getVersion(DatabaseDescriptor databaseDescriptor) {
                if (databaseDescriptor.m_dataTypes == null) {
                    databaseDescriptor.m_dataTypes = DatabaseRegistry.getInstance().getDataTypeCache(databaseDescriptor.getDatabaseType(), databaseDescriptor.getDatabaseVersion());
                }
                return databaseDescriptor.m_dataTypes;
            }
        };
    }

    protected void registerDataTypes(DataTypeCache dataTypeCache) {
    }

    protected final Iterator<BuiltInObjectCache> getBuiltInObjectCaches() {
        return new VersionIterator<BuiltInObjectCache>(){

            @Override
            protected BuiltInObjectCache getVersion(DatabaseDescriptor databaseDescriptor) {
                if (databaseDescriptor.m_builtInObjs == null) {
                    databaseDescriptor.m_builtInObjs = DatabaseRegistry.getInstance().getBuiltInObjectCache(databaseDescriptor.getDatabaseType(), databaseDescriptor.getDatabaseVersion());
                }
                return databaseDescriptor.m_builtInObjs;
            }
        };
    }

    protected void registerBuiltInObjects(BuiltInObjectCache builtInObjectCache) {
    }

    public final <T extends SystemObject> T getBuiltInObject(DBObjectCriteria<T> dBObjectCriteria) {
        SystemObject systemObject = null;
        Collection<T> collection = this.listBuiltInObjects(dBObjectCriteria);
        if (collection != null && collection.size() == 1) {
            systemObject = (SystemObject)collection.iterator().next();
        }
        return (T)systemObject;
    }

    public final <T extends SystemObject> Collection<T> listBuiltInObjects(DBObjectCriteria<T> dBObjectCriteria) {
        Collection<T> collection;
        if (this.m_base == null) {
            collection = this.listBuiltInObjectsImpl(dBObjectCriteria);
            for (SystemObject systemObject : collection) {
                this.initialiseBuiltInObject(systemObject);
            }
        } else {
            collection = this.m_base.listBuiltInObjects(dBObjectCriteria);
        }
        return collection;
    }

    protected <T extends SystemObject> Collection<T> listBuiltInObjectsImpl(DBObjectCriteria<T> dBObjectCriteria) {
        TreeSet<DBObject> treeSet = null;
        Iterator<BuiltInObjectCache> iterator = this.getBuiltInObjectCaches();
        while (iterator.hasNext()) {
            Collection<T> collection;
            BuiltInObjectCache builtInObjectCache = iterator.next();
            if (builtInObjectCache == null || (collection = builtInObjectCache.listBuiltInObjects(dBObjectCriteria)) == null || collection.size() <= 0) continue;
            if (treeSet == null) {
                treeSet = new TreeSet<DBObject>(DBUtil.getTypeComparator());
            }
            for (SystemObject systemObject : collection) {
                if (treeSet.contains(systemObject)) continue;
                treeSet.add((SystemObject)systemObject.copyTo(null, new IDPolicy.SameIDPolicy()));
            }
        }
        return treeSet == null ? Collections.emptyList() : treeSet;
    }

    protected void initialiseBuiltInObject(SystemObject systemObject) {
        systemObject.setProperty(BUILT_IN_OBJECT, Boolean.TRUE);
    }

    public String getPublicSchemaName() {
        String string = null;
        if (this.m_base != null) {
            string = this.m_base.getPublicSchemaName();
        }
        return string;
    }

    public String getDefaultSchemaName() {
        String string = null;
        if (this.m_base != null) {
            string = this.m_base.getDefaultSchemaName();
        }
        return string;
    }

    public String getSchemaDisplayName() {
        String string = this.m_base == null ? DisplayNames.getPropertyDisplayName("schema") : this.m_base.getSchemaDisplayName();
        return string;
    }

    public final boolean isValidFKDataType(DataType dataType, DataType dataType2) {
        PredefinedDataType predefinedDataType;
        PredefinedDataType predefinedDataType2 = DataTypeHelper.unwrapDataType(dataType, PredefinedDataType.class);
        if (predefinedDataType2 != null) {
            dataType = predefinedDataType2;
        }
        if ((predefinedDataType = DataTypeHelper.unwrapDataType(dataType2, PredefinedDataType.class)) != null) {
            dataType2 = predefinedDataType;
        }
        return this.isValidFKDataTypeImpl(dataType, dataType2);
    }

    protected boolean isValidFKDataTypeImpl(DataType dataType, DataType dataType2) {
        boolean bl;
        if (this.m_base == null) {
            bl = ModelUtil.areEqual((Object)dataType, (Object)dataType2);
            if (!bl && dataType instanceof PredefinedDataType && dataType2 instanceof PredefinedDataType) {
                bl = this.isValidFKDataTypeValueTypeImpl(((PredefinedDataType)dataType).getValueType(), ((PredefinedDataType)dataType2).getValueType());
            }
        } else {
            bl = this.m_base.isValidFKDataTypeImpl(dataType, dataType2);
        }
        return bl;
    }

    protected boolean isValidFKDataTypeValueTypeImpl(PredefinedDataType.ValueType valueType, PredefinedDataType.ValueType valueType2) {
        return valueType == valueType2 && PredefinedDataType.ValueType.isNumericType(valueType);
    }

    @Deprecated
    public void makeNameValidAndUnique(DBObject dBObject, DBObjectProvider dBObjectProvider) throws InvalidNameException {
        if (dBObject != null) {
            String string = dBObject.getType();
            String string2 = dBObjectProvider.getInternalName(dBObject.getName(), string);
            dBObject.setName(dBObjectProvider.getUniqueName(string, dBObject, string2));
        }
    }

    public Collection<String> getReservedWords() {
        return Collections.emptySet();
    }

    public SqlAliasExpander getSqlAliasExpander(DBObjectProvider dBObjectProvider) {
        return this.getSqlAliasExpander(dBObjectProvider, null);
    }

    public SqlAliasExpander getSqlAliasExpander(DBObjectProvider dBObjectProvider, Schema schema) {
        if (this.m_base != null) {
            return this.m_base.getSqlAliasExpander(dBObjectProvider, schema);
        }
        return null;
    }

    public final DefaultSourceOptions getDefaultSourceOptions() {
        if (this.m_base != null) {
            return this.m_base.getDefaultSourceOptions();
        }
        if (this.m_defaultSourceOptions == null) {
            this.m_defaultSourceOptions = new DefaultSourceOptions();
            this.initialiseDefaultSourceOptions(this.m_defaultSourceOptions);
        }
        return this.m_defaultSourceOptions;
    }

    protected void initialiseDefaultSourceOptions(DefaultSourceOptions defaultSourceOptions) {
    }

    public boolean isNullConstraintColumnAllowed(ColumnConstraint columnConstraint) {
        if (this.m_base != null) {
            return this.m_base.isNullConstraintColumnAllowed(columnConstraint);
        }
        return !(columnConstraint instanceof PKConstraint) || !columnConstraint.isEnabled();
    }

    public final List<BuiltInFunction> listBuiltInFunctions() {
        return this.listBuiltInFunctions(null);
    }

    public final List<BuiltInFunction> listBuiltInFunctions(String string) {
        if (this.m_base != null) {
            return this.m_base.listBuiltInFunctions(string);
        }
        ArrayList<BuiltInFunction> arrayList = new ArrayList<BuiltInFunction>();
        Iterator<BuiltInObjectCache> iterator = this.getBuiltInObjectCaches();
        while (iterator.hasNext()) {
            BuiltInObjectCache builtInObjectCache = iterator.next();
            if (builtInObjectCache == null) continue;
            for (BuiltInFunction builtInFunction : builtInObjectCache.listBuiltInFunctions()) {
                if (string != null && !string.equals(builtInFunction.getName())) continue;
                arrayList.add(builtInFunction);
            }
        }
        return arrayList;
    }

    public String getBuiltInFunctionDescription(BuiltInFunction builtInFunction) {
        if (this.m_base != null) {
            return this.m_base.getBuiltInFunctionDescription(builtInFunction);
        }
        return null;
    }

    public boolean allowSurrogatesInIdentifierValidation() {
        return false;
    }

    public static void validateIdentifier(String string, char c, int n, String string2, String string3, boolean bl, Set set, int n2, boolean bl2) throws InvalidNameException {
        int n3 = string.length();
        int n4 = string.codePointCount(0, n3);
        if (!ModelUtil.hasLength((String)string)) {
            throw new InvalidNameException(null, APIBundle.get("INVALID_IDENTIFIER_NO_NAME"));
        }
        if (string.charAt(0) == c) {
            if (string.charAt(n3 - 1) != c) {
                throw new InvalidNameException(null, APIBundle.format("INVALID_IDENTIFIER_MISSING_CLOSING_QUOTE", string));
            }
            if (n3 <= 2) {
                throw new InvalidNameException(null, APIBundle.format("INVALID_IDENTIFIER_NO_NAME", string));
            }
            int n5 = 0;
            for (int i = 1; i < n3 - 1; ++i) {
                if (string3 != null && string3.indexOf(string.charAt(i)) >= 0) {
                    throw new InvalidNameException(null, APIBundle.format("INVALID_IDENTIFIER_ILLEGAL_CHARACTER", string));
                }
                if (string.charAt(i) != c) continue;
                if (++i == n3 - 1 || string.charAt(i) != c) {
                    throw new InvalidNameException(null, APIBundle.format("INVALID_IDENTIFIER_ILLEGAL_CHARACTER", string));
                }
                ++n5;
            }
            if (n4 - n5 > n + 2) {
                throw new InvalidNameException(null, APIBundle.format("INVALID_IDENTIFIER_TOO_LONG", string));
            }
        } else {
            if (n4 > n) {
                throw new InvalidNameException(null, APIBundle.format("INVALID_IDENTIFIER_TOO_LONG", string));
            }
            if (n2 == 2) {
                string = string.toUpperCase();
            } else if (n2 == 1) {
                string = string.toLowerCase();
            }
            if (set != null && set.contains(string)) {
                throw new InvalidNameException(null, APIBundle.format("INVALID_IDENTIFIER_RESERVED_WORD", string));
            }
            if (bl && !Character.isAlphabetic(string.codePointAt(0))) {
                throw new InvalidNameException(null, APIBundle.format("INVALID_IDENTIFIER_NON_ALPHA_START", string));
            }
            if (string2 != null) {
                IntStream intStream = string.codePoints();
                PrimitiveIterator.OfInt ofInt = intStream.iterator();
                while (ofInt.hasNext()) {
                    boolean bl3;
                    Integer n6 = (Integer)ofInt.next();
                    boolean bl4 = bl3 = Character.isAlphabetic(n6) || Character.isDigit(n6);
                    if ((bl2 || !Character.isSupplementaryCodePoint(n6)) && (bl3 || string2.indexOf(n6) >= 0)) continue;
                    throw new InvalidNameException(null, APIBundle.format("INVALID_IDENTIFIER_ILLEGAL_CHARACTER", string));
                }
            }
        }
    }

    public static void validateIdentifier(String string, char c, int n, String string2, boolean bl, Set set, int n2, boolean bl2) throws InvalidNameException {
        DatabaseDescriptor.validateIdentifier(string, c, n, string2, null, bl, set, n2, bl2);
    }

    private abstract class VersionIterator<C>
    implements Iterator<C> {
        private Integer m_last;
        private List<Integer> m_versions;

        private VersionIterator() {
        }

        private List<Integer> getVersions() {
            if (this.m_versions == null) {
                this.m_versions = DatabaseRegistry.getInstance().listDatabaseVersions(DatabaseDescriptor.this.getDatabaseType());
            }
            return this.m_versions;
        }

        protected abstract C getVersion(DatabaseDescriptor var1);

        @Override
        public boolean hasNext() {
            boolean bl = false;
            List<Integer> list = this.getVersions();
            if (list.size() > 0) {
                bl = this.m_last == null ? true : this.m_last > 0 && this.m_last > list.get(0);
            }
            return bl;
        }

        @Override
        public C next() {
            DatabaseDescriptor databaseDescriptor;
            if (this.m_last == null) {
                databaseDescriptor = DatabaseDescriptor.this;
            } else {
                List<Integer> list = this.getVersions();
                int n = list.get(list.indexOf(this.m_last) - 1);
                databaseDescriptor = DatabaseRegistry.getInstance().getDatabaseDescriptor(DatabaseDescriptor.this.getDatabaseType(), n);
            }
            this.m_last = databaseDescriptor != null ? Integer.valueOf(databaseDescriptor.getDatabaseVersion()) : Integer.valueOf(0);
            return this.getVersion(databaseDescriptor);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

