/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.BuiltInObjectCache;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.extension.ConnectionMatcher;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

public final class DatabaseRegistry {
    private final MultiMap<String, DatabaseIdentifier> m_databases = new MultiMap();
    private final Map<String, ClassLoader> m_classloaders = new HashMap<String, ClassLoader>();

    private DatabaseRegistry() {
    }

    private Logger getLogger() {
        return DBLog.getLogger(this);
    }

    void checkInit() {
        DBCore.checkExtensionInitialization();
    }

    @Deprecated
    public void registerDatabase(String string, int n, String string2, String string3, String string4, ClassLoader classLoader) {
        this.registerDatabases(string, string4, classLoader, null, new DatabaseVersion(n, string2, string3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDatabases(String string, String string2, ClassLoader classLoader, ConnectionMatcher connectionMatcher, DatabaseVersion ... databaseVersionArray) {
        DatabaseFactory databaseFactory = DatabaseFactory.getInstance();
        boolean bl = "Generic JDBC".equals(string);
        if (string != null && databaseVersionArray != null) {
            MultiMap<String, DatabaseIdentifier> multiMap = this.m_databases;
            synchronized (multiMap) {
                for (DatabaseVersion databaseVersion : databaseVersionArray) {
                    if (bl && databaseVersion.m_version != 0) {
                        throw new IllegalArgumentException("Cannot register new versions for Generic JDBC");
                    }
                    this.m_databases.add((Object)string, (Object)new DatabaseIdentifier(string, databaseVersion));
                    if (classLoader != null) {
                        this.m_classloaders.put(databaseVersion.m_dbImplClassName, classLoader);
                    }
                    databaseFactory.registerDatabaseImplementation(databaseVersion.m_dbImplClassName, string2);
                }
            }
        }
        if (bl) {
            databaseFactory.setJdbcDatabaseCreator(string2);
        } else {
            databaseFactory.registerDatabaseCreator(string2, classLoader, connectionMatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> listDatabaseTypes() {
        this.checkInit();
        MultiMap<String, DatabaseIdentifier> multiMap = this.m_databases;
        synchronized (multiMap) {
            return new ArrayList<String>(this.m_databases.keySet());
        }
    }

    public List<Integer> listDatabaseVersions(String string) {
        return this.listDatabaseVersions(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> listDatabaseVersions(String string, boolean bl) {
        this.checkInit();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        MultiMap<String, DatabaseIdentifier> multiMap = this.m_databases;
        synchronized (multiMap) {
            Collection collection = this.m_databases.get((Object)string);
            if (collection != null) {
                for (DatabaseIdentifier databaseIdentifier : collection) {
                    if (!bl && databaseIdentifier.m_legacy) continue;
                    arrayList.add(databaseIdentifier.m_version);
                }
                Collections.sort(arrayList);
            }
        }
        return arrayList;
    }

    public DatabaseDescriptor getDatabaseDescriptor(String string, int n) {
        DatabaseDescriptor databaseDescriptor = null;
        DatabaseIdentifier databaseIdentifier = this.getDatabaseIdentifier(string, n);
        if (databaseIdentifier != null) {
            databaseDescriptor = databaseIdentifier.getDescriptor();
        }
        return databaseDescriptor;
    }

    public boolean isLegacyVersion(String string, int n) {
        boolean bl = true;
        DatabaseIdentifier databaseIdentifier = this.getDatabaseIdentifier(string, n);
        if (databaseIdentifier != null) {
            bl = databaseIdentifier.m_legacy;
        }
        return bl;
    }

    DataTypeCache getDataTypeCache(String string, int n) {
        DataTypeCache dataTypeCache = null;
        DatabaseIdentifier databaseIdentifier = this.getDatabaseIdentifier(string, n);
        if (databaseIdentifier != null) {
            dataTypeCache = databaseIdentifier.getDataTypeCache();
        }
        return dataTypeCache;
    }

    BuiltInObjectCache getBuiltInObjectCache(String string, int n) {
        BuiltInObjectCache builtInObjectCache = null;
        DatabaseIdentifier databaseIdentifier = this.getDatabaseIdentifier(string, n);
        if (databaseIdentifier != null) {
            builtInObjectCache = databaseIdentifier.getBuiltInObjectCache();
        }
        return builtInObjectCache;
    }

    public Class<? extends Database> loadDatabaseClass(String string) {
        this.checkInit();
        ClassLoader classLoader = this.m_classloaders.get(string);
        if (classLoader == null) {
            classLoader = DBCore.getImplClassLoader();
        }
        Class<?> clazz = null;
        try {
            Class<?> clazz2 = classLoader.loadClass(string);
            if (Database.class.isAssignableFrom(clazz2)) {
                clazz = clazz2;
            } else {
                this.getLogger().severe(string + " is not a Database implementation");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.getLogger().severe("Couldn't find database class " + string);
        }
        return clazz;
    }

    public String getDatabaseName(String string, int n) {
        DatabaseIdentifier databaseIdentifier = this.getDatabaseIdentifier(string, n);
        return databaseIdentifier == null ? null : databaseIdentifier.m_nlsName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseIdentifier getDatabaseIdentifier(String string, int n) {
        this.checkInit();
        DatabaseIdentifier databaseIdentifier = null;
        MultiMap<String, DatabaseIdentifier> multiMap = this.m_databases;
        synchronized (multiMap) {
            Collection collection = this.m_databases.get((Object)string);
            if (collection != null) {
                for (DatabaseIdentifier databaseIdentifier2 : collection) {
                    if (databaseIdentifier2.m_version != n) continue;
                    databaseIdentifier = databaseIdentifier2;
                    break;
                }
            }
        }
        return databaseIdentifier;
    }

    boolean isRegisteredDatabase(String string) {
        return this.getIdentifier(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseIdentifier getIdentifier(String string) {
        DatabaseIdentifier databaseIdentifier = null;
        if (string != null) {
            MultiMap<String, DatabaseIdentifier> multiMap = this.m_databases;
            synchronized (multiMap) {
                block3: for (Map.Entry entry : this.m_databases.entrySet()) {
                    for (DatabaseIdentifier databaseIdentifier2 : (Collection)entry.getValue()) {
                        if (!ModelUtil.areEqual((Object)string, (Object)databaseIdentifier2.m_dbClassName)) continue;
                        databaseIdentifier = databaseIdentifier2;
                        break block3;
                    }
                }
            }
        }
        return databaseIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DatabaseRegistry getInstance() {
        DBCore dBCore = DBCore.getInstance();
        DatabaseRegistry databaseRegistry = dBCore.get(DatabaseRegistry.class);
        if (databaseRegistry != null) return databaseRegistry;
        Class<DatabaseRegistry> clazz = DatabaseRegistry.class;
        synchronized (DatabaseRegistry.class) {
            databaseRegistry = dBCore.get(DatabaseRegistry.class);
            if (databaseRegistry != null) return databaseRegistry;
            databaseRegistry = new DatabaseRegistry();
            dBCore.put(databaseRegistry);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return databaseRegistry;
        }
    }

    public static class DatabaseVersion {
        private final int m_version;
        private final String m_nlsName;
        private final String m_dbImplClassName;
        private final boolean m_legacy;

        public DatabaseVersion(int n, String string, String string2) {
            this(n, string, string2, string == null);
        }

        public DatabaseVersion(int n, String string, String string2, boolean bl) {
            this.m_version = n;
            this.m_nlsName = string;
            this.m_dbImplClassName = string2;
            this.m_legacy = bl;
            if (this.m_nlsName == null && !bl) {
                DBLog.getLogger(DatabaseVersion.class).log(Level.SEVERE, "Supported versions must have an nls name", new IllegalArgumentException());
            }
        }

        public final int getVersion() {
            return this.m_version;
        }

        public final String getName() {
            return this.m_nlsName;
        }

        public final String getDatabaseClassName() {
            return this.m_dbImplClassName;
        }
    }

    private class DatabaseIdentifier {
        private final String m_type;
        private final int m_version;
        private final String m_dbClassName;
        private final String m_nlsName;
        private final boolean m_legacy;
        private Reference<DatabaseDescriptor> m_desc;
        private Reference<DataTypeCache> m_dataTypes;
        private boolean m_dataTypesIsNull;
        private Reference<BuiltInObjectCache> m_builtInObjs;
        private boolean m_builtInObjsIsNull;

        DatabaseIdentifier(String string, DatabaseVersion databaseVersion) {
            this.m_type = string;
            this.m_version = databaseVersion.m_version;
            this.m_dbClassName = databaseVersion.m_dbImplClassName;
            this.m_nlsName = databaseVersion.m_nlsName;
            this.m_legacy = databaseVersion.m_legacy;
        }

        public synchronized DatabaseDescriptor getDescriptor() {
            DatabaseDescriptor databaseDescriptor;
            DatabaseDescriptor databaseDescriptor2 = databaseDescriptor = this.m_desc == null ? null : this.m_desc.get();
            if (databaseDescriptor == null) {
                Class<? extends Database> clazz;
                DatabaseFactory.DatabaseCreator databaseCreator = DatabaseFactory.getInstance().findDatabaseCreator(this.m_dbClassName);
                if (databaseCreator != null) {
                    databaseDescriptor = databaseCreator.getDatabaseDescriptorImpl(this.m_type, this.m_version);
                }
                if (databaseDescriptor == null && (clazz = DatabaseRegistry.this.loadDatabaseClass(this.m_dbClassName)) != null) {
                    databaseDescriptor = DatabaseFactory.getDatabaseDescriptor(clazz);
                }
                if (databaseDescriptor != null) {
                    this.m_desc = new WeakReference<DatabaseDescriptor>(databaseDescriptor);
                }
            }
            return databaseDescriptor;
        }

        public synchronized DataTypeCache getDataTypeCache() {
            DataTypeCache dataTypeCache;
            DataTypeCache dataTypeCache2 = dataTypeCache = this.m_dataTypes == null ? null : this.m_dataTypes.get();
            if (dataTypeCache == null && !this.m_dataTypesIsNull) {
                DatabaseDescriptor databaseDescriptor = this.getDescriptor();
                String string = this.createResourceRoot(databaseDescriptor, "datatypes");
                dataTypeCache = new DataTypeCache(databaseDescriptor, string);
                databaseDescriptor.registerDataTypes(dataTypeCache);
                if (dataTypeCache.getDataTypeCount() == 0) {
                    this.m_dataTypesIsNull = true;
                    dataTypeCache = null;
                } else {
                    this.m_dataTypes = new WeakReference<DataTypeCache>(dataTypeCache);
                }
            }
            return dataTypeCache;
        }

        private String createResourceRoot(DatabaseDescriptor databaseDescriptor, String string) {
            String string2 = databaseDescriptor.getClass().getPackage().getName();
            String string3 = string2.replace('.', '/') + "/resource/" + string;
            int n = databaseDescriptor.getDatabaseVersion();
            List<Integer> list = DatabaseRegistry.this.listDatabaseVersions(databaseDescriptor.getDatabaseType());
            if (list.size() > 0 && n != list.get(0)) {
                string3 = string3 + "/" + n;
            }
            return string3;
        }

        public synchronized BuiltInObjectCache getBuiltInObjectCache() {
            BuiltInObjectCache builtInObjectCache;
            BuiltInObjectCache builtInObjectCache2 = builtInObjectCache = this.m_builtInObjs == null ? null : this.m_builtInObjs.get();
            if (builtInObjectCache == null && !this.m_builtInObjsIsNull) {
                DatabaseDescriptor databaseDescriptor = this.getDescriptor();
                String string = this.createResourceRoot(databaseDescriptor, "objects");
                builtInObjectCache = new BuiltInObjectCache(databaseDescriptor, string);
                databaseDescriptor.registerBuiltInObjects(builtInObjectCache);
                if (builtInObjectCache.isEmpty()) {
                    this.m_builtInObjsIsNull = true;
                } else {
                    this.m_builtInObjs = new WeakReference<BuiltInObjectCache>(builtInObjectCache);
                }
            }
            return builtInObjectCache;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof DatabaseIdentifier) {
                bl = this.m_version == ((DatabaseIdentifier)object).m_version && ModelUtil.areEqual((Object)this.m_type, (Object)((DatabaseIdentifier)object).m_type);
            }
            return bl;
        }
    }
}

