/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.plsql.PlSqlCompilerOptions;
import oracle.javatools.util.deferred.Thunk;

public class GlobalSettings
extends HashStructureAdapter {
    private static final String DATETIME = "validateDateTime";
    private static final String COMPILEROPTS = "plsqlCompilerOptions";
    private static final String PLSQLCASE = "plsqlLowerCase";
    private static final String STMT_TIMEOUT = "statementTimeout";
    private static Thunk<PropertyStorage> s_propsThunk;
    public static final String PREFS_KEY = "oracle.javatools.db.GlobalSettings";

    public static final synchronized GlobalSettings getInstance() {
        PropertyStorage propertyStorage;
        DBCore dBCore = DBCore.getInstance();
        GlobalSettings globalSettings = dBCore.get(GlobalSettings.class);
        if (globalSettings == null && s_propsThunk != null && (propertyStorage = (PropertyStorage)s_propsThunk.get()) != null) {
            globalSettings = GlobalSettings.createGlobalSettings(propertyStorage);
            dBCore.put((Object)globalSettings);
        }
        return globalSettings;
    }

    @Deprecated
    public static final void initialiseInstance(PropertyStorage propertyStorage) {
        GlobalSettings.initialiseInstance((Thunk<PropertyStorage>)Thunk.directReference((Object)propertyStorage));
    }

    public static final void initialiseInstance(Thunk<PropertyStorage> thunk) {
        if (s_propsThunk != null) {
            new IllegalStateException("Database GlobalSettings already exist, shouldn't initialise twice.").printStackTrace();
        } else {
            s_propsThunk = thunk;
        }
    }

    public static final GlobalSettings createGlobalSettings(PropertyStorage propertyStorage) {
        return new GlobalSettings(GlobalSettings.findOrCreate((PropertyStorage)propertyStorage, (String)PREFS_KEY));
    }

    private GlobalSettings(HashStructure hashStructure) {
        super(hashStructure);
    }

    public boolean isValidateDateTime() {
        return this._hash.getBoolean(DATETIME, true);
    }

    public void setValidateDateTime(boolean bl) {
        this._hash.putBoolean(DATETIME, bl);
    }

    public boolean isNewPlSqlLowerCase() {
        return this._hash.getBoolean(PLSQLCASE, false);
    }

    public void setNewPlSqlLowerCase(boolean bl) {
        this._hash.putBoolean(PLSQLCASE, bl);
    }

    public PlSqlCompilerOptions getPlSqlCompilerOptions() {
        return new PlSqlCompilerOptions(this._hash.getOrCreateHashStructure(COMPILEROPTS));
    }

    public Integer getStatementTimeout() {
        Integer n = null;
        if (this._hash.containsKey(STMT_TIMEOUT)) {
            n = this._hash.getInt(STMT_TIMEOUT);
        }
        return n;
    }

    public void setStatementTimeout(Integer n) {
        if (n == null) {
            this._hash.remove(STMT_TIMEOUT);
        } else {
            this._hash.putInt(STMT_TIMEOUT, n.intValue());
        }
    }
}

