/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ora.Indextype;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.References;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.util.ModelUtil;

public class Index
extends AbstractSchemaObject
implements ChildDBObject {
    public static final String TYPE = "INDEX";
    private transient Table m_table;

    public Index() {
    }

    public Index(String string, Table table) {
        this(string, table == null ? null : table.getSchema(), table);
    }

    public Index(String string, Schema schema) {
        this(string, schema, (Table)null);
    }

    public Index(String string, Schema schema, Table table) {
        super(string, schema);
        this.m_table = table;
    }

    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    public IndexType getIndexType() {
        return (IndexType)((Object)this.getProperty("indexType"));
    }

    @References(value=Indextype.class, cascade=CascadeAction.NONE)
    public DBObjectID getDomainIndextype() {
        return (DBObjectID)this.getProperty("domainIndextype");
    }

    @TextProperty(multiLine=true)
    public String getDomainIndextypeParameters() {
        return (String)this.getProperty("domainIndextypeParameters");
    }

    public String getDomainIndextypeOpStatus() {
        return (String)this.getProperty("domainIndextypeOpStatus");
    }

    public void setParallelDegree(Integer n) {
        this.setProperty("parallelDegree", n);
    }

    public Integer getParallelDegree() {
        return (Integer)this.getProperty("parallelDegree");
    }

    public void setIndexType(IndexType indexType) {
        this.setProperty("indexType", (Object)indexType);
    }

    public void setDomainIndextype(DBObjectID dBObjectID) {
        this.setProperty("domainIndextype", dBObjectID);
    }

    public void setDomainIndextypeParameters(String string) {
        this.setProperty("domainIndextypeParameters", string);
    }

    public void setDomainIndextypeOpStatus(String string) {
        this.setProperty("domainIndextypeOpStatus", string);
    }

    public void setKeyCompression(Integer n) {
        this.setProperty("keyCompression", n);
    }

    public Integer getKeyCompression() {
        return (Integer)this.getProperty("keyCompression");
    }

    public Boolean getReverse() {
        return (Boolean)this.getProperty("reverse");
    }

    public void setReverse(Boolean bl) {
        this.setProperty("reverse", bl);
    }

    public void setSystemGenerated(Boolean bl) {
        this.setProperty("systemGenerated", bl);
    }

    public Boolean getSystemGenerated() {
        return (Boolean)this.getProperty("systemGenerated");
    }

    public void setTable(Table table) {
        Table table2 = this.m_table;
        if (this.m_table != table) {
            this.m_table = table;
            Schema schema = this.getSchema();
            if (schema != null && this.m_table != null) {
                Schema schema2 = this.m_table.getSchema();
                if (schema2 != null && ModelUtil.areEqual((Object)schema.getName(), (Object)schema2.getName())) {
                    this.setSchema(null);
                }
            } else if (schema == null && table == null && table2 != null) {
                super.setSchema(table2.getSchema());
            }
            this.getPropertySupport().setBuilt("table");
        }
    }

    @Internal
    public Table getTable() {
        Index index;
        DBObjectID dBObjectID;
        this.checkInit("table");
        if (this.m_table == null && (dBObjectID = this.getID()) instanceof TemporaryObjectID && (index = (Index)TemporaryObjectID.findOriginalObject((TemporaryObjectID)dBObjectID)) != null) {
            this.m_table = index.m_table;
        }
        return this.m_table;
    }

    @Override
    public void setParent(DBObject dBObject) {
        if (dBObject instanceof Table || dBObject == null) {
            this.setTable((Table)dBObject);
        }
    }

    @Override
    public Object getProperty(String string) {
        Object object = "parent".equals(string) ? this.m_table : ("table".equals(string) ? this.getTable() : super.getProperty(string));
        return object;
    }

    @Override
    public void setProperty(String string, Object object) {
        if ("parent".equals(string) || "table".equals(string)) {
            Table table = this.getTable();
            this.setTable((Table)object);
            this.firePropertyChanged(string, table, object);
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setColumnExpressions(IndexObject[] indexObjectArray) {
        this.getChildSupport("columnExpressions").setChildArray(indexObjectArray);
    }

    public IndexObject[] getColumnExpressions() {
        return this.getChildSupport("columnExpressions").getChildArray(IndexObject.class);
    }

    public void addColumnExpression(IndexObject indexObject) {
        this.getChildSupport("columnExpressions").addChild(indexObject);
    }

    public void addColumnExpression(int n, IndexObject indexObject) {
        this.getChildSupport("columnExpressions").addChild(n, indexObject);
    }

    public void removeColumnExpression(IndexObject indexObject) {
        this.getChildSupport("columnExpressions").removeChild(indexObject);
    }

    @Override
    public DBObject findOwnedObject(DBObjectID dBObjectID, boolean bl) {
        return this.findOwnedObject(dBObjectID, bl, true);
    }

    @Override
    public Schema getSchema() {
        Schema schema = super.getSchema();
        if (schema == null && this.m_table != null) {
            schema = this.m_table.getSchema();
        }
        return schema;
    }

    @Override
    public void setSchema(Schema schema) {
        if (this.m_table == null || !DBUtil.areNamesAndTypesEqual(schema, this.m_table.getSchema())) {
            super.setSchema(schema);
        } else {
            super.setSchema(null);
        }
    }

    @Override
    protected void copyToImpl(AbstractDBObject abstractDBObject, DBObject dBObject, IDPolicy iDPolicy) {
        this.ensureParentTable((Index)abstractDBObject, (Table)dBObject);
        super.copyToImpl(abstractDBObject, dBObject, iDPolicy);
        this.ensureParentTable((Index)abstractDBObject, (Table)dBObject);
    }

    private void ensureParentTable(Index index, Table table) {
        if (table == null) {
            table = this.m_table;
        }
        if (table != null) {
            index.setTable(table);
        }
    }

    public static enum IndexType {
        NORMAL,
        UNIQUE,
        BITMAP,
        DOMAIN;


        public static IndexType migrate(String string) {
            try {
                int n = Integer.valueOf(string.toString());
                switch (n) {
                    case 2: {
                        return UNIQUE;
                    }
                    case 3: {
                        return BITMAP;
                    }
                    case 4: {
                        return DOMAIN;
                    }
                }
                return NORMAL;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

