/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.ValidationException;

public class NameInUseException
extends ValidationException {
    private String m_name;
    private String m_existingName;
    private String m_existingType;
    private String m_message;

    public NameInUseException(DBObject dBObject) {
        this(dBObject, dBObject.getName(), null, null);
    }

    public NameInUseException(Collection<? extends DBObject> collection) {
        super(NameInUseException.firstObj(collection), (String)null);
        this.m_message = NameInUseException.getMessage(collection);
    }

    @Deprecated
    public NameInUseException(String string) {
        this((DBObject)null, string, null, null);
    }

    @Deprecated
    public NameInUseException(String string, String string2, String string3) {
        this((DBObject)null, string, string2, string3);
    }

    public NameInUseException(DBObject dBObject, String string, String string2) {
        this(dBObject, dBObject == null ? string : dBObject.getName(), string, string2);
    }

    public NameInUseException(DBObject dBObject, DBObject dBObject2) {
        this(dBObject, dBObject == null ? dBObject2.getName() : dBObject.getName(), DBUtil.getFullyQualifiedName(dBObject2, false), dBObject2.getType());
        this.setRelatedObjects(dBObject2);
    }

    private NameInUseException(DBObject dBObject, String string, String string2, String string3) {
        super(dBObject, (String)null);
        this.m_existingType = string3;
        this.m_existingName = string2;
        this.m_name = string;
    }

    @Deprecated
    public NameInUseException(String string, String string2, String string3, String string4) {
        this((DBObject)null, string, string2, string3);
    }

    public String getName() {
        return this.m_name;
    }

    public String getExistingName() {
        return this.m_existingName;
    }

    public String getExistingType() {
        return this.m_existingType;
    }

    @Deprecated
    public String getUserName() {
        return this.m_existingName;
    }

    @Deprecated
    public String getUserType() {
        return this.m_existingType;
    }

    @Deprecated
    public String getSubUserType() {
        return null;
    }

    @Override
    public String getMessage() {
        if (this.m_message == null) {
            String string;
            String string2;
            DBObject dBObject = this.getObject();
            DBObject[] dBObjectArray = this.getRelatedObjects();
            if (dBObjectArray != null && dBObjectArray.length > 0 && dBObjectArray[0] != null) {
                DBObject dBObject2;
                boolean bl = false;
                if (dBObjectArray[0] instanceof ChildDBObject && dBObject != null && (dBObject2 = dBObjectArray[0].getParent()) != null && !DBUtil.areNamesAndTypesEqual(dBObject2, dBObject.getParent())) {
                    bl = true;
                }
                string2 = bl ? DBUtil.getFullyQualifiedName(dBObjectArray[0], false) : dBObjectArray[0].getName();
                string = dBObjectArray[0].getType();
            } else {
                string2 = this.m_existingName;
                string = this.m_existingType;
            }
            this.m_message = string2 != null && (!string2.equals(this.m_name) || dBObject == null || !dBObject.getType().equals(this.m_existingType)) ? APIBundle.format("DBOV_NAME_EXISTS2", this.m_name, string == null ? "" : DisplayNames.getTypeDisplayName(string), string2) : APIBundle.format("DBOV_NAME_EXISTS", this.m_name);
        }
        return this.m_message;
    }

    private static DBObject firstObj(Collection<? extends DBObject> collection) {
        return collection == null || collection.size() == 0 ? null : collection.iterator().next();
    }

    private static String getMessage(Collection<? extends DBObject> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        if (collection != null) {
            for (DBObject dBObject : collection) {
                if (dBObject == null) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(dBObject.getName());
            }
        }
        return stringBuilder.length() > 0 ? APIBundle.format("DBOV_NAMES_EXIST", stringBuilder.toString()) : APIBundle.format("DBOV_NAME_EXISTS", "");
    }
}

