/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.db.refactoring.UpdateProcessor;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.MissingValidatorException;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

public class TemplateExpander
extends UpdateProcessor {
    public static final String TEMPLATE_OBJECTID = "TemplateObject";
    private static final MultiMap<Class, String> s_propsToClear = new MultiMap();
    private static boolean s_propsToClearInit;
    private static final Collection<Initialiser> s_initialisers;

    @Override
    public boolean onlyProcessesPrimaryUpdates() {
        return true;
    }

    @Override
    public void processUpdate(DBObjectTransaction dBObjectTransaction, Difference difference) throws DBException {
        SystemObject systemObject = (SystemObject)difference.getUpdatedObject();
        if (systemObject != null && difference.getOriginalObject() == null) {
            this.checkAndRecurse(systemObject, dBObjectTransaction.getProvider());
        }
    }

    private void checkAndRecurse(DBObject dBObject, DBObjectProvider dBObjectProvider) throws DBException {
        for (DBObject dBObject2 : dBObject.getOwnedObjects()) {
            this.checkAndRecurse(dBObject2, dBObjectProvider);
        }
        if (TemplateExpander.isPendingObject(dBObject)) {
            this.completePendingObject(dBObject, dBObjectProvider);
        }
    }

    private void completePendingObject(DBObject dBObject, DBObjectProvider dBObjectProvider) throws DBException {
        DDL dDL;
        DBObject dBObject2 = TemplateExpander.getTemplate(dBObject);
        dBObject.getProperties().remove(TEMPLATE_OBJECTID);
        if (dBObject instanceof Table) {
            Table table = (Table)dBObject.copyTo(null, true);
            for (Column abstractBuildableObject : table.getColumns()) {
                TemplateExpander.processChildName(abstractBuildableObject, table, dBObject2, dBObjectProvider);
            }
            for (AbstractBuildableObject abstractBuildableObject : table.getIndexes()) {
                TemplateExpander.processChildName(abstractBuildableObject, table, dBObject2, dBObjectProvider);
            }
            for (AbstractBuildableObject abstractBuildableObject : table.getConstraints()) {
                TemplateExpander.processChildName(abstractBuildableObject, table, dBObject2, dBObjectProvider);
            }
            table.copyTo(dBObject);
        } else if (dBObject instanceof PlSqlSourceObject && ((PlSqlSourceObject)dBObject).getSource() == null && (dDL = dBObjectProvider.getDDLGenerator().getCreateDDL(new DDLOptions(), dBObject)) != null) {
            ((PlSqlSourceObject)dBObject).setSource(dDL.toString());
        }
    }

    private static void processChildName(DBObject dBObject, DBObject dBObject2, DBObject dBObject3, DBObjectProvider dBObjectProvider) throws DBException {
        String string = dBObject.getName();
        String string2 = TemplateExpander.replaceNameFragment(string, dBObject3.getName(), dBObject2.getName());
        try {
            String string3 = dBObject.getType();
            String string4 = dBObjectProvider.getInternalName(string2, string3);
            HashSet<String> hashSet = new HashSet<String>();
            DBObjectValidator<DBObject> dBObjectValidator = ((AbstractDBObjectProvider)dBObjectProvider).getValidator(dBObject);
            DBObjectValidator.NamespaceType namespaceType = dBObjectValidator.getNamespaceType();
            if (namespaceType == DBObjectValidator.NamespaceType.SCHEMA || namespaceType == DBObjectValidator.NamespaceType.TYPE) {
                for (DBObject dBObject4 : dBObject2.getOwnedObjects(string3)) {
                    if (dBObject4 == dBObject) continue;
                    hashSet.add(dBObject4.getName());
                }
                string2 = dBObjectProvider.getUniqueName(string3, DBUtil.getSchema(dBObject), string4, hashSet);
            } else if (namespaceType == DBObjectValidator.NamespaceType.TYPE_PARENT) {
                for (DBObject dBObject5 : dBObject2.getOwnedObjects(string3)) {
                    if (dBObject5 == dBObject) continue;
                    hashSet.add(dBObject5.getName());
                }
                if (hashSet.contains(string2)) {
                    string2 = dBObjectProvider.getUniqueName(string3, dBObject2, string4, hashSet);
                }
            }
        }
        catch (MissingValidatorException missingValidatorException) {
            // empty catch block
        }
        if (ModelUtil.areDifferent((Object)string, (Object)string2)) {
            dBObject.setName(string2);
            if (dBObject2 instanceof SystemObject) {
                DBUtil.cascadeInternalRename((SystemObject)dBObject2, dBObject, string, string2, dBObjectProvider);
            }
        }
    }

    public static final <T extends DBObject> T initialiseObject(T t) {
        PropertyHelper propertyHelper = new PropertyHelper();
        DBObject dBObject = (DBObject)t.copyTo(null);
        dBObject.setName(null);
        dBObject.setProperty(TEMPLATE_OBJECTID, t.getID());
        for (Map.Entry<Class, Collection<String>> entry : TemplateExpander.getPropertiesToClear().entrySet()) {
            boolean bl;
            Class clazz = entry.getKey();
            if (!clazz.isAssignableFrom(dBObject.getClass())) continue;
            boolean bl2 = bl = clazz == DBObject.class;
            Collection<String> collection = entry.getValue();
            if (collection == null) continue;
            for (String string : collection) {
                TemplateExpander.clearProp(propertyHelper, dBObject, string, bl);
            }
        }
        for (Initialiser initialiser : s_initialisers) {
            initialiser.initialiseObject(t, dBObject);
        }
        return (T)dBObject;
    }

    private static void clearProp(PropertyHelper propertyHelper, DBObject dBObject, String string, boolean bl) {
        propertyHelper.setPropertyValue(dBObject, string, null);
        if (bl) {
            for (DBObject dBObject2 : dBObject.getOwnedObjects()) {
                TemplateExpander.clearProp(propertyHelper, dBObject2, string, true);
            }
        }
    }

    public static final boolean isPendingObject(DBObject dBObject) {
        DBObject dBObject2 = TemplateExpander.getTemplate(dBObject);
        if (dBObject2 != null && dBObject2.getID() == null && dBObject2.getName() == null) {
            dBObject2 = null;
        }
        return dBObject2 != null;
    }

    public static void registerInitialiser(Initialiser initialiser) {
        s_initialisers.add(initialiser);
    }

    public static void registerPropertyToClear(Class clazz, String string) {
        s_propsToClear.add((Object)clazz, (Object)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Class, Collection<String>> getPropertiesToClear() {
        MultiMap<Class, String> multiMap = s_propsToClear;
        synchronized (multiMap) {
            if (!s_propsToClearInit) {
                s_propsToClearInit = true;
                TemplateExpander.registerPropertyToClear(MaterializedViewLog.class, "masterTableID");
                TemplateExpander.registerPropertyToClear(MaterializedViewLog.class, "logTable");
                TemplateExpander.registerPropertyToClear(MaterializedViewLog.class, "columnIDs");
                TemplateExpander.registerPropertyToClear(Trigger.class, "code");
                TemplateExpander.registerPropertyToClear(Trigger.class, "tableOwner");
                TemplateExpander.registerPropertyToClear(Trigger.class, "tableID");
                TemplateExpander.registerPropertyToClear(Trigger.class, "columnIDs");
                TemplateExpander.registerPropertyToClear(SchemaObject.class, "schema");
            }
        }
        return s_propsToClear;
    }

    @Deprecated
    public static void registerPropertiesToClear(Class clazz, ArrayList<String> arrayList, boolean bl) {
    }

    public static String getTemplateObjectName(DBObject dBObject) {
        DBObject dBObject2 = TemplateExpander.getTemplate(dBObject);
        if (dBObject2 != null && dBObject2.getName() != null) {
            Schema schema;
            StringBuffer stringBuffer = new StringBuffer();
            if (dBObject2 instanceof SchemaObject && (schema = ((SchemaObject)dBObject2).getSchema()) != null) {
                stringBuffer.append(schema.getName()).append(".");
            }
            stringBuffer.append(dBObject2.getName());
            return stringBuffer.toString();
        }
        return null;
    }

    private static String replaceNameFragment(String string, String string2, String string3) {
        String string4 = "_" + string + "_";
        String string5 = "_" + string2 + "_";
        String string6 = "_" + string3 + "_";
        int n = 0;
        String string7 = "_" + n + "_";
        String string8 = string5 + string6;
        while (string8.contains(string7)) {
            string7 = "_" + ++n + "_";
        }
        while (string4.indexOf(string5) >= 0) {
            string4 = string4.replace(string5, string7);
        }
        while (string4.indexOf(string7) >= 0) {
            string4 = string4.replace(string7, string6);
        }
        return string4.substring(1, string4.length() - 1);
    }

    @Deprecated
    public static void applySourceFromTemplate(PlSqlSourceObject plSqlSourceObject) {
    }

    @Deprecated
    public static void applySourceFromTemplate(PlSqlSourceObject plSqlSourceObject, PlSqlSourceObject plSqlSourceObject2) {
    }

    @Override
    public Collection<String> getProcessorProperties(DBObjectProvider dBObjectProvider) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(super.getProcessorProperties(dBObjectProvider));
        hashSet.add(TEMPLATE_OBJECTID);
        return hashSet;
    }

    private static DBObject getTemplate(DBObject dBObject) {
        DBObjectID dBObjectID = (DBObjectID)dBObject.getProperty(TEMPLATE_OBJECTID);
        DBObject dBObject2 = null;
        if (dBObjectID != null) {
            try {
                dBObject2 = dBObjectID.resolveID();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return dBObject2;
    }

    static {
        s_initialisers = new ArrayList<Initialiser>();
    }

    public static interface Initialiser {
        public void initialiseObject(DBObject var1, DBObject var2);
    }
}

