/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBSQLException;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLStatementWrapper;
import oracle.javatools.db.ddl.UnsupportedDDLException;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.GenericDiffEngine;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.Holder;

public abstract class DDLDatabase
extends AbstractDatabase {
    protected DDLDatabase(String string, String string2, Connection connection) {
        super(string, string2, connection);
    }

    protected DDLDatabase(String string, String string2, Connection connection, String string3, int n) {
        super(string, string2, connection, string3, n);
    }

    private DDLGenerator getDDLGeneratorOrFail() throws UnsupportedOperationException {
        DDLGenerator dDLGenerator = this.getDDLGenerator();
        if (dDLGenerator == null) {
            throw new UnsupportedOperationException("DDL generation not supported.");
        }
        return dDLGenerator;
    }

    @Override
    public DiffEngine getDiffEngine() {
        return GenericDiffEngine.getDiffEngine(true, false, true);
    }

    protected final boolean executeDDL(DDL dDL, boolean bl) throws DBException {
        return this.executeDDL(dDL, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeDDL(DDL dDL, boolean bl, DDLStatementWrapper.ExceptionHandler exceptionHandler) throws DBException {
        boolean bl2 = false;
        if (dDL.size() >= 1) {
            Object object;
            boolean bl3 = false;
            try {
                object = new ConnectionWrapper(this, "");
                bl3 = ((ConnectionWrapper)object).call(new ConnectionWrapper.SQLCallable<Boolean>((ConnectionWrapper)object){

                    @Override
                    public Boolean call() throws SQLException {
                        boolean bl = this.getConnection().getMetaData().dataDefinitionCausesTransactionCommit();
                        return !bl && !this.getConnection().getAutoCommit();
                    }
                });
            }
            catch (DBException dBException) {
                DBLog.getLogger(this).log(Level.WARNING, dBException.getMessage());
            }
            object = new DDLStatementWrapper((Database)this, dDL);
            ((StatementWrapper)object).setIgnoreErrors(bl);
            ((DDLStatementWrapper)object).setExceptionHandler(exceptionHandler);
            try {
                if (bl3) {
                    this.setAutoCommit(true);
                }
                bl2 = ((DDLStatementWrapper)object).execute();
            }
            finally {
                if (bl3) {
                    this.setAutoCommit(false);
                }
            }
        }
        return bl2;
    }

    private void setAutoCommit(final boolean bl) {
        ConnectionWrapper connectionWrapper = new ConnectionWrapper(this, APIBundle.get("SET_AUTOCOMMIT"));
        try {
            ConnectionWrapper connectionWrapper2 = connectionWrapper;
            connectionWrapper2.getClass();
            connectionWrapper.run(new ConnectionWrapper.SQLRunnable(connectionWrapper2){

                @Override
                public void run() throws SQLException {
                    this.getConnection().setAutoCommit(bl);
                }
            });
        }
        catch (DBException dBException) {
            DBLog.getLogger(this).log(Level.WARNING, dBException.getMessage());
        }
    }

    @Override
    public final boolean canCreate(SystemObject systemObject, boolean bl) {
        boolean bl2 = false;
        DDLGenerator dDLGenerator = this.getDDLGenerator();
        if (dDLGenerator != null) {
            boolean bl3 = this.exists(systemObject);
            if (bl || !bl3) {
                PropertyAction.Type type;
                String string = systemObject.getType();
                PropertyAction.Type type2 = type = bl3 ? PropertyAction.Type.REPLACE : PropertyAction.Type.CREATE;
                if (dDLGenerator.supportsAction(string, type)) {
                    bl2 = this.skipPrivCheck(string) ? true : this.hasSystemPrivilege(string, DBUtil.getSchema(systemObject), "CREATE");
                }
            }
        }
        return bl2;
    }

    @Override
    public final boolean canDelete(SystemObject systemObject, boolean bl) {
        String string;
        boolean bl2 = false;
        DDLGenerator dDLGenerator = this.getDDLGenerator();
        if (dDLGenerator != null && this.exists(systemObject) && dDLGenerator.supportsAction(string = systemObject.getType(), PropertyAction.Type.DELETE)) {
            bl2 = this.skipPrivCheck(string) ? true : this.hasSystemPrivilege(string, DBUtil.getSchema(systemObject), "DELETE");
        }
        return bl2;
    }

    private boolean skipPrivCheck(String string) {
        return DBObjectRegistry.isExtensionType(string, this.getDatabaseType(), this.getDatabaseVersion());
    }

    @Override
    public final void createSchema(Schema schema, boolean bl) throws DBException {
        Schema schema2;
        if (schema == null) {
            throw new IllegalArgumentException("null Schema in createSchema");
        }
        if (this.getSchema(schema.getName()) == null) {
            bl = false;
        } else if (!bl) {
            throw new NameInUseException(schema);
        }
        DDL dDL = null;
        DDLGenerator dDLGenerator = this.getDDLGeneratorOrFail();
        try {
            dDL = dDLGenerator.getCreateDDL(new DDLOptions(bl, true), schema);
        }
        catch (UnsupportedDDLException unsupportedDDLException) {
            unsupportedDDLException.throwDBException();
        }
        if (dDL == null || dDL.size() == 0) {
            UnsupportedDDLException.createNotSupported(schema);
        }
        if (bl && (schema2 = this.getSchema(schema.getName())) != null) {
            if (schema2 == schema) {
                throw new IllegalArgumentException("Cannot replace schema with itself");
            }
            if (!this.canDelete(schema2, true)) {
                throw new DBException((DBObject)schema, "Cannot drop existing schema " + schema2.getName());
            }
        }
        this.executeDDL(dDL, false);
        schema2 = this.getSchema(schema.getName());
        if (schema2 == null) {
            throw new DBException((DBObject)schema, "Created schema wasn't found in the database.");
        }
        this.fireObjectsAdded(Collections.singleton(schema2));
    }

    @Override
    public final void deleteSchema(Schema schema, boolean bl) throws DBException {
        schema = this.getSchema(schema.getName());
        DDLGenerator dDLGenerator = this.getDDLGeneratorOrFail();
        DDL dDL = null;
        try {
            dDL = dDLGenerator.getDeleteDDL(new DDLOptions(false, bl), schema);
        }
        catch (UnsupportedDDLException unsupportedDDLException) {
            unsupportedDDLException.throwDBException();
        }
        if (dDL == null || dDL.size() == 0) {
            UnsupportedDDLException.deleteNotSupported(schema).throwDBException();
        }
        this.executeDDL(dDL, false);
        this.uncacheObject(schema);
        this.fireObjectsRemoved(Collections.singleton(schema));
    }

    @Override
    public final void updateSchema(Schema schema, Schema schema2) throws DBException {
        UnsupportedDDLException.updateNotSupported(schema).throwDBException();
    }

    @Override
    public final void createObjects(SystemObject[] systemObjectArray, boolean bl) throws DBException {
        SystemObject[] systemObjectArray2 = new SystemObject[systemObjectArray.length];
        DiffEngine diffEngine = this.getDiffEngine();
        Difference difference = diffEngine.difference(systemObjectArray2, systemObjectArray);
        this.updateObjects(difference, bl, false);
    }

    protected void processCreateException(DBException dBException, SystemObject systemObject) throws DBException {
        if (systemObject == null) {
            for (DBObject dBObject = dBException.getObject(); dBObject != null; dBObject = dBObject.getParent()) {
                if (!(dBObject instanceof SystemObject)) continue;
                systemObject = (SystemObject)dBObject;
                break;
            }
        }
        if (this.isCauseNameInUse(dBException)) {
            throw new NameInUseException(systemObject);
        }
        if (systemObject != null && this.exists(systemObject)) {
            try {
                this.deleteObject(systemObject, true);
            }
            catch (DBException dBException2) {
                this.getLogger().warning(APIBundle.format("CREATE_ROLLBACK_ERR", systemObject.getType(), systemObject.getName(), dBException2));
            }
        }
        throw dBException;
    }

    protected boolean isCauseNameInUse(DBException dBException) {
        return false;
    }

    @Override
    public void deleteObjects(SystemObject[] systemObjectArray, boolean bl) throws DBException {
        if ((systemObjectArray = DBUtil.stripNulls(DBUtil.getProviderDefinitions((SystemObject[])systemObjectArray, (DBObjectProvider)this))).length > 0) {
            this.updateObjects(this.getDiffEngine().difference(systemObjectArray, new SystemObject[systemObjectArray.length]), false, bl);
        }
    }

    protected void processDeleteException(DBException dBException, SystemObject systemObject) throws DBException {
        throw dBException;
    }

    @Override
    public final void undeleteObject(SchemaObject schemaObject) throws DBException {
        this.undeleteObjects(new SchemaObject[]{schemaObject});
    }

    @Override
    public final void undeleteObjects(SchemaObject[] schemaObjectArray) throws DBException {
        if ((schemaObjectArray = DBUtil.stripNulls(schemaObjectArray)) != null && schemaObjectArray.length > 0) {
            DDL dDL = null;
            DDLGenerator dDLGenerator = this.getDDLGeneratorOrFail();
            DDLOptions dDLOptions = new DDLOptions(false, false);
            try {
                dDL = dDLGenerator.getUndeleteDDL(dDLOptions, schemaObjectArray);
            }
            catch (UnsupportedDDLException unsupportedDDLException) {
                unsupportedDDLException.throwDBException();
            }
            if (dDL == null) {
                UnsupportedDDLException.undeleteNotSupported(schemaObjectArray[0]).throwDBException();
            }
            if (this.executeDDL(dDL, false)) {
                this.finishUpdates(this.getDiffEngine().difference(schemaObjectArray, new SystemObject[schemaObjectArray.length]));
            }
        }
    }

    @Override
    protected Collection<DBObjectChange> commitTransaction(DBObjectTransaction dBObjectTransaction, Difference difference) throws DBException {
        Object object;
        DDLOptions dDLOptions = new DDLOptions(dBObjectTransaction.isReplace(), dBObjectTransaction.isCascade());
        boolean bl = false;
        Holder holder = new Holder();
        Holder holder2 = new Holder();
        Collection<? extends Difference> collection = difference.getChildren();
        SystemObject[] systemObjectArray = new SystemObject[collection.size()];
        SystemObject[] systemObjectArray2 = new SystemObject[collection.size()];
        SystemObject[] systemObjectArray3 = new SystemObject[collection.size()];
        int n = 0;
        for (Difference difference2 : collection) {
            if (!difference2.isSame()) {
                systemObjectArray[n] = (SystemObject)difference2.getOriginalObject();
                systemObjectArray2[n] = (SystemObject)difference2.getUpdatedObject();
                systemObjectArray3[n] = this.getExistingObject(systemObjectArray[n], systemObjectArray2[n]);
                if (systemObjectArray2[n] instanceof PlSqlSourceObject) {
                    bl = true;
                }
                this.appendUpdateDDL(systemObjectArray[n], systemObjectArray2[n], systemObjectArray3[n], difference2, dDLOptions, (Holder<DDL>)(systemObjectArray2[n] == null ? holder2 : holder));
            }
            ++n;
        }
        if (bl) {
            this.setCompilerOptions();
        }
        DDL dDL = (DDL)holder.get();
        DDL dDL2 = (DDL)holder2.get();
        boolean bl2 = dDL != null && dDL.size() > 0;
        boolean bl3 = dDL2 != null && dDL2.size() > 0;
        boolean bl4 = false;
        if (bl3) {
            object = new DDLStatementWrapper.ExceptionHandler(){

                @Override
                public void handleException(DBSQLException dBSQLException) throws DBException {
                    DDLDatabase.this.processDeleteException(dBSQLException, DBUtil.getSystemObject(dBSQLException.getObject()));
                }
            };
            bl4 = this.executeDDL(dDL2, false, (DDLStatementWrapper.ExceptionHandler)object);
        }
        if (bl2) {
            try {
                if (this.executeDDL(dDL, false)) {
                    bl4 = true;
                }
            }
            catch (DBSQLException dBSQLException) {
                DBObject dBObject = dBSQLException.getObject();
                for (int i = 0; i < systemObjectArray2.length; ++i) {
                    if (dBObject != systemObjectArray2[i] && DBUtil.getSystemObject(dBObject) != systemObjectArray2[i]) continue;
                    if (systemObjectArray3[i] == null) {
                        this.processCreateException(dBSQLException, systemObjectArray2[i]);
                        break;
                    }
                    if (systemObjectArray2[i] == null || this.supportsTimestamps(systemObjectArray3[i].getType())) continue;
                    DBUtil.forceObjectReset(systemObjectArray3[i], this);
                }
                throw dBSQLException;
            }
        }
        object = null;
        if (bl4) {
            object = this.finishUpdates(difference);
        } else {
            for (SystemObject systemObject : systemObjectArray2) {
                if (systemObject == null) continue;
                UnsupportedDDLException.updateNotSupported(systemObject).throwDBException();
            }
        }
        return object;
    }

    private SystemObject getExistingObject(SystemObject systemObject, SystemObject systemObject2) throws DBException {
        return DBUtil.getProviderDefinition(systemObject == null ? systemObject2 : systemObject, (DBObjectProvider)this);
    }

    @Override
    public final Schema[] listSchemas() throws DBException {
        return super.listSchemas();
    }

    private void appendUpdateDDL(SystemObject systemObject, SystemObject systemObject2, SystemObject systemObject3, Difference difference, DDLOptions dDLOptions, Holder<DDL> holder) throws DBException {
        try {
            DDL dDL;
            DDLGenerator dDLGenerator = this.getDDLGeneratorOrFail();
            if (systemObject == null) {
                if (systemObject3 == null) {
                    if (dDLOptions.isReplace()) {
                        dDLOptions = (DDLOptions)((Object)dDLOptions.copyTo(null));
                        dDLOptions.setReplace(false);
                    }
                } else if (!dDLOptions.isReplace()) {
                    throw new NameInUseException(systemObject3);
                }
                dDL = dDLGenerator.getCreateDDL(dDLOptions, systemObject2);
            } else if (systemObject2 != null) {
                dDL = dDLGenerator.getUpdateDDL(dDLOptions, difference);
            } else {
                dDL = dDLGenerator.getDeleteDDL(dDLOptions, systemObject);
                if (dDL == null) {
                    this.getLogger().log(Level.WARNING, "Could not drop " + systemObject.getType() + systemObject.getName());
                }
            }
            DDL dDL2 = (DDL)holder.get();
            if (dDL2 == null) {
                holder.set(dDL);
            } else {
                dDL2.append(dDL);
            }
        }
        catch (UnsupportedDDLException unsupportedDDLException) {
            unsupportedDDLException.throwDBException();
        }
    }

    public void setCompilerOptions() {
    }
}

