/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.AbstractDDLGenerator;
import oracle.javatools.db.ddl.AlterDDLGenerator;
import oracle.javatools.db.ddl.CreateDDLGenerator;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ddl.DropDDLGenerator;
import oracle.javatools.db.ddl.GeneratorCache;
import oracle.javatools.db.ddl.UndeleteDDLGenerator;
import oracle.javatools.db.ddl.UnsupportedDDLException;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.resource.APIBundle;

class DDLGeneratorImpl<T extends DDLType>
extends AbstractDDLGenerator<T> {
    private final GeneratorCache m_cache = new GeneratorCache();

    public DDLGeneratorImpl(Class<? extends Database> clazz, DBObjectProvider dBObjectProvider) {
        super(clazz, dBObjectProvider);
    }

    private List<CreateDDLGenerator> getCreateGenerators(String string) {
        return this.m_cache.getGenerators(CreateDDLGenerator.class, string);
    }

    protected final void registerCreateGenerator(String string, CreateDDLGenerator createDDLGenerator) {
        this.m_cache.registerGenerator(CreateDDLGenerator.class, string, createDDLGenerator);
    }

    private List<DropDDLGenerator> getDropGenerators(String string) {
        return this.m_cache.getGenerators(DropDDLGenerator.class, string);
    }

    protected final void registerDropGenerator(String string, DropDDLGenerator dropDDLGenerator) {
        this.m_cache.registerGenerator(DropDDLGenerator.class, string, dropDDLGenerator);
    }

    private List<AlterDDLGenerator> getAlterGenerators(String string) {
        return this.m_cache.getGenerators(AlterDDLGenerator.class, string);
    }

    protected final void registerAlterGenerator(String string, AlterDDLGenerator alterDDLGenerator) {
        this.m_cache.registerGenerator(AlterDDLGenerator.class, string, alterDDLGenerator);
    }

    private List<UndeleteDDLGenerator> getUndeleteGenerators(String string) {
        return this.m_cache.getGenerators(UndeleteDDLGenerator.class, string);
    }

    protected final void registerUndeleteGenerator(String string, UndeleteDDLGenerator undeleteDDLGenerator) {
        this.m_cache.registerGenerator(UndeleteDDLGenerator.class, string, undeleteDDLGenerator);
    }

    protected final void copyGenerators(DDLGeneratorImpl dDLGeneratorImpl, String string, boolean bl) {
        for (CreateDDLGenerator object : this.getCreateGenerators(string)) {
            dDLGeneratorImpl.registerCreateGenerator(string, object);
        }
        for (DropDDLGenerator dropDDLGenerator : this.getDropGenerators(string)) {
            dDLGeneratorImpl.registerDropGenerator(string, dropDDLGenerator);
        }
        if (bl) {
            for (AlterDDLGenerator alterDDLGenerator : this.getAlterGenerators(string)) {
                dDLGeneratorImpl.registerAlterGenerator(string, alterDDLGenerator);
            }
        }
    }

    private DBObject[] getChildList(DBObject dBObject, String string) {
        DBObject[] dBObjectArray = this.getPropertyHelper().getPropertyValue(dBObject, string);
        if (dBObjectArray != null && dBObjectArray instanceof DBObject) {
            dBObjectArray = new DBObject[]{(DBObject)dBObjectArray};
        }
        return dBObjectArray instanceof DBObject[] ? (DBObject[])dBObjectArray : null;
    }

    protected final void registerTopLevelChild(String string, final String string2, final String string3) {
        if (string == null || string2 == null || string3 == null) {
            throw new NullPointerException();
        }
        this.registerCreateGenerator(string, new CreateDDLGenerator(){

            @Override
            public DDL getCreateDDL(DDLOptions dDLOptions, DBObject dBObject) {
                if (dDLOptions.isReplace()) {
                    dDLOptions = (DDLOptions)((Object)dDLOptions.copyTo((Object)new DDLOptions()));
                    dDLOptions.setReplace(false);
                }
                DDL dDL = null;
                DBObject[] dBObjectArray = DDLGeneratorImpl.this.getChildList(dBObject, string2);
                if (dBObjectArray != null) {
                    dDL = DDLGeneratorImpl.this.getCreateDDL(dDLOptions, dBObjectArray);
                }
                return dDL;
            }

            @Override
            public boolean canReplace() {
                for (CreateDDLGenerator createDDLGenerator : DDLGeneratorImpl.this.getCreateGenerators(string3)) {
                    if (!createDDLGenerator.canReplace()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean canCreate(String string) {
                if (string2.equals(string)) {
                    return true;
                }
                if (string.startsWith(string2 + "/")) {
                    String string22 = string.substring(string2.length() + 1);
                    for (CreateDDLGenerator createDDLGenerator : DDLGeneratorImpl.this.getCreateGenerators(string3)) {
                        if (!createDDLGenerator.canCreate(string22)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
        this.registerAlterGenerator(string, new AlterDDLGenerator(){

            @Override
            public DDL getAlterDDL(DDLOptions dDLOptions, Difference difference) {
                DDL dDL = null;
                try {
                    Difference difference2 = DDLGeneratorImpl.this.getPropertyHelper().getChildDifference(difference, string2, true);
                    if (difference2 != null && DBObject[].class.isAssignableFrom(difference2.getDifferenceClass())) {
                        for (Difference difference3 : difference2.getChildren()) {
                            if (difference3.isSame()) continue;
                            if (difference3.isModified()) {
                                if (!dDLOptions.isReplace()) {
                                    dDLOptions = DDLOptions.copyForUpdate(dDLOptions, difference);
                                    dDLOptions.setReplace(true);
                                }
                                dDL = DDLGeneratorImpl.this.append(dDL, DDLGeneratorImpl.this.getUpdateDDLImpl(dDLOptions, difference3));
                                continue;
                            }
                            DBObject dBObject = (DBObject)difference3.getOriginalObject();
                            if (dBObject == null) {
                                dDLOptions = (DDLOptions)((Object)dDLOptions.copyTo((Object)new DDLOptions()));
                                dDLOptions.setReplace(false);
                                dDL = DDLGeneratorImpl.this.append(dDL, DDLGeneratorImpl.this.getCreateDDLImpl(dDLOptions, (DBObject)difference3.getUpdatedObject()));
                                continue;
                            }
                            dDL = DDLGeneratorImpl.this.append(dDL, DDLGeneratorImpl.this.getDeleteDDLImpl(dDLOptions, dBObject));
                        }
                    }
                }
                catch (MissingPropertyException missingPropertyException) {
                    DDLGeneratorImpl.this.getLogger().log(Level.FINE, missingPropertyException.getMessage());
                }
                return dDL;
            }

            @Override
            public Collection<PropertyAction.ChildAction> canAlter(String string) {
                Collection<PropertyAction.ChildAction> collection = null;
                if (string2.equals(string)) {
                    collection = Arrays.asList(PropertyAction.ChildAction.values());
                } else if (string.startsWith(string2 + "/")) {
                    collection = EnumSet.noneOf(PropertyAction.ChildAction.class);
                    String string22 = string.substring(string2.length() + 1);
                    for (AlterDDLGenerator alterDDLGenerator : DDLGeneratorImpl.this.getAlterGenerators(string3)) {
                        Collection<PropertyAction.ChildAction> collection2 = alterDDLGenerator.canAlter(string22);
                        if (collection2 == null) continue;
                        collection.addAll(collection2);
                    }
                }
                return collection;
            }
        });
    }

    @Override
    protected DDL<T> getCreateDDLImpl(DDLOptions dDLOptions, DBObject ... dBObjectArray) {
        DDL dDL = null;
        for (DBObject dBObject : dBObjectArray) {
            List<CreateDDLGenerator> list = this.getCreateGenerators(dBObject.getType());
            if (list == null || list.size() == 0) {
                throw UnsupportedDDLException.createNotSupported(dBObject);
            }
            boolean bl = true;
            for (CreateDDLGenerator createDDLGenerator : list) {
                if (createDDLGenerator.canReplace()) {
                    bl = false;
                }
                dDL = this.append(dDL, createDDLGenerator.getCreateDDL(dDLOptions, dBObject));
            }
            if (!dDLOptions.isReplace() || !bl) continue;
            Object object = null;
            if (this.getProvider() != null) {
                try {
                    object = DBUtil.getProviderDefinition(dBObject, this.getProvider());
                }
                catch (DBException dBException) {
                    this.getLogger().warning("Couldn't get existing object for DROP: " + dBException.getMessage());
                }
            }
            dDL = this.append(dDL, this.getDeleteDDL(dDLOptions, new DBObject[]{object == null ? dBObject : object}));
        }
        return dDL;
    }

    @Override
    protected DDL<T> getDeleteDDLImpl(DDLOptions dDLOptions, DBObject ... dBObjectArray) {
        DDL dDL = null;
        for (DBObject dBObject : dBObjectArray) {
            List<DropDDLGenerator> list = this.getDropGenerators(dBObject.getType());
            if (list == null || list.size() == 0) {
                throw UnsupportedDDLException.deleteNotSupported(dBObject);
            }
            for (DropDDLGenerator dropDDLGenerator : list) {
                dDL = this.append(dDL, dropDDLGenerator.getDropDDL(dDLOptions, dBObject));
            }
        }
        return dDL;
    }

    @Override
    public DDL<T> getUndeleteDDL(DDLOptions dDLOptions, DBObject ... dBObjectArray) {
        DDL dDL = null;
        for (DBObject dBObject : dBObjectArray) {
            List<UndeleteDDLGenerator> list = this.getUndeleteGenerators(dBObject.getType());
            if (list == null || list.size() == 0) {
                throw UnsupportedDDLException.undeleteNotSupported(dBObject);
            }
            for (UndeleteDDLGenerator undeleteDDLGenerator : list) {
                dDL = this.append(dDL, undeleteDDLGenerator.getUndeleteDDL(dDLOptions, dBObject));
            }
        }
        return this.finish(dDLOptions, dDL);
    }

    @Override
    protected DDL<T> getUpdateDDLImpl(DDLOptions dDLOptions, Difference difference) {
        DDL dDL = null;
        if (dDLOptions.getContextDifference() == null) {
            throw new IllegalStateException("No context Difference set.");
        }
        PropertyAction propertyAction = this.canUpdateObject(difference);
        if (propertyAction != null && propertyAction.getType() == PropertyAction.Type.ALTER) {
            DBObject dBObject = (DBObject)difference.getOriginalObject();
            String string = dBObject.getType();
            List<AlterDDLGenerator> list = this.getAlterGenerators(string);
            if (list == null || list.size() == 0) {
                throw UnsupportedDDLException.updateNotSupported(dBObject);
            }
            for (AlterDDLGenerator alterDDLGenerator : list) {
                DDL dDL2 = alterDDLGenerator.getAlterDDL(dDLOptions, difference);
                if (dDL2 == null || dDL2.size() <= 0) continue;
                dDL = this.append(dDL, dDL2);
            }
        } else {
            DBObject dBObject = (DBObject)difference.getOriginalObject();
            DBObject dBObject2 = (DBObject)difference.getUpdatedObject();
            if (dDLOptions.isReplace()) {
                if (this.canReplace(dBObject.getType()) && !this.hasIdentityChanged(difference)) {
                    dDL = this.getCreateDDLImpl(dDLOptions, dBObject2);
                } else {
                    dDL = this.getDeleteDDL(dDLOptions, dBObject);
                    DDLOptions dDLOptions2 = DDLOptions.copyForUpdate(dDLOptions, difference);
                    dDLOptions2.setReplace(false);
                    dDL = this.append(dDL, this.getCreateDDL(dDLOptions2, dBObject2));
                }
            } else {
                difference.print();
                throw new UnsupportedDDLException(APIBundle.get("DDL_UPDATE_NEED_REPLACE"), dBObject);
            }
        }
        return dDL;
    }

    private boolean hasIdentityChanged(Difference difference) {
        return this.hasObjectPropertyChanged(difference, "name") || this.hasObjectPropertyChanged(difference, "schema");
    }

    private boolean hasObjectPropertyChanged(Difference difference, String string) {
        boolean bl = false;
        if (DBObject.class.isAssignableFrom(difference.getDifferenceClass())) {
            try {
                Difference difference2 = this.getPropertyHelper().getChildDifference(difference, string, true);
                bl = difference2 != null;
            }
            catch (MissingPropertyException missingPropertyException) {
                DBLog.getLogger(this).log(Level.WARNING, "Expected " + string + " property to exist.");
            }
        }
        return bl;
    }

    @Override
    protected boolean canCreate(Class<? extends SystemObject> clazz, String string) {
        String string2 = Metadata.getType(clazz);
        boolean bl = this.canCreateImpl(string2, string);
        if (!bl) {
            bl = this.isProcessorProperty(clazz, string);
        }
        return bl;
    }

    private boolean canCreateImpl(String string, String string2) {
        List<CreateDDLGenerator> list = this.getCreateGenerators(string);
        for (CreateDDLGenerator createDDLGenerator : list) {
            if (!createDDLGenerator.canCreate(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsProperty(Class<? extends DBObject> clazz, String string) {
        Collection<PropertyAction.ChildAction> collection;
        Object object;
        Object object2;
        Object object3;
        String[] stringArray = Property.getProperties(string);
        for (int i = 0; i < stringArray.length; ++i) {
            object3 = new String[i + 1];
            for (int j = 0; j < i + 1; ++j) {
                object3[j] = stringArray[j];
            }
            object2 = Property.createPath((String[])object3);
            object = this.findPropertyInfo(clazz, (String)object2);
            if (object == null) {
                string = null;
                break;
            }
            if (!((PropertyInfo)object).isDerived()) continue;
            object3[((Object)object3).length - 1] = collection = ((PropertyInfo)object).getDerivedSourceProperty();
            string = Property.createPath((String[])object3);
            break;
        }
        if (string != null) {
            if (SystemObject.class.isAssignableFrom(clazz)) {
                String string2 = Metadata.getType(clazz);
                if ("properties".equals(string)) {
                    return true;
                }
                if (this.canCreateImpl(string2, string)) {
                    return true;
                }
                if (this.isProcessorProperty(clazz, string)) {
                    return true;
                }
                object3 = this.getAlterGenerators(string2);
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (AlterDDLGenerator)object2.next();
                    collection = object.canAlter(string);
                    if (collection == null || collection.isEmpty()) continue;
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsAction(String string, PropertyAction.Type type) {
        boolean bl = false;
        switch (type) {
            case CREATE: 
            case REPLACE: {
                bl = this.m_cache.containsType(CreateDDLGenerator.class, string);
                break;
            }
            case ALTER: {
                bl = this.m_cache.containsType(AlterDDLGenerator.class, string);
                break;
            }
            case DELETE: {
                bl = this.m_cache.containsType(DropDDLGenerator.class, string);
                break;
            }
            case UNDELETE: {
                bl = this.m_cache.containsType(UndeleteDDLGenerator.class, string);
            }
        }
        if (!bl) {
            bl = super.supportsAction(string, type);
        }
        return bl;
    }

    @Override
    public PropertyAction supportsPropertyChange(Class<? extends SystemObject> clazz, String string) {
        PropertyAction propertyAction = null;
        String string2 = Metadata.getType(clazz);
        EnumSet<PropertyAction.ChildAction> enumSet = EnumSet.noneOf(PropertyAction.ChildAction.class);
        List<AlterDDLGenerator> list = this.getAlterGenerators(string2);
        for (AlterDDLGenerator alterDDLGenerator : list) {
            Collection<PropertyAction.ChildAction> collection = alterDDLGenerator.canAlter(string);
            if (collection == null) continue;
            enumSet.addAll(collection);
        }
        if (!enumSet.isEmpty()) {
            propertyAction = new PropertyAction(PropertyAction.Type.ALTER, enumSet);
        } else if (this.supportsAction(string2, PropertyAction.Type.REPLACE) && this.canCreate(clazz, string)) {
            propertyAction = new PropertyAction(PropertyAction.Type.REPLACE);
        }
        return propertyAction;
    }

    private boolean canReplace(String string) {
        boolean bl = false;
        List<CreateDDLGenerator> list = this.getCreateGenerators(string);
        for (CreateDDLGenerator createDDLGenerator : list) {
            if (!createDDLGenerator.canReplace()) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

