/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.GenericBeanDiffer;
import oracle.javatools.db.diff.GenericMapDiffer;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;

class DBObjectDiffer
extends GenericBeanDiffer {
    private final DiffEngine m_internalRefDelegate;

    DBObjectDiffer() {
        this(null);
    }

    DBObjectDiffer(DiffEngine diffEngine) {
        this.m_internalRefDelegate = diffEngine;
    }

    @Override
    protected ResultSet diffProperty(Object object, Object object2, ResultSet resultSet, DiffContext diffContext, PropertyInfo propertyInfo, Map<String, PropertyInfo> map) {
        ResultSet resultSet2;
        String string = propertyInfo.getPropertyName();
        if ("properties".equals(string)) {
            resultSet2 = this.diffPropertiesMap((DBObject)object, (DBObject)object2, resultSet, diffContext, map);
        } else if ("schema".equals(string) && (object instanceof SchemaObject || object2 instanceof SchemaObject)) {
            Schema schema = DBUtil.getSchema((DBObject)object);
            Schema schema2 = DBUtil.getSchema((DBObject)object2);
            resultSet2 = new ResultSet(resultSet, schema == null ? null : new Schema(schema.getName()), (Object)(schema2 == null ? null : new Schema(schema2.getName())), string, "LEAF");
            resultSet2.setSame(DBUtil.areNamesAndTypesEqual(schema, schema2));
        } else if (this.m_internalRefDelegate != null && propertyInfo.isInternalReference()) {
            Object object3 = object == null ? null : propertyInfo.getPropertyValue(object);
            Object object4 = object2 == null ? null : propertyInfo.getPropertyValue(object2);
            boolean bl = object3 != null && object3 instanceof Object[] || object4 != null && object4 instanceof Object[];
            resultSet2 = new ResultSet(resultSet, object3, object4, string, bl ? "LIST" : "MAP");
            if (object3 == null || object4 == null) {
                resultSet2.setSame(object3 == object4);
            } else {
                DiffContext diffContext2 = new DiffContext(this.m_internalRefDelegate, resultSet2);
                this.m_internalRefDelegate.diff(object3, object4, resultSet2, diffContext2);
            }
        } else {
            resultSet2 = super.diffProperty(object, object2, resultSet, diffContext, propertyInfo, map);
        }
        return resultSet2;
    }

    protected ResultSet diffPropertiesMap(final DBObject dBObject, final DBObject dBObject2, ResultSet resultSet, DiffContext diffContext, final Map<String, PropertyInfo> map) {
        Map<String, Object> map2 = dBObject == null ? null : dBObject.getProperties();
        Map<String, Object> map3 = dBObject2 == null ? null : dBObject2.getProperties();
        final ResultSet resultSet2 = new ResultSet(resultSet, map2, map3, "properties", "MAP");
        DBObject dBObject3 = dBObject == null ? dBObject2 : dBObject;
        Class<?> clazz = dBObject3.getClass();
        PropertyCriteria propertyCriteria = PropertyCriteria.createEmptyCriteria();
        propertyCriteria.setIncludeBean(false);
        final Map<String, PropertyInfo> map4 = PropertyHelper.getPropertyInfos(dBObject3.getClass(), null, propertyCriteria);
        GenericMapDiffer genericMapDiffer = new GenericMapDiffer(){

            @Override
            protected boolean ignoreKey(Object object) {
                PropertyInfo propertyInfo;
                boolean bl = "Timestamp".equals(object) || map.containsKey(object) ? true : ((propertyInfo = (PropertyInfo)map4.get(object)) == null ? false : DBObjectDiffer.this.ignoreProperty(propertyInfo));
                return bl;
            }

            @Override
            protected Set getCombinedKeySet(Map map3, Map map2) {
                HashSet<Object> hashSet = new HashSet<Object>();
                hashSet.addAll(map4.keySet());
                hashSet.addAll(this.getCustomProperties(dBObject));
                hashSet.addAll(this.getCustomProperties(dBObject2));
                return hashSet;
            }

            private Collection<String> getCustomProperties(DBObject dBObject3) {
                ArrayList<String> arrayList = null;
                if (dBObject3 != null) {
                    Map<String, Object> map2 = DBUtil.getFrozenProperties(dBObject3);
                    for (String string : map2.keySet()) {
                        if (map.containsKey(string) || map4.containsKey(string)) continue;
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>();
                        }
                        arrayList.add(string);
                    }
                }
                return arrayList == null ? Collections.emptyList() : arrayList;
            }

            @Override
            protected ResultSet diffValue(Map map3, Map map2, Object object, ResultSet resultSet, DiffContext diffContext) {
                ResultSet resultSet22;
                PropertyInfo propertyInfo = (PropertyInfo)map4.get(object);
                if (propertyInfo != null) {
                    resultSet22 = DBObjectDiffer.this.diffProperty(dBObject, dBObject2, resultSet2, diffContext, propertyInfo, map);
                } else {
                    Object object2 = dBObject == null ? null : dBObject.getProperty(object.toString());
                    Object object3 = dBObject2 == null ? null : dBObject2.getProperty(object.toString());
                    resultSet22 = this.diffValue(object2, object3, object, resultSet, diffContext);
                }
                return resultSet22;
            }
        };
        genericMapDiffer.diff(map2, map3, resultSet2, diffContext);
        return resultSet2;
    }
}

