/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.event;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.property.Property;

public abstract class DBObjectPropertyListener
extends DBObjectListener {
    private final String[] m_properties;

    public DBObjectPropertyListener(String ... stringArray) {
        this.m_properties = stringArray;
        if (this.m_properties == null || this.m_properties.length == 0) {
            throw new IllegalArgumentException("Must specify properties to listen for");
        }
    }

    @Override
    public final void objectUpdated(DBObjectChange dBObjectChange) {
        DBObject dBObject = dBObjectChange.getDBObject();
        for (String string : this.m_properties) {
            String[] stringArray = Property.getProperties(string);
            this.objectUpdatedImpl(dBObject, string, dBObjectChange, stringArray);
        }
    }

    private void objectUpdatedImpl(DBObject dBObject, String string, DBObjectChange dBObjectChange, String[] stringArray) {
        Collection<DBObjectChange> collection;
        if (stringArray.length == 1) {
            PropertyChangeEvent propertyChangeEvent = dBObjectChange.getPropertyChange(stringArray[0]);
            if (propertyChangeEvent != null) {
                this.propertyChanged(dBObject, string, propertyChangeEvent);
            }
        } else if (stringArray.length > 1 && !(collection = dBObjectChange.getOwnedObjectsUpdated(stringArray[0])).isEmpty()) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            for (DBObjectChange dBObjectChange2 : collection) {
                this.objectUpdatedImpl(dBObject, string, dBObjectChange2, stringArray2);
            }
        }
    }

    protected abstract void propertyChanged(DBObject var1, String var2, PropertyChangeEvent var3);
}

